/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.models;

import cms.tmx.api.mng.IBankStockTransferApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.notice.BankAccountFandRecordReport;
import cms.tmx.entity.notice.BankAccountFundReport;
import cms.tmx.entity.notice.BankAccountReport;
import cms.tmx.entity.trade.Bank;
import cms.tmx.entity.trade.BankQueryParam;
import cms.tmx.entity.trade.BankTransferRecord;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BankStockTransferModel
extends MxModel {
    private Map<Integer, ObservableList<Bank>> mapBank = new HashMap<Integer, ObservableList<Bank>>();
    private Map<Integer, FundAccount> mapFund = new HashMap<Integer, FundAccount>();
    private Map<Integer, BankTransferRecord> mapRecord = new HashMap<Integer, BankTransferRecord>();
    private Map<Integer, ObservableList<BankQueryParam>> mapTransferRecord = new HashMap<Integer, ObservableList<BankQueryParam>>();
    private Map<Integer, ObservableList<BankQueryParam>> mapNowTransferRecord = new HashMap<Integer, ObservableList<BankQueryParam>>();
    private ObservableList<BankQueryParam> listAllRecord = FxUtils.newList();
    private BooleanProperty changedBank = new SimpleBooleanProperty();
    @Inject
    private IBankStockTransferApi transApi;
    @Inject
    protected MEventService es;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private MxAlert alert;
    private static final String TRANSFER_IN_PWD_FLAG = "1357";
    private static final String TRANSFER_OUT_PWD_FLAG = "2367";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    Date dt = new Date();
    String nowDate = this.sdf.format(this.dt);

    @PostConstruct
    public void init() {
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPush(MEvent event) {
        BankAccountFandRecordReport report;
        PMainTenance.GetTransferBankAccountFundRecordReport pReport;
        Object obj = event.getObj();
        if (obj instanceof BankAccountReport) {
            BankAccountReport report2 = (BankAccountReport)BankAccountReport.class.cast(obj);
            PMainTenance.BankAccountReport pReport2 = report2.getReport();
            String error = pReport2.getErrorInfo();
            FundAccount fund = this.mapFund.remove(pReport2.getSeq());
            if (!error.isEmpty() && fund == null) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, error));
                return;
            }
            ObservableList<Bank> listBank = this.mapBank.remove(pReport2.getSeq());
            if (listBank == null) {
                return;
            }
            List listRep = pReport2.getBankAccountList();
            listRep.forEach(bankAcc -> {
                Bank bank = new Bank();
                bank.update(bankAcc);
                bank.setFund(fund);
                listBank.add((Object)bank);
            });
            this.changedBank();
        } else if (obj instanceof BankAccountFundReport) {
            BankAccountFundReport report3 = (BankAccountFundReport)BankAccountFundReport.class.cast(obj);
            PMainTenance.BankAccountFundReport pReport3 = report3.getReport();
            BankTransferRecord record = this.mapRecord.remove(pReport3.getSeq());
            if (record != null) {
                record.update(pReport3);
                record.changed();
            }
        } else if (obj instanceof BankAccountFandRecordReport && !(pReport = (report = (BankAccountFandRecordReport)BankAccountFandRecordReport.class.cast(obj)).getReport()).getRecordList().isEmpty()) {
            if (pReport.getRecord(0).getTransferDate().equals(this.nowDate)) {
                ObservableList<BankQueryParam> listNowRecord = this.mapNowTransferRecord.remove(pReport.getSeq());
                if (listNowRecord == null) {
                    return;
                }
                List listRep = pReport.getRecordList();
                listRep.forEach(item -> {
                    BankQueryParam record = new BankQueryParam();
                    record.update(item);
                    listNowRecord.add((Object)record);
                });
                ObservableList<BankQueryParam> observableList = this.listAllRecord;
                synchronized (observableList) {
                    this.listAllRecord.addAll(listNowRecord);
                }
            }
            ObservableList<BankQueryParam> listRecord = this.mapTransferRecord.remove(pReport.getSeq());
            if (listRecord == null) {
                return;
            }
            List listRep = pReport.getRecordList();
            listRep.forEach(item -> {
                BankQueryParam record = new BankQueryParam();
                record.update(item);
                listRecord.add((Object)record);
            });
            ObservableList<BankQueryParam> observableList = this.listAllRecord;
            synchronized (observableList) {
                this.listAllRecord.addAll(listRecord);
            }
            this.changed();
        }
    }

    public void queryBanks(int seq, ObservableList<Bank> listBank, FundAccount fund, boolean cacheFund) throws MException {
        PMainTenance.GetBankAccountsRequest.Builder builder = PMainTenance.GetBankAccountsRequest.newBuilder();
        builder.setMarketGrp(fund.getMarketGrp());
        builder.setInvestorId(fund.getInvestId());
        builder.setCurrency(fund.getCurrencyId());
        builder.setSeq(seq);
        this.mapBank.put(seq, listBank);
        if (cacheFund) {
            this.mapFund.put(seq, fund);
        }
        this.transApi.getBankAccounts(builder.build());
    }

    public void queryBankBalance(FundAccount fund, Bank bank, String pwd, BankTransferRecord record) throws MException, Exception {
        PMainTenance.GetBankAccountFundRequest.Builder builder = PMainTenance.GetBankAccountFundRequest.newBuilder();
        builder.setMarketGrp(fund.getMarketGrp());
        builder.setInvestorId(fund.getInvestId());
        builder.setBankNo(bank.getBankId());
        builder.setBankAccountNo(bank.getBankAccountId());
        String pwdDe = DesEncrypt.encrypt((String)pwd);
        builder.setBankAccountPassword(pwdDe);
        builder.setCurrencyId(bank.getCurrency().getRaw());
        builder.setSeq(record.getSeq());
        this.mapRecord.put(record.getSeq(), record);
        this.transApi.getBankAccountFund(builder.build());
    }

    public void transferBankAccountFund(FundAccount fund, Bank bank, boolean InOut, double amount, String pwd, BankTransferRecord record) throws MException, Exception {
        PMainTenance.TransferBankAccountFundRequest.Builder builder = PMainTenance.TransferBankAccountFundRequest.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(fund.getMarketGrp());
        builder.setInvestorId(fund.getInvestId());
        builder.setBankNo(bank.getBankId());
        builder.setBankAccountNo(bank.getBankAccountId());
        String pwdDe = DesEncrypt.encrypt((String)pwd);
        String bankPwd = DesEncrypt.encrypt((String)bank.getBankPwd());
        if (InOut) {
            if (TRANSFER_IN_PWD_FLAG.contains(bank.getPasswordFlag().getRaw())) {
                builder.setBankAccountPassword(pwdDe);
            }
        } else {
            if (TRANSFER_OUT_PWD_FLAG.contains(bank.getPasswordFlag().getRaw())) {
                builder.setBankAccountPassword(bankPwd);
            }
            builder.setCustWithdrawPassword(pwdDe);
        }
        builder.setCurrencyId(bank.getCurrency().getRaw());
        builder.setAmount(amount);
        builder.setSeq(record.getSeq());
        this.mapRecord.put(record.getSeq(), record);
        this.transApi.transferBankAccountFund(builder.build());
    }

    public void getTransferBankAccountFundRecord(Bank bank, int seq, ObservableList<BankQueryParam> listRecord, String begDate, String endDate) throws MException, Exception {
        PMainTenance.GetTransferBankAccountFundRecordRequest.Builder builder = PMainTenance.GetTransferBankAccountFundRecordRequest.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(bank.getFund().getMarketGrp());
        builder.setInvestorId(bank.getFund().getInvestId());
        builder.setBankNo(bank.getBankId());
        builder.setBankAccountNo(bank.getBankAccountId());
        builder.setCurrencyId(bank.getCurrency().getRaw());
        builder.setBegDate(begDate);
        builder.setEndDate(endDate);
        builder.setSeq(seq);
        if (begDate.equals(this.nowDate)) {
            this.mapNowTransferRecord.put(seq, listRecord);
        } else {
            this.mapTransferRecord.put(seq, listRecord);
        }
        this.transApi.getTransferBankAccountFundRecord(builder.build());
    }

    public ObservableList<BankQueryParam> getListAllRecord() {
        return this.listAllRecord;
    }

    public void setListAllRecord(ObservableList<BankQueryParam> listAllRecord) {
        this.listAllRecord = listAllRecord;
    }

    public BooleanProperty changedBankProperty() {
        return this.changedBank;
    }

    public void changedBank() {
        this.changedBank.set(!this.changedBank.get());
    }
}

