/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.message;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.trade.XBondStrategy;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.pricingit.ExecMode;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.ExecutionReport;
import cms.tmx.http.api.strategy.dto.StrategyEvent;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxPart;
import cms.tmx.trade.message.MessagePrompt;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class XBondAlertMng {
    @Inject
    private MEventService es;
    @Inject
    private MxAlert alert;
    private static final int INTERVAL = 5000;
    private AtomicLong timeStrategy = new AtomicLong(0L);
    private AtomicLong time = new AtomicLong(0L);
    protected Gson gson = GsonFactory.getInstance();
    private LinkedList<MxPart> list = new LinkedList();

    @PostConstruct
    public void init() {
        this.es.subscribe("uap.push.StrategyEvent", event -> this.alert(event));
    }

    public void addPart(MxPart part) {
        this.list.add(part);
    }

    public void removePart(MxPart part) {
        this.list.remove(part);
    }

    public void alert(ExecutionReport report, MessagePrompt message) {
        if (this.list.isEmpty()) {
            return;
        }
        Instrument inst = report.getInstrument();
        if (!inst.getMarket().equals("XCFE")) {
            return;
        }
        ExecMode execMode = report.getExecMode();
        if (execMode.getEmName() != null) {
            return;
        }
        Long now = System.currentTimeMillis();
        if (now - this.time.get() < 5000L) {
            return;
        }
        if (message.getType().contains("\u5f02\u5e38")) {
            this.time.set(now);
            String info = message.getCont();
            Platform.runLater(() -> {
                boolean bl = this.alert.alert(Alert.AlertType.WARNING, info);
            });
        }
    }

    public void alert(MEvent event) {
        if (this.list.isEmpty()) {
            return;
        }
        StrategyEvent strategyEvent = (StrategyEvent)this.gson.fromJson(String.valueOf(event.getObj()), StrategyEvent.class);
        XBondStrategy strategy = new XBondStrategy();
        ContextSettings context = (ContextSettings)this.gson.fromJson(strategyEvent.getDetails(), ContextSettings.class);
        if ("200,201,202,300".contains(String.valueOf(context.getExecModeType()))) {
            return;
        }
        strategy.update((Object)context);
        Long now = System.currentTimeMillis();
        if (now - this.timeStrategy.get() < 5000L) {
            return;
        }
        if (strategy.getErrorMsg().contains("\u5f02\u5e38\u505c\u6b62")) {
            this.timeStrategy.set(now);
            String info = "\u7b56\u7565[" + strategy.getName() + "] " + strategy.getErrorMsg();
            Platform.runLater(() -> {
                boolean bl = this.alert.alert(Alert.AlertType.WARNING, info);
            });
        }
    }
}

