/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.message;

import cms.tmx.core.MScheduler;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.media.AudioClip;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SoundControl {
    private static final Logger logger = LogManager.getLogger(SoundControl.class);
    @Inject
    private MScheduler ms;
    @Inject
    private MScheduler schedulerAlgoStopped;
    @Inject
    private MScheduler schedulerAutoStopped;
    @Inject
    private MScheduler schedulerTaskStopped;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    public static final String INST_NOTICE_AUDIO = "instruction_notice.wav";
    public static final String DEAL_NOTICE_AUDIO = "deal_notice.wav";
    public static final String ERROR_NOTICE_AUDIO = "error_notice.wav";
    public static final String RISK_NOTICE_AUDIO = "risk_notice.wav";
    public static final String STRATEGY_ALGO_NOTICE_AUDIO = "strategy_notice.wav";
    public static final String STRATEGY_AUTO_NOTICE_AUDIO = "strategy_auto_notice.wav";
    public static final String TASK_STOP_NOTICE = "task_stop_notice.wav";
    private Map<Audio, AudioClip> map = new HashMap<Audio, AudioClip>();

    @PostConstruct
    private void init() {
        try {
            String pathInst = this.getPath(INST_NOTICE_AUDIO);
            this.map.put(Audio.INST, new AudioClip(pathInst));
            String pathDeal = this.getPath(DEAL_NOTICE_AUDIO);
            this.map.put(Audio.DEAL, new AudioClip(pathDeal));
            String pathErr = this.getPath(ERROR_NOTICE_AUDIO);
            this.map.put(Audio.ERROR, new AudioClip(pathErr));
            String pathRish = this.getPath(RISK_NOTICE_AUDIO);
            this.map.put(Audio.RISK, new AudioClip(pathRish));
            String pathStrategyAlgo = this.getPath(STRATEGY_ALGO_NOTICE_AUDIO);
            this.map.put(Audio.STRATEGY_ALGO, new AudioClip(pathStrategyAlgo));
            String pathStrategyAuto = this.getPath(STRATEGY_AUTO_NOTICE_AUDIO);
            this.map.put(Audio.STRATEGY_AUTO, new AudioClip(pathStrategyAuto));
            String pathTaskStop = this.getPath(TASK_STOP_NOTICE);
            this.map.put(Audio.TASK_STOP, new AudioClip(pathTaskStop));
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u52a0\u8f7d\u63d0\u793a\u97f3\u5931\u8d25\uff1a", (Throwable)e);
        }
        this.ms.setInterval(2000);
        this.schedulerAlgoStopped.setInterval(2000);
        this.schedulerAutoStopped.setInterval(2000);
    }

    private String getPath(String fileName) {
        String path = "";
        try {
            path = Paths.get(this.pathBase, "conf", fileName).toUri().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
        }
        return path;
    }

    public void notify(Audio audio) {
        AudioClip clip = this.map.get((Object)audio);
        if (clip != null) {
            this.ms.schedule(event -> {
                logger.info("====================> soundControl notifyPush");
                clip.stop();
                clip.play();
            });
        }
    }

    public void notifyAlgoStopped(Audio audio) {
        AudioClip clip = this.map.get((Object)audio);
        if (clip != null) {
            this.schedulerAlgoStopped.schedule(event -> {
                logger.info("====================> soundControl notifyPush (for algo strategy stopped)");
                clip.stop();
                clip.play();
            });
        }
    }

    public void notifyAutoStopped(Audio audio) {
        AudioClip clip = this.map.get((Object)audio);
        if (clip != null) {
            this.schedulerAutoStopped.schedule(event -> {
                logger.info("====================> soundControl notifyPush (for auto strategy stopped)");
                clip.stop();
                clip.play();
            });
        }
    }

    public void notifyTaskStopped(Audio audio) {
        AudioClip clip = this.map.get((Object)audio);
        if (clip != null) {
            this.schedulerTaskStopped.schedule(event -> {
                logger.info("====================> soundControl notifyPush (for auto strategy stopped)");
                clip.stop();
                clip.play();
            });
        }
    }

    public static enum Audio {
        NONE,
        INST,
        DEAL,
        ERROR,
        RISK,
        STRATEGY_ALGO,
        STRATEGY_AUTO,
        TASK_STOP;

    }
}

