/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.message;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.NoticeTipsSettings;
import cms.tmx.entity.web.settings.OrderTipsSettings;
import cms.tmx.notification.IMessage;
import cms.tmx.notification.INotifyService;
import cms.tmx.trade.message.MessagePrompt;
import cms.tmx.trade.message.SoundControl;
import cms.tmx.web.service.IUserSettingsService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NoticeTipsSettingsMng {
    private static final Logger logger = LogManager.getLogger(NoticeTipsSettingsMng.class);
    public static final String VOICE_DEF = "1";
    public static final String VOICE_MUTE = "2";
    @Inject
    private IUserSettingsService userSet;
    @Inject
    private INotifyService ns;
    @Inject
    private SoundControl sound;
    @Inject
    private MEventService es;
    @Inject
    private MxAlert alert;

    @PostConstruct
    public void init() {
        this.es.subscribe("topic.prompt", event -> this.updateTips(event));
    }

    private NoticeTipsSettings getTips() {
        NoticeTipsSettings tipSet = null;
        try {
            tipSet = (NoticeTipsSettings)this.userSet.getTipsSettings("0", "000004");
        }
        catch (MException e) {
            logger.error("get NoticeTipsSettings faild", (Throwable)e);
        }
        return tipSet;
    }

    public boolean forcedRemind() {
        try {
            OrderTipsSettings tipSet = (OrderTipsSettings)this.userSet.getTipsSettings("0", "000001");
            return tipSet.getExceptionTip();
        }
        catch (MException | Exception e) {
            logger.error("\u83b7\u53d6\u5f02\u5e38\u63d0\u793a\u8bbe\u7f6e\u5931\u8d25", e);
            return false;
        }
    }

    public synchronized void recordData(MessagePrompt message) {
        this.ns.recordData((IMessage)message);
    }

    public synchronized void recordShow(MessagePrompt message) {
        this.checkTips(message);
    }

    public void voicePrompt(String ntsType) {
        NoticeTipsSettings tipSet = this.getTips();
        if (tipSet == null) {
            return;
        }
        if ("\u98ce\u9669\u76d1\u63a7 ".equals(ntsType) && VOICE_DEF.equals(tipSet.getRiskMonitor())) {
            this.sound.notify(SoundControl.Audio.RISK);
        }
    }

    private void checkTips(MessagePrompt msg) {
        try {
            NoticeTipsSettings tipSet = this.getTips();
            String type = msg.getType();
            String name = (String)IMessage.TIPS_MAP.get(type);
            if (tipSet == null || name == null) {
                this.recordData(msg);
                return;
            }
            boolean forced = this.forcedRemind();
            forced = forced && (name.contains("Exception") || name.contains("risk"));
            Field fieldTips = NoticeTipsSettings.class.getDeclaredField(String.valueOf(name) + "Tips");
            Field field = NoticeTipsSettings.class.getDeclaredField(name);
            fieldTips.setAccessible(true);
            field.setAccessible(true);
            this.logger(msg, String.valueOf(fieldTips.get(tipSet)), String.valueOf(field.get(tipSet)), forced);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Deprecated
    private void checkPermissions(MessagePrompt msg) {
        NoticeTipsSettings tipSet = this.getTips();
        if (tipSet == null) {
            this.recordData(msg);
            return;
        }
        boolean forced = this.forcedRemind();
        switch (msg.getType()) {
            case "\u6307\u4ee4\u5ba1\u6279 ": {
                this.logger(msg, tipSet.getOrderApprovalTips(), tipSet.getOrderApproval());
                break;
            }
            case "\u6307\u4ee4\u5f02\u5e38 ": {
                this.logger(msg, tipSet.getOrderExceptionTips(), tipSet.getOrderException(), forced);
                break;
            }
            case "\u59d4\u6258\u5f02\u5e38 ": {
                this.logger(msg, tipSet.getTrustExceptionTips(), tipSet.getTrustException(), forced);
                break;
            }
            case "\u7b56\u7565\u5f02\u5e38 ": {
                this.logger(msg, tipSet.getStrategyExceptionTips(), tipSet.getStrategyException(), forced);
                break;
            }
            case "\u7cfb\u7edf\u5f02\u5e38 ": {
                this.logger(msg, tipSet.getSystemExceptionTips(), tipSet.getSystemException(), forced);
                break;
            }
            case "\u7f51\u7edc\u5f02\u5e38 ": {
                this.logger(msg, tipSet.getNetworkExceptionTips(), tipSet.getNetworkException(), forced);
                break;
            }
            case "\u98ce\u9669\u76d1\u63a7 ": {
                this.logger(msg, tipSet.getRiskMonitorTips(), tipSet.getRiskMonitor(), forced);
                break;
            }
            case "\u7b97\u6cd5\u5f02\u5e38 ": {
                this.logger(msg, tipSet.getAlgorithmExceptionTips(), tipSet.getAlgorithmException(), forced);
                break;
            }
            case "\u6307\u4ee4\u4e0b\u8fbe ": {
                this.logger(msg, tipSet.getOrderPlacedTips(), tipSet.getOrderPlaced());
                break;
            }
            case "\u59d4\u6258\u4e0b\u8fbe ": {
                this.logger(msg, tipSet.getTrustPlacedTips(), tipSet.getTrustPlaced());
                break;
            }
            case "\u59d4\u6258\u6210\u4ea4 ": {
                this.logger(msg, tipSet.getTrustDealedTips(), tipSet.getTrustDealed());
                break;
            }
            case "\u7528\u6237\u767b\u5f55 ": {
                this.logger(msg, tipSet.getUserLoginTips(), tipSet.getUserLogin());
                break;
            }
            case "\u5e02\u573a\u72b6\u6001 ": {
                this.logger(msg, tipSet.getMarketStatusTips(), tipSet.getMarketStatus());
                break;
            }
            case "\u529f\u80fd\u6743\u9650 ": {
                this.logger(msg, tipSet.getFuncPermissionsTips(), tipSet.getFuncPermissions());
                break;
            }
            case "\u6570\u636e\u6743\u9650 ": {
                this.logger(msg, tipSet.getDataPermissionsTips(), tipSet.getDataPermissions());
                break;
            }
            case "\u6307\u4ee4\u72b6\u6001 ": {
                this.logger(msg, tipSet.getOrderStatusTips(), tipSet.getOrderStatus());
            }
        }
    }

    private void logger(MessagePrompt msg, String tips, String voice, boolean forced) {
        if (VOICE_DEF.equals(tips)) {
            this.ns.recordShow((IMessage)msg);
        } else if (VOICE_MUTE.equals(tips)) {
            msg.setPark(true);
            this.ns.recordShow((IMessage)msg);
        } else if (forced) {
            this.ns.recordShow((IMessage)msg);
        } else {
            this.ns.recordData((IMessage)msg);
        }
        if (VOICE_DEF.equals(voice)) {
            SoundControl.Audio autio = msg.getAudio() == null ? SoundControl.Audio.DEAL : msg.getAudio();
            this.sound.notify(autio);
        }
    }

    private void logger(MessagePrompt msg, String tips, String voice) {
        this.logger(msg, tips, voice, false);
    }

    private void updateTips(MEvent event) {
        try {
            String type = (String)event.getObj(String.class);
            String tips = event.getStr(type);
            String name = (String)IMessage.TIPS_MAP.get(type);
            NoticeTipsSettings tipSet = this.getTips();
            StringBuilder builderName = new StringBuilder();
            builderName.append(Character.toUpperCase(name.charAt(0)));
            builderName.append(name.substring(1)).toString();
            Method method = NoticeTipsSettings.class.getMethod("set" + builderName.toString() + "Tips", String.class);
            method.invoke((Object)tipSet, tips);
            this.userSet.updateSettingsDetail((BaseSettings)tipSet);
        }
        catch (MException | Exception e) {
            logger.error((Object)e, e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

