/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.message;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.notification.MessagePromptApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.misc.PMisc;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.workflow.PWorkflow;
import cms.tmx.define.BsDict;
import cms.tmx.entity.notice.AlgorithmStatusNoticeReport;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.InstructionReport;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.notice.ResourceReport;
import cms.tmx.entity.notice.RiskMonitorReport;
import cms.tmx.entity.notice.StrategyNoticeReport;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.entity.trade.instruction.BasketOrderAdvice;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.http.api.strategy.dto.AlgoStatus;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.EventType;
import cms.tmx.http.api.strategy.dto.ExecType;
import cms.tmx.http.api.strategy.dto.HedgeStatus;
import cms.tmx.http.api.strategy.dto.HedgeTaskInfo;
import cms.tmx.http.api.strategy.dto.OrderCancelReject;
import cms.tmx.http.api.strategy.dto.RiskEvent;
import cms.tmx.http.api.strategy.dto.StrategyEvent;
import cms.tmx.http.api.strategy.dto.TransPosReport;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.http.workflow.dto.HttpInsPushMessage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.message.MessagePrompt;
import cms.tmx.trade.message.NoticeTipsSettingsMng;
import cms.tmx.trade.message.SoundControl;
import cms.tmx.trade.message.XBondAlertMng;
import cms.tmx.trade.utils.MessagePromptFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class MessagePromptMng {
    private Map<String, String> filter = new HashMap<String, String>();
    private static final String LOGIN = "\u767b\u5f55\u6210\u529f\uff01";
    private static final String EXIT = "\u9000\u51fa\u7cfb\u7edf\uff01";
    public static final String FIRST_LOGIN = "\u8fd9\u662f\u60a8\u9996\u6b21\u767b\u5f55\u4ea4\u6613\u5927\u5e08\uff0c\u6b22\u8fce\u4f7f\u7528\uff01";
    public static final String PB_IP = "\u672c\u6b21\u767b\u5f55IP\u4e0e\u4e0a\u6b21\u767b\u5f55IP\u4e0d\u7b26\uff0c\u5982\u679c\u4e0d\u662f\u60a8\u672c\u4eba\u884c\u4e3a\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u5bc6\u7801\uff01";
    public static final String PRO_IP = "\u672c\u6b21\u767b\u5f55IP\u4e0e\u4e0a\u6b21\u767b\u5f55IP\u4e0d\u7b26\uff0c\u5982\u679c\u4e0d\u662f\u60a8\u672c\u4eba\u884c\u4e3a\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u6211\u53f8\u6295\u987e\u66f4\u6539\uff01";
    public static final String PB_MAC = "\u672c\u6b21\u767b\u5f55\u8bbe\u5907\u4e0e\u4e0a\u6b21\u767b\u5f55\u8bbe\u5907\u4e0d\u540c\uff0c\u5982\u679c\u4e0d\u662f\u60a8\u672c\u4eba\u884c\u4e3a\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u5bc6\u7801\uff01";
    public static final String PRO_MAC = "\u672c\u6b21\u767b\u5f55\u8bbe\u5907\u4e0e\u4e0a\u6b21\u767b\u5f55\u8bbe\u5907\u4e0d\u540c\uff0c\u5982\u679c\u4e0d\u662f\u60a8\u672c\u4eba\u884c\u4e3a\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u6211\u53f8\u6295\u987e\u66f4\u6539\uff01";
    @Inject
    private MEventService es;
    @Inject
    private MessagePromptApi api;
    @Inject
    private MObjFactory of;
    @Inject
    private SoundControl sound;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private NoticeTipsSettingsMng ntsMng;
    @Inject
    private XBondAlertMng xbondMng;
    @Inject
    private MessagePromptFactory mpf;
    @Inject
    protected IBaseApi baseApi;
    private Gson gson = GsonFactory.getInstance();
    private static final Logger logger = LogManager.getLogger(MessagePromptMng.class);
    @Inject
    private MConfService cs;

    @PostConstruct
    public void init() {
        this.es.subscribe("server.hb.reconnected", event -> this.connected(true));
        this.es.subscribe("server.hb.disconnected", event -> this.connected(false));
        this.es.subscribe("market.hb.reconnected", event -> this.connectedMarket(true));
        this.es.subscribe("market.hb.disconnected", event -> this.connectedMarket(false));
        this.es.subscribe("future.market.hb.reconnected", event -> this.connectedFutureMarket(true));
        this.es.subscribe("future.market.hb.disconnected", event -> this.connectedFutureMarket(false));
        this.es.subscribe("server.web.reconnected", event -> this.connectedWeb(true));
        this.es.subscribe("server.web.disconnected", event -> this.connectedWeb(false));
        this.es.subscribe("strategy.hb.reconnected", event -> this.connectedStrategy(true));
        this.es.subscribe("strategy.hb.disconnected", event -> this.connectedStrategy(false));
        this.es.subscribe("stage.after.login", event -> this.logger("", "\u7528\u6237\u767b\u5f55 ", LOGIN));
        this.es.subscribe("message.first.login", event -> this.logger("", "\u7528\u6237\u767b\u5f55 ", FIRST_LOGIN));
        this.es.subscribe("message.info.login", event -> this.logger("\u7528\u6237\u767b\u5f55 ", event.getDesc()));
        this.es.subscribe("ip.pb.login", event -> this.ipLogin(true));
        this.es.subscribe("ip.pro.login", event -> this.ipLogin(false));
        this.es.subscribe("mac.pb.login", event -> this.macLogin(true));
        this.es.subscribe("mac.pro.login", event -> this.macLogin(false));
        this.es.subscribe("on.exit", event -> this.logger("", "\u7528\u6237\u767b\u5f55 ", EXIT));
        this.es.subscribe("message.log", event -> this.logger("\u6587\u4ef6\u5355", "\u59d4\u6258\u4e0b\u8fbe ", event.getDesc()));
        this.es.subscribe("message.notification", event -> this.onCall(event));
        this.es.subscribe("server.sub", event -> this.report(event));
        this.es.subscribe("mise_cancel", event -> this.algoMiseCancel(event));
        this.es.subscribe("block_trade", event -> this.blockTrade(event));
        this.es.subscribe("strategy_stopped_algo", event -> this.strategyAlgoStopped(event));
        this.es.subscribe("strategy_stopped_auto", event -> this.strategyAutoStopped(event));
        this.es.subscribe("uap.push.ExecutionReport", event -> this.httpExecutionReport(event));
        this.es.subscribe("uap.push.InsEvent", event -> this.httpInsReport(event));
        this.es.subscribe("uap.push.TransPosReport", event -> this.httpTransPosReport(event));
        this.es.subscribe("uap.push.RiskEvent", event -> this.riskReport(event));
        this.es.subscribe("uap.push.BondWarning", event -> this.httpBondWarningReport(event));
        this.es.subscribe("uap.push.StrategyEvent", event -> this.httpStrategyReport(event));
        this.es.subscribe("uap.push.HedgeTaskEvent", event -> this.httpStrategyReport(event));
        this.es.subscribe("uap.push.OrderCancelReject", event -> this.ordRejectReport(event));
        this.es.subscribe("market.no.message", event -> this.marketNoMessage(event));
        this.initFilter();
        this.of.create(MessagePrompt.class);
    }

    private void initFilter() {
        this.filter.put(this.api.getNewOrderSingleMethodCode(), "\u59d4\u6258\u4e0b\u8fbe ");
        this.filter.put(this.api.getNewOrderCrossMethodCode(), "\u59d4\u6258\u4e0b\u8fbe ");
        this.filter.put(this.api.getOrderCancelMethodCode(), "\u64a4\u5355");
        this.filter.put(this.api.getOrderCancelReplaceMethodCode(), "\u64a4\u5355\u91cd\u4e0b");
        this.filter.put(this.api.getAlgoOrderEntrustMethodCode(), "\u59d4\u6258\u4e0b\u8fbe ");
        this.filter.put(this.api.getAlgoOrderCancelMethodCode(), "\u64a4\u5355");
        this.filter.put(this.api.getAlgoOrderCancelReplaceMethodCode(), "\u64a4\u5355\u91cd\u4e0b");
        this.filter.put(this.api.getWorkFlowDoActionMethodCode(), "\u6307\u4ee4\u4e0b\u8fbe ");
        this.filter.put(this.api.getBlockOrderCancelMethodCode(), "\u64a4\u5355");
        this.filter.put(null, "\u7cfb\u7edf\u5f02\u5e38 ");
    }

    private void connected(boolean bool) {
        this.logger("", "\u7cfb\u7edf\u5f02\u5e38 ", bool ? "\u540e\u53f0\u91cd\u8fde\u6210\u529f\uff01" : "\u540e\u53f0\u8fde\u63a5\u65ad\u5f00\uff0c\u6b63\u5728\u91cd\u8fde...");
    }

    private void connectedMarket(boolean bool) {
        this.logger("", "\u7cfb\u7edf\u5f02\u5e38 ", bool ? "\u73b0\u8d27\u884c\u60c5\u670d\u52a1\u91cd\u8fde\u6210\u529f\uff01" : "\u73b0\u8d27\u884c\u60c5\u670d\u52a1\u8fde\u63a5\u65ad\u5f00\uff0c\u6b63\u5728\u91cd\u8fde...");
    }

    private void connectedFutureMarket(boolean bool) {
        this.logger("", "\u7cfb\u7edf\u5f02\u5e38 ", bool ? "\u671f\u8d27\u884c\u60c5\u670d\u52a1\u91cd\u8fde\u6210\u529f\uff01" : "\u671f\u8d27\u884c\u60c5\u670d\u52a1\u8fde\u63a5\u65ad\u5f00\uff0c\u6b63\u5728\u91cd\u8fde...");
    }

    private void connectedWeb(boolean bool) {
        this.logger("", "\u7cfb\u7edf\u5f02\u5e38 ", bool ? "web\u670d\u52a1\u91cd\u8fde\u6210\u529f\uff01" : "web\u670d\u52a1\u8fde\u63a5\u65ad\u5f00\uff0c\u6b63\u5728\u91cd\u8fde...");
    }

    private void connectedStrategy(boolean bool) {
        this.logger("", "\u7cfb\u7edf\u5f02\u5e38 ", bool ? "\u7b56\u7565\u670d\u52a1\u91cd\u8fde\u6210\u529f\uff01" : "\u7b56\u7565\u670d\u52a1\u8fde\u63a5\u65ad\u5f00\uff0c\u6b63\u5728\u91cd\u8fde...");
    }

    private void ipLogin(boolean bool) {
        this.logger("", "\u7cfb\u7edf\u5f02\u5e38 ", bool ? PB_IP : PRO_IP);
    }

    private void macLogin(boolean bool) {
        this.logger("", "\u7cfb\u7edf\u5f02\u5e38 ", bool ? PB_MAC : PRO_MAC);
    }

    private void onCall(MEvent event) {
        String function = event.getStr("method_code");
        Object savedObject = event.remove((Object)"saved_object");
        if (this.filter.containsKey(function)) {
            this.parse(savedObject, event);
        }
    }

    private void parse(Object param, MEvent event) {
        PPostTrade.TradeCaptureReport report;
        String function = event.getStr("method_code");
        String type = this.filter.get(function);
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.setType(type);
        PBase.OpStatus status = null;
        Object obj = event.getObj();
        if (obj instanceof PBase.OpStatus) {
            status = (PBase.OpStatus)PBase.OpStatus.class.cast(obj);
        } else if (obj instanceof PAlgorithmTrade.AlgoBaseOrderEntrustResp) {
            status = ((PAlgorithmTrade.AlgoBaseOrderEntrustResp)PAlgorithmTrade.AlgoBaseOrderEntrustResp.class.cast(obj)).getOpStatus();
        } else if (obj instanceof PAlgorithmTrade.AlgoBaseOrderCancleResp) {
            status = ((PAlgorithmTrade.AlgoBaseOrderCancleResp)PAlgorithmTrade.AlgoBaseOrderCancleResp.class.cast(obj)).getOpStatus();
        } else if (obj instanceof PAlgorithmTrade.AlgoBaseOrderCancelReplaceResp) {
            status = ((PAlgorithmTrade.AlgoBaseOrderCancelReplaceResp)PAlgorithmTrade.AlgoBaseOrderCancelReplaceResp.class.cast(obj)).getOpStatus();
        } else if (obj instanceof PWorkflow.DoActionResp) {
            status = ((PWorkflow.DoActionResp)PWorkflow.DoActionResp.class.cast(obj)).getStatus();
        }
        if (param instanceof PPostTrade.TradeCaptureReport && !(report = (PPostTrade.TradeCaptureReport)PPostTrade.TradeCaptureReport.class.cast(param)).getTradeReportType().equals((Object)PField.TradeReportType.TRADE_REPORT_TYPE_CANCEL)) {
            return;
        }
        message.setOpStatus(status);
        MessagePrompt msg = message.update(param);
        message.setType("\u59d4\u6258\u4e0b\u8fbe ");
        message.setAudio(SoundControl.Audio.DEAL);
        this.logger(message);
        if (msg != null) {
            message.setType("\u59d4\u6258\u4e0b\u8fbe ");
            message.setAudio(SoundControl.Audio.DEAL);
            this.logger(msg);
        }
    }

    private boolean careReport(MEvent event) {
        String userId;
        String type = event.getStr("push_type");
        MxNotice obj = (MxNotice)event.getObj(MxNotice.class);
        if (obj == null) {
            return false;
        }
        PMisc.Notice notice = obj.getNotice();
        String pushId = notice.getOpUser().getUserId();
        int index = pushId.indexOf("|");
        if (index != -1) {
            pushId = pushId.substring(0, index);
        }
        if (!pushId.equals(userId = this.eCore.getStr("user_id"))) {
            return false;
        }
        if (obj instanceof AlgorithmStatusNoticeReport) {
            return true;
        }
        if (type.equals("150") || type.equals("124")) {
            return true;
        }
        if (obj instanceof ExecutionReport) {
            return true;
        }
        if (obj instanceof CancelRejectReport) {
            return true;
        }
        if (obj instanceof RiskMonitorReport) {
            return true;
        }
        if (obj instanceof StrategyNoticeReport) {
            return true;
        }
        if (obj instanceof AlgorithmStatusNoticeReport) {
            return true;
        }
        if (event.getInt("push_type") == 600) {
            return false;
        }
        return obj.getNotice().getEventScope() == 10;
    }

    private void marketNoMessage(MEvent event) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.setType("\u7cfb\u7edf\u5f02\u5e38 ");
        message.setContent(event.getStr("reason"));
        message.setAudio(SoundControl.Audio.ERROR);
        this.logger(message);
    }

    private void httpTransPosReport(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        TransPosReport report = (TransPosReport)this.gson.fromJson(obj.toString(), TransPosReport.class);
        MxNode pushType = MxNodeFactory.create((String)"push_type");
        if (report.getExecType() != null) {
            pushType.setRaw(report.getExecType().getValue());
        }
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.setType(pushType.getValue());
        message.update((Object)report);
        String type = pushType.getRaw();
        if ("70".equals(type)) {
            message.setType("\u59d4\u6258\u6210\u4ea4 ");
            message.setAudio(SoundControl.Audio.DEAL);
            this.logger(message);
        } else if ("56".equals(type)) {
            message.setType("\u59d4\u6258\u5f02\u5e38 ");
            message.setAudio(SoundControl.Audio.ERROR);
            this.logger(message);
        } else {
            message.setType("\u59d4\u6258\u6210\u4ea4 ");
            message.setAudio(SoundControl.Audio.DEAL);
            this.logger(message);
        }
    }

    private void ordRejectReport(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrderCancelReject strategyEvent = (OrderCancelReject)this.gson.fromJson((JsonElement)obj, OrderCancelReject.class);
        MessagePrompt message = (MessagePrompt)this.of.create(MessagePrompt.class);
        message.update(strategyEvent);
        message.setType("\u59d4\u6258\u5f02\u5e38 ");
        message.setAudio(SoundControl.Audio.ERROR);
        this.logger(message);
    }

    private void httpExecutionReport(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        cms.tmx.http.api.strategy.dto.ExecutionReport executionReport = (cms.tmx.http.api.strategy.dto.ExecutionReport)this.gson.fromJson((JsonElement)obj, cms.tmx.http.api.strategy.dto.ExecutionReport.class);
        MxNode pushType = MxNodeFactory.create((String)"push_type");
        if (executionReport.getExecType() != null) {
            if (executionReport.getExecType().equals((Object)ExecType.EXEC_TYPE_PENDING_CANCEL) || executionReport.getExecType().equals((Object)ExecType.EXEC_TYPE_PENDING_NEW)) {
                return;
            }
            pushType.setRaw(executionReport.getExecType().getValue());
        }
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.setType(pushType.getValue());
        message.update((Object)executionReport);
        String type = pushType.getRaw();
        if ("70".equals(type)) {
            message.setType("\u59d4\u6258\u6210\u4ea4 ");
            message.setAudio(SoundControl.Audio.DEAL);
            this.logger(message);
        } else if ("56".equals(type)) {
            message.setType("\u59d4\u6258\u5f02\u5e38 ");
            message.setAudio(SoundControl.Audio.ERROR);
            this.logger(message);
        } else if ("48".equals(type)) {
            message.setType("\u59d4\u6258\u4e0b\u8fbe ");
            message.setAudio(SoundControl.Audio.DEAL);
            this.logger(message);
        } else if ("52".equals(type)) {
            message.setType("\u59d4\u6258\u4e0b\u8fbe ");
            message.setAudio(SoundControl.Audio.NONE);
            this.logger(message);
        } else {
            message.setType("\u59d4\u6258\u6210\u4ea4 ");
            message.setAudio(SoundControl.Audio.DEAL);
            this.logger(message);
        }
        this.xbondMng.alert(executionReport, message);
    }

    private void httpInsReport(MEvent event) {
        JsonObject pushMsg = (JsonObject)event.getObj(JsonObject.class);
        logger.info("instruction push :" + pushMsg.toString());
        HttpInsPushMessage insPushMsg = (HttpInsPushMessage)this.gson.fromJson(pushMsg.toString(), HttpInsPushMessage.class);
        if (insPushMsg == null || insPushMsg.getInstruction() == null || insPushMsg.getTimestamp() == 0L) {
            return;
        }
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.update((Object)insPushMsg);
        if (!"\u6307\u4ee4\u5f02\u5e38 ".equals(message.getType())) {
            String submitted = (String)BsDict.NEW_INSTRUCTION_STATUS_MAP.get("kStatusSubmitted");
            String executing = (String)BsDict.NEW_INSTRUCTION_STATUS_MAP.get("kStatusExecuting");
            if (message.getCont().contains(submitted) || message.getCont().contains(executing)) {
                message.setType("\u6307\u4ee4\u72b6\u6001 ");
            } else {
                message.setType("\u6307\u4ee4\u72b6\u6001 ");
            }
            message.setAudio(SoundControl.Audio.INST);
        }
        this.logger(message);
    }

    private void riskReport(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        RiskEvent risk = (RiskEvent)this.gson.fromJson((JsonElement)obj, RiskEvent.class);
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.setType("\u98ce\u9669\u76d1\u63a7 ");
        message.update((Object)risk.getRiskResult());
        message.setType("\u98ce\u9669\u76d1\u63a7 ");
        message.setAudio(SoundControl.Audio.RISK);
        this.logger(message);
    }

    private void httpBondWarningReport(MEvent event) {
        Object obj = event.getObj();
        if (obj instanceof JsonPrimitive) {
            String content = ((JsonPrimitive)JsonPrimitive.class.cast(obj)).getAsString();
            MessagePrompt message = this.mpf.createMessagePrompt();
            message.setContent(content);
            message.setType("\u98ce\u9669\u76d1\u63a7 ");
            message.setAudio(SoundControl.Audio.RISK);
            this.logger(message);
        }
    }

    private void httpStrategyReport(MEvent event) {
        HedgeTaskInfo taskInfo;
        JsonElement obj = (JsonElement)event.getObj();
        StrategyEvent strategyEvent = (StrategyEvent)this.gson.fromJson(String.valueOf(obj), StrategyEvent.class);
        String pushType = event.getStr("push_type");
        MessagePrompt message = (MessagePrompt)this.of.create(MessagePrompt.class);
        if (EventType.NOTICE.equals((Object)strategyEvent.getType())) {
            return;
        }
        if ("StrategyEvent".equals(pushType)) {
            ContextSettings context = (ContextSettings)this.gson.fromJson(strategyEvent.getDetails(), ContextSettings.class);
            if (context.getText() != null && context.getAlgoStatus().equals((Object)AlgoStatus.ALGO_STATUS_STOPPED)) {
                message.update((Object)context);
                message.setType("\u7b56\u7565\u5f02\u5e38 ");
                message.setAudio(SoundControl.Audio.ERROR);
                this.logger(message);
            }
        } else if ("HedgeTaskEvent".equals(pushType) && (taskInfo = (HedgeTaskInfo)this.gson.fromJson(strategyEvent.getDetails(), HedgeTaskInfo.class)).getText() != null && taskInfo.getHedgeStatus().equals((Object)HedgeStatus.HEDGE_STATUS_STOPPED)) {
            message.update((Object)taskInfo);
            message.setType("\u7b56\u7565\u5f02\u5e38 ");
            message.setAudio(SoundControl.Audio.ERROR);
            this.logger(message);
        }
    }

    private void report(MEvent event) {
        if (!this.careReport(event)) {
            return;
        }
        try {
            MxNotice obj = (MxNotice)event.getObj(MxNotice.class);
            MxNode pushType = MxNodeFactory.create((String)"push_type");
            if (obj instanceof ExecutionReport) {
                ExecutionReport report = (ExecutionReport)event.getObj(ExecutionReport.class);
                pushType.setRaw(String.valueOf(report.getType()));
            }
            MessagePrompt message = this.mpf.createMessagePrompt();
            message.setType(pushType.getValue());
            message.update(event.getObj());
            String type = pushType.getRaw();
            boolean instPush = this.cs.getValueAsBool("instruction.push.prompt", true);
            if (obj instanceof RiskMonitorReport) {
                message.setType("\u98ce\u9669\u76d1\u63a7 ");
                message.setAudio(SoundControl.Audio.RISK);
                this.logger(message);
            } else if ("70".equals(type)) {
                message.setType("\u59d4\u6258\u6210\u4ea4 ");
                message.setAudio(SoundControl.Audio.DEAL);
                this.logger(message);
            } else if ("56".equals(type)) {
                message.setType("\u59d4\u6258\u5f02\u5e38 ");
                message.setAudio(SoundControl.Audio.ERROR);
                this.logger(message);
            } else if ("48".equals(type) || "52".equals(type) || obj instanceof CancelRejectReport) {
                message.setType("\u59d4\u6258\u4e0b\u8fbe ");
                message.setAudio(SoundControl.Audio.DEAL);
                this.logger(message);
            } else if (obj instanceof StrategyNoticeReport) {
                message.setType("\u7b56\u7565\u5f02\u5e38 ");
                message.setAudio(SoundControl.Audio.ERROR);
                this.logger(message);
            } else if (instPush && obj instanceof InstructionReport) {
                if (!"\u6307\u4ee4\u5f02\u5e38 ".equals(message.getType())) {
                    if (message.getCont().contains("\u5ba1\u6279\u4e2d")) {
                        message.setType("\u6307\u4ee4\u5ba1\u6279 ");
                    } else {
                        message.setType("\u6307\u4ee4\u72b6\u6001 ");
                    }
                    message.setAudio(SoundControl.Audio.INST);
                }
                this.logger(message);
            } else if (instPush && obj instanceof ResourceReport) {
                message.setType("\u6307\u4ee4\u4e0b\u8fbe ");
                message.setAudio(SoundControl.Audio.INST);
                this.logger(message);
            } else if (instPush && obj instanceof AlgorithmStatusNoticeReport) {
                if (message.getAlgoStatus().getRaw().equals("1") || message.getAlgoStatus().getRaw().equals("2") || message.getAlgoStatus().getRaw().equals("3")) {
                    message.setType("\u7b97\u6cd5\u72b6\u6001 ");
                    message.setAudio(SoundControl.Audio.DEAL);
                    if (message.getAccount().equals(this.baseApi.getOpUser().getUserId())) {
                        message.setAccount("");
                    }
                    this.logger(message);
                } else if (message.getAlgoStatus().getRaw().equals("999") || message.getAlgoStatus().getRaw().equals("5")) {
                    message.setType("\u7b97\u6cd5\u5f02\u5e38 ");
                    message.setAudio(SoundControl.Audio.ERROR);
                    if (message.getAccount().equals(this.baseApi.getOpUser().getUserId())) {
                        message.setAccount("");
                    }
                    this.logger(message);
                }
            }
        }
        catch (Exception e) {
            logger.error("push message prompt faild: ", (Throwable)e);
        }
    }

    public void loggerData(String account, String type, String content) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.setAccount(account);
        message.setType(type);
        message.setContent(content);
        this.loggerData(message);
    }

    public void logger(String account, String type, String content) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.setAccount(account);
        message.setType(type);
        message.setContent(content);
        this.logger(message);
    }

    public void logger(String type, String content) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.setType(type);
        message.setContent(content);
        this.logger(message);
    }

    public synchronized void loggerData(MessagePrompt message) {
        message.CheckExceptionTip();
        this.ntsMng.recordData(message);
    }

    public synchronized void logger(MessagePrompt message) {
        message.CheckExceptionTip();
        this.ntsMng.recordShow(message);
    }

    public void basketInst(BasketOrderAdvice advice, String panelType, Object obj, String risk) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.updateBasketInst(advice, panelType, obj, risk);
        message.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        message.setAudio(SoundControl.Audio.INST);
        this.logger(message);
    }

    public void regularInst(OrderAdvice advice, String panelType, Object obj, String risk) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.updateRegularInst(advice, panelType, obj, risk);
        message.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        message.setAudio(SoundControl.Audio.INST);
        this.logger(message);
    }

    public void algoInst(AlgoParam param, String panelType, Object obj, String risk) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.updateAlgoInst(param, panelType, obj, risk);
        message.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        message.setAudio(SoundControl.Audio.INST);
        this.logger(message);
    }

    public void algoMise(AdjustPosAdvice adj, String panelType, Object obj) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.updateMise(adj, panelType, obj);
        message.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        message.setAudio(SoundControl.Audio.INST);
        this.logger(message);
    }

    public void algoMiseOrder(MEvent event, Object obj) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.updateMiseOrder(event, obj);
        message.setType("\u59d4\u6258\u4e0b\u8fbe ");
        message.setAudio(SoundControl.Audio.DEAL);
        this.logger(message);
    }

    public void algoMiseCancel(MEvent event) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.updateMiseCancel(event);
        message.setType("\u59d4\u6258\u4e0b\u8fbe ");
        message.setAudio(SoundControl.Audio.DEAL);
        this.logger(message);
    }

    public void blockTrade(MEvent event) {
        MessagePrompt message = this.mpf.createMessagePrompt();
        message.updateBlockTrade(event);
        message.setType("\u59d4\u6258\u4e0b\u8fbe ");
        message.setAudio(SoundControl.Audio.DEAL);
        this.logger(message);
    }

    public void strategyAlgoStopped(MEvent event) {
        this.sound.notifyAlgoStopped(SoundControl.Audio.STRATEGY_ALGO);
    }

    public void strategyAutoStopped(MEvent event) {
        this.sound.notifyAlgoStopped(SoundControl.Audio.STRATEGY_AUTO);
    }
}

