/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.message;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.PResource;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.datatype.proto.unify_risk.PRiskSyncService;
import cms.tmx.datatype.proto.unify_risk.PUnifyRiskService;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.datatype.proto.workflow.PWorkflow;
import cms.tmx.define.BsDict;
import cms.tmx.define.IErrorMsg;
import cms.tmx.entity.BlockTradeParam;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.notice.AlgorithmStatusNoticeReport;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.InstructionReport;
import cms.tmx.entity.notice.ListExecuteReport;
import cms.tmx.entity.notice.ResourceReport;
import cms.tmx.entity.notice.RiskMonitorReport;
import cms.tmx.entity.notice.StrategyNoticeReport;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.entity.trade.instruction.BasketOrderAdvice;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.entity.web.settings.OrderTipsSettings;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.ContextSettings;
import cms.tmx.http.api.strategy.dto.CustomContextSettings;
import cms.tmx.http.api.strategy.dto.EntrustAction;
import cms.tmx.http.api.strategy.dto.ExecutionReport;
import cms.tmx.http.api.strategy.dto.HedgeTaskInfo;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.OrderCancelReject;
import cms.tmx.http.api.strategy.dto.RiskResult;
import cms.tmx.http.api.strategy.dto.RiskRetCode;
import cms.tmx.http.api.strategy.dto.TransPosReport;
import cms.tmx.http.api.strategy.dto.XbondContextSettings;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.http.workflow.dto.HttpInsPushMessage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.notification.IMessage;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.trade.message.SoundControl;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.service.IUserSettingsService;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MessagePrompt
implements IMessage {
    private String account = "";
    private String type = "";
    private String content = "";
    private String checkType = "";
    private SoundControl.Audio audio;
    private boolean park;
    private PBase.OpStatus opStatus;
    private static MxNode node;
    private static MxNode side;
    private static MxNode algo;
    private static MxNode basketPrice;
    private static MxNode basketStg;
    private static MxNode basketSide;
    private static MxNode marketNode;
    private static MxNode blockType;
    private static MxNode execType;
    private static MxNode ordStatus;
    private static MxNode riskType;
    private static MxNode riskAction;
    private static MxNode strategyType;
    private static MxNode positionEffect;
    private static MxNode instructionType;
    private static MxNode algoStatus;
    @Inject
    private IErrorMsg error;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private PortfolioAccountModel modPort;
    @Inject
    private InstructionModel modInst;
    @Inject
    private IUserSettingsService userSet;
    @Inject
    private IFundAccountService fundService;
    private static final Logger logger;
    private static final int LT_NEW_TASK = 1;
    private static final int LT_CANCEL_TASK = 2;
    private static final int LT_REPLACE_TASK = 3;
    private static final int ORDER = 1;
    private static final int CANCEL = 2;
    private static final int REPLACE = 3;
    private double count;
    private static final String STRATEGY = "\u7b56\u7565\u6267\u884c,";
    private volatile boolean excTip = false;
    private volatile boolean excTipFlag = true;

    static {
        logger = LogManager.getLogger(MessagePrompt.class);
    }

    @PostConstruct
    public void init() {
        if (node == null) {
            node = MxNodeFactory.create((String)"market_code", (String)"");
        }
        if (side == null) {
            side = MxNodeFactory.create((String)"side", (String)"");
        }
        if (algo == null) {
            algo = MxNodeFactory.create((String)"algo_name", (String)"");
        }
        if (basketPrice == null) {
            basketPrice = MxNodeFactory.create((String)"bsk_handicap", (String)"");
        }
        if (basketStg == null) {
            basketStg = MxNodeFactory.create((String)"basket_strategy_type", (String)"");
        }
        if (basketSide == null) {
            basketSide = MxNodeFactory.create((String)"basket_side", (String)"");
        }
        if (marketNode == null) {
            marketNode = MxNodeFactory.create((String)"market_code", (String)"");
        }
        if (blockType == null) {
            blockType = MxNodeFactory.create((String)"block_fixed_ord_type", (String)"");
        }
        if (execType == null) {
            execType = MxNodeFactory.create((String)"execution_type", (String)"");
        }
        if (ordStatus == null) {
            ordStatus = MxNodeFactory.create((String)"ord_status");
        }
        if (riskType == null) {
            riskType = MxNodeFactory.create((String)"risk_type");
        }
        if (riskAction == null) {
            riskAction = MxNodeFactory.create((String)"risk_action");
        }
        if (strategyType == null) {
            strategyType = MxNodeFactory.create((String)"future_strategy_type");
        }
        if (positionEffect == null) {
            positionEffect = MxNodeFactory.create((String)"position_effect");
        }
        if (instructionType == null) {
            instructionType = MxNodeFactory.create((String)"instruction_status");
        }
        if (algoStatus == null) {
            algoStatus = MxNodeFactory.create((String)"algo_status");
        }
    }

    public MessagePrompt() {
        if (node == null) {
            node = MxNodeFactory.create((String)"market_code", (String)"");
        }
        if (side == null) {
            side = MxNodeFactory.create((String)"side", (String)"");
        }
        if (algo == null) {
            algo = MxNodeFactory.create((String)"algo_name", (String)"");
        }
        if (basketPrice == null) {
            basketPrice = MxNodeFactory.create((String)"bsk_handicap", (String)"");
        }
        if (basketStg == null) {
            basketStg = MxNodeFactory.create((String)"basket_strategy_type", (String)"");
        }
        if (basketSide == null) {
            basketSide = MxNodeFactory.create((String)"basket_side", (String)"");
        }
        if (marketNode == null) {
            marketNode = MxNodeFactory.create((String)"market_code", (String)"");
        }
        if (blockType == null) {
            blockType = MxNodeFactory.create((String)"block_fixed_ord_type", (String)"");
        }
        if (execType == null) {
            execType = MxNodeFactory.create((String)"execution_type", (String)"");
        }
        if (ordStatus == null) {
            ordStatus = MxNodeFactory.create((String)"ord_status");
        }
        if (riskType == null) {
            riskType = MxNodeFactory.create((String)"risk_type");
        }
        if (riskAction == null) {
            riskAction = MxNodeFactory.create((String)"risk_action");
        }
        if (strategyType == null) {
            strategyType = MxNodeFactory.create((String)"future_strategy_type");
        }
        if (positionEffect == null) {
            positionEffect = MxNodeFactory.create((String)"position_effect");
        }
        if (instructionType == null) {
            instructionType = MxNodeFactory.create((String)"instruction_status");
        }
        if (algoStatus == null) {
            algoStatus = MxNodeFactory.create((String)"algo_status");
        }
    }

    public MessagePrompt update(Object obj) {
        if (obj instanceof PMessage.NewOrderSingle) {
            this.update((PMessage.NewOrderSingle)PMessage.NewOrderSingle.class.cast(obj));
        } else {
            if (obj instanceof PMessage.NewOrderCross) {
                return this.update((PMessage.NewOrderCross)PMessage.NewOrderCross.class.cast(obj));
            }
            if (obj instanceof PMessage.OrderCancelRequest) {
                this.update((PMessage.OrderCancelRequest)PMessage.OrderCancelRequest.class.cast(obj));
            } else if (obj instanceof PMessage.OrderCancelReplaceRequest) {
                this.update((PMessage.OrderCancelReplaceRequest)PMessage.OrderCancelReplaceRequest.class.cast(obj));
            } else if (obj instanceof ListExecuteReport) {
                this.update((ListExecuteReport)ListExecuteReport.class.cast(obj));
            } else if (obj instanceof PAlgorithmTrade.AlgoBaseOrderEntrust) {
                this.update((PAlgorithmTrade.AlgoBaseOrderEntrust)PAlgorithmTrade.AlgoBaseOrderEntrust.class.cast(obj));
            } else if (obj instanceof PAlgorithmTrade.AlgoBaseOrderCancel) {
                this.update((PAlgorithmTrade.AlgoBaseOrderCancel)PAlgorithmTrade.AlgoBaseOrderCancel.class.cast(obj));
            } else if (obj instanceof PAlgorithmTrade.AlgoBaseOrderCancelReplaceRequest) {
                this.update((PAlgorithmTrade.AlgoBaseOrderCancelReplaceRequest)PAlgorithmTrade.AlgoBaseOrderCancelReplaceRequest.class.cast(obj));
            } else if (obj instanceof AlgorithmStatusNoticeReport) {
                this.update((AlgorithmStatusNoticeReport)AlgorithmStatusNoticeReport.class.cast(obj));
            } else if (obj instanceof PInstructionManagement.NewInstructionReq) {
                try {
                    this.update((PInstructionManagement.NewInstructionReq)PInstructionManagement.NewInstructionReq.class.cast(obj));
                }
                catch (InvalidProtocolBufferException e) {
                    logger.error("InvalidProtocolBufferException", (Throwable)e);
                }
            } else if (obj instanceof PWorkflow.DoActionReq) {
                this.update((PWorkflow.DoActionReq)PWorkflow.DoActionReq.class.cast(obj));
            } else if (obj instanceof cms.tmx.entity.notice.ExecutionReport) {
                this.update((cms.tmx.entity.notice.ExecutionReport)cms.tmx.entity.notice.ExecutionReport.class.cast(obj));
            } else if (obj instanceof CancelRejectReport) {
                this.update((CancelRejectReport)CancelRejectReport.class.cast(obj));
            } else if (obj instanceof PPostTrade.TradeCaptureReport) {
                this.update((PPostTrade.TradeCaptureReport)PPostTrade.TradeCaptureReport.class.cast(obj));
            } else if (obj instanceof RiskMonitorReport) {
                this.update((RiskMonitorReport)RiskMonitorReport.class.cast(obj));
            } else if (obj instanceof StrategyNoticeReport) {
                this.update((StrategyNoticeReport)StrategyNoticeReport.class.cast(obj));
            } else if (obj instanceof InstructionReport) {
                this.update((InstructionReport)InstructionReport.class.cast(obj));
            } else if (obj instanceof ExecutionReport) {
                this.update((ExecutionReport)ExecutionReport.class.cast(obj));
            } else if (obj instanceof TransPosReport) {
                this.update((TransPosReport)TransPosReport.class.cast(obj));
            } else if (obj instanceof ResourceReport) {
                this.update((ResourceReport)ResourceReport.class.cast(obj));
            } else if (obj instanceof RiskResult) {
                this.update((RiskResult)RiskResult.class.cast(obj));
            } else if (obj instanceof HttpInsPushMessage) {
                this.update((HttpInsPushMessage)HttpInsPushMessage.class.cast(obj));
            } else if (obj instanceof ContextSettings) {
                this.update((ContextSettings)ContextSettings.class.cast(obj));
            } else if (obj instanceof HedgeTaskInfo) {
                this.update((HedgeTaskInfo)HedgeTaskInfo.class.cast(obj));
            } else if (obj instanceof OrderCancelReject) {
                this.update((OrderCancelReject)OrderCancelReject.class.cast(obj));
            }
        }
        return null;
    }

    public void update(PMessage.NewOrderSingle single) {
        this.setAccount(single.getExtAccntId().replaceAll("[_A-Z]*$", ""));
        String result = this.checkStatus(this.opStatus);
        if ("\u4e0b\u5355\u5931\u8d25,".equals(result) && this.getExceptionTip()) {
            this.setCheckType("true");
        }
        PComponent.Instrument inst = single.getInstrument();
        String type = inst.getSecurityType();
        String secCode = inst.getSecurityId();
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        RefItem refItem = this.refMng.getItem(type, inst.getMarket(), secCode);
        String secName = refItem == null ? "" : refItem.getName();
        String bs = this.checkSide(single.getSide(), single.getPositionEffect());
        int ordType = single.getOrdTypeValue();
        String price = 49 == ordType ? "" : StringUtils.toStr((double)single.getPrice(), (int)(refItem == null ? 3 : refItem.getScale()));
        int count = (int)single.getOrderQty();
        String cause = this.checkCause(this.opStatus);
        String content = MessagePrompt.pack(result, secCode, market, secName, bs, price, count, cause);
        this.setContent(content);
    }

    public MessagePrompt update(PMessage.NewOrderCross cross) {
        this.setAccount(cross.getExtAccntId().replaceAll("[_A-Z]*$", ""));
        String result = this.checkStatus(this.opStatus);
        PComponent.Instrument inst = cross.getInstrument();
        String type = inst.getSecurityType();
        String secCode = inst.getSecurityId();
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        RefItem refItem = this.refMng.getItem(type, inst.getMarket(), secCode);
        String secName = refItem.getName();
        String cause = this.checkCause(this.opStatus);
        if (this.opStatus.getStatus() != 1) {
            String content = MessagePrompt.pack("\u53cc\u8fb9\u5355\u4e0b\u5355\u5931\u8d25,", secCode, market, secName, cause);
            this.setContent(content);
            return null;
        }
        PComponent.SideCrossOrdMod ordMod1 = cross.getModSide(0);
        String bs = this.checkSide(ordMod1.getSideValue());
        String price = StringUtils.toStr((double)ordMod1.getPrice(), (int)refItem.getScale());
        int count = (int)ordMod1.getOrderQty();
        String content = MessagePrompt.pack(result, secCode, market, secName, bs, price, count, cause);
        this.setContent(content);
        PComponent.SideCrossOrdMod ordMod2 = cross.getModSide(1);
        MessagePrompt msg = this.clone(this);
        bs = this.checkSide(ordMod2.getSideValue());
        price = StringUtils.toStr((double)ordMod2.getPrice(), (int)refItem.getScale());
        count = (int)ordMod2.getOrderQty();
        content = MessagePrompt.pack(result, secCode, market, secName, bs, price, count, cause);
        msg.setContent(content);
        return msg;
    }

    public void update(PMessage.OrderCancelRequest cancel) {
        PComponent.Instrument inst;
        String type;
        this.setAccount(cancel.getExtAccntId().replaceAll("[_A-Z]*$", ""));
        String result = this.checkResult(this.opStatus);
        if ("\u64a4\u5355\u5931\u8d25,".equals(result) && this.getExceptionTip()) {
            this.setCheckType("true");
        }
        if ((type = (inst = cancel.getInstrument()).getSecurityType()).isEmpty() && inst.getMarketGroup().equals("FUTURES")) {
            type = "FUT";
        }
        String secCode = inst.getSecurityId();
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        RefItem refItem = this.refMng.getItem(type, inst.getMarket(), secCode);
        String secName = refItem == null ? "" : refItem.getName();
        String cause = this.checkCause(this.opStatus);
        String content = MessagePrompt.pack(result, secCode, market, secName, cause);
        this.setContent(content);
    }

    public void update(OrderCancelReject rej) {
        String invesId = this.fundService.getCcsInvesId(rej.getExtAccntId());
        if (!StringUtils.isEmpty((String)invesId)) {
            this.setAccount(invesId);
        }
        String id = rej.getOrderId();
        String text = rej.getRejMsg();
        if (StringUtils.isEmpty((String)text)) {
            text = rej.getCxlRejReason();
        }
        String securitId = "";
        String market = "";
        if (rej.getInstrument() != null) {
            securitId = rej.getInstrument().getSecurityId();
            marketNode.setRaw(rej.getInstrument().getMarket());
            market = marketNode.getValue();
        }
        String content = MessagePrompt.pack(id, securitId, market, "\u64a4\u5355\u88ab\u62d2,\u539f\u56e0:", text);
        this.setContent(content);
    }

    public void update(PMessage.OrderCancelReplaceRequest replace) {
        this.setAccount(replace.getExtAccntId().replaceAll("[_A-Z]$*", ""));
        String result = this.checkReplace(this.opStatus);
        PComponent.Instrument inst = replace.getInstrument();
        String type = inst.getSecurityType();
        if (type.isEmpty() && inst.getMarketGroup().equals("FUTURES")) {
            type = "FUT";
        }
        String secCode = inst.getSecurityId();
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        RefItem refItem = this.refMng.getItem(type, inst.getMarket(), secCode);
        String secName = refItem == null ? "" : refItem.getName();
        String cause = this.checkCause(this.opStatus);
        int ordType = replace.getOrdTypeValue();
        String price = 49 == ordType ? "" : StringUtils.toStr((double)replace.getPrice(), (int)(refItem == null ? 3 : refItem.getScale()));
        String content = MessagePrompt.pack(result, secCode, market, secName, price, cause);
        this.setContent(content);
    }

    public void update(ListExecuteReport report) {
        POrderService.ListExecuteReport re = report.getReport();
        String listId = re.getListId();
        this.setAccount(re.getExtAccntId().replaceAll("[_A-Z]*$", ""));
        String type = this.checkListReport(re.getListExecType());
        this.setType(type);
        int succNum = re.getSuccessNum();
        int failNum = re.getFailNum();
        String content = MessagePrompt.pack(String.valueOf(type) + "\u63d0\u4ea4,", "\u6279\u6b21\u53f7" + listId, "\u6210\u529f" + succNum + "\u7b14", "\u5931\u8d25" + failNum + "\u7b14");
        if (failNum > 0) {
            content = String.valueOf(content) + "\u8bf7\u67e5\u770b\u59d4\u6258\u8be6\u60c5";
        }
        this.setContent(content);
    }

    private String checkListReport(int op) {
        logger.debug("op: " + op);
        if (op == 1) {
            return "\u4e0b\u5355";
        }
        if (op == 2) {
            return "\u64a4\u5355";
        }
        if (op == 3) {
            return "\u64a4\u5355\u91cd\u4e0b";
        }
        return "\u672a\u5b9a\u4e49";
    }

    private MessagePrompt clone(MessagePrompt msg) {
        MessagePrompt mp = new MessagePrompt();
        mp.setAccount(msg.getAccount());
        mp.setType(msg.getType());
        return mp;
    }

    private void update(PAlgorithmTrade.AlgoBaseOrderEntrust algo) {
        String fundAcc = algo.getExtAccntId();
        this.setAccount(fundAcc.replaceAll("[_A-Z]*$", ""));
        String result = this.checkStatus(this.opStatus);
        PAlgorithmTrade.Instrument inst = algo.getInstrument();
        String secCode = inst.getSecurityId();
        String secName = inst.getSymbol();
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        String bs = this.checkAlgo(algo.getSideValue(), algo.getAlgorithmTypeValue());
        String price = "";
        int count = algo.getOrderQty();
        String cause = this.checkCause(this.opStatus);
        String content = MessagePrompt.pack(result, secCode, market, secName, bs, price, count, cause);
        this.setContent(content);
    }

    private void update(PAlgorithmTrade.AlgoBaseOrderCancel cancel) {
        int algoType = cancel.getAlgoTypeValue();
        algo.setRaw(String.valueOf(algoType));
        String algoName = algo.getValue();
        String id = cancel.getAlgoSysOrderId();
        String result = this.checkResult(this.opStatus);
        String cause = this.checkCause(this.opStatus);
        String content = MessagePrompt.pack(result, algoName, id, cause);
        this.setContent(content);
    }

    private void update(PAlgorithmTrade.AlgoBaseOrderCancelReplaceRequest cancel) {
        int algoType = cancel.getAlgoTypeValue();
        algo.setRaw(String.valueOf(algoType));
        String algoName = algo.getValue();
        String id = cancel.getOrigAlgoSysOrderId();
        String result = this.checkReplace(this.opStatus);
        String cause = this.checkCause(this.opStatus);
        String content = MessagePrompt.pack(result, algoName, id, cause);
        this.setContent(content);
    }

    private void update(PInstructionManagement.NewInstructionReq instReq) throws InvalidProtocolBufferException {
        PInstruction.Instruction instruction = instReq.getInstruction();
        String portId = instruction.getPortfolioId();
        String portName = this.modPort.getPortfolioNameById(portId);
        this.setAccount(String.valueOf(portId) + "(" + portName + ")");
        int actionId = instReq.getContext().getActionId();
        String action = (String)BsDict.INSTRUCTION_TYPE_MAP.get(String.valueOf(actionId));
        Any any = instruction.getDetails();
        if (action == null) {
            action = "\u4e0b\u8fbe\u5efa\u8bae";
        }
        if (any.is(PInstruction.AlgorithmOrderAdvice.class)) {
            PInstruction.AlgorithmOrderAdvice advice = (PInstruction.AlgorithmOrderAdvice)any.unpack(PInstruction.AlgorithmOrderAdvice.class);
            String result = this.checkInst(this.opStatus, action);
            PComponent.Instrument inst = advice.getInstrument();
            String secCode = inst.getSecurityId();
            String secName = inst.getSymbol();
            node.setRaw(inst.getMarket());
            String market = node.getValue();
            String bs = this.checkAlgo(advice.getSideValue(), advice.getAlgorithmTypeValue());
            String price = "";
            this.count = 0.0;
            List list = advice.getAccntSecInfoList();
            if (8 == instruction.getType()) {
                this.setAccount(((PInstruction.AccntSecInfo)list.get(0)).getInvestorId());
            }
            list.forEach(info -> {
                double d = this.count = this.count + info.getOrderQty();
            });
            String cause = this.checkCause(this.opStatus);
            String content = MessagePrompt.pack(result, secCode, market, secName, bs, price, this.count, cause);
            this.setContent(content);
        } else if (any.is(PInstruction.SingleOrderAdvice.class)) {
            PInstruction.SingleOrderAdvice advice = (PInstruction.SingleOrderAdvice)any.unpack(PInstruction.SingleOrderAdvice.class);
            String result = this.checkInst(this.opStatus, action);
            String secCode = advice.getSecurityId();
            RefItem refItem = this.refMng.getItem(advice.getSecurityType(), advice.getMarket(), secCode);
            String secName = refItem.getName();
            node.setRaw(advice.getMarket());
            String market = node.getValue();
            String bs = this.checkSide(advice.getSide());
            double price = advice.getPrice();
            this.count = 0.0;
            List list = advice.getAccntSecInfoList();
            if (2 == instruction.getType()) {
                this.setAccount(((PInstruction.AccntSecInfo)list.get(0)).getInvestorId());
            }
            list.forEach(info -> {
                double d = this.count = this.count + info.getOrderQty();
            });
            String cause = this.checkCause(this.opStatus);
            String content = MessagePrompt.pack(result, secCode, market, secName, bs, price, this.count, cause);
            this.setContent(content);
        } else if (any.is(PInstruction.AdjustPosAlgoOrderAdvice.class)) {
            PInstruction.AdjustPosAlgoOrderAdvice advice = (PInstruction.AdjustPosAlgoOrderAdvice)any.unpack(PInstruction.AdjustPosAlgoOrderAdvice.class);
            String result = this.checkInst(this.opStatus, action);
            String cause = this.checkCause(this.opStatus);
            String accountId = advice.getInvestorId();
            String basketName = advice.getBasketName();
            if (!accountId.isEmpty()) {
                this.setAccount(accountId);
            }
            String content = MessagePrompt.pack(result, "\u8c03\u4ed3\u76ee\u6807\u7bee\u5b50:" + basketName, " " + cause);
            this.setContent(content);
        }
    }

    private void update(PWorkflow.DoActionReq doAction) {
        long entryId = doAction.getEntryId();
        int actionId = doAction.getActionId();
        String id = this.modInst.getInstByEntryId(entryId).getId();
        String action = (String)BsDict.INSTRUCTION_TYPE_MAP.get(String.valueOf(actionId));
        String result = this.checkInst(this.opStatus, action);
        String cause = this.checkCause(this.opStatus);
        String content = MessagePrompt.pack(result, id, cause);
        this.setContent(content);
    }

    private void update(PPostTrade.TradeCaptureReport report) {
        PField.TradeReportType reportType = report.getTradeReportType();
        if (PField.TradeReportType.TRADE_REPORT_TYPE_CANCEL.equals((Object)reportType)) {
            String id = report.getTradeReportId();
            String result = this.checkResult(this.opStatus);
            String cause = this.checkCause(this.opStatus);
            String content = MessagePrompt.pack(result, id, cause);
            this.setContent(content);
        }
    }

    public void updateBasketInst(BasketOrderAdvice advice, String panelType, Object obj, String risk) {
        String content;
        String cause;
        String result;
        String action;
        String string = action = "2".equals(panelType) ? "\u4e0b\u8fbe\u5efa\u8bae" : "\u4e0b\u8fbe\u6307\u4ee4";
        if (obj instanceof String) {
            result = String.valueOf(action) + "\u63d0\u4ea4,";
            cause = "\u64cd\u4f5c\u6210\u529f";
        } else {
            String msg = ((MException)((Object)MException.class.cast(obj))).getMessage();
            result = String.valueOf(action) + "\u5931\u8d25,";
            cause = msg;
        }
        if (risk == null) {
            risk = "";
        }
        if (advice != null) {
            String account = ((BasketSecurityInst)advice.getItemList().get(0)).getInvestorId();
            String portId = advice.getPortfolioId();
            if (!portId.isEmpty()) {
                account = String.valueOf(portId) + "(" + advice.getPortfolioName() + ")";
            }
            String basketName = advice.getBasketName();
            basketSide.setRaw(String.valueOf(advice.getSide()));
            String bs = basketSide.getValue();
            basketPrice.setRaw(String.valueOf(advice.getPriceType()));
            String priceType = basketPrice.getValue();
            String percent = String.valueOf(advice.getFloatPercent()) + "%";
            basketStg.setRaw(String.valueOf(advice.getStrategyType()));
            String strateType = basketStg.getValue();
            double strate = advice.getStrategyValue();
            int instType = advice.getInstructionType();
            content = instType == 12 || instType == 13 ? MessagePrompt.pack(result, basketName, bs, strateType, strate, cause, risk) : MessagePrompt.pack(result, basketName, bs, priceType, percent, strateType, strate, cause, risk);
            this.setAccount(account);
        } else {
            content = MessagePrompt.pack(result, cause);
        }
        this.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        this.setContent(content);
    }

    public void updateRegularInst(OrderAdvice advice, String panelType, Object obj, String risk) {
        String content;
        String cause;
        String result;
        String action = "2".equals(panelType) ? "\u4e0b\u8fbe\u5efa\u8bae" : "\u4e0b\u8fbe\u6307\u4ee4";
        String reference = "";
        if (obj instanceof String) {
            String id = String.valueOf(obj);
            result = String.valueOf(action) + "\u63d0\u4ea4,";
            cause = "\u64cd\u4f5c\u6210\u529f";
            reference = "(" + id + ")";
        } else {
            String msg = ((MException)((Object)MException.class.cast(obj))).getMessage();
            result = String.valueOf(action) + "\u5931\u8d25,";
            cause = msg;
        }
        if (risk == null) {
            risk = "";
        }
        if (advice != null) {
            String price;
            String account = ((AccntSecInfo)advice.getAccSecInfoList().get(0)).getInvestorId();
            String portId = advice.getPortfolioId();
            if (!portId.isEmpty()) {
                account = String.valueOf(portId) + "(" + advice.getPortfolioName() + ")";
            }
            side.setRaw(String.valueOf(advice.getSide()));
            String bs = side.getValue();
            int ordType = advice.getOrdType();
            if (49 == ordType) {
                price = "";
            } else {
                RefItem refItem = this.refMng.getItem(advice.getSecType(), advice.getMarket(), advice.getSec());
                price = StringUtils.toStr((double)advice.getPrice(), (int)(refItem == null ? 3 : refItem.getScale()));
            }
            long qty = advice.getOrderQty();
            String secId = advice.getSec();
            String secName = advice.getSecName();
            marketNode.setRaw(advice.getMarket());
            String market = marketNode.getValue();
            content = MessagePrompt.pack(result, secId, market, secName, bs, price, qty, cause, reference, risk);
            this.setAccount(account);
        } else {
            content = MessagePrompt.pack(result, cause);
        }
        this.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        this.setContent(content);
    }

    public void updateMiseOrder(MEvent event, Object obj) {
        String content;
        String cause;
        String result;
        String action = "\u4e0b\u5355\u63d0\u4ea4";
        String id = "";
        if (obj instanceof String) {
            id = String.valueOf(obj);
            result = String.valueOf(action) + ",";
            cause = "\u64cd\u4f5c\u6210\u529f";
        } else {
            String msg = ((MException)((Object)MException.class.cast(obj))).getMessage();
            result = String.valueOf(action) + "\u5931\u8d25,";
            cause = msg;
        }
        if (event != null) {
            String accountId = event.getStr("inst_id");
            String baskName = event.getStr("bask_name");
            this.setAccount(accountId);
            content = MessagePrompt.pack(action, "\u76ee\u6807\u7bee\u5b50:" + baskName, String.valueOf(cause) + "(" + id + ")");
        } else {
            content = MessagePrompt.pack(result, cause);
        }
        this.setType("\u59d4\u6258\u4e0b\u8fbe ");
        this.setContent(content);
    }

    public void updateMiseCancel(MEvent event) {
        String content;
        String order;
        String action = "\u64a4\u5355\u63d0\u4ea4";
        String cause = "\u64cd\u4f5c\u6210\u529f";
        if (event.getObj() instanceof MException) {
            String msg = ((MException)((Object)MException.class.cast(event.getObj()))).getMessage();
            String result = String.valueOf(action) + "\u5931\u8d25,";
            cause = msg;
            order = event.getStr("order_id");
            content = MessagePrompt.pack(result, String.valueOf(cause) + "(" + order + ")");
        } else {
            order = event.getStr("order_id");
            content = MessagePrompt.pack(action, String.valueOf(cause) + "(" + order + ")");
        }
        String accountId = event.getStr("inst_id");
        this.setAccount(accountId);
        this.setType("\u64a4\u5355");
        this.setContent(content);
    }

    public void updateBlockTrade(MEvent event) {
        String content;
        String action = "";
        String cause = "\u64cd\u4f5c\u6210\u529f";
        String msg = "";
        Object param = event.get((Object)"block_param");
        if (param instanceof BlockTradeParam) {
            BlockTradeParam blockParam = (BlockTradeParam)BlockTradeParam.class.cast(param);
            action = blockParam.getAction();
            blockType.setRaw(String.valueOf(blockParam.getApplType()));
            msg = String.valueOf(blockParam.getInstrument().getSecId()) + " " + blockParam.getInstrument().getMarket().getValue() + " " + blockParam.getInstrument().getSymbol() + " " + blockType.getValue() + " " + StringUtils.toStr((double)blockParam.getPrice(), (int)3) + " " + blockParam.getOrderQty() + " ";
            this.setAccount(blockParam.getInvestorId());
        }
        if (event.getObj() instanceof MException) {
            cause = ((MException)((Object)MException.class.cast(event.getObj()))).getMessage();
            String result = "\u5927\u5b97\u4ea4\u6613\u63d0\u4ea4\u5931\u8d25,";
            content = MessagePrompt.pack(result, msg, cause);
        } else {
            content = MessagePrompt.pack(action, msg, cause);
        }
        this.setContent(content);
    }

    public void updateMise(AdjustPosAdvice adj, String panelType, Object obj) {
        String content;
        String cause;
        String result;
        String action = "2".equals(panelType) ? "\u4e0b\u8fbe\u5efa\u8bae" : "\u4e0b\u8fbe\u6307\u4ee4";
        String id = "";
        if (obj instanceof String) {
            id = String.valueOf(obj);
            result = String.valueOf(action) + ",";
            cause = "\u64cd\u4f5c\u6210\u529f";
        } else {
            String msg = ((MException)((Object)MException.class.cast(obj))).getMessage();
            result = String.valueOf(action) + "\u5931\u8d25,";
            cause = msg;
        }
        if (adj != null) {
            String accountId = adj.getInvestorId();
            String portId = adj.getPortfolioId();
            String portName = adj.getPortfolioName();
            String basketName = "";
            if (adj.getBasket() != null) {
                basketName = String.valueOf(basketName) + "\u8c03\u4ed3\u76ee\u6807\u7bee\u5b50:" + adj.getBasket().getName();
            }
            this.setAccount(accountId);
            if (!portId.isEmpty()) {
                this.setAccount(String.valueOf(portId) + "(" + portName + ")");
            }
            content = MessagePrompt.pack(result, basketName, cause, id);
        } else {
            content = MessagePrompt.pack(result, cause);
        }
        this.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        this.setContent(content);
    }

    public void updateAlgoInst(AlgoParam advice, String panelType, Object obj, String risk) {
        String content;
        String cause;
        String result;
        String action = "2".equals(panelType) ? "\u4e0b\u8fbe\u5efa\u8bae" : "\u4e0b\u8fbe\u6307\u4ee4";
        String reference = "";
        String price = "";
        if (obj instanceof String) {
            String id = String.valueOf(obj);
            result = String.valueOf(action) + "\u63d0\u4ea4,";
            cause = "\u64cd\u4f5c\u6210\u529f";
            reference = "(" + id + ")";
        } else {
            String msg = ((MException)((Object)MException.class.cast(obj))).getMessage();
            result = String.valueOf(action) + "\u5931\u8d25,";
            cause = msg;
        }
        if (risk == null) {
            risk = "";
        }
        if (advice != null) {
            String account = ((AccntSecInfo)advice.getAccSecInfoList().get(0)).getInvestorId();
            String portId = advice.getPortfolio();
            if (!portId.isEmpty()) {
                account = String.valueOf(portId) + "(" + advice.getPortfolioName() + ")";
            }
            side.setRaw(advice.isBuy() ? Integer.toString(49) : Integer.toString(50));
            String bs = "\u7b97\u6cd5" + side.getValue();
            int type = advice.getAlgoType();
            switch (type) {
                case 15: 
                case 16: 
                case 19: 
                case 20: {
                    type *= 10;
                }
            }
            algo.setRaw(String.valueOf(type));
            String algoType = "(" + algo.getValue() + ")";
            long qty = advice.getCount();
            String secId = advice.getCode();
            String secName = advice.getName();
            marketNode.setRaw(advice.getMarket());
            String market = marketNode.getValue();
            content = MessagePrompt.pack(result, secId, market, secName, bs, algoType, price, qty, cause, reference, risk);
            this.setAccount(account);
        } else {
            content = MessagePrompt.pack(result, cause);
        }
        this.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        this.setContent(content);
    }

    private void update(cms.tmx.entity.notice.ExecutionReport mxReport) {
        PMessage.ExecutionReport report = mxReport.getReport();
        this.setAccount(report.getExtAccntId().replaceAll("[_A-Z]*$", ""));
        execType.setRaw(String.valueOf(report.getExecTypeValue()));
        String result = execType.getValue();
        String orderId = report.getSingleOrder().getOrderId().trim();
        PComponent.Instrument inst = report.getInstrument();
        String type = inst.getSecurityType();
        if (type.isEmpty() && inst.getMarketGroup().equals("FUTURES")) {
            type = "FUT";
        }
        String secCode = inst.getSecurityId();
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        RefItem refItem = this.refMng.getItem(type, inst.getMarket(), secCode);
        String secName = "";
        String price = "";
        if (refItem != null) {
            secName = refItem.getName();
            price = StringUtils.toStr((double)report.getPrice(), (int)refItem.getScale());
        }
        String bs = this.checkSide(report.getSideValue());
        int count = (int)report.getOrderQty();
        String cause = report.getRejMsg();
        ordStatus.setRaw(String.valueOf(report.getOrdStatusValue()));
        String status = ordStatus.getValue();
        String content = MessagePrompt.pack(result, orderId, secCode, market, secName, bs, price, count, status, cause);
        this.setContent(content);
    }

    private void update(CancelRejectReport report) {
        PMessage.OrderCancelReject cancel = report.getReport();
        this.setAccount(cancel.getExtAccntId().replaceAll("[_A-Z]*$", ""));
        String result = this.checkResult(this.opStatus);
        if ("\u64a4\u5355\u5931\u8d25,".equals(result) && this.getExceptionTip()) {
            this.setCheckType("true");
        }
        String orderId = cancel.getSingleOrder().getOrderId().trim();
        PComponent.Instrument inst = cancel.getInstrument();
        String type = inst.getSecurityType();
        if (type.isEmpty() && inst.getMarketGroup().equals("FUTURES")) {
            type = "FUT";
        }
        String secCode = inst.getSecurityId();
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        RefItem refItem = this.refMng.getItem(type, inst.getMarket(), secCode);
        String secName = refItem == null ? "" : refItem.getName();
        String cause = cancel.getRejMsg();
        String content = MessagePrompt.pack(result, orderId, secCode, market, secName, cause);
        this.setContent(content);
    }

    private void update(RiskResult report) {
        String orderType = "";
        if (report.getEntrustAction() == EntrustAction.EN_ACTION_NEW_ORDER) {
            orderType = "\u59d4\u6258";
        } else if (report.getEntrustAction() == EntrustAction.EN_ACTION_NEW_ORDER) {
            orderType = "\u64a4\u5355";
        }
        String riskType = "";
        if (report.getRiskCode() == RiskRetCode.RISK_RET_CODE_WARN) {
            riskType = "\u98ce\u63a7\u9884\u8b66";
        } else if (report.getRiskCode() == RiskRetCode.RISK_RET_CODE_FORBID) {
            riskType = "\u98ce\u63a7\u7981\u6b62";
        }
        String orderId = report.getOrderId();
        Instrument inst = report.getInstrument();
        String secCode = "";
        String secName = "";
        String market = "";
        if (inst != null) {
            secCode = inst.getSecurityId();
            node.setRaw(inst.getMarket());
            market = node.getValue();
            RefItem refItem = this.refMng.getItem(this.type, inst.getMarket(), secCode);
            if (refItem != null) {
                secName = refItem.getName();
            }
        }
        String riskInfo = report.getRiskInfo();
        String content = MessagePrompt.pack(orderType, riskType, orderId, secCode, market, secName, riskInfo);
        this.setContent(content);
    }

    public void update(RiskMonitorReport report) {
        PUnifyRiskService.RiskMonitorResp risk = report.getReport();
        this.setType("\u98ce\u9669\u76d1\u63a7 ");
        risk.getRiskQuotaId();
        risk.getRiskTimestamp();
        String objName = risk.getObjectName();
        String riskName = risk.getRiskName();
        String indexName = risk.getRiskQuotaName();
        riskType.setRaw(String.valueOf(risk.getRiskType()));
        double curVal = risk.getValue();
        riskAction.setRaw(String.valueOf(risk.getRiskActionValue()));
        String setVal = risk.getSetValue();
        PRiskSyncService.Instrument inst = risk.getInstrument();
        String secCode = inst.getSecurityId();
        String content = "";
        if (secCode.isEmpty()) {
            content = MessagePrompt.pack(objName, riskName, indexName, riskType, curVal, riskAction, setVal);
        } else {
            String secName = "";
            RefItem refItem = this.refMng.getItem(inst.getSecurityType(), inst.getMarket(), secCode);
            if (refItem != null) {
                secName = refItem.getName();
            }
            content = MessagePrompt.pack(objName, riskName, indexName, secCode, secName, riskType, curVal, riskAction, setVal);
        }
        this.setContent(content);
    }

    private void update(StrategyNoticeReport report) {
        PStrategy.StrategyNotice strategy = report.getReport();
        String account = strategy.getExtFundAccntId();
        this.setAccount(account);
        String strategyName = strategy.getName();
        String cause = strategy.getErrorMsg();
        String content = MessagePrompt.pack(strategyName, "\u5f02\u5e38\u505c\u6b62", "\u539f\u56e0", cause);
        String id = strategy.getContextId();
        if (id.contains("|")) {
            content = MessagePrompt.pack(strategyName, "\u5bf9\u51b2\u4efb\u52a1" + id, "\u5f02\u5e38\u505c\u6b62", "\u539f\u56e0", cause);
        }
        this.setContent(content);
    }

    private void update(ContextSettings context) {
        Gson gson = new Gson();
        String json = gson.toJson(context.getDetails());
        JsonObject jo = (JsonObject)gson.fromJson(json, JsonObject.class);
        String extFundId = "";
        if (jo.get("@type").getAsString().contains("XbondContextSettings")) {
            XbondContextSettings xbond = (XbondContextSettings)gson.fromJson((JsonElement)jo, XbondContextSettings.class);
            extFundId = xbond.getAccount().getExtFundAccntId();
        } else if (jo.get("@type").getAsString().contains("CustomContextSettings")) {
            CustomContextSettings custom = (CustomContextSettings)gson.fromJson((JsonElement)jo, CustomContextSettings.class);
            extFundId = custom.getAccount().getExtFundAccntId();
        }
        FundAccount fund = this.fundService.getFundAccountNew(extFundId, "IB");
        if (fund != null) {
            this.setAccount(fund.getInvestId());
        }
        String strategyName = context.getName();
        String cause = context.getText();
        String content = MessagePrompt.pack(strategyName, "\u5f02\u5e38\u505c\u6b62", "\u539f\u56e0", cause);
        this.setContent(content);
    }

    private void update(HedgeTaskInfo task) {
        String extFundId = task.getAccount().getExtFundAccntId();
        FundAccount fund = this.fundService.getFundAccountNew(extFundId, "IB");
        if (fund != null) {
            this.setAccount(fund.getInvestId());
        }
        String strategyName = task.getOrigAlgoName();
        String cause = task.getText();
        String id = task.getTaskId();
        this.content = MessagePrompt.pack(strategyName, "\u5bf9\u51b2\u4efb\u52a1" + id, "\u5f02\u5e38\u505c\u6b62", "\u539f\u56e0", cause);
        this.setContent(this.content);
    }

    private void update(AlgorithmStatusNoticeReport algoStatu) {
        PAlgorithmTrade.AlgorithmStatusNotice notice = algoStatu.getReport();
        this.setAccount(notice.getExtAccntId());
        String id = notice.getAlgoSysOrderId();
        String algoName = notice.getExtAccntId();
        String text = notice.getText().replace("remark", "");
        algoStatus.setRaw(String.valueOf(notice.getBaseOrderStatusValue()));
        String status = algoStatus.getValue();
        String content = MessagePrompt.pack(id, algoName, status, text);
        PAlgorithmTrade.Instrument inst = notice.getInstrument();
        if (inst != null && !inst.getSecurityId().isEmpty()) {
            String secInfo = inst.getSecurityId();
            content = MessagePrompt.pack(id, algoName, secInfo, status, text);
        }
        this.setContent(content);
    }

    private void update(InstructionReport report) {
        PInstructionManagement.InstructionReport pReport = report.getReport();
        this.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        PInstruction.Instruction pInst = pReport.getInstruction(0);
        String id = pInst.getInstructionId();
        instructionType.setRaw(String.valueOf(pInst.getStatusValue()));
        String instType = instructionType.getValue();
        Instruction inst = new Instruction();
        inst.update((Object)pInst);
        String orderObj = inst.getOrderObj();
        String errInfo = pReport.getInstruction(0).getErrInfo();
        if (!errInfo.isEmpty()) {
            this.setType("\u6307\u4ee4\u5f02\u5e38 ");
            this.setAudio(SoundControl.Audio.ERROR);
        }
        String content = MessagePrompt.pack(id, instType, orderObj, errInfo);
        this.setContent(content);
    }

    private void update(HttpInsPushMessage cast) {
        cms.tmx.http.instruction.dto.Instruction instruction = cast.getInstruction();
        ObInstruction obIns = new ObInstruction();
        obIns.update((Object)instruction);
        this.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        List job = cast.getJob();
        String errInfo = "";
        if (job != null && job.size() > 0) {
            errInfo = String.valueOf(((ExecJob)job.get(0)).getRiskCheckInfo()) + " " + ((ExecJob)job.get(0)).getErrInfo();
        }
        String content = MessagePrompt.pack(obIns.getId(), obIns.getInsStatus(), obIns.getSecurityCode(), obIns.getSecurityName(), obIns.getTypeName(), obIns.getStatusName(), errInfo);
        if (!obIns.getErrInfo().trim().isEmpty()) {
            this.setType("\u6307\u4ee4\u5f02\u5e38 ");
            this.setAudio(SoundControl.Audio.ERROR);
        }
        this.setContent(content);
    }

    private void update(ExecutionReport report) {
        String bs;
        Instrument inst;
        this.setAccount("");
        if (report.getInvestorId() != null) {
            this.setAccount(report.getInvestorId());
        }
        if (report.getExecType() != null) {
            execType.setRaw(String.valueOf(report.getExecType().getValue()));
        }
        String result = execType.getValue();
        String orderId = report.getOrderId();
        if (report.getInstrument() != null && "XHKG".equals(report.getInstrument().getMarket())) {
            orderId = report.getCounterOrdId();
        }
        if ("CASH_PAYOFF".equals((inst = report.getInstrument()).getMarketIndicator())) {
            String cause = "";
            if (report.getRejMsg() != null) {
                cause = report.getRejMsg();
            }
            String status = report.getOrdStatus().toString();
            String amount = StringUtils.toStr((double)report.getOrderAmount(), (int)2);
            String content = MessagePrompt.pack(result, orderId, "\u76f4\u63a5\u8fd8\u6b3e", amount, status, cause);
            this.setContent(content);
            return;
        }
        String type = inst.getSecurityType();
        if (type != null && type.isEmpty() && inst.getMarketGroup().equals("FUTURES")) {
            type = "FUT";
        }
        String secCode = inst.getSecurityId();
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        RefItem refItem = null;
        if (type != null) {
            refItem = this.refMng.getItem(type, inst.getMarket(), secCode);
        }
        String secName = "";
        String price = "";
        if (refItem != null) {
            secName = refItem.getName();
            price = StringUtils.toStr((double)report.getPrice(), (int)refItem.getScale());
        }
        String string = bs = report.getSide() == null ? "" : report.getSide().toString();
        if ("COMMON_ISSUE".equals(inst.getMarketIndicator())) {
            bs = "\u8be2\u4ef7\u7533\u62a5";
        } else if ("VOUCHER_PAYOFF".equals(inst.getMarketIndicator())) {
            bs = "\u73b0\u5238\u8fd8\u5238";
        } else {
            String desc = MarketIndicator.getDesc((String)inst.getMarketIndicator());
            if (!desc.isEmpty()) {
                bs = desc;
            }
        }
        int count = (int)report.getOrderQty();
        String cause = "";
        if (report.getRejMsg() != null) {
            cause = report.getRejMsg();
        }
        String status = "";
        if (report.getOrdStatus() != null && report.isInactive() && ("48".equals(report.getOrdStatus().getValue()) || "49".equals(report.getOrdStatus().getValue()))) {
            status = OrdStatus.getDes((String)"73");
        }
        String content = MessagePrompt.pack(result, orderId, secCode, market, secName, bs, price, count, status, cause);
        this.setContent(content);
    }

    private void update(ResourceReport report) {
        PResource.Resource pReport = report.getReport();
        this.setType("\u6307\u4ee4\u4e0b\u8fbe ");
        String orderObj = pReport.getReferenceName();
        String id = pReport.getReference();
        instructionType.setRaw(String.valueOf(pReport.getStatusValue()));
        String instType = instructionType.getValue();
        String errInfo = pReport.getErrInfo();
        String content = MessagePrompt.pack(id, instType, orderObj, errInfo);
        this.setContent(content);
    }

    private void update(TransPosReport report) {
        this.setAccount(report.getSrc().getInvestorId());
        execType.setRaw(String.valueOf(report.getExecType().getValue()));
        String result = execType.getValue();
        String orderId = report.getTransSeq();
        Instrument inst = report.getInstrument();
        RefItem refItem = null;
        String secCode = "";
        if (inst != null) {
            String type = inst.getSecurityType();
            secCode = inst.getSecurityId();
            if (type != null) {
                refItem = this.refMng.getItem(type, inst.getMarket(), secCode);
            }
        }
        node.setRaw(inst.getMarket());
        String market = node.getValue();
        String secName = "";
        String price = "";
        if (refItem != null) {
            secName = refItem.getName();
            price = StringUtils.toStr((double)report.getConfirmPrice(), (int)refItem.getScale());
        } else {
            price = StringUtils.toStr((double)report.getConfirmAmount(), (int)3);
        }
        String bs = MarketIndicator.getValue((String)report.getInstrument().getMarketIndicator());
        int count = report.getConfirmQty();
        String cause = "";
        if (report.getRejMsg() != null) {
            cause = report.getRejMsg();
        }
        String status = report.getTransStatus().toString();
        String content = MessagePrompt.pack(result, orderId, secCode, market, secName, bs, price, count, status, cause);
        this.setContent(content);
    }

    private String checkAlgo(int s, int type) {
        String side = this.checkSide(s);
        algo.setRaw(String.valueOf(type));
        return "\u7b97\u6cd5" + side + "(" + algo.getValue() + ")";
    }

    public PBase.OpStatus getOpStatus() {
        return this.opStatus;
    }

    public void setOpStatus(PBase.OpStatus opStatus) {
        this.opStatus = opStatus;
    }

    public static String pack(Object ... objs) {
        StringBuilder content = new StringBuilder();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!String.valueOf(obj).isEmpty()) {
                content.append(String.valueOf(String.valueOf(obj)) + "  ");
            }
            ++n2;
        }
        return content.toString();
    }

    private String checkStatus(PBase.OpStatus status) {
        if (status == null) {
            return "\u4e0b\u5355\u5931\u8d25,";
        }
        int code = status.getStatus();
        if (code == 1) {
            return "\u4e0b\u5355\u63d0\u4ea4,";
        }
        return "\u4e0b\u5355\u5931\u8d25,";
    }

    private String checkResult(PBase.OpStatus status) {
        if (status == null) {
            return "\u64a4\u5355\u5931\u8d25,";
        }
        int code = status.getStatus();
        if (code == 1) {
            return "\u64a4\u5355\u63d0\u4ea4,";
        }
        return "\u64a4\u5355\u5931\u8d25,";
    }

    private String checkReplace(PBase.OpStatus status) {
        if (status == null) {
            return "\u64a4\u5355\u91cd\u4e0b\u5931\u8d25,";
        }
        int code = status.getStatus();
        if (code == 1) {
            return "\u64a4\u5355\u91cd\u4e0b\u63d0\u4ea4,";
        }
        return "\u64a4\u5355\u91cd\u4e0b\u5931\u8d25,";
    }

    private String checkInst(PBase.OpStatus status, String action) {
        if (status == null) {
            return String.valueOf(action) + "\u5931\u8d25,";
        }
        int code = status.getStatus();
        if (code == 1) {
            return String.valueOf(action) + "\u63d0\u4ea4,";
        }
        return String.valueOf(action) + "\u5931\u8d25,";
    }

    private String checkCause(PBase.OpStatus status) {
        if (status == null) {
            return "\u8d85\u65f6";
        }
        String reason = this.error.getMsg(status.getStatus());
        if (reason == null) {
            reason = status.getReason();
            if (!status.getData().isEmpty()) {
                reason = String.valueOf(reason) + "(" + status.getData() + ")";
            }
        } else if (!status.getData().isEmpty()) {
            reason = String.valueOf(reason) + "(" + status.getData() + ")";
        }
        return reason;
    }

    private String checkReport(int op) {
        logger.info("op: " + op);
        if (op == 1) {
            return "\u4e0b\u5355\u63d0\u4ea4,";
        }
        if (op == 2) {
            return "\u64a4\u5355\u63d0\u4ea4,";
        }
        if (op == 3) {
            return "\u6539\u5355\u63d0\u4ea4,";
        }
        return STRATEGY;
    }

    private String checkSide(PField.Side side, PField.PositionEffect posi) {
        if (posi != PField.PositionEffect.PE_UNDEFINED) {
            String strPre = side == PField.Side.SIDE_BUY ? "\u4e70" : "\u5356";
            String strAft = "";
            switch (posi) {
                case PE_OPEN: {
                    strAft = "\u5f00";
                    break;
                }
                case PE_CLOSE: {
                    strAft = "\u5e73";
                    break;
                }
                case PE_CLOSE_TODAY: {
                    strAft = "\u5e73\u4eca";
                    break;
                }
                case PE_FIFO: {
                    strAft = "\u81ea\u52a8";
                    break;
                }
            }
            return String.valueOf(strPre) + strAft;
        }
        return this.checkSide(side.getNumber());
    }

    private String checkSide(int s) {
        String raw = String.valueOf(s);
        side.setRaw(raw);
        return side.getValue();
    }

    public void CheckExceptionTip() {
        if (this.content.startsWith("\u4e0b\u5355\u5931\u8d25") || this.content.startsWith("\u4e0b\u5355\u88ab\u62d2") || this.content.startsWith("\u64a4\u5355\u5931\u8d25") || this.content.startsWith("\u64a4\u5355\u88ab\u62d2") || this.content.startsWith("\u59d4\u6258\u88ab\u62d2")) {
            if (this.getExceptionTip()) {
                this.setType("\u59d4\u6258\u5f02\u5e38 ");
                this.setAudio(SoundControl.Audio.ERROR);
                this.setCheckType("true");
            }
        } else if (this.type.equals("\u7cfb\u7edf\u5f02\u5e38 ") && this.getExceptionTip()) {
            this.setCheckType("true");
        }
    }

    public boolean getExceptionTip() {
        if (this.excTipFlag) {
            this.excTipFlag = false;
            try {
                OrderTipsSettings tipSet = (OrderTipsSettings)this.userSet.getSettingsDetail("0", "000001");
                this.excTip = tipSet.getExceptionTip();
                return this.excTip;
            }
            catch (MException | Exception e) {
                logger.error("\u83b7\u53d6\u5f02\u5e38\u63d0\u793a\u8bbe\u7f6e\u5931\u8d25", e);
            }
        }
        return this.excTip;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCont() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCheckType() {
        return this.checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public SoundControl.Audio getAudio() {
        return this.audio;
    }

    public void setAudio(SoundControl.Audio audio) {
        this.audio = audio;
    }

    public MxNode getAlgoStatus() {
        return algoStatus;
    }

    public void setAlgoStatus(MxNode algoStatus) {
        MessagePrompt.algoStatus = algoStatus;
    }

    public IErrorMsg getError() {
        return this.error;
    }

    public IRefDataMng getRefMng() {
        return this.refMng;
    }

    public PortfolioAccountModel getModPort() {
        return this.modPort;
    }

    public InstructionModel getModInst() {
        return this.modInst;
    }

    public IUserSettingsService getUserSet() {
        return this.userSet;
    }

    public void setError(IErrorMsg error) {
        this.error = error;
    }

    public void setRefMng(IRefDataMng refMng) {
        this.refMng = refMng;
    }

    public void setModPort(PortfolioAccountModel modPort) {
        this.modPort = modPort;
    }

    public void setModInst(InstructionModel modInst) {
        this.modInst = modInst;
    }

    public void setUserSet(IUserSettingsService userSet) {
        this.userSet = userSet;
    }

    public boolean isPark() {
        return this.park;
    }

    public void setPark(boolean park) {
        this.park = park;
    }
}

