/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.message;

import cms.tmx.entity.CtpFundAccount;
import cms.tmx.trade.message.MessagePromptMng;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class FutureAlertMng {
    @Inject
    private MessagePromptMng msgMng;
    @Inject
    private ScheduledExecutorService ses;
    private static final int INTERVAL = 300000;
    private Map<CtpFundAccount, AtomicLong> map = new HashMap<CtpFundAccount, AtomicLong>();
    private static final double PARAM = 0.8;

    @PostConstruct
    public void init() {
        this.ses.scheduleAtFixedRate(() -> this.checkAll(), 0L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alert(CtpFundAccount acct) {
        CtpFundAccount ctpFundAccount = acct;
        synchronized (ctpFundAccount) {
            Long now = System.currentTimeMillis();
            AtomicLong time = this.map.get(acct);
            if (time == null) {
                time = new AtomicLong(0L);
            }
            if (now - time.get() < 300000L) {
                return;
            }
            if (acct.getMarginRatio() > 0.8) {
                time.set(now);
                this.logger(acct);
                this.map.put(acct, time);
            } else {
                this.map.remove(acct);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAll() {
        for (Map.Entry<CtpFundAccount, AtomicLong> entry : this.map.entrySet()) {
            CtpFundAccount acct;
            Long now = System.currentTimeMillis();
            CtpFundAccount ctpFundAccount = acct = entry.getKey();
            synchronized (ctpFundAccount) {
                AtomicLong time = entry.getValue();
                if (now - time.get() < 300000L) {
                    return;
                }
                if (acct.getMarginRatio() > 0.8) {
                    time.set(now);
                    this.logger(acct);
                } else {
                    this.map.remove(acct);
                }
            }
        }
    }

    private void logger(CtpFundAccount acct) {
        StringBuilder info = new StringBuilder("\u8d26\u6237");
        info.append(acct.getInvestId());
        info.append("\u7684\u5f53\u524d\u4fdd\u8bc1\u91d1\u6bd4\u4f8b\u4e3a");
        info.append(String.valueOf(String.format("%.2f", acct.getMarginRatio() * 100.0)) + "%");
        info.append("\uff0c\u8d85\u8fc780%\u7684\u76d1\u63a7\u9608\u503c");
        this.msgMng.logger(acct.getInvestId(), "\u98ce\u9669\u76d1\u63a7 ", info.toString());
    }
}

