/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.entrust;

import cms.tmx.core.MException;
import cms.tmx.data.http.RefDataMng;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.query.sge.ObSgePosition;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SgeCloseEntrust {
    @Inject
    private MarketDataModel marketMng;
    @Inject
    private RefDataMng refMng;
    private MxNode ocFlag;
    @Inject
    private HttpBaseApi baseApi;
    private ObSgePosition position;
    private MarketItem mktItem;
    @Inject
    private TradeServiceApi api;
    private static final Logger logger = LogManager.getLogger(SgeCloseEntrust.class);

    @PostConstruct
    public void init() {
        this.ocFlag = MxNodeFactory.create((String)"position_effect", (String)"67");
    }

    public void submit() throws MException {
        if (this.position == null) {
            throw new MException(999997, "no position");
        }
        RefItem refItem = this.refMng.getItem(String.valueOf(this.position.getInstrument().getSecType()) + this.position.getInstrument().getMarket().getRaw(), this.position.getInstrument().getMarket().getRaw(), this.position.getInstrument().getSecId());
        if (refItem == null) {
            throw new MException(999997, "no ref item " + this.position.getInstrument().getSecId());
        }
        this.marketMng.query(refItem);
        this.mktItem = this.marketMng.getItem(refItem);
        if (this.mktItem == null) {
            throw new MException(999997, "no market item " + this.position.getInstrument().getSecId());
        }
        if (this.position.getNewPrice() <= 0.0) {
            throw new MException(999997, "\u52a8\u6001\u884c\u60c5\u4e3a\u7a7a");
        }
        this.orderSubmit(this.position);
    }

    private void orderSubmit(ObSgePosition po) {
        NewOrderSingle order = new NewOrderSingle();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument security = new Instrument();
        security.setSecurityId(po.getInstrument().getSecId());
        security.setSymbol(po.getInstrument().getSymbol());
        security.setMarket(po.getInstrument().getMarket().getRaw());
        security.setMarketGroup("SGE");
        security.setSecurityType(po.getInstrument().getSecType());
        security.setMarketIndicator(this.mktItem.getRefItem().isDelayedDelivery() ? "Deferred" : "Spot");
        order.setInstrument(security);
        order.setAccount(po.getAccntId());
        order.setExtCashAccntId(po.getExtCashAccntId());
        order.setExtSecAccntId(po.getSecAccntId());
        order.setOrdType(OrdType.get((String)"50"));
        if ("1".equals(Integer.toString(po.getDirection()))) {
            order.setSide(Side.get((String)"50"));
        } else if ("2".equals(Integer.toString(po.getDirection()))) {
            order.setSide(Side.get((String)"49"));
        }
        order.setOrderQty(po.getAvailable());
        order.setPrice(po.getNewPrice());
        order.setPositionEffect("67");
        order.setPurpose(1);
        try {
            this.api.newSgeOrderSingle(order, "sge");
        }
        catch (MException e) {
            logger.error("\u8d35\u91d1\u5c5e\u5e73\u4ed3\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
    }

    public void setPosition(ObSgePosition position) {
        this.position = position;
    }
}

