/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.entrust;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MException;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsPortfCloseEntrust
extends CcsSingleEntrust {
    @Inject
    private IMarketDataMng marketMng;
    @Inject
    private IRefDataMng refMng;
    private CcsPortfPosition position;

    @PostConstruct
    public void init() {
        this.setSide(50);
        this.setOrderType(50);
        this.setAppID("010");
    }

    public void setPosition(CcsPortfPosition position) {
        this.position = position;
        this.setAcc(position.getExtAccId());
        this.setSecAcc(position.getExtSecAccId());
        this.setMarket(position.getMarket().getRaw());
        this.setSec(position.getSecId());
        this.setSecType(position.getSecType());
        this.setQuantity(position.getCanVol());
        this.setPortfolioId(position.getPortfolioId());
        this.setSubAccntId(position.getSubAccntId());
        this.setSubSecAccntId(position.getSubSecAccntId());
    }

    @Override
    public void submit() throws MException {
        if (this.position == null) {
            throw new MException(999997, "no position");
        }
        RefItem refItem = this.refMng.getItem(this.getSecType(), this.getMarket(), this.getSec());
        if (refItem == null) {
            throw new MException(999997, "no ref item " + this.getSec());
        }
        MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
        if (marketItem == null) {
            throw new MException(999997, "no market item " + this.getSec());
        }
        if (this.position.getNewPrice() <= 0.0) {
            throw new MException(999997, "\u52a8\u6001\u884c\u60c5\u4e3a\u7a7a");
        }
        this.setPrice(this.position.getNewPrice());
        super.submit();
    }
}

