/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.entrust;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MException;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsCloseEntrust
extends CcsSingleEntrust {
    @Inject
    private IMarketDataMng marketMng;
    @Inject
    private IRefDataMng refMng;
    private CcsPosition position;

    @PostConstruct
    public void init() {
        this.setSide(50);
        this.setOrderType(50);
        this.setAppID("010");
    }

    public void setPosition(CcsPosition position) {
        this.position = position;
        this.setAcc(position.getExtAccId());
        this.setSecAcc(position.getExtSecAccId());
        this.setMarket(position.getMarket().getRaw());
        this.setSec(position.getSecId());
        this.setSecType(position.getSecType());
        this.setQuantity(position.getCanVol());
    }

    @Override
    public void submit() throws MException {
        RefItem refItem = null;
        if (this.position == null) {
            throw new MException(999997, "no position");
        }
        if ("SHSC".equals(this.position.getMarket().getRaw()) || "SZSC".equals(this.position.getMarket().getRaw())) {
            this.setAppID("HKN");
            refItem = this.refMng.getItem(String.valueOf(this.getSecType()) + this.getMarket(), this.getMarket(), this.getSec());
        } else {
            refItem = this.refMng.getItem(this.getSecType(), this.getMarket(), this.getSec());
        }
        if (refItem == null) {
            throw new MException(999997, "no ref item " + this.getSec());
        }
        MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
        if (marketItem == null) {
            throw new MException(999997, "no market item " + this.getSec());
        }
        if (this.position.getNewPrice() <= 0.0) {
            throw new MException(999997, "\u52a8\u6001\u884c\u60c5\u4e3a\u7a7a");
        }
        this.setPrice(this.position.getNewPrice());
        super.submit();
    }
}

