/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.entrust;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxModel;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CancelOrder
extends MxModel {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private ICancelOrderApi cancelApi;
    protected Message message = null;
    protected PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
    protected boolean force;

    public void submit(Order order) throws MException {
        PMessage.OrderCancelRequest.Builder builder = PMessage.OrderCancelRequest.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setClOrdId(order.getClOrdId());
        builder.setOrigClOrdId(order.getClOrdId());
        builder.setOrderId(order.getSysOrderId());
        this.inst.setMarket(order.getInstrument().getMarket().getRaw());
        this.inst.setSecurityId(order.getInstrument().getSecId());
        this.inst.setSecurityType(order.getInstrument().getSecType());
        this.inst.setApplId(order.getApplId());
        if (order instanceof CcsOrder) {
            builder.setExtAccntId(((CcsOrder)order).getExtAccntId());
        }
        if (order instanceof CtpOrder) {
            builder.setExtAccntId(((CtpOrder)order).getExtAccntId());
        }
        if (this.message != null) {
            builder.setObject(Any.pack((Message)this.message));
        }
        builder.setInstrument(this.inst);
        builder.setForce(this.force);
        this.cancelApi.submit(builder.build());
    }
}

