/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.entrust;

import cms.tmx.api.basket.IBasketCancelReplaceApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IOrderCancelReplaceApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CancelAndOrder
extends MxModel {
    @Inject
    private IBaseApi baseApi;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected IMarketDataMng marketMng;
    @Inject
    private IOrderCancelReplaceApi replaceApi;
    @Inject
    private IBasketCancelReplaceApi basketReplaceApi;
    protected MarketItem mktItem;
    protected PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();

    public void submit(Order order) throws MException {
        PMessage.OrderCancelReplaceRequest.Builder builder = PMessage.OrderCancelReplaceRequest.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setOrderId(order.getSysOrderId());
        builder.setPrice(order.getNewPrice());
        if (!StringUtils.isEmpty((String)order.getReference()) && !StringUtils.isEmpty((String)order.getResourceId()) && 49 == order.getOrdType()) {
            builder.setOrdTypeValue(49);
            builder.setTif(PField.TimeInForce.forNumber((int)order.getTif()));
            builder.setMaxPriceLevels(order.getMaxLevels());
        } else if (order.getOrdType() == 99) {
            builder.setOrdTypeValue(99);
        } else {
            builder.setOrdTypeValue(50);
        }
        builder.setReference(order.getReference());
        builder.setResourceId(order.getResourceId());
        this.inst.setMarket(order.getInstrument().getMarket().getRaw());
        this.inst.setSecurityId(order.getInstrument().getSecId());
        this.inst.setSecurityType(order.getInstrument().getSecType());
        this.inst.setApplId(order.getInstrument().getApplId());
        if (order instanceof CcsOrder) {
            builder.setExtAccntId(((CcsOrder)order).getExtAccntId());
        } else if (order instanceof CtpOrder) {
            builder.setExtAccntId(((CtpOrder)order).getExtAccntId());
            builder.setExtSecAccntId(((CtpOrder)order).getExtSecAccntId());
            builder.setPositionEffectValue(Integer.parseInt(((CtpOrder)order).getOcFlag().getRaw()));
            builder.setPurpose(Integer.parseInt(((CtpOrder)order).getShFlag().getRaw()));
            builder.setSideValue(Integer.parseInt(order.getSide().getRaw()));
        }
        builder.setInstrument(this.inst);
        this.replaceApi.submit(builder.build());
    }

    public void submitBasket(List<Order> list) throws MException {
        int totalNum = list.size() % 150 == 0 ? list.size() / 150 : list.size() / 150 + 1;
        PBase.Fragment.Builder fra = PBase.Fragment.newBuilder();
        fra.setIndex(1);
        fra.setTotalFragNum(totalNum);
        fra.setTotalDataNum(list.size());
        ArrayList<PMessage.ListOrdGrpLeg> ordList = new ArrayList<PMessage.ListOrdGrpLeg>();
        for (Order order : list) {
            if (!(order instanceof CcsOrder)) continue;
            CcsOrder item = (CcsOrder)CcsOrder.class.cast(order);
            PMessage.ListOrdGrpLeg.Builder builder = PMessage.ListOrdGrpLeg.newBuilder();
            this.inst.setMarket(item.getInstrument().getMarket().getRaw());
            this.inst.setSecurityId(item.getInstrument().getSecId());
            this.inst.setSecurityType(item.getInstrument().getSecType());
            builder.setInstrument(this.inst);
            builder.setSecondaryClOrdId(item.getBasketId());
            builder.setClOrdLinkId(item.getClOrdId());
            builder.setSideValue(Integer.parseInt(item.getSide().getRaw()));
            builder.setOrdTypeValue(50);
            builder.setExtAccntId(item.getExtAccntId());
            builder.setExtSecAccntId(item.getExtSecAccntId());
            builder.setPrice(item.getNewPrice());
            builder.setOrderQty((double)(item.getOrderQty() - item.getCumQty()));
            ordList.add(builder.build());
        }
        int i = 1;
        String uuid = UUID.randomUUID().toString();
        String reference = list.get(0).getReference();
        String resourceId = list.get(0).getResourceId();
        this.basketReplaceApi.cancelReplace(ordList, fra.build(), i, uuid, "CCS", reference, resourceId);
    }
}

