/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.entrust;

import cms.tmx.api.basket.INewOrderListApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.javafx.MxModel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BatchEntrust
extends MxModel {
    @Inject
    private MEventService es;
    @Inject
    private INewOrderListApi orderApi;

    @PostConstruct
    private void init() {
        this.es.subscribe("basket.entrust", event -> {
            try {
                Instruction instruction = (Instruction)event.get(Instruction.class, "instruction");
                Basket basket = (Basket)event.get(Basket.class, "basket");
                List tradeItems = (List)event.get(List.class, "items");
                BasketSubmitResult result = this.submit(instruction, tradeItems, basket, instruction.getClInstructionId());
                event.setOK();
                event.put((Object)"result", (Object)result);
            }
            catch (MException e) {
                this.logger.error("\u5feb\u6377\u952e\u7bee\u5b50\u6307\u4ee4\u6307\u4ee4\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public BasketSubmitResult entrust(List<BasketTradeItem> list, boolean isPortfolio) throws MException {
        Basket bsk = new Basket();
        bsk.setName("\u6e05\u4ed3\u7bee\u5b50");
        BasketSubmitResult result = this.submit(list, bsk);
        for (String id : result.getSuccessedIds()) {
            MEvent event = new MEvent();
            event.put((Object)"listId", (Object)id);
            event.put((Object)"isPortfolio", (Object)isPortfolio);
            this.es.postEvent("basket.submit", event);
        }
        return result;
    }

    private BasketSubmitResult submit(List<BasketTradeItem> tradeItemList, Basket basket) throws MException {
        BasketSubmitResult result = new BasketSubmitResult();
        if (tradeItemList == null) {
            return result;
        }
        HashMap map = new HashMap();
        for (BasketTradeItem tradeItem : tradeItemList) {
            PMessage.ListOrdGrpLeg order = this.toListOrdGrpLeg(tradeItem);
            if (!map.containsKey(tradeItem.getAcc())) {
                LinkedList<PMessage.ListOrdGrpLeg> newOrderList = new LinkedList<PMessage.ListOrdGrpLeg>();
                newOrderList.add(order);
                map.put(tradeItem.getAcc(), newOrderList);
                continue;
            }
            ((List)map.get(tradeItem.getAcc())).add(order);
        }
        for (FundAccount accnt : map.keySet()) {
            String listId = "";
            int count = ((List)map.get(accnt)).size();
            try {
                if (accnt instanceof CcsSubFundAccount) {
                    CcsSubFundAccount subAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(accnt);
                    listId = this.orderApi.submit((List)map.get(accnt), basket.getId(), basket.getName(), subAccnt.getPortfolioId(), "", "", "");
                } else {
                    listId = this.orderApi.submit((List)map.get(accnt), basket.getId(), basket.getName(), null, "", "", "");
                }
                result.getSuccessedIds().add(listId);
                result.getSuccessedTimes().getAndAdd(count);
            }
            catch (MException e) {
                result.getFailedTimes().getAndAdd(count);
                result.setDesc("\n" + result.getDesc() + e.getMessage());
                this.logger.error("\u6e05\u4ed3\u7bee\u5b50 basket sumbit fail", (Throwable)e);
            }
        }
        return result;
    }

    public BasketSubmitResult submit(Instruction instruction, List<BasketTradeItem> tradeItemList, Basket basket, String clListId) throws MException {
        BasketSubmitResult result = new BasketSubmitResult();
        if (tradeItemList == null) {
            return result;
        }
        HashMap map = new HashMap();
        for (BasketTradeItem tradeItem : tradeItemList) {
            PMessage.ListOrdGrpLeg order = this.toListOrdGrpLeg(tradeItem);
            if (!map.containsKey(tradeItem.getAcc())) {
                LinkedList<PMessage.ListOrdGrpLeg> newOrderList = new LinkedList<PMessage.ListOrdGrpLeg>();
                newOrderList.add(order);
                map.put(tradeItem.getAcc(), newOrderList);
                continue;
            }
            ((List)map.get(tradeItem.getAcc())).add(order);
        }
        for (FundAccount accnt : map.keySet()) {
            String listId = "";
            try {
                if (accnt instanceof CcsSubFundAccount) {
                    CcsSubFundAccount subAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(accnt);
                    listId = this.orderApi.submit((List)map.get(accnt), basket.getId(), basket.getName(), subAccnt.getPortfolioId(), instruction == null ? "" : instruction.getId(), instruction == null ? "" : instruction.getResource().getId(), clListId);
                } else {
                    listId = this.orderApi.submit((List)map.get(accnt), basket.getId(), basket.getName(), null, instruction == null ? "" : instruction.getId(), instruction == null ? "" : instruction.getResource().getId(), clListId);
                }
                result.getSuccessedIds().add(listId);
                result.getSuccessedTimes().getAndIncrement();
            }
            catch (MException e) {
                result.getFailedTimes().getAndIncrement();
                result.setDesc("\n" + result.getDesc() + e.getMessage());
                this.logger.error("basket sumbit fail", (Throwable)e);
            }
        }
        return result;
    }

    private PMessage.ListOrdGrpLeg toListOrdGrpLeg(BasketTradeItem tradeItem) throws MException {
        SecAccount sec;
        BasketItem bskItem = tradeItem.getItem();
        if (bskItem == null) {
            throw new MException(0, "\u7bee\u5b50\u6210\u5206\u80a1\u4e3a\u7a7a");
        }
        PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
        builderI.setSecurityId(bskItem.getSecurityId());
        builderI.setSymbol(bskItem.getSecurityName());
        builderI.setMarket(bskItem.getMarket().getRaw());
        builderI.setSecurityType(bskItem.getRefItem().getType());
        if (bskItem.getSecurityId().startsWith("688")) {
            builderI.setApplId("700");
        } else if (bskItem.getRefItem() != null && bskItem.getRefItem().isGem()) {
            builderI.setApplId("GEM");
        } else if ("SHSC".equals(bskItem.getMarket().getRaw()) || "SZSC".equals(bskItem.getMarket().getRaw())) {
            builderI.setApplId("HKN");
        } else {
            builderI.setApplId("010");
        }
        PComponent.Instrument instrument = builderI.build();
        PMessage.ListOrdGrpLeg.Builder builderOrder = PMessage.ListOrdGrpLeg.newBuilder();
        builderOrder.setInstrument(instrument);
        String side = tradeItem.getBsTrade().getRaw();
        builderOrder.setOrderQtyCapacity((double)tradeItem.getTargetCount());
        builderOrder.setSideValue(Integer.parseInt(side));
        builderOrder.setOrderQty((double)tradeItem.getCount(side.equals("49")));
        builderOrder.setPrice(tradeItem.getPrice(side.equals("49")));
        builderOrder.setOrdTypeValue(50);
        builderOrder.setExtAccntId(tradeItem.getAcc().getExtAccntId());
        builderOrder.setExtSecAccntId(tradeItem.getSecAcc().getExtSecAccntId());
        builderOrder.setClOrdId(tradeItem.getClOrderId());
        CcsFundAccount acc = tradeItem.getAcc();
        if (acc instanceof CcsSubFundAccount) {
            CcsSubFundAccount subAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(acc);
            builderOrder.setSubAccntId(subAcc.getSubAccntId());
        }
        if ((sec = tradeItem.getSecAcc()) instanceof CcsSubSecAccount) {
            CcsSubSecAccount subSec = (CcsSubSecAccount)CcsSubSecAccount.class.cast(sec);
            builderOrder.setSubSecAccntId(subSec.getSubSecAccntId());
        }
        return builderOrder.build();
    }
}

