/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.crontab;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@Creatable
@Singleton
public class ReSubMarketJob
implements Job {
    private Logger logger = LogManager.getLogger(ReSubMarketJob.class);
    @Inject
    private IMarketDataMng dataMng;
    @Inject
    private IBaseApi baseApi;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (StringUtils.isEmpty((String)this.baseApi.getPostId())) {
            this.logger.info("\u5c1a\u672a\u767b\u9646,\u4e0d\u8fdb\u884c\u884c\u60c5\u91cd\u8ba2\u9605");
            return;
        }
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");
        long now = new Date().getTime();
        String day = dayFormat.format(now);
        try {
            if (!(now > this.getTime(day, "091500") && now < this.getTime(day, "113000") || now > this.getTime(day, "130000") && now < this.getTime(day, "160000"))) {
                this.logger.info("\u975e\u4ea4\u6613\u65f6\u95f4\u6bb5\uff0c\u4e0d\u8fdb\u884c\u91cd\u8ba2\u9605");
                return;
            }
        }
        catch (ParseException e) {
            this.logger.error("\u91cd\u8ba2\u9605\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (Throwable)e);
            return;
        }
        this.logger.info("\u4ea4\u6613\u65f6\u95f4\u6bb5\uff0c\u89e6\u53d1\u91cd\u8ba2\u9605");
        Map map = this.dataMng.getMap();
        List marketItems = map.entrySet().stream().filter(item -> System.currentTimeMillis() - ((MarketItem)item.getValue()).getLastUpdateTime() > 60000L && ((MarketItem)item.getValue()).isReSub()).collect(Collectors.toList());
        if (marketItems.isEmpty()) {
            return;
        }
        ArrayList<RefItem> refItems = new ArrayList<RefItem>();
        for (Map.Entry entry : marketItems) {
            refItems.add((RefItem)entry.getKey());
        }
        this.dataMng.subMarketItems(refItems, null);
        this.logger.info("resub market data ,size:" + refItems.size() + "content:" + refItems);
    }

    private long getTime(String day, String time) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.parse(String.valueOf(day) + time).getTime();
    }
}

