/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.crontab;

import cms.tmx.core.MConfService;
import cms.tmx.core.MCrontabService;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.AutoExportSettings;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.ExportMethod;
import cms.tmx.trade.crontab.AccntAssetJob;
import cms.tmx.trade.crontab.AlgoRefreshJob;
import cms.tmx.trade.crontab.ApamaAlgoRefreshJob;
import cms.tmx.trade.crontab.AutoExportJob;
import cms.tmx.trade.crontab.CcsMdHeartBeatJob;
import cms.tmx.trade.crontab.CreditLoginJob;
import cms.tmx.trade.crontab.CtpMdHeartBeatJob;
import cms.tmx.trade.crontab.DbfExportJob;
import cms.tmx.trade.crontab.ManageHeartBeatJob;
import cms.tmx.trade.crontab.MarginAlgoQueryJob;
import cms.tmx.trade.crontab.NewPriceOrderQueryJob;
import cms.tmx.trade.crontab.NewPriceQueryJob;
import cms.tmx.trade.crontab.PositionMDQueryJob;
import cms.tmx.trade.crontab.QueryRefreshJob;
import cms.tmx.trade.crontab.ReSubMarketJob;
import cms.tmx.trade.crontab.RefDataRefreshJob;
import cms.tmx.trade.crontab.RegistDeepSuperviseJob;
import cms.tmx.trade.crontab.ReloadRefDataJob;
import cms.tmx.trade.crontab.RequeryDataJob;
import cms.tmx.trade.crontab.StopMonitorFileJob;
import cms.tmx.trade.crontab.WebHeartBeatJob;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.service.IUserSettingsService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CrontabMngService {
    private static final Logger logger = LogManager.getLogger(CrontabMngService.class);
    public static final int SELECTED = 1;
    private static final int UNSELECTED = 0;
    @Inject
    private MEventService es;
    @Inject
    private IUserSettingsService setService;
    @Inject
    private MCrontabService cronService;
    @Inject
    private MConfService cs;
    private MEventHandler dbfHandler = event -> {
        int type = event.getInt("export_type");
        String cron = event.getStr("set_time");
        int interval = event.getInt("auto_interval");
        if (type == 0) {
            this.cronService.removeJob("dbf_export_job");
            return;
        }
        if (type == 1) {
            String[] time = cron.split(":");
            if (time.length != 3) {
                return;
            }
            cron = String.valueOf(time[2]) + " " + time[1] + " " + time[0] + " * * ?";
            this.cronService.resetJob(DbfExportJob.class, cron, 0, "dbf_export_job", "dbf_export_trigger");
        } else {
            this.cronService.resetJob(DbfExportJob.class, "", interval, "dbf_export_job", "dbf_export_trigger");
        }
    };

    @PostConstruct
    private void init() {
        this.es.subscribe("settingsRefresh", event -> this.autoExport());
        this.autoRequeryData();
        this.autoRegistDeepSupervise();
        this.es.subscribe("stage.after.login", event -> this.webHeartBeat());
        this.marketItemRefresh();
        this.stopMonitorFile();
        this.es.subscribe("stage.after.login", event -> this.positionMarketDataQuery());
        this.es.subscribe("stage.after.login", event -> this.manageHeartbeat());
        this.es.subscribe("stage.after.login", event -> this.newPricesQuery());
        this.es.subscribe("stage.after.login", event -> this.newPricesOrderQuery());
        this.es.subscribe("stage.after.login", event -> this.newFrameAccntAssets());
        this.es.subscribe("stage.after.login", event -> this.ccsMdHeartbeat());
        this.es.subscribe("stage.after.login", event -> this.ctpMdHeartbeat());
        this.es.subscribe("stage.after.login", event -> this.creditLogin());
        this.es.subscribe("stage.after.login", event -> this.refdataRefresh());
        this.es.subscribe("stage.after.login", event -> this.algoRefresh());
        this.es.subscribe("stage.after.login", event -> this.apamaAlgoRefresh());
        this.es.subscribe("stage.after.login", event -> this.queryRefresh());
        this.es.subscribe("dbf.begin", this.dbfHandler);
        this.es.subscribe("stage.after.login", event -> this.marginAlgoQuery());
    }

    private void autoExport() {
        String dataExport = this.cs.getValue("data.export");
        if (StringUtils.isEmpty((String)dataExport) || !Boolean.valueOf(dataExport).booleanValue()) {
            return;
        }
        try {
            BaseSettings settings = this.setService.getSettingsDetail("0", "000003");
            if (!(settings instanceof AutoExportSettings)) {
                logger.error("\u83b7\u53d6\u81ea\u52a8\u5bfc\u51fa\u8bbe\u7f6e\u5931\u8d25");
                return;
            }
            AutoExportSettings autoExportSettings = (AutoExportSettings)AutoExportSettings.class.cast(settings);
            List exportMethods = autoExportSettings.getExportMethods();
            if (autoExportSettings.getEnabled() != 1) {
                this.cronService.removeJob("auto_export_job");
                return;
            }
            String cron = "";
            ArrayList<String> crons = new ArrayList<String>();
            int interval = 0;
            for (ExportMethod exportMethod : exportMethods) {
                String value;
                int n;
                int n2;
                String[] stringArray;
                if (exportMethod.getSelected() != 1) continue;
                if (exportMethod.getMethod() == 1) {
                    stringArray = exportMethod.getValue();
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        value = stringArray[n];
                        String[] time = value.split(":");
                        if (time.length == 3) {
                            cron = String.valueOf(time[2]) + " " + time[1] + " " + time[0] + " * * ?";
                            crons.add(cron);
                        }
                        ++n;
                    }
                    this.cronService.resetJobGroup(AutoExportJob.class, crons, interval, "auto_export_job", "auto_export_trigger");
                    continue;
                }
                if (exportMethod.getMethod() != 2) continue;
                stringArray = exportMethod.getValue();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    value = stringArray[n];
                    interval = Integer.valueOf(value);
                    this.cronService.resetJob(AutoExportJob.class, cron, interval, "auto_export_job", "auto_export_trigger");
                    ++n;
                }
            }
        }
        catch (MException | Exception e) {
            logger.error("\u83b7\u53d6\u81ea\u52a8\u5bfc\u51fa\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    private void autoLoadRefData() {
        String cron = "0/30 20-59 9 * * ?";
        this.cronService.resetJob(ReloadRefDataJob.class, cron, 0, "reload_refdata_job", "reload_refdata_trigger");
    }

    private void autoRequeryData() {
        String cron = "0 0 9 * * ?";
        this.cronService.resetJob(RequeryDataJob.class, cron, 0, "requery_data_job", "requery_data_trigger");
    }

    private void webHeartBeat() {
        this.cronService.resetJob(WebHeartBeatJob.class, "", 10, "web_heart_job", "web_heart_trigger");
    }

    private void marketItemRefresh() {
        this.cronService.resetJob(ReSubMarketJob.class, "0 0/2 9-16 * * ?", 0, "re_sub_market_job", "re_sub_market_trigger");
    }

    private void autoRegistDeepSupervise() {
        String cron = "0 15 9 * * ?";
        this.cronService.resetJob(RegistDeepSuperviseJob.class, cron, 0, "regist_deepsupervise_job", "regist_deepsupervise_trigger");
    }

    private void stopMonitorFile() {
        String cron = "0 30 15 * * ?";
        this.cronService.resetJob(StopMonitorFileJob.class, cron, 0, "stop_monitor_job", "stor_monitor_trigger");
    }

    private void positionMarketDataQuery() {
        String cron = "0/5 * 9-16 * * ?";
        this.cronService.resetJob(PositionMDQueryJob.class, cron, 0, "pos_md_query_job", "pos_md_query_trigger");
    }

    private void newPricesQuery() {
        String cron = "0/5 * 9-16 * * ?";
        this.cronService.resetJob(NewPriceQueryJob.class, cron, 0, "ins_md_query_job", "ins_md_query_trigger");
    }

    private void newPricesOrderQuery() {
        String cron = "0/5 * 9-16 * * ?";
        this.cronService.resetJob(NewPriceOrderQueryJob.class, cron, 0, "ord_md_query_job", "ord_md_query_trigger");
    }

    private void manageHeartbeat() {
        String cron = "0/10 * * * * ?";
        this.cronService.resetJob(ManageHeartBeatJob.class, cron, 0, "manage_heart_job", "manage_heart_trigger");
    }

    private void marginAlgoQuery() {
        String cron = "0/10 * * * * ?";
        this.cronService.resetJob(MarginAlgoQueryJob.class, cron, 0, "margin_algo_query_job", "margin_algo_query_trigger");
    }

    private void newFrameAccntAssets() {
        this.cronService.resetJob(AccntAssetJob.class, "", 30, "accnt_asset_job", "accnt_asset_trigger");
    }

    private void ccsMdHeartbeat() {
        String cron = "0/10 * * * * ?";
        this.cronService.resetJob(CcsMdHeartBeatJob.class, cron, 0, "ccsmd_heart_job", "ccsmd_heart_trigger");
    }

    private void ctpMdHeartbeat() {
        String cron = "0/10 * * * * ?";
        this.cronService.resetJob(CtpMdHeartBeatJob.class, cron, 0, "ctpmd_heart_job", "ctpmd_heart_trigger");
    }

    private void creditLogin() {
        this.cronService.resetJob(CreditLoginJob.class, "", 30, "credit_login_job", "credit_login_trigger");
    }

    private void refdataRefresh() {
        this.cronService.resetJob(RefDataRefreshJob.class, "", 30, "ref_data_refresh_job", "ref_data_refresh_trigger");
    }

    private void algoRefresh() {
        this.cronService.resetJob(AlgoRefreshJob.class, "", 10, "algo_refresh_job", "algo_refresh_trigger");
    }

    private void apamaAlgoRefresh() {
        this.cronService.resetJob(ApamaAlgoRefreshJob.class, "", 10, "apama_algo_refresh_job", "apama_algo_refresh_trigger");
    }

    private void queryRefresh() {
        this.cronService.resetJob(QueryRefreshJob.class, "", 5, "query_refresh_job", "query_refresh_trigger");
    }

    private void dbfExport() {
        this.cronService.resetJob(DbfExportJob.class, "", 600, "dbf_export_job", "dbf_export_trigger");
    }
}

