/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.crontab;

import cms.tmx.core.MConfService;
import cms.tmx.core.MCrontabService;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.AutoExportFLowsSettings;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.ExportMethod;
import cms.tmx.trade.crontab.AutoExportFlowsJob;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.service.IUserSettingsService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CrontabFlowsMngService {
    private static final Logger logger = LogManager.getLogger(CrontabFlowsMngService.class);
    public static final int SELECTED = 1;
    private static final int UNSELECTED = 0;
    @Inject
    private MEventService es;
    @Inject
    private IUserSettingsService setService;
    @Inject
    private MCrontabService cronService;
    @Inject
    private MConfService cs;
    @Inject
    private AutoExportFlowsJob job;

    @PostConstruct
    private void init() {
        this.es.subscribe("settingsRefresh", event -> this.autoExport());
    }

    private void autoExport() {
        String dataExport = this.cs.getValue("data.export");
        if (StringUtils.isEmpty((String)dataExport) || !Boolean.valueOf(dataExport).booleanValue()) {
            return;
        }
        try {
            BaseSettings settings = this.setService.getSettingsDetail("0", "000005");
            if (!(settings instanceof AutoExportFLowsSettings)) {
                logger.error("\u83b7\u53d6\u81ea\u52a8\u5bfc\u51fa\u8bbe\u7f6e\u5931\u8d25");
                return;
            }
            AutoExportFLowsSettings autoExportSettings = (AutoExportFLowsSettings)AutoExportFLowsSettings.class.cast(settings);
            List exportMethods = autoExportSettings.getExportMethods();
            if (autoExportSettings.getEnabled() != 1) {
                this.cronService.removeJob("auto_export_flows_job");
                return;
            }
            String cron = "";
            ArrayList<String> crons = new ArrayList<String>();
            int interval = 0;
            for (ExportMethod exportMethod : exportMethods) {
                String value;
                int n;
                int n2;
                String[] stringArray;
                if (exportMethod.getSelected() != 1) continue;
                if (exportMethod.getMethod() == 1) {
                    stringArray = exportMethod.getValue();
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        value = stringArray[n];
                        String[] time = value.split(":");
                        if (time.length == 3) {
                            cron = String.valueOf(time[2]) + " " + time[1] + " " + time[0] + " * * ?";
                            crons.add(cron);
                        }
                        ++n;
                    }
                    this.cronService.resetJobGroup(AutoExportFlowsJob.class, crons, interval, "auto_export_flows_job", "auto_export_flows_trigger");
                    continue;
                }
                if (exportMethod.getMethod() != 2) continue;
                stringArray = exportMethod.getValue();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    value = stringArray[n];
                    interval = Integer.valueOf(value);
                    this.cronService.resetJob(AutoExportFlowsJob.class, cron, interval, "auto_export_flows_job", "auto_export_flows_trigger");
                    ++n;
                }
            }
        }
        catch (MException | Exception e) {
            logger.error("\u83b7\u53d6\u81ea\u52a8\u5bfc\u51fa\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25", e);
        }
    }
}

