/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.crontab;

import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecClassifyDetails;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.ClearRecord;
import cms.tmx.entity.trade.Deal;
import cms.tmx.entity.trade.ExtAccntDetail;
import cms.tmx.entity.trade.ExtTransRecord;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.PortfolioDetail;
import cms.tmx.entity.trade.ReconcileInfo;
import cms.tmx.entity.trade.SecTransRecord;
import cms.tmx.entity.trade.TradeRecord;
import cms.tmx.entity.web.settings.AutoExportSettings;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.ClearingModel;
import cms.tmx.notification.IMessage;
import cms.tmx.notification.INotifyService;
import cms.tmx.query.current.models.CcsDealModel;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.IAccountDetailService;
import cms.tmx.query.history.IAccountStatService;
import cms.tmx.query.history.ICcsDealHisService;
import cms.tmx.query.history.ICcsPositionHisService;
import cms.tmx.query.history.IPortfolioDetailService;
import cms.tmx.query.history.ISecClassifyService;
import cms.tmx.query.history.ITradeRecordHisService;
import cms.tmx.query.history.models.CcsOrderHisServiceImpl;
import cms.tmx.query.history.models.ClearRecordHisServiceImpl;
import cms.tmx.query.history.models.TransferQueryModel;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.service.IUserSettingsService;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@Creatable
@Singleton
public class AutoExportJob
implements Job {
    private static final Logger logger = LogManager.getLogger(AutoExportJob.class);
    private static final String FILE_TYPE_XLS = ".xls";
    public static final int SELECTED = 1;
    public static final int SELECTED_DEFAULT = 2;
    private String pageNum = "1";
    private String pageSize = "1000";
    @Inject
    private ExecutorService exe;
    @Inject
    private IUserSettingsService setService;
    private AutoExportSettings settings;
    @Inject
    private IFundAccountService fundAccndService;
    @Inject
    private IAccountStatService accountStatService;
    @Inject
    private IAccountDetailService accountDetailService;
    @Inject
    private IPortfolioDetailService portfDetailService;
    @Inject
    private ISecClassifyService secClassifyService;
    @Inject
    private TransferQueryModel transRecordModel;
    @Inject
    private CcsOrderModel ccsOrderModel;
    @Inject
    private CcsDealModel ccsDealModel;
    @Inject
    private CcsPositionModel ccsPositionModel;
    @Inject
    private ITradeRecordHisService tradeRecordService;
    @Inject
    private CcsOrderHisServiceImpl orderHisService;
    @Inject
    private ICcsDealHisService dealHisService;
    @Inject
    private ICcsPositionHisService positionHisService;
    @Inject
    private ClearRecordHisServiceImpl clearRecordService;
    @Inject
    private PortfolioAccountModel portfAccntModel;
    @Inject
    private ClearingModel clearingModel;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private IBaseApi baseApi;
    private List<FundAccount> fundAccounts = new CopyOnWriteArrayList<FundAccount>();
    private List<Portfolio> portfolios = new CopyOnWriteArrayList<Portfolio>();
    private String path = "";
    private String currentDate = "";
    private String dateString = "";
    private String fileTime = "";
    private List<String> extAccntIds = new CopyOnWriteArrayList<String>();
    private List<String> portfolioIds = new CopyOnWriteArrayList<String>();
    private List<String> subAccntIds = new CopyOnWriteArrayList<String>();
    private List<String> accDesc = new CopyOnWriteArrayList<String>();
    private List<String> accField = new CopyOnWriteArrayList<String>();
    private List<String> orderDesc = new CopyOnWriteArrayList<String>();
    private List<String> orderField = new CopyOnWriteArrayList<String>();
    private List<String> dealDesc = new CopyOnWriteArrayList<String>();
    private List<String> dealField = new CopyOnWriteArrayList<String>();
    private List<String> positionDesc = new CopyOnWriteArrayList<String>();
    private List<String> positionField = new CopyOnWriteArrayList<String>();
    private List<String> unfinishedDesc = new CopyOnWriteArrayList<String>();
    private List<String> unfinishedField = new CopyOnWriteArrayList<String>();
    private List<String> tradeRecordDesc = new CopyOnWriteArrayList<String>();
    private List<String> tradeRecordField = new CopyOnWriteArrayList<String>();
    private List<String> dealSumDesc = new CopyOnWriteArrayList<String>();
    private List<String> dealSumField = new CopyOnWriteArrayList<String>();
    private List<String> statementsDesc = new CopyOnWriteArrayList<String>();
    private List<String> statementsField = new CopyOnWriteArrayList<String>();
    private List<String> accDetailDesc = new CopyOnWriteArrayList<String>();
    private List<String> accDetailField = new CopyOnWriteArrayList<String>();
    private List<String> portfEntrustDesc = new CopyOnWriteArrayList<String>();
    private List<String> portfEntrustField = new CopyOnWriteArrayList<String>();
    private List<String> portfDealDesc = new CopyOnWriteArrayList<String>();
    private List<String> portfDealField = new CopyOnWriteArrayList<String>();
    private List<String> portfPositionDesc = new CopyOnWriteArrayList<String>();
    private List<String> portfPositionField = new CopyOnWriteArrayList<String>();
    private List<String> portfDealSumDesc = new CopyOnWriteArrayList<String>();
    private List<String> portfDealSumField = new CopyOnWriteArrayList<String>();
    private List<String> portfDetailDesc = new CopyOnWriteArrayList<String>();
    private List<String> portfDetailField = new CopyOnWriteArrayList<String>();
    private List<String> portfCashTransferDesc = new CopyOnWriteArrayList<String>();
    private List<String> portfCashTransferField = new CopyOnWriteArrayList<String>();
    private List<String> portfPosiTransferDesc = new CopyOnWriteArrayList<String>();
    private List<String> portfPosiTransferField = new CopyOnWriteArrayList<String>();
    private List<String> portfClearRecordDesc = new CopyOnWriteArrayList<String>();
    private List<String> portfClearRecordField = new CopyOnWriteArrayList<String>();
    private List<String> secClassifyIds = new CopyOnWriteArrayList<String>();
    private List<String> secClassifyDesc = new CopyOnWriteArrayList<String>();
    private List<String> secClassifyField = new CopyOnWriteArrayList<String>();
    private boolean firstQuery;
    @Inject
    private INotifyService ntService;

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        logger.info("\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u5bfc\u51fa\u5b9a\u65f6\u4efb\u52a1\uff1a");
        this.exe.execute(() -> this.doExport());
    }

    @PostConstruct
    private void init() {
        System.err.println("init:" + System.identityHashCode(this));
    }

    private void doExport() {
        try {
            this.settings = (AutoExportSettings)this.setService.getSettingsDetail("0", "000003");
            if (this.settings == null) {
                return;
            }
            if (!this.settings.isCached()) {
                this.parseSettings(this.settings);
            }
            Date date = new Date();
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
            this.currentDate = simpleFormat.format(date);
            this.dateString = simpleFormat.format(date);
            if (this.settings.getDataTimeliness() == 1) {
                this.currentDate = this.clearingModel.getLastTradingDay();
            } else if (this.settings.getDataTimeliness() == 2 && this.currentDate.equals(this.clearingModel.getLastTradingDay())) {
                this.currentDate = this.clearingModel.getLastTradingDay();
            }
            if (this.settings.getFileNameTimestamp() == 1) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                this.fileTime = sdf.format(date);
            }
        }
        catch (MException e) {
            logger.error("\u6267\u884c\u81ea\u52a8\u5bfc\u51fa\u5b9a\u65f6\u4efb\u52a1\u65f6\u83b7\u53d6\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
        }
        logger.info("auto export begin, path :" + this.path);
        logger.info("fundAccounts :" + this.fundAccounts);
        logger.info("portfolios :" + this.portfolios);
        logger.info("secClassifyIds :" + this.secClassifyIds);
        logger.info("accDesc :" + this.accDesc);
        logger.info("accField :" + this.accField);
        logger.info("orderDesc :" + this.orderDesc);
        logger.info("orderField :" + this.orderField);
        logger.info("unfinishedDesc :" + this.unfinishedDesc);
        logger.info("unfinishedField :" + this.unfinishedField);
        logger.info("dealDesc :" + this.dealDesc);
        logger.info("dealField :" + this.dealField);
        logger.info("positionDesc :" + this.positionDesc);
        logger.info("positionField :" + this.positionField);
        logger.info("tradeRecordDesc :" + this.tradeRecordDesc);
        logger.info("tradeRecordField :" + this.tradeRecordField);
        logger.info("dealSumDesc :" + this.dealSumDesc);
        logger.info("dealSumField :" + this.dealSumField);
        logger.info("statementsDesc :" + this.statementsDesc);
        logger.info("statementsField :" + this.statementsField);
        logger.info("accDetailDesc :" + this.accDetailDesc);
        logger.info("accDetailField :" + this.accDetailField);
        logger.info("portfEntrustDesc :" + this.portfEntrustDesc);
        logger.info("portfEntrustField :" + this.portfEntrustField);
        logger.info("portfPositionDesc :" + this.portfPositionDesc);
        logger.info("portfPositionField :" + this.portfPositionField);
        logger.info("portfDealDesc :" + this.portfDealDesc);
        logger.info("portfDealField :" + this.portfDealField);
        logger.info("portfDealSumDesc :" + this.portfDealSumDesc);
        logger.info("portfDealSumField :" + this.portfDealSumField);
        logger.info("portfDetailDesc :" + this.portfDetailDesc);
        logger.info("portfDetailField :" + this.portfDetailField);
        logger.info("portfCashTransferDesc :" + this.portfCashTransferDesc);
        logger.info("portfCashTransferField :" + this.portfCashTransferField);
        logger.info("portfPosiTransferDesc :" + this.portfPosiTransferDesc);
        logger.info("portfPosiTransferField :" + this.portfPosiTransferField);
        logger.info("portfClearRecordDesc :" + this.portfClearRecordDesc);
        logger.info("portfClearRecordField :" + this.portfClearRecordField);
        logger.info("secClassifyDesc :" + this.secClassifyDesc);
        logger.info("secClassifyField :" + this.secClassifyField);
        if (this.fundAccounts.isEmpty() && this.portfolios.isEmpty() && this.secClassifyIds.isEmpty()) {
            return;
        }
        this.exe.execute(() -> {
            try {
                if (!this.accDesc.isEmpty() && !this.accField.isEmpty()) {
                    this.exportFundAccounts();
                }
            }
            catch (Exception e) {
                logger.error("export fundAccounts error", (Throwable)e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u8d26\u53f7\u4fe1\u606f\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                this.exportCcsOrder();
            }
            catch (MException | Exception e) {
                logger.error("export ccsOrder error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u59d4\u6258\u6216\u672a\u5b8c\u6210\u59d4\u6258\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.dealDesc.isEmpty() && !this.dealField.isEmpty()) {
                    this.exportCcsDeal();
                }
            }
            catch (MException | Exception e) {
                logger.error("export ccsDeal error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u73b0\u8d27\u6210\u4ea4\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.positionDesc.isEmpty() && !this.positionField.isEmpty()) {
                    this.exportCcsPosition();
                }
            }
            catch (MException | Exception e) {
                logger.error("export ccsPosition error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u73b0\u8d27\u6301\u4ed3\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.tradeRecordDesc.isEmpty() && !this.tradeRecordField.isEmpty()) {
                    this.exportTradeRecord();
                }
            }
            catch (MException | Exception e) {
                logger.error("export ccsTradeRecord error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u8d44\u5238\u6d41\u6c34\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.dealSumDesc.isEmpty() && !this.dealSumField.isEmpty()) {
                    this.exportAccDealSum();
                }
            }
            catch (MException | Exception e) {
                logger.error("export AccDealSum error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u8d26\u53f7\u6210\u4ea4\u6c47\u603b\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.statementsDesc.isEmpty() && !this.statementsField.isEmpty()) {
                    this.exportAccStatement();
                }
            }
            catch (MException | Exception e) {
                logger.error("export accStatement error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u5bf9\u8d26\u5355\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.accDetailDesc.isEmpty() && !this.accDetailField.isEmpty()) {
                    this.exportAccDetail();
                }
            }
            catch (Exception e) {
                logger.error("export accDetail error", (Throwable)e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u8d26\u53f7\u8d44\u4ea7\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.portfDetailDesc.isEmpty() && !this.portfDetailField.isEmpty()) {
                    this.exportPortfDetail();
                }
            }
            catch (MException | Exception e) {
                logger.error("export portfDetail error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u6295\u7ec4\u8d44\u4ea7\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.portfEntrustDesc.isEmpty() && !this.portfEntrustField.isEmpty()) {
                    this.exportPortfCcsOrder();
                }
            }
            catch (MException | Exception e) {
                logger.error("export portfCcsOrder error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u6295\u7ec4\u59d4\u6258\u6216\u672a\u5b8c\u6210\u59d4\u6258\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.portfDealDesc.isEmpty() && !this.portfDealField.isEmpty()) {
                    this.exportPortfCcsDeal();
                }
            }
            catch (MException | Exception e) {
                logger.error("export portfCcsDeal error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u6295\u7ec4\u73b0\u8d27\u6210\u4ea4\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.portfPositionDesc.isEmpty() && !this.portfPositionField.isEmpty()) {
                    this.exportPortfCcsPosition();
                }
            }
            catch (MException | Exception e) {
                logger.error("export portfCcsPosition error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u6295\u7ec4\u73b0\u8d27\u6301\u4ed3\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.portfDealSumDesc.isEmpty() && !this.portfDealSumField.isEmpty()) {
                    this.exportPortfDealSum();
                }
            }
            catch (MException | Exception e) {
                logger.error("export portfDealSum error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u6295\u7ec4\u6210\u4ea4\u6c47\u603b\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.portfCashTransferDesc.isEmpty() && !this.portfCashTransferField.isEmpty()) {
                    this.exportPortfCashTransfer();
                }
            }
            catch (MException | Exception e) {
                logger.error("export portfCashTransfer error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u6295\u7ec4\u8d44\u91d1\u5212\u8f6c\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.portfPosiTransferDesc.isEmpty() && !this.portfPosiTransferField.isEmpty()) {
                    this.exportPortfPosiTransfer();
                }
            }
            catch (MException | Exception e) {
                logger.error("export portfPosiTransfer error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u6295\u7ec4\u8bc1\u5238\u5212\u8f6c\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.portfClearRecordDesc.isEmpty() && !this.portfClearRecordField.isEmpty()) {
                    this.exportPortfClearRecord();
                }
            }
            catch (MException | Exception e) {
                logger.error("export ClearRecord error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u65e5\u7ec8\u6d41\u6c34\u5931\u8d25" + e.getMessage());
            }
        });
        this.exe.execute(() -> {
            try {
                if (!this.secClassifyDesc.isEmpty() && !this.secClassifyField.isEmpty()) {
                    this.exportSecClassList();
                }
            }
            catch (MException | Exception e) {
                logger.error("export secClassList error", e);
                this.record("\u81ea\u52a8\u5bfc\u51fa\u8bc1\u5238\u5206\u7c7b\u5931\u8d25" + e.getMessage());
            }
        });
    }

    private void exportSecClassList() throws MException {
        if (this.secClassifyDesc.isEmpty() && this.secClassifyField.isEmpty()) {
            return;
        }
        this.secClassifyDesc = this.secClassifyDesc.stream().distinct().collect(Collectors.toList());
        this.secClassifyField = this.secClassifyField.stream().distinct().collect(Collectors.toList());
        List SecClassify = new LinkedList();
        LinkedList SecClassifyAll = new LinkedList();
        String pageSize = "100";
        for (String secClassifyId : this.secClassifyIds) {
            int i = 1;
            String pageNum = "1";
            do {
                SecClassify = this.secClassifyService.query(this.baseApi.getPartyId(), secClassifyId, pageNum, pageSize);
                SecClassifyAll.addAll(SecClassify);
                pageNum = String.valueOf(++i);
            } while (SecClassify.size() == 100);
        }
        if (SecClassifyAll.isEmpty()) {
            return;
        }
        for (SecClassifyDetails detail : SecClassifyAll) {
            detail.setMarketCode(detail.getMarket());
            detail.setMarketName(detail.getMarket());
        }
        StringBuilder sb = new StringBuilder();
        HSSFWorkbook book = AutoExportJob.collectField(sb, SecClassifyAll, SecClassifyDetails.class, this.secClassifyDesc, this.secClassifyField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u8bc1\u5238\u5206\u7c7b" + this.fileTime + FILE_TYPE_XLS);
    }

    private void record(final String content) {
        this.ntService.recordShow(new IMessage(){

            public String getType() {
                return "\u7cfb\u7edf\u5f02\u5e38 ";
            }

            public String getCont() {
                return content;
            }

            public String getAccount() {
                return "";
            }
        });
    }

    private void exportPortfClearRecord() throws MException {
        LinkedList records = new LinkedList();
        HisQueryPage pages = new HisQueryPage();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setMarketGrp("CCS");
        page.setDimension("2");
        page.setPortfolioIdList(this.portfolioIds);
        pages = this.clearRecordService.getAllCcsData(page);
        records.addAll(pages.getDataList());
        if (records.isEmpty()) {
            return;
        }
        if (!this.portfClearRecordDesc.isEmpty() && !this.portfClearRecordField.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            HSSFWorkbook book = AutoExportJob.collectField(sb, records, ClearRecord.class, this.portfClearRecordDesc, this.portfClearRecordField, null);
            AutoExportJob.saveXLSFile(book, this.path, "\u65e5\u7ec8\u6d41\u6c34" + this.fileTime + FILE_TYPE_XLS);
        }
    }

    private void exportPortfCashTransfer() throws MException {
        List records = new LinkedList();
        records = this.transRecordModel.getExtTransfer(this.currentDate, this.currentDate, this.portfolioIds);
        if (records.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        HSSFWorkbook book = AutoExportJob.collectField(sb, records, ExtTransRecord.class, this.portfCashTransferDesc, this.portfCashTransferField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6295\u7ec4\u8d44\u91d1\u5212\u8f6c" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportPortfPosiTransfer() throws MException {
        List records = new LinkedList();
        records = this.transRecordModel.getSecTransfer(this.currentDate, this.currentDate, this.portfolioIds);
        if (records.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        HSSFWorkbook book = AutoExportJob.collectField(sb, records, SecTransRecord.class, this.portfPosiTransferDesc, this.portfPosiTransferField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6295\u7ec4\u8bc1\u5238\u5212\u8f6c" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportAccDetail() {
        Date date = new Date();
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
        String nowDate = simpleFormat.format(date);
        int i = 1;
        this.pageNum = "1";
        this.pageSize = "200";
        List accDetail = new LinkedList();
        LinkedList accDetailAll = new LinkedList();
        LinkedList<ExtAccntDetail> accDetails = new LinkedList<ExtAccntDetail>();
        if (this.currentDate.equals(nowDate)) {
            do {
                accDetail = this.accountDetailService.query(this.baseApi.getPartyId(), "", "", this.pageNum, this.pageSize);
                accDetailAll.addAll(accDetail);
                this.pageNum = String.valueOf(++i);
            } while (accDetail.size() == 200);
        } else {
            do {
                accDetail = this.accountDetailService.query(this.baseApi.getPartyId(), this.currentDate, this.currentDate, this.pageNum, this.pageSize);
                accDetailAll.addAll(accDetail);
                this.pageNum = String.valueOf(++i);
            } while (accDetail.size() == 200);
        }
        if (!accDetailAll.isEmpty()) {
            for (ExtAccntDetail detail : accDetailAll) {
                if (StringUtils.isEmpty((String)detail.getInvestorId()) || !this.fundAccounts.toString().contains(detail.getInvestorId())) continue;
                if ("1".equals(detail.getStatus())) {
                    detail.setStatus("\u542f\u7528");
                }
                accDetails.add(detail);
            }
        }
        if (accDetails.isEmpty()) {
            return;
        }
        for (ExtAccntDetail detail : accDetails) {
            detail.setTotalAsset(Double.valueOf(BigDecimal.valueOf(detail.getTotalAsset()).setScale(4, 4).doubleValue()));
            detail.setNetValue(Double.valueOf(BigDecimal.valueOf(detail.getNetValue()).setScale(4, 4).doubleValue()));
            detail.setBalance(Double.valueOf(BigDecimal.valueOf(detail.getBalance()).setScale(4, 4).doubleValue()));
            detail.setWithdrawQuota(Double.valueOf(BigDecimal.valueOf(detail.getWithdrawQuota()).setScale(4, 4).doubleValue()));
            detail.setCapitalization(Double.valueOf(BigDecimal.valueOf(detail.getCapitalization()).setScale(4, 4).doubleValue()));
            detail.setStockAsset(Double.valueOf(BigDecimal.valueOf(detail.getStockAsset()).setScale(4, 4).doubleValue()));
            detail.setFundAsset(Double.valueOf(BigDecimal.valueOf(detail.getFundAsset()).setScale(4, 4).doubleValue()));
            detail.setFuturesAsset(String.valueOf(BigDecimal.valueOf(Double.parseDouble(detail.getFuturesAsset())).setScale(4, 4).doubleValue()));
            detail.setRepurchaseAsset(String.valueOf(BigDecimal.valueOf(Double.parseDouble(detail.getRepurchaseAsset())).setScale(4, 4).doubleValue()));
            detail.setOptionsAsset(String.valueOf(BigDecimal.valueOf(Double.parseDouble(detail.getOptionsAsset())).setScale(4, 4).doubleValue()));
        }
        StringBuilder sb = new StringBuilder();
        HSSFWorkbook book = AutoExportJob.collectField(sb, accDetails, ExtAccntDetail.class, this.accDetailDesc, this.accDetailField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u8d26\u53f7\u8d44\u4ea7" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportPortfDetail() throws MException {
        Date date = new Date();
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
        String nowDate = simpleFormat.format(date);
        int i = 1;
        String pageNum = "1";
        String pageSize = "200";
        List portfDetail = new LinkedList();
        LinkedList portfDetailAll = new LinkedList();
        LinkedList<PortfolioDetail> portfDetails = new LinkedList<PortfolioDetail>();
        if (this.currentDate.equals(nowDate)) {
            do {
                portfDetail = this.portfDetailService.query(this.baseApi.getPartyId(), "", "", pageNum, pageSize);
                portfDetailAll.addAll(portfDetail);
                pageNum = String.valueOf(++i);
            } while (portfDetail.size() == 200);
        } else {
            do {
                portfDetail = this.portfDetailService.query(this.baseApi.getPartyId(), this.currentDate, this.currentDate, pageNum, pageSize);
                portfDetailAll.addAll(portfDetail);
                pageNum = String.valueOf(++i);
            } while (portfDetail.size() == 200);
        }
        if (!portfDetailAll.isEmpty()) {
            for (PortfolioDetail detail : portfDetailAll) {
                if (StringUtils.isEmpty((String)detail.getPortfolioId()) || !this.portfolioIds.toString().contains(detail.getPortfolioId())) continue;
                portfDetails.add(detail);
            }
        }
        if (portfDetails.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        HSSFWorkbook book = AutoExportJob.collectField(sb, portfDetails, PortfolioDetail.class, this.portfDetailDesc, this.portfDetailField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6295\u7ec4\u8d44\u4ea7" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportAccStatement() throws MException {
        List reconcileInfo = new LinkedList();
        LinkedList reconcileInfos = new LinkedList();
        int i = 1;
        String pageNum = "1";
        String pageSize = "200";
        for (FundAccount fundAccnt : this.fundAccounts) {
            i = 1;
            pageNum = "1";
            do {
                reconcileInfo = this.accountStatService.query(fundAccnt.getInvestId(), this.currentDate, pageNum, pageSize);
                reconcileInfos.addAll(reconcileInfo);
                pageNum = String.valueOf(++i);
            } while (reconcileInfo.size() == 200);
        }
        if (reconcileInfos.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        HSSFWorkbook book = AutoExportJob.collectField(sb, reconcileInfos, ReconcileInfo.class, this.statementsDesc, this.statementsField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u5bf9\u8d26\u5355" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportTradeRecord() throws MException {
        LinkedList tradeRecords = new LinkedList();
        HisQueryPage page = new HisQueryPage();
        Date date = new Date();
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
        String currentDate = simpleFormat.format(date);
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(currentDate);
        page.setEndDate(currentDate);
        page.setExtAccntIdList(this.extAccntIds);
        page.setMarketGrp("CCS");
        this.tradeRecordService.query(page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(100);
            page.setCurrentPage(Integer.valueOf(1));
            this.tradeRecordService.query(page);
        }
        tradeRecords.addAll(page.getDataList());
        StringBuilder sb = new StringBuilder();
        if (tradeRecords.isEmpty()) {
            return;
        }
        HSSFWorkbook book = AutoExportJob.collectField(sb, tradeRecords, TradeRecord.class, this.tradeRecordDesc, this.tradeRecordField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u8d44\u5238\u6d41\u6c34" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportFundAccounts() {
        StringBuilder sb = new StringBuilder();
        HSSFWorkbook book = AutoExportJob.collectField(sb, this.fundAccounts, FundAccount.class, this.accDesc, this.accField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u8d26\u53f7" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportCcsOrder() throws MException {
        List ccsOrders;
        if (this.orderDesc.isEmpty() && this.orderField.isEmpty() && this.unfinishedDesc.isEmpty() && this.unfinishedField.isEmpty()) {
            return;
        }
        LinkedList orders = new LinkedList();
        HisQueryPage pages = new HisQueryPage();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setExtAccntIdList(this.extAccntIds);
        page.setMarketGrp("CCS");
        page.setDimension("1");
        pages = this.orderHisService.getAllCcsData(page);
        orders.addAll(pages.getDataList());
        if (orders.isEmpty()) {
            return;
        }
        if (!this.orderDesc.isEmpty() && !this.orderField.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ccsOrders = this.ccsOrderModel.updateOrder(orders);
            HSSFWorkbook book = AutoExportJob.collectField(sb, ccsOrders, CcsOrder.class, this.orderDesc, this.orderField, null);
            AutoExportJob.saveXLSFile(book, this.path, "\u59d4\u6258" + this.fileTime + FILE_TYPE_XLS);
        }
        if (!this.unfinishedDesc.isEmpty() && !this.unfinishedField.isEmpty()) {
            StringBuilder unSb = new StringBuilder();
            ccsOrders = this.ccsOrderModel.updateOrder(orders);
            List unfinished = ccsOrders.stream().filter(item -> item.isCanCancel()).collect(Collectors.toList());
            if (unfinished.isEmpty()) {
                return;
            }
            HSSFWorkbook book = AutoExportJob.collectField(unSb, unfinished, CcsOrder.class, this.unfinishedDesc, this.unfinishedField, null);
            AutoExportJob.saveXLSFile(book, this.path, "\u672a\u5b8c\u6210\u59d4\u6258" + this.fileTime + FILE_TYPE_XLS);
        }
    }

    private void exportPortfCcsOrder() throws MException {
        List ccsOrders;
        if (this.portfEntrustDesc.isEmpty() && this.portfEntrustField.isEmpty()) {
            return;
        }
        LinkedList orders = new LinkedList();
        HisQueryPage pages = new HisQueryPage();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setMarketGrp("CCS");
        page.setDimension("2");
        page.setSubAccntIdList(this.subAccntIds);
        pages = this.orderHisService.getAllCcsData(page);
        orders.addAll(pages.getDataList());
        if (orders.isEmpty()) {
            return;
        }
        if (!this.portfEntrustDesc.isEmpty() && !this.portfEntrustField.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ccsOrders = this.ccsOrderModel.updateOrder(orders);
            HSSFWorkbook book = AutoExportJob.collectField(sb, ccsOrders, CcsOrder.class, this.portfEntrustDesc, this.portfEntrustField, null);
            AutoExportJob.saveXLSFile(book, this.path, "\u6295\u7ec4\u59d4\u6258" + this.fileTime + FILE_TYPE_XLS);
        }
        if (!this.unfinishedDesc.isEmpty() && !this.unfinishedField.isEmpty()) {
            StringBuilder unSb = new StringBuilder();
            ccsOrders = this.ccsOrderModel.updateOrder(orders);
            List unfinished = ccsOrders.stream().filter(item -> item.isCanCancel()).collect(Collectors.toList());
            if (unfinished.isEmpty()) {
                return;
            }
            HSSFWorkbook book = AutoExportJob.collectField(unSb, unfinished, CcsOrder.class, this.unfinishedDesc, this.unfinishedField, null);
            AutoExportJob.saveXLSFile(book, this.path, "\u672a\u5b8c\u6210\u59d4\u6258" + this.fileTime + FILE_TYPE_XLS);
        }
    }

    private void exportCcsDeal() throws MException {
        LinkedList deals = new LinkedList();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setExtAccntIdList(this.extAccntIds);
        page.setMarketGrp("CCS");
        page.setDimension("1");
        HisQueryPage pages = this.dealHisService.getAllCcsData(page);
        deals.addAll(pages.getDataList());
        if (deals.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        List ccsDeals = this.ccsDealModel.updateDeal(deals);
        HSSFWorkbook book = AutoExportJob.collectField(sb, ccsDeals, CcsDeal.class, this.dealDesc, this.dealField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6210\u4ea4" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportPortfCcsDeal() throws MException {
        LinkedList deals = new LinkedList();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setMarketGrp("CCS");
        page.setDimension("2");
        page.setSubAccntIdList(this.subAccntIds);
        HisQueryPage pages = this.dealHisService.getAllCcsData(page);
        deals.addAll(pages.getDataList());
        if (deals.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        List ccsDeals = this.ccsDealModel.updateDeal(deals);
        HSSFWorkbook book = AutoExportJob.collectField(sb, ccsDeals, CcsDeal.class, this.portfDealDesc, this.portfDealField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6295\u7ec4\u6210\u4ea4" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportCcsPosition() throws MException {
        LinkedList positions = new LinkedList();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setExtAccntIdList(this.extAccntIds);
        page.setMarketGrp("CCS");
        page.setDimension("1");
        page.setContainsClose(false);
        HisQueryPage pages = this.positionHisService.getAllCcsData(page);
        positions.addAll(pages.getDataList());
        if (positions.isEmpty()) {
            return;
        }
        if (!this.firstQuery) {
            LinkedList<RefItem> listItem = new LinkedList<RefItem>();
            for (CcsPosition t : positions) {
                RefItem item;
                if (!this.dateString.equals(t.getTradingDay()) || (item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecId())) == null) continue;
                listItem.add(item);
            }
            Gears gears = new Gears();
            gears.setBuy(new int[]{0});
            if (!listItem.isEmpty()) {
                this.mktMng.query(listItem, gears);
            }
        }
        for (CcsPosition posi : positions) {
            BigDecimal b;
            double cost;
            if (!this.firstQuery && this.dateString.equals(posi.getTradingDay())) {
                RefItem refItem = this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
                if (refItem == null) {
                    posi.setPercent(0.0);
                    posi.setYield(0.0);
                    continue;
                }
                MarketItem marketItem = this.mktMng.getInfo((IRefItem)refItem);
                if (marketItem != null) {
                    if (marketItem.getNowPrice() == 0.0) {
                        posi.setNowPrice(marketItem.getClosePrice());
                    } else {
                        posi.setNowPrice(marketItem.getNowPrice());
                    }
                }
            }
            if ((cost = (b = new BigDecimal(posi.getCost())).setScale(4, 4).doubleValue()) == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setPercent(0.0);
            } else {
                double percent = (posi.getNowPrice() - cost) * 100.0 / cost;
                posi.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
            }
            BigDecimal buy = new BigDecimal(posi.getBuyCost());
            double buyCost = buy.setScale(4, 4).doubleValue();
            if (buyCost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setYield(0.0);
                continue;
            }
            double yield = (posi.getNowPrice() - buyCost) * 100.0 / buyCost;
            posi.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
        }
        this.firstQuery = true;
        StringBuilder sb = new StringBuilder();
        List ccsPositions = this.ccsPositionModel.updateCcsPosition(positions);
        HSSFWorkbook book = AutoExportJob.collectField(sb, ccsPositions, CcsPosition.class, this.positionDesc, this.positionField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6301\u4ed3" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportPortfCcsPosition() throws MException {
        LinkedList positions = new LinkedList();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setMarketGrp("CCS");
        page.setDimension("2");
        page.setSubAccntIdList(this.subAccntIds);
        page.setContainsClose(false);
        HisQueryPage pages = this.positionHisService.getAllCcsData(page);
        positions.addAll(pages.getDataList());
        if (positions.isEmpty()) {
            return;
        }
        if (!this.firstQuery) {
            LinkedList<RefItem> listItem = new LinkedList<RefItem>();
            for (CcsPosition t : positions) {
                RefItem item;
                if (!this.dateString.equals(t.getTradingDay()) || (item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecId())) == null) continue;
                listItem.add(item);
            }
            Gears gears = new Gears();
            gears.setBuy(new int[]{0});
            if (!listItem.isEmpty()) {
                this.mktMng.query(listItem, gears);
            }
        }
        for (CcsPosition posi : positions) {
            BigDecimal b;
            double cost;
            if (!this.firstQuery && this.dateString.equals(posi.getTradingDay())) {
                RefItem refItem = this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
                if (refItem == null) {
                    posi.setPercent(0.0);
                    posi.setYield(0.0);
                    continue;
                }
                MarketItem marketItem = this.mktMng.getInfo((IRefItem)refItem);
                if (marketItem != null) {
                    if (marketItem.getNowPrice() == 0.0) {
                        posi.setNowPrice(marketItem.getClosePrice());
                    } else {
                        posi.setNowPrice(marketItem.getNowPrice());
                    }
                }
            }
            if ((cost = (b = new BigDecimal(posi.getCost())).setScale(4, 4).doubleValue()) == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setPercent(0.0);
            } else {
                double percent = (posi.getNowPrice() - cost) * 100.0 / cost;
                posi.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
            }
            BigDecimal buy = new BigDecimal(posi.getBuyCost());
            double buyCost = buy.setScale(4, 4).doubleValue();
            if (buyCost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setYield(0.0);
                continue;
            }
            double yield = (posi.getNowPrice() - buyCost) * 100.0 / buyCost;
            posi.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
        }
        this.firstQuery = true;
        StringBuilder sb = new StringBuilder();
        List ccsPositions = this.ccsPositionModel.updateCcsPosition(positions);
        HSSFWorkbook book = AutoExportJob.collectField(sb, ccsPositions, CcsPosition.class, this.portfPositionDesc, this.portfPositionField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6295\u7ec4\u6301\u4ed3" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportAccDealSum() throws MException {
        RefItem refItem;
        LinkedList deals = new LinkedList();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setExtAccntIdList(this.extAccntIds);
        page.setMarketGrp("CCS");
        page.setDimension("1");
        HisQueryPage pages = this.dealHisService.getAllCcsSumData(page);
        deals.addAll(pages.getDataList());
        if (deals.isEmpty()) {
            return;
        }
        ArrayList<RefItem> refList = new ArrayList<RefItem>();
        for (Deal deal : deals) {
            deal.setLastPx(BigDecimal.valueOf(deal.getLastPx()).setScale(4, 4).doubleValue());
            deal.setExecFee(BigDecimal.valueOf(deal.getExecFee()).setScale(3, 4).doubleValue());
            deal.setRealFee(BigDecimal.valueOf(deal.getRealFee()).setScale(4, 4).doubleValue());
            deal.setCommision(BigDecimal.valueOf(deal.getCommision()).setScale(4, 4).doubleValue());
            refItem = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            if (refItem == null || this.mktMng.getInfo((IRefItem)refItem) != null) continue;
            refList.add(refItem);
        }
        this.mktMng.query(refList, new Gears());
        for (Deal deal : deals) {
            deal.setLastAmount(0.0);
            refItem = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            if (refItem == null) {
                deal.setLastAmount(-1000.0);
                continue;
            }
            if (this.mktMng.getInfo((IRefItem)refItem) == null || refItem.getType().equals("PLEDGE")) {
                deal.setLastAmount(-1000.0);
                continue;
            }
            deal.setNowPrice(this.mktMng.getInfo((IRefItem)refItem).getNowPrice());
            if (this.mktMng.getInfo((IRefItem)refItem).getNowPrice() == 0.0) {
                deal.setNowPrice(this.mktMng.getInfo((IRefItem)refItem).getClosePrice());
            }
            if (deal.getLastPx() == 0.0) continue;
            double percent = 0.0;
            percent = deal.getSide().getRaw().equals(String.valueOf(49)) || deal.getSide().getRaw().equals(String.valueOf(71)) ? (deal.getNowPrice() - deal.getLastPx()) * 100.0 / deal.getLastPx() : (deal.getSide().getRaw().equals(String.valueOf(50)) || deal.getSide().getRaw().equals(String.valueOf(70)) ? (deal.getLastPx() - deal.getNowPrice()) * 100.0 / deal.getLastPx() : -1000.0);
            deal.setLastAmount(StringUtils.parseDouble((String)String.valueOf(percent), (int)2));
        }
        StringBuilder sb = new StringBuilder();
        List ccsDeals = this.ccsDealModel.updateDealWithoutPrice(deals);
        HSSFWorkbook book = AutoExportJob.collectField(sb, ccsDeals, CcsDeal.class, this.dealSumDesc, this.dealSumField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6210\u4ea4\u6c47\u603b" + this.fileTime + FILE_TYPE_XLS);
    }

    private void exportPortfDealSum() throws MException {
        RefItem refItem;
        LinkedList deals = new LinkedList();
        HisQueryPage page = new HisQueryPage();
        page.setBeginDate(this.currentDate);
        page.setEndDate(this.currentDate);
        page.setMarketGrp("CCS");
        page.setDimension("2");
        page.setPortfolioIdList(this.portfolioIds);
        page.setSubAccntIdList(this.subAccntIds);
        HisQueryPage pages = this.dealHisService.getAllCcsSumData(page);
        deals.addAll(pages.getDataList());
        if (deals.isEmpty()) {
            return;
        }
        ArrayList<RefItem> refList = new ArrayList<RefItem>();
        for (Deal deal : deals) {
            refItem = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            if (refItem == null || this.mktMng.getInfo((IRefItem)refItem) != null) continue;
            refList.add(refItem);
        }
        this.mktMng.query(refList, new Gears());
        for (Deal deal : deals) {
            deal.setLastAmount(0.0);
            refItem = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            if (refItem == null) {
                deal.setLastAmount(-1000.0);
                continue;
            }
            if (this.mktMng.getInfo((IRefItem)refItem) == null || refItem.getType().equals("PLEDGE")) {
                deal.setLastAmount(-1000.0);
                continue;
            }
            deal.setNowPrice(this.mktMng.getInfo((IRefItem)refItem).getNowPrice());
            if (this.mktMng.getInfo((IRefItem)refItem).getNowPrice() == 0.0) {
                deal.setNowPrice(this.mktMng.getInfo((IRefItem)refItem).getClosePrice());
            }
            if (deal.getLastPx() == 0.0) continue;
            double percent = 0.0;
            percent = deal.getSide().getRaw().equals(String.valueOf(49)) || deal.getSide().getRaw().equals(String.valueOf(71)) ? (deal.getNowPrice() - deal.getLastPx()) * 100.0 / deal.getLastPx() : (deal.getSide().getRaw().equals(String.valueOf(50)) || deal.getSide().getRaw().equals(String.valueOf(70)) ? (deal.getLastPx() - deal.getNowPrice()) * 100.0 / deal.getLastPx() : -1000.0);
            deal.setLastAmount(StringUtils.parseDouble((String)String.valueOf(percent), (int)2));
        }
        StringBuilder sb = new StringBuilder();
        List ccsDeals = this.ccsDealModel.updateDeal(deals);
        HSSFWorkbook book = AutoExportJob.collectField(sb, ccsDeals, CcsDeal.class, this.portfDealSumDesc, this.portfDealSumField, null);
        AutoExportJob.saveXLSFile(book, this.path, "\u6295\u7ec4\u6210\u4ea4\u6c47\u603b" + this.fileTime + FILE_TYPE_XLS);
    }

    public static HSSFWorkbook collectField(StringBuilder sb, List<?> objs, Class<?> clazz, List<String> descs, List<String> fields, String pd) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet spreadsheet = workbook.createSheet();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFDataFormat df = workbook.createDataFormat();
        cellStyle.setDataFormat(df.getFormat("@"));
        HSSFRow row = spreadsheet.createRow(0);
        int j = 0;
        while (j < descs.size()) {
            row.createCell(j).setCellValue(descs.get(j));
            ++j;
        }
        int i = 1;
        while (i < objs.size() + 1) {
            row = spreadsheet.createRow(i);
            Object obj = objs.get(i - 1);
            if (obj != null) {
                int j2 = 0;
                while (j2 < fields.size()) {
                    Object content = null;
                    try {
                        Method method = clazz.getMethod("get" + fields.get(j2), new Class[0]);
                        content = method.invoke(obj, new Object[0]);
                        HSSFCell cell = row.createCell(j2);
                        cell.setCellStyle(cellStyle);
                        cell.setCellType(CellType.STRING);
                        if (content == null) {
                            cell.setCellValue("");
                        } else if (content instanceof Number) {
                            Number num = (Number)content;
                            if (num.doubleValue() > Double.MAX_VALUE) {
                                cell.setCellValue(content.toString());
                            } else {
                                BigDecimal decimal = new BigDecimal(String.valueOf(content));
                                cell.setCellValue(decimal.toString());
                            }
                        } else {
                            cell.setCellValue(content.toString());
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u51fa\u9519: field: " + fields.get(j2), (Throwable)e);
                    }
                    ++j2;
                }
            }
            ++i;
        }
        return workbook;
    }

    private void parseSettings(AutoExportSettings settings) throws MException {
        this.clearData();
        settings.getSecurityData().getAccounts().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.extAccntIds.add(item.getExtAccntId());
            }
        });
        settings.getPortfolioData().getTitles().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                if (item.getPortfolioId().isEmpty()) {
                    return;
                }
                this.portfolioIds.add(item.getPortfolioId());
                this.portfolioIds = this.portfolioIds.stream().distinct().collect(Collectors.toList());
                for (CcsFundAccount fundAccnt : this.portfAccntModel.getMap(item.getPortfolioId()).keySet()) {
                    if (!(fundAccnt instanceof CcsSubFundAccount)) continue;
                    CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                    this.subAccntIds.add(subFundAccnt.getSubAccntId());
                }
            }
        });
        settings.getSecurityClassifyData().getSecurityClassify().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.secClassifyIds.add(item.getSecClassifyId().substring(0, 4));
            }
        });
        this.secClassifyIds = this.secClassifyIds.stream().distinct().collect(Collectors.toList());
        this.fundAccounts.addAll(this.fundAccndService.getFundAccountList().stream().filter(item -> this.extAccntIds.contains(item.getExtAccntId())).collect(Collectors.toList()));
        this.portfolios.addAll(this.portfAccntModel.getPortfolios().stream().filter(item -> this.portfolioIds.contains(item.getId())).collect(Collectors.toList()));
        settings.getSecurityData().getAct().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.accDesc.add(item.getDescription());
                this.accField.add(item.getField());
            }
        });
        settings.getSecurityData().getDeal().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.dealDesc.add(item.getDescription());
                this.dealField.add(item.getField());
            }
        });
        settings.getSecurityData().getEntrust().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.orderDesc.add(item.getDescription());
                this.orderField.add(item.getField());
            }
        });
        settings.getSecurityData().getPosition().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.positionDesc.add(item.getDescription());
                this.positionField.add(item.getField());
            }
        });
        settings.getSecurityData().getUnfinished().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.unfinishedDesc.add(item.getDescription());
                this.unfinishedField.add(item.getField());
            }
        });
        settings.getSecurityData().getTradeRecord().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.tradeRecordDesc.add(item.getDescription());
                this.tradeRecordField.add(item.getField());
            }
        });
        settings.getSecurityData().getDealCount().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.dealSumDesc.add(item.getDescription());
                this.dealSumField.add(item.getField());
            }
        });
        settings.getSecurityData().getStatements().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.statementsDesc.add(item.getDescription());
                this.statementsField.add(item.getField());
            }
        });
        settings.getSecurityData().getExtAccntDetail().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.accDetailDesc.add(item.getDescription());
                this.accDetailField.add(item.getField());
            }
        });
        settings.getPortfolioData().getEntrust().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.portfEntrustDesc.add(item.getDescription());
                this.portfEntrustField.add(item.getField());
            }
        });
        settings.getPortfolioData().getPosition().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.portfPositionDesc.add(item.getDescription());
                this.portfPositionField.add(item.getField());
            }
        });
        settings.getPortfolioData().getDeal().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.portfDealDesc.add(item.getDescription());
                this.portfDealField.add(item.getField());
            }
        });
        settings.getPortfolioData().getDealCount().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.portfDealSumDesc.add(item.getDescription());
                this.portfDealSumField.add(item.getField());
            }
        });
        settings.getPortfolioData().getPortfolioDetail().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.portfDetailDesc.add(item.getDescription());
                this.portfDetailField.add(item.getField());
            }
        });
        settings.getPortfolioData().getClearRecord().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.portfClearRecordDesc.add(item.getDescription());
                this.portfClearRecordField.add(item.getField());
            }
        });
        settings.getPortfolioData().getExtTransRecord().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.portfCashTransferDesc.add(item.getDescription());
                this.portfCashTransferField.add(item.getField());
            }
        });
        settings.getPortfolioData().getSecTransRecord().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.portfPosiTransferDesc.add(item.getDescription());
                this.portfPosiTransferField.add(item.getField());
            }
        });
        settings.getSecurityClassifyData().getSecurityClassifies().stream().forEach(item -> {
            if (item.getSelected() == 1) {
                this.secClassifyDesc.add(item.getDescription());
                this.secClassifyField.add(item.getField());
            }
        });
        this.path = settings.getExportDirectory();
        settings.setCached(true);
    }

    public static void saveXLSFile(HSSFWorkbook book, String path, String fileName) {
        logger.info("write " + fileName + " begin: ");
        long begin = System.currentTimeMillis();
        OutputStream os = null;
        try {
            try {
                File tempFile = new File(path);
                if (!tempFile.exists()) {
                    tempFile.mkdirs();
                }
                os = new FileOutputStream(String.valueOf(tempFile.getPath()) + File.separator + fileName);
                book.write(os);
                logger.info(String.valueOf(fileName) + " take time: " + (System.currentTimeMillis() - begin));
            }
            catch (Exception e) {
                logger.error("\u81ea\u52a8\u5bfc\u51fa\u8f93\u51facsv\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                try {
                    if (book != null) {
                        book.close();
                    }
                }
                catch (IOException e2) {
                    logger.error("\u81ea\u52a8\u5bfc\u51fa\u5173\u95ed\u8f93\u51fa\u6d41\u51fa\u9519", (Throwable)e2);
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e3) {
                    logger.error("\u81ea\u52a8\u5bfc\u51fa\u5173\u95ed\u8f93\u51fa\u6d41\u51fa\u9519", (Throwable)e3);
                }
            }
        }
        finally {
            try {
                if (book != null) {
                    book.close();
                }
            }
            catch (IOException e) {
                logger.error("\u81ea\u52a8\u5bfc\u51fa\u5173\u95ed\u8f93\u51fa\u6d41\u51fa\u9519", (Throwable)e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                logger.error("\u81ea\u52a8\u5bfc\u51fa\u5173\u95ed\u8f93\u51fa\u6d41\u51fa\u9519", (Throwable)e);
            }
        }
    }

    private void clearData() {
        this.path = "";
        this.currentDate = "";
        this.fileTime = "";
        this.extAccntIds.clear();
        this.subAccntIds.clear();
        this.fundAccounts.clear();
        this.portfolioIds.clear();
        this.accDesc.clear();
        this.accField.clear();
        this.orderDesc.clear();
        this.orderField.clear();
        this.dealDesc.clear();
        this.dealField.clear();
        this.positionDesc.clear();
        this.positionField.clear();
        this.unfinishedDesc.clear();
        this.unfinishedField.clear();
        this.tradeRecordDesc.clear();
        this.tradeRecordField.clear();
        this.dealSumDesc.clear();
        this.dealSumField.clear();
        this.statementsDesc.clear();
        this.statementsField.clear();
        this.accDetailDesc.clear();
        this.accDetailField.clear();
        this.portfDetailDesc.clear();
        this.portfDetailField.clear();
        this.portfEntrustDesc.clear();
        this.portfEntrustField.clear();
        this.portfPositionDesc.clear();
        this.portfPositionField.clear();
        this.portfDealDesc.clear();
        this.portfDealField.clear();
        this.portfDealSumDesc.clear();
        this.portfDealSumField.clear();
        this.portfCashTransferDesc.clear();
        this.portfCashTransferField.clear();
        this.portfPosiTransferDesc.clear();
        this.portfPosiTransferField.clear();
        this.portfClearRecordDesc.clear();
        this.portfClearRecordField.clear();
        this.secClassifyIds.clear();
        this.secClassifyDesc.clear();
        this.secClassifyField.clear();
    }
}

