/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade.crontab;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.AutoExportFLowsSettings;
import cms.tmx.trade.crontab.AutoExportJob;
import cms.tmx.trade.crontab.GXFlows;
import cms.tmx.web.api.core.HttpClientService;
import cms.tmx.web.service.IUserSettingsService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@Creatable
@Singleton
public class AutoExportFlowsJob
implements Job {
    private static final Logger logger = LogManager.getLogger(AutoExportFlowsJob.class);
    private static final String FILE_TYPE_XLS = ".xls";
    public static final int SELECTED = 1;
    public static final int SELECTED_DEFAULT = 2;
    @Inject
    private ExecutorService exe;
    @Inject
    private HttpClientService httpClient;
    private AutoExportFLowsSettings settings;
    @Inject
    private IUserSettingsService setService;
    private String path = "";
    private String fileTime = "";
    private String portfIds = "";
    private List<String> portfolioIds = new CopyOnWriteArrayList<String>();
    @Inject
    private IBaseApi baseApi;

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        logger.info("\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u5bfc\u51fa\u5b9a\u65f6\u4efb\u52a1\uff1a(\u56fd\u65b0\u4f30\u503c\u6d41\u6c34)");
        this.exe.execute(() -> this.doExport());
    }

    private void doExport() {
        try {
            this.settings = (AutoExportFLowsSettings)this.setService.getSettingsDetail("0", "000005");
            if (this.settings == null) {
                return;
            }
            this.portfolioIds.clear();
            this.settings.getPortfolioData().getTitles().stream().forEach(item -> {
                if (item.getSelected() == 1) {
                    if (item.getPortfolioId().isEmpty()) {
                        return;
                    }
                    this.portfolioIds.add(item.getPortfolioId());
                    this.portfolioIds = this.portfolioIds.stream().distinct().collect(Collectors.toList());
                }
            });
            this.portfIds = String.join((CharSequence)",", this.portfolioIds);
            this.path = this.settings.getExportDirectory();
            Date date = new Date();
            if (this.settings.getFileNameTimestamp() == 1) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                this.fileTime = sdf.format(date);
            } else {
                this.fileTime = "";
            }
        }
        catch (MException e) {
            logger.error("\u6267\u884c\u81ea\u52a8\u5bfc\u51fa\u5b9a\u65f6\u4efb\u52a1\u65f6\u83b7\u53d6\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
        }
        Gson gson = new Gson();
        this.exe.execute(() -> {
            HashMap<String, String> paramMap2 = new HashMap<String, String>();
            paramMap2.put("postId", this.baseApi.getPostId());
            paramMap2.put("portfolioIds", this.portfIds);
            List list = new ArrayList();
            try {
                String json = this.httpClient.doGet("/db/gx/evaluation-flow/listAll", paramMap2, true);
                list = (List)gson.fromJson(json, new TypeToken<ArrayList<GXFlows>>(){}.getType());
                System.out.println();
            }
            catch (MException e) {
                e.printStackTrace();
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<String> desc = new ArrayList<String>();
            ArrayList<String> field = new ArrayList<String>();
            desc.add("l_workgid3");
            desc.add("Vc_stoc9");
            desc.add("L_workg7");
            desc.add("L_seria3");
            desc.add("L_seria4");
            desc.add("C_exch25");
            desc.add("Vc_cjrq");
            desc.add("Vc_cjbh");
            desc.add("Vc_jycw");
            desc.add("Vc_tzfl");
            field.add("EXT_PORTFOLIO_ID");
            field.add("INVESTOR_SEC_ID");
            field.add("INVESTOR_ID");
            field.add("ORDER_ID");
            field.add("RPT_ORDER_ID");
            field.add("MARKET");
            field.add("EXEC_DATE");
            field.add("EXEC_NO");
            field.add("TRADE_SEAT");
            field.add("INVEST_TYPE");
            HSSFWorkbook book = AutoExportJob.collectField(sb, list, GXFlows.class, desc, field, null);
            if (this.path.isEmpty()) {
                this.path = "D:\\";
            }
            AutoExportJob.saveXLSFile(book, this.path, "\u4f30\u503c\u6d41\u6c34" + this.fileTime + FILE_TYPE_XLS);
        });
    }
}

