/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.trade;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.dialog.TableMenuBarDialog;
import cms.tmx.control.dialog.TreeTableMenuBarDialog;
import cms.tmx.core.MAddon;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.notice.MarketStatusReport;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.CtpPosition;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.http.query.sge.ObSgePosition;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.margin.models.ContractModel;
import cms.tmx.query.margin.models.MarginPositionModel;
import cms.tmx.trade.crontab.CrontabFlowsMngService;
import cms.tmx.trade.crontab.CrontabMngService;
import cms.tmx.trade.entrust.BatchEntrust;
import cms.tmx.trade.entrust.CcsCancelAndOrder;
import cms.tmx.trade.entrust.CcsCancelOrder;
import cms.tmx.trade.entrust.CcsCloseEntrust;
import cms.tmx.trade.entrust.CcsPortfCloseEntrust;
import cms.tmx.trade.entrust.FutureCloseEntrust;
import cms.tmx.trade.entrust.SgeCloseEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.trade.models.SubMng;
import cms.tmx.trade.models.basket.BasketCancelOrder;
import cms.tmx.trade.models.basket.BasketCancelReplace;
import cms.tmx.trade.models.basket.BasketMngModel;
import cms.tmx.trade.views.BankStockTransferDialog;
import cms.tmx.trade.views.CcsTradeDialog;
import cms.tmx.trade.views.PositionOtcTransferDialog;
import cms.tmx.trade.views.PositionTransferDialog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableView;
import javafx.stage.Modality;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TradeAddon
extends MAddon {
    private static final Logger logger = LogManager.getLogger(TradeAddon.class);
    @Inject
    private MEventService es;
    @Inject
    private IFundAccountService fundMng;
    @Inject
    private CcsCancelAndOrder ccsReplace;
    @Inject
    private CcsCancelOrder ccsCancel;
    @Inject
    private BasketCancelReplace bskReplace;
    @Inject
    private BasketCancelOrder bskCancel;
    @Inject
    private DialogFactory df;
    @Inject
    private MObjFactory of;
    @Inject
    private ISecAccountService secAccMng;
    @Inject
    private PortfolioAccountModel portfolioAccntModel;
    @Inject
    private OtcPortfolioAccountModel otcPortfolioAccntModel;
    @Inject
    private InstructionAccountModel instructionAccntModel;
    @Inject
    private BasketMngModel basketMng;
    @Inject
    private CcsPositionModel posiModel;
    @Inject
    private ContractModel marginContradeModel;
    @Inject
    private MarginPositionModel marginPositionModel;
    @Inject
    private cms.tmx.query.margin.models.xt.ContractModel xtContractModel;
    @Inject
    private cms.tmx.query.margin.models.xt.MarginPositionModel xtPositionModel;
    @Inject
    private CrontabMngService crontabMngService;
    @Inject
    private CrontabFlowsMngService crontabFlowsMngService;
    @Inject
    private MessagePromptMng msgMng;
    @Inject
    private SubMng subMng;
    private MEventHandler hSetCode = event -> {
        Method[] methods;
        Method[] methodArray = methods = ((Object)((Object)this)).getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (event.getStr("MethodName").equals(method.getName())) {
                try {
                    method.invoke(((Object)((Object)this)).getClass().newInstance(), this.of, this.df);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            ++n2;
        }
    };
    @Inject
    private ExecutorService exe;
    private MEventHandler hClosePosition = event -> {
        Object obj = event.getObj();
        if (!(obj instanceof List)) {
            return;
        }
        int countSuc = 0;
        int countFailed = 0;
        List list = (List)obj;
        ArrayList newList = new ArrayList();
        List list2 = list;
        synchronized (list2) {
            for (Object object : list) {
                newList.add(object);
            }
        }
        for (Object item : newList) {
            String secId = "";
            try {
                Object entrust;
                CcsPortfPosition pos;
                if (item instanceof CcsPortfPosition) {
                    pos = (CcsPortfPosition)CcsPortfPosition.class.cast(item);
                    secId = pos.getSecId();
                    entrust = (CcsPortfCloseEntrust)((Object)((Object)this.of.create(CcsPortfCloseEntrust.class)));
                    ((CcsPortfCloseEntrust)((Object)((Object)entrust))).setPosition(pos);
                    ((CcsPortfCloseEntrust)((Object)((Object)entrust))).submit();
                } else if (item instanceof CcsPosition) {
                    pos = (CcsPosition)CcsPosition.class.cast(item);
                    secId = pos.getSecId();
                    entrust = (CcsCloseEntrust)((Object)((Object)this.of.create(CcsCloseEntrust.class)));
                    ((CcsCloseEntrust)((Object)((Object)entrust))).setPosition((CcsPosition)pos);
                    ((CcsCloseEntrust)((Object)((Object)entrust))).submit();
                } else if (item instanceof CtpPosition) {
                    pos = (CtpPosition)CtpPosition.class.cast(item);
                    secId = pos.getSecId();
                    entrust = (FutureCloseEntrust)((Object)((Object)this.of.create(FutureCloseEntrust.class)));
                    ((FutureCloseEntrust)((Object)((Object)entrust))).setPosition((CtpPosition)pos);
                    ((FutureCloseEntrust)((Object)((Object)entrust))).submit();
                } else {
                    if (!(item instanceof ObSgePosition)) continue;
                    pos = (ObSgePosition)ObSgePosition.class.cast(item);
                    secId = pos.getInstrument().getSecId();
                    entrust = (SgeCloseEntrust)this.of.create(SgeCloseEntrust.class);
                    ((SgeCloseEntrust)entrust).setPosition((ObSgePosition)pos);
                    ((SgeCloseEntrust)entrust).submit();
                }
                ++countSuc;
            }
            catch (MException e) {
                logger.error("submit position close entrust failed: " + secId, (Throwable)e);
                event.setDesc(e.getMessage());
                ++countFailed;
            }
        }
        event.put((Object)"suc.count", (Object)countSuc);
        event.put((Object)"fail.count", (Object)countFailed);
    };
    @Inject
    private BatchEntrust batchEntrust;
    private MEventHandler hCloseBasketPosition = event -> {
        Object obj = event.getObj();
        boolean isPortfolio = event.getBool("isPortfolio");
        if (!(obj instanceof List)) {
            return;
        }
        List list = (List)obj;
        ArrayList<BasketTradeItem> newList = new ArrayList<BasketTradeItem>();
        List list2 = list;
        synchronized (list2) {
            for (Object object : list) {
                if (!(object instanceof BasketTradeItem)) continue;
                newList.add((BasketTradeItem)object);
            }
        }
        try {
            BasketSubmitResult result = this.batchEntrust.entrust(newList, isPortfolio);
            event.put((Object)"clear.basket", (Object)result);
        }
        catch (MException e) {
            logger.error("\u6e05\u4ed3\u6301\u4ed3\u6570\u636e " + e.getMessage(), (Throwable)e);
        }
    };

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.pre.login", event -> this.onLogin(event));
        this.ccsReplace.subscribe();
        this.ccsCancel.subscribe();
        this.bskReplace.subscribe();
        this.bskCancel.subscribe();
        this.es.subscribe("dialogEvent", this.hSetCode);
        this.es.subscribe("positionTransferEvent", event -> this.transfer(event));
        this.es.subscribe("positionOtcTransferEvent", event -> this.otcTransfer(event));
        this.es.subscribe("server.sub", e -> this.onPush(e));
        this.es.subscribe("change.table.column", e -> this.select(e));
        this.es.subscribe("change.tree.table.column", e -> this.selectTree(e));
        super.loadDone();
    }

    public void select(MEvent event) {
        Object object = event.get((Object)"data");
        TableView table = (TableView)TableView.class.cast(object);
        TableMenuBarDialog obj = (TableMenuBarDialog)this.of.create(TableMenuBarDialog.class);
        obj.setTableSource(table);
        MxDialog dialog = this.df.create((DialogObj)obj, "");
        dialog.launch();
    }

    public void selectTree(MEvent event) {
        Object object = event.get((Object)"data");
        TreeTableView table = (TreeTableView)TreeTableView.class.cast(object);
        TreeTableMenuBarDialog obj = (TreeTableMenuBarDialog)this.of.create(TreeTableMenuBarDialog.class);
        obj.setTreeTableSource(table);
        MxDialog dialog = this.df.create((DialogObj)obj, "");
        dialog.launch();
    }

    protected void onPush(MEvent event) {
        if (event.getObj() instanceof MarketStatusReport) {
            MarketStatusReport cast = (MarketStatusReport)MarketStatusReport.class.cast(event.getObj());
            int counterStatus = cast.getReport().getCounterStatus();
            if (2 == counterStatus) {
                event.put((Object)"market_status", (Object)true);
                this.es.postEvent("marketStatus", event);
            } else if (3 == counterStatus) {
                event.put((Object)"market_status", (Object)false);
                this.es.postEvent("marketStatus", event);
            }
        }
    }

    private void onLogin(MEvent event) {
        this.exe.execute(() -> {
            try {
                this.fundMng.getFundAccountList();
                this.secAccMng.getSecAccountMap();
            }
            catch (MException e) {
                logger.error("\u767b\u5f55\u540e\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u53ca\u8bc1\u5238\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e);
            }
        });
        this.exe.execute(() -> this.portfolioAccntModel.getPortfolios());
        this.exe.execute(() -> {
            this.instructionAccntModel.createAccMap();
            this.otcPortfolioAccntModel.getPortfolios();
            this.marginContradeModel.query();
            this.marginPositionModel.query();
            this.exe.execute(() -> {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    logger.error("\u767b\u5f55\u540e\u81ea\u52a8\u67e5\u8be2\u6301\u4ed3\u5931\u8d25", (Throwable)e);
                }
                this.posiModel.initQuery();
            });
        });
        this.exe.execute(() -> {
            this.xtContractModel.query();
            this.xtPositionModel.query();
        });
        this.exe.execute(() -> {
            try {
                this.basketMng.query();
            }
            catch (MException e) {
                logger.error("portfolio account init failed", (Throwable)e);
            }
        });
        this.es.subscribe("trade.close.position", this.hClosePosition);
        this.es.subscribe("trade.close.basket.position", this.hCloseBasketPosition);
    }

    private void otcTransfer(MEvent event) {
        PositionOtcTransferDialog obj = (PositionOtcTransferDialog)((Object)this.of.create(PositionOtcTransferDialog.class));
        Party party = (Party)event.getObj();
        if (party != null) {
            obj.setParty(party);
        }
        Platform.runLater(() -> {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u573a\u5916\u57fa\u91d1");
            dialog.launch();
        });
    }

    private void transfer(MEvent event) {
        PositionTransferDialog obj = (PositionTransferDialog)((Object)this.of.create(PositionTransferDialog.class));
        Party party = (Party)event.getObj();
        if (party != null) {
            obj.setParty(party);
        }
        Platform.runLater(() -> {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u6295\u7ec4\u8bc1\u5238\u5212\u8f6c");
            dialog.launch();
        });
    }

    public void doubleFastTrade(MObjFactory mobj, DialogFactory dfa) {
        CcsTradeDialog obj = (CcsTradeDialog)((Object)mobj.create(CcsTradeDialog.class));
        MxDialog dialog = dfa.create((DialogObj)obj, "\u53cc\u5411\u5feb\u6377\u4ea4\u6613");
        obj.setCtrl(dialog.getCtrl());
        dialog.initModality(Modality.NONE);
        dialog.launch();
    }

    public void bankStockTransfer(MObjFactory mobj, DialogFactory dfa) {
        BankStockTransferDialog obj = (BankStockTransferDialog)((Object)mobj.create(BankStockTransferDialog.class));
        MxDialog dialog = dfa.create((DialogObj)obj, "\u94f6\u8bc1\u8f6c\u8d26");
        dialog.getButton(ButtonType.OK).setVisible(false);
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        dialog.launch();
    }
}

