/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.utils;

import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.DecimalUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringUtils {
    private static final Logger logger = LogManager.getLogger(StringUtils.class);
    private static final int NUM_WAN = 10000;
    private static final int NUM_YI = 100000000;
    public static final int MAX_SCALE = 3;
    public static final int MIN_SCALE = 2;
    private static final int PAD_LIMIT = 8192;
    public static final String SPACE = " ";
    public static final String IP_SYMBOL = "[0-9.]*";
    public static final String IP = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
    public static final String MAC = "^([0-9a-fA-F]{2})(([0-9a-fA-F]{2}){5})$";
    public static final String SEC_ACCT = "[A-Za-z0-9]+";
    public static final String FUND_ACCT = "[0-9]+";
    public static final String INT = "^(([1-9]{1}\\d*)|([0]{1}))$";
    public static final String INT_INT = "^(([1-9]{1}\\d*)|([0]{1}))(/([1-9]{1}\\d*)?)?$";
    public static final String INT_INT_CHECK = "^(([1-9]{1}\\d*)|([0]{1}))(/([1-9]{1}\\d*))?$";
    public static final String INT_POSITIVE = "^([1-9]{1}\\d*)$";
    public static final String DOUBLE = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,})?$";
    public static final String CELLPHONE = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(18[0,5-9]))\\d{8}$";
    public static final String TELEPHONE = "^(0\\d{2}-\\d{8}(-\\d{1,4})?)|(0\\d{3}-\\d{7,8}(-\\d{1,4})?)$";
    public static final String NUM = "^([1-9]{1}\\d*)$";
    public static final String NUMERIC = "[0-9]*";
    public static final String INVESTOR_ID = "[A-Za-z0-9@]*";
    public static final String PWDSYMBOL = "^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*$";
    public static final String PWD = "^(?![0-9a-z]+$)(?![0-9A-Z]+$)(?![0-9\\W]+$)(?![a-zA-Z]+$)(?![a-z_\\W]+$)(?![A-Z_\\W]+$)[a-zA-Z0-9_\\W]{8,20}+$";
    public static final String ACCNTPWD = "^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$";
    public static final String EMAILESYMBOL = "[A-Za-z0-9_\\-.@]{0,50}";
    public static final String NORMAL = "[A-Za-z0-9\u4e00-\u9fa5]*";
    public static final String TEXT = "[A-Za-z0-9_\u4e00-\u9fa5\\-]*";
    public static final String TEXT_PORTF = "[A-Za-z0-9_\u4e00-\u9fa5\\-\\(\\).]*";
    public static final String TEXT_SPECIAL = "[A-Za-z0-9_\u4e00-\u9fa5\\-~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*";
    public static final String TEXT_SPECIAL_ALL = "[A-Za-z0-9_\u4e00-\u9fa5\\-~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?\\(\\)]*";
    public static final String LETTER_NUM = "[A-Za-z0-9]*";
    public static final String HOUR = "^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$";
    public static final String MINUTE = "^(([0-9]{0,1})|([0-5][0-9]))$";
    public static final String PERCENT = "^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$";
    public static final String MINUS_DOUBLE = "^[-]?(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,})?$";
    public static final String NUM_SMALL = "^(([0-9]{0,12})|0)(\\.(\\d){0,4})?$";
    public static final String THOUSANDS_SCALE_ZERO = ",##0";
    public static final String NUM_FORMATTER = "%1$,.2f";
    public static final String LETTERS = "[A-Za-z]+";
    public static final String SECURITY = "[A-Za-z0-9]*";
    public static final String SGESECURITY = "[A-Za-z0-9\\(\\)\\+]*";
    public static final String ABROADSECURITY = "[A-Za-z0-9\\(\\)\\-]*";
    public static final String SECURITY_STDBOND = "[A-Za-z0-9_]*";
    public static final String PRICE_EXPRESSION = "^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$";
    public static final String EXTRANET_IP = "\\d+.\\d+.\\d+.\\d+";
    public static final String INT_012 = "[012]";
    public static final String INT_12 = "[12]";
    public static final String CARRY_NUM = "[1-9]";
    public static final String ORDER_AMOUNT = "^(([1-9]{1}\\d*)|([1-9]{1}))(\\.\\d{0,2})?$";
    public static final String PERSON_LOGIN = "^[0-9]*$";
    public static final String PARTY_LOGIN = "^[a-zA-Z\u4e00-\u9fa5][a-zA-Z0-9~!@#$%^&*:<>?,.=_\u4e00-\u9fa5]*$";
    public static final String DOUBLE4_TEXT = "^((([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?)|([A-Za-z0-9_\u4e00-\u9fa5]*)$";
    public static final String DOUBLE4 = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$";
    public static final String DOUBLE2 = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$";
    public static final String TIME_HOUR_MINUTE = "^[0-9:\uff1a]{0,5}$";
    public static final String TIME_HOUR_MINUTE_CHECK = "^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3])):(([0-9]{0,1})|([0-5][0-9]))$";
    public static final NumberFormat nf = NumberFormat.getInstance();

    static {
        nf.setMaximumFractionDigits(20);
        nf.setGroupingUsed(false);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String toLog(String log) {
        return String.format("[%s] %s\n", DateTimeUtils.getTimeStamp(), log);
    }

    public static boolean isLessThan100(String str, int decimal) {
        if (StringUtils.isDouble(str, decimal)) {
            return StringUtils.parseDouble(str) <= 100.0;
        }
        return false;
    }

    public static boolean isLessThan10000M(String str, int decimal) {
        if (StringUtils.isDouble(str, decimal)) {
            return StringUtils.parseDouble(str) < 1.0E10;
        }
        return false;
    }

    public static boolean isMinusDouble(String str, int decimal) {
        if (StringUtils.isMinus(str, decimal)) {
            double value = StringUtils.parseDouble(str);
            return value >= -100.0 && value <= 100.0;
        }
        return false;
    }

    public static boolean isMinusDouble(String str, double maxValue, double minValue, int decimal) {
        if (StringUtils.isDecimal(str, decimal)) {
            double value = StringUtils.parseDouble(str);
            return value >= minValue && value <= maxValue;
        }
        return false;
    }

    public static boolean isDecimal(String str, int scale) {
        str = StringUtils.checkStr(str);
        return StringUtils.patternCheck("^[-]?(([1-9]{1}\\d*)|([0]{1}))+(\\.(\\d){0," + scale + "})?$", str);
    }

    public static boolean isMinus(String str, int scale) {
        str = StringUtils.checkStr(str);
        return StringUtils.patternCheck("^[-]?(([1-9]{1}\\d*)|([0]{1}))?(\\.(\\d){0," + scale + "})?$", str);
    }

    public static boolean isInt(String str) {
        str = StringUtils.checkStr(str);
        return StringUtils.patternCheck(INT, str);
    }

    public static boolean isDouble(String str) {
        str = StringUtils.checkStr(str);
        return StringUtils.patternCheck(DOUBLE, str);
    }

    public static boolean isMinusDouble(String str) {
        str = StringUtils.checkStr(str);
        return StringUtils.patternCheck(MINUS_DOUBLE, str);
    }

    public static boolean isMinusDouble1(String str, int decimal) {
        str = StringUtils.checkStr(str);
        return StringUtils.patternCheck("^[-]?(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0," + decimal + "})?$", str);
    }

    public static boolean isDouble(String str, int decimal) {
        str = StringUtils.checkStr(str);
        return StringUtils.patternCheck("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0," + decimal + "})?$", str);
    }

    public static boolean isNormal(String str, int scale) {
        return StringUtils.patternCheck("[A-Za-z0-9\u4e00-\u9fa5]*{0," + scale + "}", str);
    }

    public static boolean isText(String str, int scale) {
        return StringUtils.patternCheck("[A-Za-z0-9_\u4e00-\u9fa5\\-]*{0," + scale + "}", str);
    }

    public static boolean isNum(String str) {
        return StringUtils.patternCheck("^([1-9]{1}\\d*)$", str);
    }

    public static boolean isEmailSymbol(String str) {
        return StringUtils.patternCheck(EMAILESYMBOL, str);
    }

    public static boolean isCellphone(String str) {
        return StringUtils.patternCheck(CELLPHONE, str);
    }

    public static boolean isTelephone(String str) {
        return StringUtils.patternCheck(TELEPHONE, str);
    }

    public static boolean isNumeric(String str) {
        return StringUtils.patternCheck(NUMERIC, str);
    }

    public static boolean isNumeric(String str, int scale) {
        return StringUtils.patternCheck("[0-9]{0," + scale + "}", str);
    }

    public static boolean isPwdSymbol(String str) {
        return StringUtils.patternCheck(PWDSYMBOL, str);
    }

    public static boolean isPwd(String str) {
        return StringUtils.patternCheck(PWD, str);
    }

    public static boolean containsChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static String chineseToAscii(String string) {
        try {
            char[] chars = string.toCharArray();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < chars.length) {
                if (StringUtils.containsChinese(String.valueOf(chars[i]))) {
                    sb.append("u").append(Integer.toHexString(chars[i]));
                } else {
                    sb.append(chars[i]);
                }
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error("\u4e2d\u6587\u8f6cascii\u51fa\u9519", (Throwable)e);
            return "NA";
        }
    }

    public static boolean isPwd(String str, int scale) {
        return StringUtils.patternCheck("^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]{0," + scale + "}$", str);
    }

    public static Boolean isAccntPwd(String str) {
        return StringUtils.patternCheck(ACCNTPWD, str);
    }

    public static boolean isMac(String str) {
        return StringUtils.patternCheck(MAC, str);
    }

    public static boolean isIp(String str) {
        return StringUtils.patternCheck(IP, str);
    }

    public static boolean patternCheck(String strPattern, String string) {
        Pattern pattern = Pattern.compile(strPattern);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static int parseChar(char value) {
        if (Character.isDigit(value)) {
            return value - 48;
        }
        if (Character.isLowerCase(value)) {
            return 10 + (value - 97);
        }
        if (Character.isUpperCase(value)) {
            return 10 + (value - 65);
        }
        return -1;
    }

    public static int checkScale(int scale) {
        if (scale < 2 || scale > 3) {
            scale = 2;
        }
        return scale;
    }

    public static String toPriceStr(double value, double unit) {
        int scale = DecimalUtils.getScale(unit);
        String format = String.format("%%1$,.%df", scale);
        return String.format(format, value);
    }

    public static String toPriceStr(double value, int scale) {
        String format = String.format("%%1$,.%df", scale);
        return String.format(format, value);
    }

    public static String toStr(double value, int scale) {
        String format = String.format("%%1$,.%df", scale);
        return String.format(format, value);
    }

    public static String doubleToStringTwo(double value) {
        DecimalFormat format = new DecimalFormat("#.00");
        return format.format(value);
    }

    public static String toPriceStr(String text) {
        text = StringUtils.checkStr(text);
        return String.format(NUM_FORMATTER, StringUtils.parseDouble(text));
    }

    public static String toPriceStr(double value) {
        return String.format(NUM_FORMATTER, value);
    }

    public static int getScale(String unit) {
        if (StringUtils.isInt(unit) || !StringUtils.isDouble(unit)) {
            return 0;
        }
        return unit.substring(unit.indexOf(".") + 1).length();
    }

    public static int parseInt(String value) {
        if (value != null && !value.equals("")) {
            try {
                value = StringUtils.checkStr(value);
                BigDecimal bd = new BigDecimal(value);
                return bd.intValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static long parseLong(String value) {
        if (value != null && !value.equals("")) {
            try {
                value = StringUtils.checkStr(value);
                BigDecimal bd = new BigDecimal(value);
                return bd.longValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    public static long parseLongFloor(String value) {
        if (value != null && !value.equals("")) {
            try {
                value = StringUtils.checkStr(value);
                BigDecimal bd = new BigDecimal(value);
                bd.setScale(0, 3);
                return bd.longValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    public static double parseDouble(String value) {
        double d = 0.0;
        if (value != null && !value.equals("")) {
            value = StringUtils.checkStr(value);
            try {
                d = Double.valueOf(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return d;
    }

    public static double parseDouble(String value, int scale) {
        double d = 0.0;
        StringBuilder t = new StringBuilder(".");
        int i = 0;
        while (i < scale) {
            t = t.append("0");
            ++i;
        }
        DecimalFormat df = new DecimalFormat(t.toString());
        if (value != null && !value.equals("")) {
            try {
                value = StringUtils.checkStr(value);
                df.setRoundingMode(RoundingMode.DOWN);
                value = df.format(Double.parseDouble(value));
                d = Double.valueOf(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return d;
    }

    public static int parseDoubleAsInt(String value) {
        Double d = StringUtils.parseDouble(value);
        return d.intValue();
    }

    public static String numToChinese(int num) {
        switch (num) {
            case 1: {
                return "\u4e00";
            }
            case 2: {
                return "\u4e8c";
            }
            case 3: {
                return "\u4e09";
            }
            case 4: {
                return "\u56db";
            }
            case 5: {
                return "\u4e94";
            }
            case 6: {
                return "\u516d";
            }
            case 7: {
                return "\u4e03";
            }
            case 8: {
                return "\u516b";
            }
            case 9: {
                return "\u4e5d";
            }
            case 10: {
                return "\u5341";
            }
            case 11: {
                return "\u5341\u4e00";
            }
            case 12: {
                return "\u5341\u4e8c";
            }
            case 13: {
                return "\u5341\u4e09";
            }
            case 14: {
                return "\u5341\u56db";
            }
            case 15: {
                return "\u5341\u4e94";
            }
        }
        return String.valueOf(num);
    }

    public static String bigNumToString(int num) {
        String value = "";
        value = num < 10000 ? String.valueOf(num) : (num < 100000000 ? (num % 10000 > 0 ? String.format("%s\u4e07+", num / 10000) : String.format("%s\u4e07", num / 10000)) : (num % 100000000 > 0 ? String.format("%s\u4ebf+", num / 100000000) : String.format("%s\u4ebf", num / 100000000)));
        return value;
    }

    public static String bigDoubleNumToString(double num) {
        String value = "";
        if (num < 10000.0) {
            String format = String.format("%%1$,.%df", 2);
            value = String.format(format, num);
        } else {
            value = num < 1.0E8 ? (num % 10000.0 > 0.0 ? String.format("%s\u4e07+", (int)num / 10000) : String.format("%s\u4e07", (int)num / 10000)) : (num % 1.0E8 > 0.0 ? String.format("%s\u4ebf+", (int)(num / 1.0E8)) : String.format("%s\u4ebf", (int)(num / 1.0E8)));
        }
        return value;
    }

    public static double toPercent(String value, int scale) {
        double d = 0.0;
        if (value != null) {
            value = StringUtils.checkStr(value);
            BigDecimal b = new BigDecimal(value);
            d = b.setScale(scale, 1).multiply(new BigDecimal(100), new MathContext(scale)).doubleValue();
        }
        return d;
    }

    public static String toThousands(String value) {
        String str = StringUtils.checkStr(value);
        DecimalFormat df = new DecimalFormat(StringUtils.getFormatterStr(0));
        return df.format(new BigDecimal(str));
    }

    public static String toThousands(String value, int scale) {
        String str = StringUtils.checkStr(value);
        DecimalFormat df = new DecimalFormat(StringUtils.getFormatterStr(scale));
        return df.format(new BigDecimal(str));
    }

    public static String toThousands(Number num) {
        Number number = StringUtils.checkNum(num);
        DecimalFormat df = new DecimalFormat(StringUtils.getFormatterStr(0));
        return df.format(new BigDecimal(number.doubleValue()));
    }

    public static String toThousands(Number num, int scale) {
        Number number = StringUtils.checkNum(num);
        DecimalFormat df = new DecimalFormat(StringUtils.getFormatterStr(scale));
        return df.format(new BigDecimal(number.doubleValue()));
    }

    public static String toThousands(Number num, double unit) {
        int scale = DecimalUtils.getScale(unit);
        return StringUtils.toThousands(num, scale);
    }

    private static String checkStr(String value) {
        if (value != null && !value.equals("") && !"null".equals(value)) {
            return value.replaceAll(",", "");
        }
        return "0";
    }

    private static Number checkNum(Number num) {
        if (num == null) {
            return 0;
        }
        return num;
    }

    public static String toThousands(String value, double unit) {
        int scale = DecimalUtils.getScale(unit);
        return StringUtils.toThousands(value, scale);
    }

    private static String getFormatterStr(int scale) {
        switch (scale) {
            case 0: {
                return THOUSANDS_SCALE_ZERO;
            }
            case 1: {
                return ",##0.0";
            }
            case 2: {
                return ",##0.00";
            }
            case 3: {
                return ",##0.000";
            }
            case 4: {
                return ",##0.0000";
            }
        }
        if (scale < 0) {
            return THOUSANDS_SCALE_ZERO;
        }
        StringBuffer sb = new StringBuffer(THOUSANDS_SCALE_ZERO);
        sb.append(".");
        int i = 0;
        while (i < scale) {
            sb.append("0");
            ++i;
        }
        return sb.toString();
    }

    public static String getMagnitude(String value) {
        Double db = StringUtils.parseDouble(StringUtils.checkStr(value));
        return StringUtils.getMagnitude(db);
    }

    private static String getMagnitude(Double value) {
        if (value < 10000.0) {
            return "";
        }
        if (value >= 10000.0 && value < 100000.0) {
            return "\u4e07";
        }
        if (value >= 100000.0 && value < 1000000.0) {
            return "\u5341\u4e07";
        }
        if (value >= 1000000.0 && value < 1.0E7) {
            return "\u767e\u4e07";
        }
        if (value >= 1.0E7 && value < 1.0E8) {
            return "\u5343\u4e07";
        }
        if (value >= 1.0E8 && value < 1.0E9) {
            return "\u4ebf";
        }
        if (value >= 1.0E9 && value < 1.0E10) {
            return "\u5341\u4ebf";
        }
        if (value >= 1.0E10 && value < 1.0E11) {
            return "\u767e\u4ebf";
        }
        if (value >= 1.0E11 && value < 1.0E12) {
            return "\u5343\u4ebf";
        }
        if (value >= 1.0E12 && value < 1.0E13) {
            return "\u4e07\u4ebf";
        }
        return null;
    }

    public static boolean isLetters(String str) {
        return StringUtils.patternCheck(LETTERS, str);
    }

    public static boolean belongto(String str, String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (str.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isApama(String type) {
        return StringUtils.belongto(type, "5", "6", "7", "10", "11", "12", "13");
    }

    public static String replaceToken(String token) {
        if (token == null) {
            return "";
        }
        if (token.length() < 20) {
            return token;
        }
        StringBuilder sb = new StringBuilder(token);
        sb.replace(10, 19, "**********");
        return sb.toString();
    }

    public static String replaceCookie(String cookie) {
        if (cookie == null) {
            return "";
        }
        if (cookie.length() < 30) {
            return cookie;
        }
        StringBuilder sb = new StringBuilder(cookie);
        sb.replace(20, 29, "**********");
        return sb.toString();
    }

    public static String formatDouble(Double d) {
        return nf.format(d);
    }

    public static Double parseString(String s) {
        s = StringUtils.checkStr(s);
        try {
            return nf.parse(s).doubleValue();
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    public static String getClientVersion(String version) {
        switch (version) {
            case "test": {
                return "\u6d4b\u8bd5\u7248";
            }
            case "integ": {
                return "\u96c6\u6210\u7248";
            }
            case "exp": {
                return "\u4f53\u9a8c\u7248";
            }
            case "prod": {
                return "\u751f\u4ea7";
            }
        }
        return "";
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.letterToIp("aib.afh.d`.di"));
    }

    public static String ipToLetter(String ip) {
        if (ip == null) {
            return "";
        }
        char[] charArray = ip.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '.') {
                sb.append(c);
            } else {
                sb.append((char)(c + 48));
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String letterToIp(String ip) {
        if (ip == null) {
            return "";
        }
        char[] charArray = ip.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '.') {
                sb.append(c);
            } else {
                sb.append((char)(c - 48));
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String rightPad(String str, int size) {
        return StringUtils.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str.substring(0, size);
        }
        if (pads > 8192) {
            return StringUtils.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtils.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str.substring(0, size);
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        int i = 0;
        while (i < pads) {
            padding[i] = padChars[i % padLen];
            ++i;
        }
        return str.concat(new String(padding));
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        int i = repeat - 1;
        while (i >= 0) {
            buf[i] = ch;
            --i;
        }
        return new String(buf);
    }

    public static String join(Object[] array, String separator) {
        return org.apache.commons.lang.StringUtils.join((Object[])array, (String)separator);
    }
}

