/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PdfExportUtils {
    private static final Logger logger = LogManager.getLogger(PdfExportUtils.class);

    public static void exportPdf(InputStream templateStream, String newPdfPath, Map<String, String> dataMap) {
        try {
            BaseFont baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            FileOutputStream out = new FileOutputStream(newPdfPath);
            PdfReader reader = new PdfReader(templateStream);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)bos);
            AcroFields form = stamper.getAcroFields();
            form.addSubstitutionFont(baseFont);
            for (String name : form.getFields().keySet()) {
                form.setField(name, dataMap.get(name));
            }
            stamper.setFormFlattening(true);
            stamper.close();
            Document doc = new Document();
            PdfCopy copy = new PdfCopy(doc, (OutputStream)out);
            doc.open();
            PdfImportedPage importPage = copy.getImportedPage(new PdfReader(bos.toByteArray()), 1);
            copy.addPage(importPage);
            doc.close();
        }
        catch (Exception e) {
            logger.error("\u751f\u6210pdf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

