/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MarketUtils {
    private static final Map<String, String> MARKET_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("NEEQ", "\u65b0\u4e09\u677f");
            this.put("XSHG", "\u4e0a\u4ea4\u6240");
            this.put("XSHE", "\u6df1\u4ea4\u6240");
            this.put("CCFX", "\u4e2d\u91d1\u6240");
            this.put("XSGE", "\u4e0a\u671f\u6240");
            this.put("XDCE", "\u5927\u5546\u6240");
            this.put("XZCE", "\u90d1\u5546\u6240");
            this.put("XOTC", "\u573a\u5916");
            this.put("XCFE", "\u94f6\u884c\u95f4");
            this.put("XINE", "\u4e0a\u6d77\u56fd\u9645\u80fd\u6e90\u4ea4\u6613\u4e2d\u5fc3");
            this.put("SZSC", "\u6df1\u6e2f\u901a");
            this.put("SHSC", "\u6caa\u6e2f\u901a");
            this.put("XHKG", "\u6e2f\u4ea4\u6240");
            this.put("XNYS", "\u7ebd\u7ea6\u8bc1\u5238\u4ea4\u6613\u6240");
            this.put("XNAS", "\u7eb3\u65af\u8fbe\u514b\u4ea4\u6613\u6240");
            this.put("SGEX", "\u91d1\u4ea4\u6240");
        }
    };
    private static final Map<String, String> MARKET_CODE_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("CCFX", "a");
            this.put("XDCE", "b");
            this.put("XZCE", "c");
            this.put("XSGE", "d");
            this.put("XINE", "e");
        }
    };

    public static String getMarketGroup(String market) {
        String type = "";
        if (market.equals("XSHE") || market.equals("XSHG") || market.equals("NEEQ") || market.equals("SHSC") || market.equals("SZSC")) {
            type = "CCS";
        } else if (market.equals("XSGE") || market.equals("XDCE") || market.equals("XZCE") || market.equals("CCFX") || market.equals("XINE")) {
            type = "FUTURES";
        } else if (market.equals("SGEX")) {
            type = "GOLD";
        } else if (market.equals("XCFE")) {
            type = "IB";
        } else if (market.equals("XOTC") || market.contains("XHKG") || market.contains("XNYS") || market.contains("XNAS")) {
            type = "OTC";
        }
        return type;
    }

    public static String findMarketGrp(List<String> secExchange) {
        String type = new String();
        String exChange = secExchange.toString();
        if (exChange.contains("XSHE") || exChange.contains("XSHG") || exChange.contains("NEEQ") || exChange.equals("SHSC") || exChange.equals("SZSC")) {
            type = "CCS";
        } else if (exChange.contains("XSGE") || exChange.contains("XDCE") || exChange.contains("XZCE") || exChange.contains("CCFX") || exChange.equals("XINE")) {
            type = "FUTURES";
        } else if (exChange.equals("SGEX")) {
            type = "GOLD";
        } else if (exChange.contains("XCFE")) {
            type = "IB";
        } else if (exChange.contains("XOTC") || exChange.contains("XHKG") || exChange.contains("XNYS") || exChange.contains("XNAS")) {
            type = "OTC";
        }
        return type;
    }

    public static String findMarketGrp(String exChange) {
        String type = new String();
        if (exChange.contains("XSHE") || exChange.contains("XSHG") || exChange.contains("NEEQ") || exChange.equals("SHSC") || exChange.equals("SZSC")) {
            type = "CCS";
        } else if (exChange.contains("XSGE") || exChange.contains("XDCE") || exChange.contains("XZCE") || exChange.contains("CCFX") || exChange.equals("XINE")) {
            type = "FUTURES";
        } else if (exChange.equals("SGEX")) {
            type = "GOLD";
        } else if (exChange.contains("XCFE")) {
            type = "IB";
        } else if (exChange.contains("XOTC") || exChange.contains("XHKG") || exChange.contains("XNYS") || exChange.contains("XNAS")) {
            type = "OTC";
        }
        return type;
    }

    public static String getMarketNameById(String market) {
        return MARKET_MAP.get(market);
    }

    public static String getNeeqMarketPriceType(int tif, int maxLevels) {
        String marketType = "";
        if (66 == tif) {
            marketType = "SH1";
        } else if (51 == tif) {
            marketType = "SH2";
        } else if (48 == tif) {
            if (1 == maxLevels) {
                marketType = "SH3";
            } else if (maxLevels == 0) {
                marketType = "SH4";
            }
        }
        return marketType;
    }

    public static String getNormalMarketPriceType(int tif, int maxLevels, String market) {
        String marketType = "";
        if (Objects.equals("XSHE", market)) {
            if (48 == tif) {
                if (1 == maxLevels) {
                    marketType = "SZ1";
                } else if (maxLevels == 0) {
                    marketType = "SZ2";
                }
            } else if (51 == tif) {
                if (maxLevels == 0) {
                    marketType = "SZ3";
                } else if (5 == maxLevels) {
                    marketType = "SZ4";
                }
            } else if (52 == tif) {
                marketType = "SZ5";
            }
        } else if (Objects.equals("XSHG", market)) {
            if (48 == tif) {
                if (maxLevels == 0) {
                    marketType = "SH4";
                } else if (1 == maxLevels) {
                    marketType = "SH3";
                } else if (5 == maxLevels) {
                    marketType = "SH1";
                }
            } else if (51 == tif) {
                marketType = "SH2";
            }
        }
        return marketType;
    }

    public static String getMarketCodeById(String market) {
        return MARKET_CODE_MAP.get(market);
    }
}

