/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ListUtils {
    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        int i = 0;
        while (i < n) {
            List<T> value;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
            ++i;
        }
        return result;
    }

    public static <T> List<List<T>> split(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int pageSize = n;
        int size = (source.size() - 1) / pageSize + 1;
        int j = 0;
        while (j < size) {
            int fromIndex = j * pageSize;
            int toIndex = (j + 1) * pageSize > source.size() ? source.size() : (j + 1) * pageSize;
            System.err.println(String.valueOf(fromIndex) + "|" + toIndex);
            result.add(source.subList(fromIndex, toIndex));
            ++j;
        }
        return result;
    }

    public static <T> boolean checkDiffrent(List<T> list, List<T> list2) {
        list.sort(Comparator.comparing(Object::hashCode));
        list2.sort(Comparator.comparing(Object::hashCode));
        return list.toString().equals(list2.toString());
    }
}

