/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger logger = LogManager.getLogger(FileUtils.class);

    public static void writeObject(String fileName, Object obj) throws FileNotFoundException, IOException {
        ObjectOutputStream objOS = new ObjectOutputStream(new FileOutputStream(new File(fileName)));
        objOS.writeObject(obj);
        objOS.close();
    }

    public static Object readObject(String fileName) throws IOException, ClassNotFoundException {
        ObjectInputStream objIS = new ObjectInputStream(new FileInputStream(new File(fileName)));
        Object obj = objIS.readObject();
        objIS.close();
        return obj;
    }

    public static File getFile(String first, String ... more) {
        String savePath = Paths.get(first, more).toString();
        File file = new File(savePath);
        if (!file.exists()) {
            if (file.isDirectory()) {
                file.mkdirs();
            } else {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
        return file;
    }

    public static List<String> loadFile(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            logger.error("load file " + file.getName() + " failed", (Throwable)e);
        }
        return FileUtils.read(fis);
    }

    private static List<String> read(InputStream is) {
        LinkedList<String> list = new LinkedList<String>();
        BufferedReader br = null;
        try {
            try {
                InputStreamReader isr = new InputStreamReader(is);
                br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    list.add(line);
                }
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    logger.error((Object)e2, (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return list;
    }

    public static List<String> loadFile(Object obj, String src) {
        InputStream fis = obj.getClass().getClassLoader().getResourceAsStream(src);
        return FileUtils.read(fis);
    }

    public static String getFileExt(String path) {
        String[] split = FileUtils.getName(path).split("\\.");
        return split[split.length - 1];
    }

    public static String getFileMd5(File file) {
        StringBuilder sb;
        block15: {
            if (!file.isFile()) {
                throw new NumberFormatException("\u53c2\u6570\u9519\u8bef\uff01\u8bf7\u8f93\u5165\u6821\u51c6\u6587\u4ef6");
            }
            FileInputStream fis = null;
            byte[] rb = null;
            DigestInputStream digestInputStream = null;
            sb = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    MessageDigest md5 = MessageDigest.getInstance("md5");
                    digestInputStream = new DigestInputStream(fis, md5);
                    byte[] buffer = new byte[4096];
                    while (digestInputStream.read(buffer) > 0) {
                        md5 = digestInputStream.getMessageDigest();
                        rb = md5.digest();
                    }
                    sb = new StringBuilder();
                    int i = 0;
                    while (i < rb.length) {
                        String a = Integer.toHexString(0xFF & rb[i]);
                        if (a.length() < 2) {
                            a = String.valueOf('0') + a;
                        }
                        sb.append(a);
                        ++i;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        logger.error((Object)e2, (Throwable)e2);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String getName(String path) {
        return path.substring(path.lastIndexOf("\\") + 1);
    }

    public static void main(String[] args) {
        Map<String, String> map = new HashMap<String, String>();
        map.put("spike", new String("fang"));
        map.put("bingjie", new String("wang"));
        try {
            FileUtils.writeObject("D:\\test.rd", map);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Object obj = FileUtils.readObject("D:\\test.rd");
            map = (Map)obj;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

