/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.utils;

import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DecimalUtils {
    public static int getIntMax(int len) {
        if (len <= 0) {
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            sb.append("9");
            ++i;
        }
        return StringUtils.parseInt(sb.toString());
    }

    public static long getLongMax(int len) {
        if (len <= 0) {
            return 0L;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            sb.append("9");
            ++i;
        }
        return StringUtils.parseLong(sb.toString());
    }

    public static double getDoubleMax(int len) {
        return DecimalUtils.getLongMax(len);
    }

    public static boolean isDecimal(String str, boolean positive, int length, int scale) {
        String pattern = String.format("^%s(([1-9]{1}\\d{0,%d})|([0]{1})){1}(\\.(\\d){0,%d})?$", positive ? "" : "[-]?", length - 1, scale);
        return str.matches(pattern);
    }

    public static boolean isInt(String str, boolean positive, int length) {
        String pattern = String.format("^%s(([1-9]{1}\\d{0,%d})|([0]{1}))$", positive ? "" : "[-]?", length - 1);
        return str.matches(pattern);
    }

    public static boolean isIntIncludeZero(String str, boolean positive, int length) {
        String pattern = String.format("^%s(([0-9]{1}\\d{0,%d})|([0]{1}))$", positive ? "" : "[-]?", length - 1);
        return str.matches(pattern);
    }

    public static int getScale(double unit) {
        String str = BigDecimal.valueOf(unit).stripTrailingZeros().toString();
        return StringUtils.getScale(str);
    }

    public static double getUnit(int scale) {
        double ret = 1.0;
        int i = 0;
        while (i < scale) {
            ret /= 10.0;
            ++i;
        }
        return ret;
    }

    public static double getValueByScale(double value, int scale) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        return bd.setScale(scale, RoundingMode.DOWN).doubleValue();
    }

    public static double getValueByScale(double value, int scale, boolean buy) {
        BigDecimal bd = new BigDecimal(Double.toString(value));
        if (!buy) {
            return bd.setScale(scale, RoundingMode.UP).doubleValue();
        }
        return bd.setScale(scale, RoundingMode.DOWN).doubleValue();
    }

    public static void main(String[] args) {
        System.out.println(DecimalUtils.getValueByScale(1.126, 2));
    }
}

