/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.utils;

import cms.tmx.utils.StringUtils;
import cn.hutool.core.io.file.FileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class CommUtils {
    private static final Logger logger = LogManager.getLogger(CommUtils.class);
    private static final String IS_VIRTUAL = "IS_VIRTUAL";
    private static final String HD_MODEL = "HD_MODEL";
    private static final String HD_SERIALNUMBER = "HD_SERIALNUMBER";
    private static String ip;
    private static String mac;
    private static String sn;
    private static boolean bSNGot;
    private static final String ATTR_SN = "volume:vsn";
    private static Map<String, String> hdInfoMap;
    private static final String ESCAPECHAR = "@:;,|\\\\";
    private static String newVol;
    private static String cpuId;
    private static String pcName;
    private static String pi;
    private static String vol;
    private static String osv;
    private static Boolean isVirtual;

    static {
        try {
            String baseDir = String.valueOf(System.getProperty("user.dir")) + File.separator + "dll" + File.separator + "sigar-x86-winnt.dll";
            System.load(baseDir);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ip = "";
        mac = "";
        sn = "";
        bSNGot = false;
        newVol = "";
        cpuId = "";
        pcName = "";
        pi = "";
        vol = "";
        osv = "";
        isVirtual = null;
    }

    public static String getIP() {
        if (!ip.isEmpty()) {
            return ip;
        }
        try {
            InetAddress ia = InetAddress.getLocalHost();
            ip = ia.getHostAddress();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u672c\u5730ip\u5931\u8d25", (Throwable)e);
        }
        ip = CommUtils.toEscapeAndtruncate(ip, 15);
        if (StringUtils.isEmpty(ip)) {
            ip = "NA";
        }
        return ip;
    }

    public static String getMAC() {
        if (!mac.isEmpty()) {
            return mac;
        }
        try {
            InetAddress ia = InetAddress.getLocalHost();
            byte[] byteMAC = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < byteMAC.length) {
                String value = Integer.toHexString(byteMAC[i] & 0xFF);
                if (value.length() == 1) {
                    sb.append(0);
                    sb.append(value);
                } else {
                    sb.append(value);
                }
                ++i;
            }
            mac = sb.toString().toUpperCase();
            mac = CommUtils.toEscapeAndtruncate(mac, 18);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6mac\u5931\u8d25", (Throwable)e);
        }
        if (StringUtils.isEmpty(mac)) {
            mac = "NA";
        }
        return mac;
    }

    public static String getSerialNumber() {
        long begin;
        block13: {
            if (bSNGot) {
                return sn;
            }
            begin = System.currentTimeMillis();
            String hdNumberFromC = CommUtils.getHdNumberFromC();
            if (hdNumberFromC != null && !StringUtils.isEmpty(hdNumberFromC.trim())) {
                bSNGot = true;
                sn = CommUtils.toEscapeAndtruncate(hdNumberFromC.trim(), 32);
                return sn;
            }
            Scanner sc = null;
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"wmic", "diskdrive", "get", "serialnumber"});
                process.getOutputStream().close();
                sc = new Scanner(process.getInputStream());
                sc.next();
                String serial = sc.next();
                if (StringUtils.isEmpty(serial)) break block13;
                if (StringUtils.isNum(serial)) {
                    try {
                        serial = new BigDecimal(serial).toBigInteger().toString(16).toUpperCase();
                    }
                    catch (Exception exception) {}
                }
                sn = CommUtils.toEscapeAndtruncate(serial, 32);
                bSNGot = true;
                return sn;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u901a\u8fc7wmic\u83b7\u53d6\u786c\u76d8id\u5931\u8d25", (Throwable)e);
            }
        }
        for (FileStore store : FileSystems.getDefault().getFileStores()) {
            try {
                String storeSN = store.getAttribute(ATTR_SN).toString();
                if (storeSN.isEmpty()) continue;
                try {
                    long num = Long.parseLong(storeSN);
                    sn = Long.toString(num > 0L ? num : 0L - num, 16).toUpperCase();
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u786c\u76d8\u5e8f\u5217\u53f7\u5931\u8d25", (Throwable)e);
                }
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u786c\u76d8\u5e8f\u5217\u53f7\u5931\u8d25", (Throwable)e);
            }
        }
        bSNGot = true;
        if (StringUtils.isEmpty(sn)) {
            sn = "NA";
        }
        logger.info("\u83b7\u53d6\u786c\u76d8\u5e8f\u5217\u53f7:" + sn + "takes:" + (System.currentTimeMillis() - begin));
        return sn;
    }

    private static synchronized Map<String, String> getHDInfoFromC() {
        if (hdInfoMap != null) {
            return hdInfoMap;
        }
        hdInfoMap = new HashMap<String, String>();
        try {
            File oldFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + ".hdsn.output");
            if (oldFile.exists()) {
                oldFile.delete();
            }
            Process exec = Runtime.getRuntime().exec(String.valueOf(System.getProperty("user.dir")) + File.separator + "dll" + File.separator + "diskid.exe");
            exec.waitFor(3L, TimeUnit.SECONDS);
            File file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + ".hdsn.output");
            List lines = new FileReader(file).readLines();
            if (lines.isEmpty()) {
                hdInfoMap.put(HD_SERIALNUMBER, "");
                hdInfoMap.put(IS_VIRTUAL, "false");
                hdInfoMap.put(HD_MODEL, "");
                return hdInfoMap;
            }
            hdInfoMap.put(HD_SERIALNUMBER, (String)lines.get(0));
            if (lines.size() >= 2) {
                hdInfoMap.put(HD_MODEL, (String)lines.get(1));
                hdInfoMap.put(IS_VIRTUAL, CommUtils.isVirtualHd((String)lines.get(1)));
            }
            return hdInfoMap;
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7diskId\u7a0b\u5e8f\u83b7\u53d6\u786c\u76d8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return hdInfoMap;
        }
    }

    private static String isVirtualHd(String hdModel) {
        if ((hdModel = hdModel.toUpperCase()).contains("VBOX") || hdModel.contains("VIRT") || hdModel.contains("VMWARE") || hdModel.contains("QEMU") || hdModel.contains("XEN")) {
            return "true";
        }
        return "false";
    }

    public static void main(String[] args) {
        System.err.println("\\@");
        String str = StringUtils.chineseToAscii("\u7684\\\u5c0f@\u8111");
        System.out.println(StringUtils.chineseToAscii("\\@"));
        System.out.println(CommUtils.toEscapeAndtruncate(str, 15));
        System.out.println(CommUtils.getVOL());
        System.out.println(CommUtils.getPI());
        System.out.println(CommUtils.getVolNew());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVolNew() {
        if (!newVol.isEmpty()) {
            return newVol;
        }
        String ss = "";
        String userHome = System.getProperty("user.home");
        if (!userHome.isEmpty() && userHome.contains(":")) {
            ss = String.valueOf(userHome.split(":")[0]) + ":";
        }
        StringBuilder sb = new StringBuilder("");
        block2: for (FileStore store : FileSystems.getDefault().getFileStores()) {
            try {
                String storeSN;
                if (!store.toString().contains(ss) || (storeSN = store.getAttribute(ATTR_SN).toString()).isEmpty()) continue;
                long num = Long.parseLong(storeSN);
                sb = new StringBuilder("");
                sb.append(Long.toString(num > 0L ? num : 0L - num, 16).toUpperCase());
                if (sb.length() == 0) continue;
                while (true) {
                    if (sb.length() >= 8) {
                        if (sb.length() >= 4) {
                            sb.insert(4, "-");
                        }
                        newVol = CommUtils.toEscapeAndtruncate(sb.toString(), 10);
                        continue block2;
                    }
                    sb.insert(0, "0");
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u786c\u76d8\u5e8f\u5217\u53f7\u5931\u8d25", (Throwable)e);
            }
        }
        if (StringUtils.isEmpty(newVol)) {
            newVol = CommUtils.toEscapeAndtruncate(CommUtils.getVOL(), 10);
        }
        if (StringUtils.isEmpty(newVol)) {
            newVol = "NA";
        }
        return newVol;
    }

    private static String toEscapeAndtruncate(String string, int length) {
        block10: {
            if (!StringUtils.isEmpty(string)) break block10;
            return "NA";
        }
        try {
            char[] chars = string.toCharArray();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < chars.length) {
                if (ESCAPECHAR.contains(String.valueOf(chars[i]))) {
                    sb.append("\\").append(chars[i]);
                } else {
                    sb.append(chars[i]);
                }
                ++i;
            }
            String str = sb.toString();
            if (str.length() <= length) {
                return str;
            }
            str = str.substring(str.length() - length);
            if (str.startsWith("\\\\") || str.startsWith("\\@") || str.startsWith("\\:") || str.startsWith("\\;") || str.startsWith("\\,") || str.startsWith("\\|")) {
                return str;
            }
            if (ESCAPECHAR.contains(String.valueOf(str.charAt(0)))) {
                str = str.substring(1);
            }
            if (ESCAPECHAR.contains(String.valueOf(str.charAt(0)))) {
                str = str.substring(1);
            }
            return str;
        }
        catch (Exception e) {
            logger.error("\u8f6c\u4e49\u51fa\u9519" + string, (Throwable)e);
            return "NA";
        }
    }

    public static synchronized String getCPUSerial() {
        if (!cpuId.isEmpty()) {
            return cpuId;
        }
        Scanner sc = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "ProcessorId"});
            process.getOutputStream().close();
            sc = new Scanner(process.getInputStream());
            sc.next();
            String serial = sc.next();
            if (!StringUtils.isEmpty(serial)) {
                cpuId = CommUtils.toEscapeAndtruncate(serial, 20);
                return cpuId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u901a\u8fc7wmic\u83b7\u53d6cpuId\u5931\u8d25", (Throwable)e);
        }
        String result = "";
        logger.info("\u901a\u8fc7vbs\u83b7\u53d6cpuId\u5f00\u59cb");
        try {
            String line;
            File file = File.createTempFile("tmp", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "On Error Resume Next \r\n strComputer = \".\"  \r\nSet objWMIService = GetObject(\"winmgmts:\" _ \r\n& \"{impersonationLevel=impersonate}!\\\\\" & strComputer & \"\\root\\cimv2\") \r\nSet colItems = objWMIService.ExecQuery(\"Select * from Win32_Processor\")  \r\n For Each objItem in colItems \r\n Wscript.Echo objItem.ProcessorId  \r\n exit for  ' do the first cpu only! \r\n Next";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            logger.info("\u901a\u8fc7vb\u83b7\u53d6cpuId\u7ed3\u679c" + line);
            input.close();
            file.delete();
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7vbs\u83b7\u53d6cpuId\u5931\u8d25", (Throwable)e);
        }
        cpuId = result != null && !result.toUpperCase().contains("NULL") && result.trim().length() > 1 ? CommUtils.toEscapeAndtruncate(result.trim(), 20) : "NA";
        return cpuId;
    }

    public static String getPCName() {
        if (!pcName.isEmpty()) {
            return pcName;
        }
        try {
            InetAddress ia = InetAddress.getLocalHost();
            String pcN = StringUtils.chineseToAscii(ia.getHostName().toString());
            pcName = CommUtils.toEscapeAndtruncate(pcN, 20);
            return pcName;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u672c\u673a\u540d\u79f0\u5931\u8d25", (Throwable)e);
            return "NA";
        }
    }

    public static String getPI() {
        if (!pi.isEmpty()) {
            return pi;
        }
        try {
            StringBuilder sb = new StringBuilder();
            Sigar sigar = new Sigar();
            FileSystem[] fslist = sigar.getFileSystemList();
            int i = 0;
            while (i < fslist.length) {
                block18: {
                    FileSystem fs = fslist[i];
                    if (fs.getDirName().contains(":")) {
                        sb.append(fs.getDirName().split(":")[0]);
                    } else {
                        sb.append(fs.getDirName());
                    }
                    sb.append("^");
                    sb.append(fs.getSysTypeName());
                    sb.append("^");
                    FileSystemUsage usage = null;
                    try {
                        usage = sigar.getFileSystemUsage(fs.getDirName());
                    }
                    catch (SigarException e) {
                        logger.error("\u83b7\u53d6\u78c1\u76d8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                        break block18;
                    }
                    switch (fs.getType()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            sb.append(String.valueOf(usage.getTotal() / 0x100000L) + "G");
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            break;
                        }
                    }
                    if (!StringUtils.isEmpty(sb.toString())) break;
                }
                ++i;
            }
            if (sb.length() > 1) {
                pi = sb.toString();
                pi = CommUtils.toEscapeAndtruncate(pi, 20);
            }
        }
        catch (Throwable e) {
            logger.error("\u83b7\u53d6\u786c\u76d8\u5206\u533a\u4fe1\u606f\u5931\u8d25", e);
        }
        if (StringUtils.isEmpty(pi)) {
            pi = "NA";
        }
        return pi;
    }

    private static String getVol(String dir) {
        String cmdStr = "cmd /c vol " + dir;
        String volStr = "";
        try {
            String strTemp;
            InputStream in = Runtime.getRuntime().exec(cmdStr).getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, "GBK"));
            while ((strTemp = bufferedReader.readLine()) != null) {
                volStr = String.valueOf(volStr) + strTemp;
            }
            if (volStr.contains("\u9a71\u52a8\u5668")) {
                volStr = volStr.substring(volStr.indexOf("\u5e8f\u5217\u53f7\u662f") + 4, volStr.length());
            } else if (volStr.contains("Volume in drive")) {
                volStr = volStr.substring(volStr.indexOf("is") + 3, volStr.length());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return dir;
        }
        if (volStr != null) {
            volStr = volStr.replaceAll(" ", "");
        }
        if (StringUtils.isEmpty(volStr)) {
            volStr = "NA";
        }
        return volStr;
    }

    public static String getVOL() {
        if (!vol.isEmpty()) {
            return vol;
        }
        String userHome = System.getProperty("user.home");
        if (!userHome.isEmpty() && userHome.contains(":")) {
            vol = userHome.split(":")[0];
        }
        vol = CommUtils.getVol(String.valueOf(vol) + ":");
        return vol;
    }

    public static String getOSV() {
        if (!osv.isEmpty()) {
            return osv;
        }
        osv = System.getProperty("os.name");
        if (StringUtils.isEmpty(osv)) {
            osv = "NA";
        }
        return osv;
    }

    public static String getHdNumberFromC() {
        Map<String, String> hdInfoFromC = CommUtils.getHDInfoFromC();
        return hdInfoFromC.get(HD_SERIALNUMBER);
    }

    public static boolean isVirtual() {
        if (isVirtual != null) {
            return isVirtual;
        }
        Map<String, String> hdInfoFromC = CommUtils.getHDInfoFromC();
        isVirtual = "true".equals(hdInfoFromC.get(IS_VIRTUAL)) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return isVirtual;
    }

    public static String newMac() {
        String lastMac = "";
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                byte[] bytes;
                StringBuffer stringBuffer = new StringBuffer();
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface == null || (bytes = networkInterface.getHardwareAddress()) == null || networkInterface.getDisplayName() == null) continue;
                int i = 0;
                while (i < bytes.length) {
                    int tmp = bytes[i] & 0xFF;
                    String str = Integer.toHexString(tmp);
                    if (str.length() == 1) {
                        stringBuffer.append("0" + str);
                    } else {
                        stringBuffer.append(str);
                    }
                    ++i;
                }
                lastMac = stringBuffer.toString().toUpperCase();
                if (networkInterface.getDisplayName() != null && (networkInterface.getDisplayName().toUpperCase().contains("VPN") || networkInterface.getDisplayName().toUpperCase().contains("VMWARE") || networkInterface.getDisplayName().toUpperCase().contains("VIRTUALBOX") || lastMac.length() != 12 || networkInterface.isVirtual())) continue;
                return lastMac;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lastMac;
    }
}

