/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XswapHedgeTaskModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.XswapHedgeTask;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class XswapHedgeTaskPart
extends MxPart {
    @FXML
    private TableView<XswapHedgeTask> tableHedge;
    @FXML
    private TableColumn<XswapHedgeTask, String> taskId;
    @FXML
    private TableColumn<XswapHedgeTask, String> strategyName;
    @FXML
    private TableColumn<XswapHedgeTask, MxNode> hedgeStatus;
    @FXML
    private TableColumn<XswapHedgeTask, String> code;
    @FXML
    private TableColumn<XswapHedgeTask, Number> execQty;
    @FXML
    private TableColumn<XswapHedgeTask, Number> execPrice;
    @FXML
    private TableColumn<XswapHedgeTask, String> hedgeCode1;
    @FXML
    private TableColumn<XswapHedgeTask, MxNode> hedgeOrdSide1;
    @FXML
    private TableColumn<XswapHedgeTask, Number> hedgePrice1;
    @FXML
    private TableColumn<XswapHedgeTask, String> hedgeCode2;
    @FXML
    private TableColumn<XswapHedgeTask, MxNode> hedgeOrdSide2;
    @FXML
    private TableColumn<XswapHedgeTask, Number> hedgePrice2;
    @Inject
    private XswapHedgeTaskModel model;
    @FXML
    private CheckBox onlyUnfinished;
    @FXML
    private TextField searchText;
    @Inject
    private MxAlert alert;
    MxList<XswapHedgeTask> mlist = new MxList();
    private Predicate<XswapHedgeTask> pd = t -> {
        String txt;
        String status = t.getHedgeStatus().getRaw();
        if (this.onlyUnfinished.isSelected() && StringUtils.belongto((String)status, (String[])new String[]{"2", "3"})) {
            return false;
        }
        String name = t.getStrategyName().toUpperCase();
        return name.contains(txt = this.searchText.getText().toUpperCase());
    };
    @Inject
    private MScheduler scheduler;
    private InvalidationListener lstnSearch = ob -> this.scheduler.schedule(event -> {
        ArrayList<XswapHedgeTask> newList = new ArrayList<XswapHedgeTask>();
        List<XswapHedgeTask> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.filter(newList, this.pd);
            this.tableHedge.refresh();
        });
    });
    private InvalidationListener lstnModel = ob -> {
        ArrayList<XswapHedgeTask> newList = new ArrayList<XswapHedgeTask>();
        List<XswapHedgeTask> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.update(newList, this.pd);
            this.tableHedge.refresh();
        });
    };

    @FXML
    public void initialize() {
        this.createTable();
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.onlyUnfinished.selectedProperty().addListener(this.lstnSearch);
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.onlyUnfinished.selectedProperty().addListener(this.lstnSearch);
    }

    protected void createTable() {
        this.taskId.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).taskIdProperty());
        this.strategyName.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).strategyNameProperty());
        this.hedgeStatus.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).hedgeStatusProperty());
        this.code.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).codeProperty());
        this.execQty.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).execQtyProperty());
        this.execPrice.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).execPriceProperty());
        this.execPrice.setCellFactory(data -> new DoubleTableCell(3));
        this.hedgeCode1.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).hedgeCode1Property());
        this.hedgeOrdSide1.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).hedgeOrdSide1Property());
        this.hedgeOrdSide1.setCellFactory(cell -> new SideCell());
        this.hedgePrice1.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).hedgePrice1Property());
        this.hedgePrice1.setCellFactory(data -> new DoubleTableCell(4));
        this.hedgeCode2.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).hedgeCode2Property());
        this.hedgeOrdSide2.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).hedgeOrdSide2Property());
        this.hedgeOrdSide2.setCellFactory(cell -> new SideCell());
        this.hedgePrice2.setCellValueFactory(data -> ((XswapHedgeTask)data.getValue()).hedgePrice2Property());
        this.hedgePrice2.setCellFactory(data -> new DoubleTableCell(4));
        this.tableHedge.setPlaceholder((Node)new Label());
        this.tableHedge.setItems(this.mlist.getList());
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeOneOrTwoHeadExcel(this.tableHedge, (String)"\u5bf9\u51b2\u4efb\u52a1\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithTwoHead(this.tableHedge, (int)0, (int)0);
    }
}

