/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XswapBondForwardOrderModel;
import cms.tmx.bond.views.StdBondForwardDealPart;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObSingleOrderXswapBond;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XswapBondForwardUnfinishedOrderPart
extends MxPagePart<Order, ObSingleOrderXswapBond> {
    private final Logger logger = LogManager.getLogger(StdBondForwardDealPart.class);
    @FXML
    protected TableView<ObSingleOrderXswapBond> tableView;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, Boolean> selected;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> source;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> sourceId;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, MxNode> ordType;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> securityId;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, MxNode> side;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, Number> leavesQty;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, Number> orderQty;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, Number> price;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> ocFlag;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> ordTime;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> effTime;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> orderId;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> traderId;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> userName;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, String> errInfo;
    @FXML
    private TableColumn<ObSingleOrderXswapBond, MxNode> ordStatus;
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @FXML
    protected CheckBox checkBox;
    @Inject
    private XswapBondForwardOrderModel model;
    @Inject
    private MxAlert alert;

    protected List<Order> getList() {
        return this.model.getOrdList().getList();
    }

    @FXML
    protected void initialize() {
        super.initialize();
        this.searchTextStrategy.textProperty().addListener(this.listenerSearch);
        this.searchTextTrader.textProperty().addListener(this.listenerSearch);
        this.createTableView();
        this.model.setUnfinishedOrder(true);
        this.initValue();
        this.refresh();
    }

    @PreDestroy
    protected void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchTextStrategy.textProperty().removeListener(this.listenerSearch);
        this.searchTextTrader.textProperty().removeListener(this.listenerSearch);
    }

    private void initValue() {
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getPageList();
            synchronized (observableList) {
                this.mxList.getPageList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
    }

    @FXML
    protected void refresh() {
        this.model.query();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.side.setCellFactory(cell -> new SideCell());
        this.leavesQty.setCellFactory(cell -> new CountCell());
        this.orderQty.setCellFactory(cell -> new CountCell());
        this.price.setCellFactory(p -> new ObPriceCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    @FXML
    private void orderCancel() {
        FilteredList order = this.mxList.getPageList().filtered(data -> data.isSelected());
        if (order == null || order.isEmpty()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u8ba2\u5355\uff01");
            return;
        }
        boolean orderCancel = true;
        try {
            if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u5171\u64a4" + order.size() + "\u7b14\u59d4\u6258")) {
                return;
            }
            for (ObSingleOrderXswapBond obBond : order) {
                if (!obBond.isSelected()) continue;
                boolean bl = orderCancel = this.model.orderCancel(obBond) && orderCancel;
            }
        }
        catch (MException e) {
            this.logger.error((Object)e);
            this.alert.alert(Alert.AlertType.WARNING, "\u64a4\u5355\u5931\u8d25\uff1a" + (Object)((Object)e));
        }
        if (orderCancel) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u6210\u529f");
        } else {
            this.alert.alert(Alert.AlertType.WARNING, "\u64a4\u5355\u5931\u8d25");
        }
    }

    @FXML
    private void allOrderCancel() {
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableView);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableView, (List)this.mxList.getList(), (String)"\u672a\u5b8c\u6210\u8ba2\u5355\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected boolean predicate(Order data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String orderId = data.getOrderId();
        if (!SingleOrder.CAN_CANCEL_STATUS.contains(data.getOrdStatus().getValue())) {
            return false;
        }
        boolean bTxt = code.contains(text) || orderId.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        String sourceId = "";
        if (data.getExecMode() != null) {
            sourceId = String.valueOf(data.getExecMode().getEmId()).toUpperCase();
        }
        String source = data.getSource().trim().toUpperCase();
        boolean bStrategy = sourceId.contains(txtStrategy) || source.contains(txtStrategy);
        String txtTrader = this.searchTextTrader.getText().trim().toUpperCase();
        String traderId = data.getTraderId().toUpperCase();
        boolean bTrader = traderId.contains(txtTrader);
        return bTxt && bStrategy && bTrader;
    }

    public void defaultSort() {
        this.mxList.getPageList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
    }

    public class CountCell<T>
    extends TableCell<T, Number> {
        private Label label = new Label();

        public void updateItem(Number value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                int i = (int)value.longValue();
                this.label.setText(StringUtils.toStr((double)i, (int)0));
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                XswapBondForwardUnfinishedOrderPart.this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }

    public class IdCell<T>
    extends TableCell<T, Number> {
        private Label label = new Label();

        public void updateItem(Number value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                if (value.longValue() == 0L) {
                    this.label.setText("");
                } else {
                    this.label.setText(StringUtils.toStr((double)((Double)value), (int)0));
                }
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                XswapBondForwardUnfinishedOrderPart.this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected class ObPriceCell
    extends DoubleTableCell<ObSingleOrderXswapBond> {
        protected ObPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)3));
            }
        }
    }
}

