/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.bond.SecFormatter;
import cms.tmx.bond.models.XswapBondForwardOrderModel;
import cms.tmx.bond.models.XswapBondForwardTradeModel;
import cms.tmx.bond.models.XswapDealMarketModel;
import cms.tmx.bond.views.StdSecSuggest;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.Formatter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.entity.data.XBondDealMarketItem;
import cms.tmx.entity.trade.ObSingleOrderXswapBond;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.trade.models.UserPreCtrl;
import cms.tmx.trade.views.StdBondEntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XswapBondForwardTradePart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(XswapBondForwardTradePart.class);
    @FXML
    private TableView<HandicapInfo> tableMktSell;
    @FXML
    private TableView<HandicapInfo> tableMktBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellYield;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyYield;
    @FXML
    private TableColumn<HandicapInfo, String> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, String> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, String> colSelfSellCount;
    @FXML
    private TableColumn<HandicapInfo, String> colSelfBuyCount;
    @FXML
    private TableView<XBondDealMarketItem> tableDealMarket;
    @FXML
    private TableColumn<XBondDealMarketItem, String> code;
    @FXML
    private TableColumn<XBondDealMarketItem, Number> nowPrice;
    @FXML
    private TableColumn<XBondDealMarketItem, Number> nowCount;
    @FXML
    private TableColumn<XBondDealMarketItem, Number> offset;
    @FXML
    private TableColumn<XBondDealMarketItem, Number> openPrice;
    @FXML
    private TableColumn<XBondDealMarketItem, Number> highYield;
    @FXML
    private TableColumn<XBondDealMarketItem, Number> lowYield;
    @FXML
    private TableColumn<XBondDealMarketItem, Number> volume;
    @FXML
    private TableColumn<XBondDealMarketItem, Number> yestd;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private TextField txtTime;
    @FXML
    private Button btnOrd;
    @FXML
    private Spinner<Double> priceSpn;
    @FXML
    private Spinner<Integer> countSpn;
    @FXML
    private ComboBox<MxNode> cmbOcFlag;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private RadioButton sellRadio;
    @FXML
    private RadioButton buyRadio;
    @FXML
    private Label lbEndErr;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    private MarketDataModel marketDataModel;
    @Inject
    private XswapBondForwardOrderModel unfinishedModel;
    @Inject
    protected UserPreCtrl preModel;
    @Inject
    protected DialogFactory df;
    @Inject
    private XswapBondForwardTradeModel model;
    @Inject
    protected MxAlert alert;
    @Inject
    protected IRefDataMng ref;
    @Inject
    protected MEventService es;
    @Inject
    protected MObjFactory of;
    MxList<XBondDealMarketItem> mlist = new MxList();
    @Inject
    private XswapDealMarketModel dmModel;
    @Inject
    private MScheduler scheduler;
    @Inject
    private IBaseApi baseApi;
    private AutoCompletion<RefItem> auto;
    private MarketItem mktItem;
    private StdSecSuggest suggest = new StdSecSuggest();
    private Collection<RefItem> codeList = new ArrayList<RefItem>();
    private DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 1);
    private InvalidationListener listenerMktItem = ob -> this.onMarketChange();
    private InvalidationListener listenerUnfinishChange = ob -> this.resetMarketOrder();
    private Collection<RefItem> refs = null;
    private List<HandicapInfo> listBuyHandicap = new ArrayList<HandicapInfo>();
    private List<HandicapInfo> listSellHandicap = new ArrayList<HandicapInfo>();
    private Predicate<XBondDealMarketItem> pd = t -> true;
    private InvalidationListener lstnModel = ob -> {
        ArrayList<XBondDealMarketItem> newList = new ArrayList<XBondDealMarketItem>();
        List<XBondDealMarketItem> list = this.dmModel.getList();
        synchronized (list) {
            newList.addAll(this.dmModel.getList());
        }
        this.mlist.updatePart(newList);
        Platform.runLater(() -> this.tableDealMarket.refresh());
    };
    private InvalidationListener lstnTxtcode = ob -> {
        XBondDealMarketItem selectedItems = (XBondDealMarketItem)this.tableDealMarket.getSelectionModel().getSelectedItem();
        this.txtCode.setText(selectedItems.getCode());
        for (RefItem ref : this.refs) {
            if (!ref.getCode().equals(this.txtCode.getText())) continue;
            this.txtCode.setUserData((Object)ref);
            break;
        }
        this.priceSpn.getEditor().clear();
        this.countSpn.getEditor().clear();
        this.auto.setChange(selectedItems.getCode());
    };
    private List<ObSingleOrderXswapBond> orders = new ArrayList<ObSingleOrderXswapBond>();

    @FXML
    private void initialize() {
        this.unfinishedModel.setUnfinishedOrder(true);
        this.unfinishedModel.query();
        this.mktItem = this.marketDataModel.createItem(5);
        this.initControls();
        this.keyEvent();
        this.listenerUnfinishChange.invalidated(null);
        this.dmModel.changed();
    }

    @PreDestroy
    public void close() {
        this.dmModel.changedProperty().removeListener(this.lstnModel);
        this.mktItem.changedProperty().removeListener(this.listenerMktItem);
        this.unfinishedModel.changedProperty().removeListener(this.listenerUnfinishChange);
    }

    private void onMarketChange() {
        this.exe.execute(() -> {
            long start = System.currentTimeMillis();
            if (this.model.isSame(this.listSellHandicap, (List<HandicapInfo>)this.mktItem.getListSellHandicap()) && this.model.isSame(this.listBuyHandicap, (List<HandicapInfo>)this.mktItem.getListBuyHandicap())) {
                logger.error("\u4e0b\u8fbe\u59d4\u6258\uff0c\u884c\u60c5\u76f8\u540c\uff0c\u4e0d\u5237\u65b0\uff01");
            } else {
                logger.error("\u4e0b\u8fbe\u59d4\u6258\uff0c\u884c\u60c5\u4e0d\u76f8\u540c\uff0c\u5237\u65b0\uff01");
                this.resetMarketOrder();
                if (this.model.isBidAskPrice()) {
                    double price = this.model.getHandicapPrice();
                    Platform.runLater(() -> this.model.setPrice(price));
                }
            }
            this.update();
            logger.error("\u884c\u60c5\u53d8\u5316\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        });
    }

    private void update() {
        this.model.updateHandicapInfo(this.listBuyHandicap, (List<HandicapInfo>)this.mktItem.getListBuyHandicap());
        this.model.updateHandicapInfo(this.listSellHandicap, (List<HandicapInfo>)this.mktItem.getListSellHandicap());
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener(this.listenerMktItem);
        this.unfinishedModel.changedProperty().addListener(this.listenerUnfinishChange);
        if (this.unfinishedModel.getObList().num == 0) {
            this.exe.execute(() -> {
                this.unfinishedModel.setUnfinishedOrder(true);
                this.unfinishedModel.query();
            });
        }
    }

    private void initControls() {
        this.initSecurity();
        this.createTableview();
        this.createDealTableview();
        this.txtCode.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
        this.initTime();
        this.initSpn();
        this.initCmb();
        this.initDealMarket();
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)old, (Boolean)now));
        this.buyRadio.selectedProperty().bindBidirectional((Property)this.model.buyProperty());
        this.initListenerUnfinish();
        int i = 0;
        while (i < 5) {
            HandicapInfo infoBuy = new HandicapInfo();
            HandicapInfo infoSell = new HandicapInfo();
            infoBuy.setIndex(i + 1);
            infoSell.setIndex(i + 1);
            this.listBuyHandicap.add(infoBuy);
            this.listSellHandicap.add(infoSell);
            ++i;
        }
    }

    private void initDealMarket() {
        this.dmModel.changedProperty().addListener(this.lstnModel);
        this.dmModel.subscribe("*");
        this.tableDealMarket.getSelectionModel().selectedItemProperty().addListener(this.lstnTxtcode);
    }

    private void createDealTableview() {
        TableUtils.initValueFactory(this.tableDealMarket);
        this.code.setCellValueFactory(cell -> ((XBondDealMarketItem)cell.getValue()).codeProperty());
        this.nowPrice.setCellValueFactory(cell -> ((XBondDealMarketItem)cell.getValue()).nowPriceProperty());
        this.nowCount.setCellValueFactory(cell -> ((XBondDealMarketItem)cell.getValue()).nowYieldProperty());
        this.offset.setCellValueFactory(cell -> ((XBondDealMarketItem)cell.getValue()).offsetProperty());
        this.openPrice.setCellValueFactory(cell -> ((XBondDealMarketItem)cell.getValue()).openPriceProperty());
        this.highYield.setCellValueFactory(cell -> ((XBondDealMarketItem)cell.getValue()).highYieldProperty());
        this.lowYield.setCellValueFactory(cell -> ((XBondDealMarketItem)cell.getValue()).lowYieldProperty());
        this.volume.setCellValueFactory(cell -> ((XBondDealMarketItem)cell.getValue()).volumeProperty());
        this.tableDealMarket.setPlaceholder((Node)new Label());
        this.tableDealMarket.setItems(this.mlist.getList());
    }

    private void initTime() {
        this.txtTime.textProperty().bindBidirectional((Property)this.model.timeProperty());
        this.txtTime.setText("19:00");
        this.txtTime.setTextFormatter((TextFormatter)new Formatter("^[0-9:\uff1a]{0,5}$", 5));
        this.txtTime.setStyle("red");
        this.txtTime.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                String txt = this.txtTime.getText();
                if (!StringUtils.patternCheck((String)"^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3])):(([0-9]{0,1})|([0-5][0-9]))$", (String)(txt = txt.replace("\uff1a", ":")))) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u6709\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e, \u4f8b 19:00");
                    return;
                }
                int hour = Integer.valueOf(txt.substring(0, txt.indexOf(":")));
                int minute = Integer.valueOf(txt.substring(txt.indexOf(":") + 1, txt.length()));
                String hourStr = String.valueOf(hour);
                if (hour < 10) {
                    hourStr = "0" + hourStr;
                }
                String minuteStr = String.valueOf(minute);
                if (minute < 10) {
                    minuteStr = "0" + minuteStr;
                }
                this.txtTime.setText(String.valueOf(hourStr) + ":" + minuteStr);
                int end = hour * 60 + minute;
                Calendar calender = Calendar.getInstance();
                int hours = calender.get(11);
                int minuter = calender.get(12);
                if (end < hours * 60 + minuter) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
                    return;
                }
                this.lbEndErr.setText("");
            }
        });
    }

    private void initSpn() {
        SpinnerUtils.addDoubleArrowKeyHandler(this.getPriceSpn(), (double)0.005, (double)0.0);
        this.ctrlPrice.ctrl(this.priceSpn);
        this.ctrlPrice.setUnit(0.005);
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.priceSpn.getEditor().selectAll());
        this.ctrlCount.ctrl(this.countSpn);
        MxBindings.bindSI((Property)this.countSpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.countSpn.getEditor().setOnMouseClicked(event -> this.countSpn.getEditor().selectAll());
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            key.consume();
        }
    }

    private void initCmb() {
        MxNode node = MxNodeFactory.createNew((String)"xswap_position_effect", (String)"70");
        this.cmbOcFlag.valueProperty().bindBidirectional(this.model.ocFlagProperty());
        this.cmbOcFlag.setItems(node.getNodes());
        this.cmbOcFlag.setValue((Object)node);
        this.cmbType.setItems(this.model.getOrderType().getNodes());
        this.cmbType.valueProperty().bindBidirectional(this.model.orderTypeProperty());
    }

    private void keyEvent() {
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.countSpn.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.qtyKeyPress((KeyEvent)event));
        this.txtTime.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.timeKeyPress((KeyEvent)event));
    }

    private void codeKeyPress(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.txtTime.requestFocus();
            key.consume();
        }
    }

    private void timeKeyPress(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.countSpn.requestFocus();
            key.consume();
        }
    }

    private void qtyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order();
            key.consume();
        }
    }

    private void initSecurity() {
        this.refs = this.ref.getItems(new String[]{"SBFWD"});
        this.ref.changedProperty().addListener((ob, old, now) -> {
            this.refs = this.ref.getItems(new String[]{"SBFWD"});
            this.suggest.setAllSuggestions(this.refs);
        });
        for (RefItem ref : this.refs) {
            StdBondForward std;
            if (!(ref instanceof StdBondForward) || !(std = (StdBondForward)ref).getStatus().equals("B")) continue;
            this.codeList.add(ref);
        }
        this.codeList.forEach(data -> this.mlist.add((MxObject)new XBondDealMarketItem(data.getMarket(), data.getCode())));
        this.suggest.addPossibleSuggestions(this.codeList);
        this.auto = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.suggest, (StringConverter)((StringConverter)this.of.create(SecConverter.class)));
        this.auto.changedProperty().addListener((ob, old, now) -> {
            this.model.refItem = (StdBondForward)this.txtCode.getUserData();
            if (this.model.refItem != null) {
                this.lbName.setText(this.model.refItem.getName());
            } else {
                this.lbName.setText("");
            }
            this.onRefItemChange();
        });
        this.txtCode.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
    }

    private void onRefItemChange() {
        this.mktItem.clear();
        if (this.model.refItem != null) {
            StdBondForward ref = this.model.refItem;
            Map map = (Map)this.marketDataModel.getMapInfo().get(ref);
            if (map == null) {
                this.marketDataModel.subMarketItem((RefItem)ref);
            }
            String mKey = String.valueOf(ref.getMarket()) + ref.getCode();
            MarketItem item = (MarketItem)((Map)this.marketDataModel.getMapInfo().get(ref)).get(mKey);
            this.mktItem.setRefItem((RefItem)ref);
            this.mktItem.update((Object)item);
            this.updateHandicapInfo((ObservableList<HandicapInfo>)this.mktItem.getListBuyHandicap());
            this.updateHandicapInfo((ObservableList<HandicapInfo>)this.mktItem.getListSellHandicap());
            this.resetMarketOrder();
        } else {
            this.resetMarketOrder();
        }
    }

    private void updateHandicapInfo(ObservableList<HandicapInfo> infos) {
        for (HandicapInfo info : infos) {
            if (!(info.getPrice() < 0.0)) continue;
            info.clear();
        }
    }

    private void setNum(MarketItem mi) {
        ObservableList listBuy = mi.getListBuyHandicap();
        for (HandicapInfo buy : listBuy) {
            buy.setSumQtyStr(String.valueOf(buy.getSumQty() / 10000000));
            buy.setCountStr(String.valueOf(buy.getCount() / 10000000));
            buy.setOrderStr(String.valueOf(buy.getOrder()));
        }
        ObservableList listSell = mi.getListSellHandicap();
        for (HandicapInfo sell : listSell) {
            sell.setSumQtyStr(String.valueOf(sell.getSumQty() / 10000000));
            sell.setCountStr(String.valueOf(sell.getCount() / 10000000));
            sell.setOrderStr(String.valueOf(sell.getOrder()));
        }
    }

    protected void onBSChange(Boolean old, Boolean now) {
        this.model.setBuy(now);
        Platform.runLater(() -> {
            if (this.sellRadio.isSelected()) {
                this.btnOrd.setText("\u5356\u51fa");
                CssUtils.removeStyleClass((Control)this.btnOrd, (String)"btnRed");
            } else {
                this.btnOrd.setText("\u4e70\u5165");
                CssUtils.addStyleClass((Control)this.btnOrd, (String)"btnRed");
            }
        });
    }

    @FXML
    public void submit() {
        this.order();
    }

    public void order() {
        int minuter;
        Calendar calender;
        int hour;
        if (!StringUtils.patternCheck((String)"^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3])):(([0-9]{0,1})|([0-5][0-9]))$", (String)this.txtTime.getText())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6709\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e, \u4f8b 19:00");
            return;
        }
        if (this.countSpn.getEditor().getText().isEmpty() || Double.valueOf(this.countSpn.getEditor().getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6570\u91cf\u4e0d\u80fd\u4e3a0");
            return;
        }
        if (Double.valueOf(this.countSpn.getEditor().getText()) > 99.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e70\u5356\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc799(\u5343\u4e07)");
            return;
        }
        if (Double.valueOf(this.priceSpn.getEditor().getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4ef7\u683c\u4e0d\u80fd\u4e3a0");
            return;
        }
        String[] time = this.txtTime.getText().split(":");
        int end = this.getInt(time[0]) * 60 + this.getInt(time[1]);
        if (end < (hour = (calender = Calendar.getInstance()).get(11)) * 60 + (minuter = calender.get(12))) {
            this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
            return;
        }
        this.sendMessage();
        try {
            if (this.preModel.isPopBeforeOrder()) {
                StdBondEntrustConfirmDialog obj = (StdBondEntrustConfirmDialog)this.of.create(StdBondEntrustConfirmDialog.class);
                obj.setRefItem((RefItem)this.model.refItem);
                obj.setUnit("\u5143");
                obj.setList(this.model.getEntrustList());
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
                if (dialog.launch() != ButtonType.OK) {
                    return;
                }
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.model.submit();
            this.alert.alert(Alert.AlertType.INFORMATION, "\u4e0b\u5355\u6210\u529f");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void sendMessage() {
        int minuter;
        Calendar calender;
        int hour;
        if (this.model.refItem == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
            return;
        }
        if (!StringUtils.patternCheck((String)"^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3])):(([0-9]{0,1})|([0-5][0-9]))$", (String)this.txtTime.getText())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6709\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e, \u4f8b 19:00");
            return;
        }
        if (this.countSpn.getEditor().getText().isEmpty() || Double.valueOf(this.countSpn.getEditor().getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6570\u91cf\u4e0d\u80fd\u4e3a0");
            return;
        }
        if (this.priceSpn.getEditor().getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u91d1\u989d\u4e0d\u80fd\u4e3a0");
            return;
        }
        if (Double.valueOf(this.countSpn.getEditor().getText()) > 99.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e70\u5356\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc799(\u5343\u4e07)");
            return;
        }
        String[] time = this.txtTime.getText().split(":");
        int end = this.getInt(time[0]) * 60 + this.getInt(time[1]);
        if (end < (hour = (calender = Calendar.getInstance()).get(11)) * 60 + (minuter = calender.get(12))) {
            this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
            return;
        }
        this.model.setSecurity(this.txtCode.getText());
        this.model.setTime(String.valueOf(this.txtTime.getText()) + ":00.000");
        MxNode ocFlag = (MxNode)this.cmbOcFlag.getSelectionModel().getSelectedItem();
        this.model.setOcFlagString(ocFlag.getValue());
        String type = ((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getValue();
        this.model.setOrderTypeString(type);
        this.model.setCount(Integer.valueOf(this.countSpn.getEditor().getText()));
    }

    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    protected int getInt(String txt) {
        return "".equals(txt) ? 0 : StringUtils.parseInt((String)txt);
    }

    private void createTableview() {
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMktSell.getItems().size() - this.tableMktSell.getItems().indexOf(p.getValue())))))));
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMktBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(true));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(false));
        this.mktBuyYield.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).sumQtyStrProperty());
        this.mktSellYield.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).sumQtyStrProperty());
        this.mktBuyYield.setCellFactory(cell -> new QtyCell());
        this.mktSellYield.setCellFactory(cell -> new QtyCell());
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countStrProperty());
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countStrProperty());
        this.colSellCount.setCellFactory(cell -> new QtyCell());
        this.colBuyCount.setCellFactory(cell -> new QtyCell());
        this.colSelfSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderStrProperty());
        this.colSelfBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderStrProperty());
        this.colSelfSellCount.setCellFactory(cell -> new SelfQtyCell());
        this.colSelfBuyCount.setCellFactory(cell -> new SelfQtyCell());
        this.tableMktSell.getColumns().remove(this.colSellCount);
        this.tableMktBuy.getColumns().remove(this.colBuyCount);
        this.tableMktSell.setPlaceholder((Node)new Label());
        this.tableMktBuy.setPlaceholder((Node)new Label());
        this.tableMktBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemBuySelected(true, (HandicapInfo)now));
        this.tableMktSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSellSelected(false, (HandicapInfo)now));
        this.tableMktBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMktSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetMarketOrder() {
        if (this.mktItem.getRefItem() != null) {
            if (this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
                double count;
                long start = System.currentTimeMillis();
                MxList<ObSingleOrderXswapBond> mxList = this.unfinishedModel.getObList();
                synchronized (mxList) {
                    this.orders.clear();
                    this.orders.addAll((Collection<ObSingleOrderXswapBond>)this.unfinishedModel.getObList().getList());
                }
                for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                    info.setOrder(-1);
                    if (info.getPrice() == -1.0) continue;
                    info.setOrder(0);
                    if (this.orders == null || this.orders.isEmpty()) continue;
                    for (ObSingleOrderXswapBond order : this.orders) {
                        if (!order.getSecurityId().equals(this.txtCode.getText()) || order.getPrice() != info.getPrice() || !"81".equals(order.getSide().getRaw())) continue;
                        if (StringUtils.isEmpty((String)info.getTraderId()) || !info.getTraderId().contains(order.getTraderId())) {
                            info.setTraderId(String.valueOf(StringUtils.isEmpty((String)info.getTraderId()) ? "" : info.getTraderId()) + "," + order.getTraderId());
                        }
                        info.setSelf(Boolean.valueOf(true));
                        count = (double)info.getOrder() + order.getOrderQty() - order.getCumQty();
                        info.setOrder((int)count);
                    }
                }
                for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                    info.setOrder(-1);
                    if (info.getPrice() == -1.0) continue;
                    info.setOrder(0);
                    if (this.orders == null || this.orders.isEmpty()) continue;
                    for (ObSingleOrderXswapBond order : this.orders) {
                        if (!order.getSecurityId().equals(this.txtCode.getText()) || order.getPrice() != info.getPrice() || !"80".equals(order.getSide().getRaw())) continue;
                        if (StringUtils.isEmpty((String)info.getTraderId()) || !info.getTraderId().contains(order.getTraderId())) {
                            info.setTraderId(String.valueOf(StringUtils.isEmpty((String)info.getTraderId()) ? "" : info.getTraderId()) + "," + order.getTraderId());
                        }
                        info.setSelf(Boolean.valueOf(true));
                        count = (double)info.getOrder() + order.getOrderQty() - order.getCumQty();
                        info.setOrder((int)count);
                    }
                }
                logger.error("resetMarketOrder\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            }
            this.setNum(this.mktItem);
        }
    }

    private void onItemBuySelected(boolean b, HandicapInfo now) {
        if (now != null) {
            this.priceSpn.getEditor().setText(now.getPriceStr());
            this.countSpn.getEditor().setText(now.getSumQtyStr());
            this.sellRadio.setSelected(true);
        }
        Platform.runLater(() -> this.clearSelection());
    }

    private void onItemSellSelected(boolean b, HandicapInfo now) {
        if (now != null) {
            this.priceSpn.getEditor().setText(now.getPriceStr());
            this.countSpn.getEditor().setText(now.getSumQtyStr());
            this.buyRadio.setSelected(true);
        }
        Platform.runLater(() -> this.clearSelection());
    }

    private void clearSelection() {
        this.tableMktBuy.getSelectionModel().clearSelection();
        this.tableMktSell.getSelectionModel().clearSelection();
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public void setPriceSpn(Spinner<Double> priceSpn) {
        this.priceSpn = priceSpn;
    }

    public Spinner<Integer> getCountSpn() {
        return this.countSpn;
    }

    public void setCountSpn(Spinner<Integer> countSpn) {
        this.countSpn = countSpn;
    }

    class HandicapCountCell
    extends TableCell<HandicapInfo, Number> {
        private static final int INVALID_COUNT = -1;

        HandicapCountCell() {
        }

        public void updateItem(Number item, boolean empty) {
            HandicapInfo handiInfo;
            if (!empty && item.longValue() != -1L && (handiInfo = (HandicapInfo)this.getTableRow().getItem()) != null && !handiInfo.isClear()) {
                this.setText(String.valueOf(item));
                return;
            }
            this.setText(null);
        }
    }

    public class PriceCell
    extends TableCell<HandicapInfo, String> {
        private boolean buy = false;

        PriceCell(boolean buy) {
            CssUtils.priceTag((Control)this);
            this.buy = buy;
        }

        public void updateItem(String item, boolean empty) {
            HandicapInfo handiInfo;
            if (!(empty || item.isEmpty() || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear())) {
                double price = Double.parseDouble(item);
                String traderId = handiInfo.getTraderId();
                String[] split = traderId.split(",");
                if (!StringUtils.isEmpty((String)traderId)) {
                    List<String> list = Arrays.asList(split);
                    if (list.contains(TraderModel.traderId)) {
                        CssUtils.makePink((Control)this);
                    } else {
                        CssUtils.makeYellow((Control)this);
                    }
                } else if (!this.buy) {
                    CssUtils.makeFall((Control)this);
                } else {
                    CssUtils.makeRise((Control)this);
                }
                if (price > 0.0) {
                    String txt = String.format("%.3f", price);
                    this.setText(txt);
                    return;
                }
            }
            this.setText(null);
        }
    }

    public class QtyCell
    extends TableCell<HandicapInfo, String> {
        QtyCell() {
        }

        public void updateItem(String item, boolean empty) {
            double price;
            HandicapInfo handiInfo;
            if (!empty && !item.isEmpty() && (handiInfo = (HandicapInfo)this.getTableRow().getItem()) != null && !handiInfo.isClear() && (price = Double.parseDouble(item)) > 0.0) {
                this.setText(String.format("%.4f", price));
                return;
            }
            this.setText(null);
        }
    }

    public class SelfQtyCell
    extends TableCell<HandicapInfo, String> {
        SelfQtyCell() {
        }

        public void updateItem(String item, boolean empty) {
            HandicapInfo handiInfo;
            if (!(empty || item.isEmpty() || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear())) {
                if (handiInfo.isSelf().booleanValue()) {
                    CssUtils.makePink((Control)this);
                } else {
                    CssUtils.makeYellow((Control)this);
                }
                double price = Double.parseDouble(item);
                if (price > 0.0) {
                    this.setText(String.format("%.4f", price));
                    return;
                }
            }
            this.setText(null);
        }
    }
}

