/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XswapBondForwardPositionModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XswapBondForwardPositionPart
extends MxPart {
    private final Logger logger = LogManager.getLogger(XswapBondForwardPositionPart.class);
    private MxList<ObPosition> list = new MxList();
    @FXML
    private TableView<ObPosition> tablePosition;
    @FXML
    private TableColumn<ObPosition, String> code;
    @FXML
    private TableColumn<ObPosition, String> side;
    @FXML
    private TableColumn<ObPosition, Number> secBalance;
    @FXML
    private TableColumn<ObPosition, Number> secAvail;
    @FXML
    private TextField searchText;
    @Inject
    private XswapBondForwardPositionModel model;
    @Inject
    private MxAlert alert;
    private Predicate<ObPosition> pd = t -> {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getSecurityId().toUpperCase();
        return code.contains(text);
    };
    private InvalidationListener listenerSearch = ob -> {
        List<ObPosition> list = this.model.getObList();
        synchronized (list) {
            this.list.filter(this.model.getObList(), this.pd);
        }
        this.tablePosition.refresh();
    };
    private InvalidationListener lstnModel = ob -> {
        ArrayList newList = new ArrayList();
        Platform.runLater(() -> {
            List<ObPosition> list2 = this.model.getObList();
            synchronized (list2) {
                newList.addAll(this.model.getObList());
            }
            this.list.update(newList, this.pd);
            this.listenerSearch.invalidated(null);
            this.tablePosition.sort();
        });
    };

    @FXML
    private void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.listenerSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.listenerSearch);
    }

    private void createTable() {
        this.code.setCellValueFactory(data -> ((ObPosition)data.getValue()).securityIdProperty());
        this.side.setCellValueFactory(data -> ((ObPosition)data.getValue()).sideProperty());
        this.secBalance.setCellValueFactory(data -> ((ObPosition)data.getValue()).secBalanceProperty());
        this.secBalance.setCellFactory(cell -> new CountCell());
        this.secAvail.setCellValueFactory(data -> ((ObPosition)data.getValue()).secAvailProperty());
        this.secAvail.setCellFactory(cell -> new CountCell());
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.list.getList());
    }

    @FXML
    public void refresh() {
        try {
            this.model.query();
        }
        catch (MException | IOException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
        }
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public class CountCell<T>
    extends TableCell<T, Number> {
        private Label label = new Label();

        public void updateItem(Number value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                int i = (int)(value.longValue() / 10000000L);
                this.label.setText(StringUtils.toStr((double)i, (int)3));
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                XswapBondForwardPositionPart.this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }
}

