/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XswapBondForwardDealModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.ObExecution;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.utils.StringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XswapBondForwardDealPart
extends MxPagePart<Execution, ObExecution> {
    private static final Logger logger = LogManager.getLogger(XswapBondForwardDealPart.class);
    @FXML
    protected TableView<ObExecution> tableView;
    @FXML
    protected TableView<ObExecution> tableDealCount;
    @FXML
    private TableColumn<ObExecution, String> securityId;
    @FXML
    private TableColumn<ObExecution, String> ocFlag;
    @FXML
    private TableColumn<ObExecution, Party> counterParty;
    @FXML
    private TableColumn<ObExecution, String> authorizerParty;
    @FXML
    private TableColumn<ObExecution, String> authorizer;
    @FXML
    private TableColumn<ObExecution, String> traderName;
    @FXML
    private TableColumn<ObExecution, String> execTime;
    @FXML
    private TableColumn<ObExecution, String> execId;
    @FXML
    private TableColumn<ObExecution, String> orderId;
    @FXML
    private TableColumn<ObExecution, Number> lastPx;
    @FXML
    private TableColumn<ObExecution, Number> lastQty;
    @FXML
    private TableColumn<ObExecution, Side> side;
    @FXML
    private TableColumn<ObExecution, String> securityIdSum;
    @FXML
    private TableColumn<ObExecution, Side> sideSum;
    @FXML
    private TableColumn<ObExecution, Number> lastPxSum;
    @FXML
    private TableColumn<ObExecution, Number> lastQtySum;
    @FXML
    private TableColumn<ObExecution, Number> dealCount;
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @FXML
    private RadioButton detailRadio;
    @FXML
    private RadioButton countRadio;
    protected ToggleGroup group = new ToggleGroup();
    protected MxList<ObExecution> mxCountList = new MxList(200);
    @Inject
    private XswapBondForwardDealModel model;
    @Inject
    private MxAlert alert;
    protected Predicate<ObExecution> pdsum = t -> this.predicateSum((ObExecution)t);

    @FXML
    public void initialize() {
        this.searchTextStrategy.textProperty().addListener(this.listenerSearch);
        this.searchTextTrader.textProperty().addListener(this.listenerSearch);
        super.initialize();
        this.createTableView();
        this.createCountTable();
        this.setRadio();
        this.refresh();
    }

    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.searchTextStrategy.textProperty().removeListener(this.listenerSearch);
        this.searchTextTrader.textProperty().removeListener(this.listenerSearch);
    }

    private void createCountTable() {
        TableUtils.initValueFactory(this.tableDealCount);
        this.securityIdSum.setCellValueFactory(data -> ((ObExecution)data.getValue()).securityIdProperty());
        this.sideSum.setCellValueFactory(data -> ((ObExecution)data.getValue()).sideProperty());
        this.lastPxSum.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastPxProperty());
        this.lastPxSum.setCellFactory(p -> new ObPriceCell());
        this.lastQtySum.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastQtyProperty());
        this.lastQtySum.setCellFactory(cell -> new CountCell());
        this.dealCount.setCellValueFactory(data -> ((ObExecution)data.getValue()).dealCountProperty());
        this.tableDealCount.setPlaceholder((Node)new Label());
        this.tableDealCount.setItems(this.mxCountList.getPageList());
    }

    protected void setRadio() {
        this.detailRadio.setToggleGroup(this.group);
        this.countRadio.setToggleGroup(this.group);
        this.detailRadio.setSelected(true);
        this.tableView.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbCurrentCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbTotalCount.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbCountSeparator.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbPrevPage.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.lbNextPage.visibleProperty().bind((ObservableValue)this.detailRadio.selectedProperty());
        this.tableDealCount.visibleProperty().bind((ObservableValue)this.countRadio.selectedProperty());
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.side.setCellValueFactory(data -> ((ObExecution)data.getValue()).sideProperty());
        this.securityId.setCellValueFactory(data -> ((ObExecution)data.getValue()).securityIdProperty());
        this.lastPx.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastPxProperty());
        this.lastPx.setCellFactory(p -> new ObPriceCell());
        this.lastQty.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastQtyProperty());
        this.lastQty.setCellFactory(cell -> new CountCell());
        this.ocFlag.setCellValueFactory(data -> ((ObExecution)data.getValue()).positionEffectProperty());
        this.authorizer.setCellValueFactory(data -> ((ObExecution)data.getValue()).authorizerProperty());
        this.traderName.setCellValueFactory(data -> ((ObExecution)data.getValue()).traderNameProperty());
        this.execTime.setCellValueFactory(data -> ((ObExecution)data.getValue()).execTimeProperty());
        this.execId.setCellValueFactory(data -> ((ObExecution)data.getValue()).execIdProperty());
        this.orderId.setCellValueFactory(data -> ((ObExecution)data.getValue()).orderIdProperty());
        this.tableView.setPlaceholder((Node)new Label());
        this.tableView.setItems(this.mxList.getPageList());
    }

    @FXML
    protected void refresh() {
        this.model.query();
    }

    protected void refreshList() {
        super.refreshList();
        List<ObExecution> sumList = this.createCountList(this.getList());
        this.mxCountList.update(sumList, this.pdsum);
        this.mxCountList.updatePageList();
    }

    @FXML
    protected void refreshSum() {
        this.refresh();
    }

    protected boolean predicate(Execution exec) {
        String traderId;
        String txtTrader;
        boolean bTrader;
        String text = this.searchText.getText().trim().toUpperCase();
        String code = exec.getInstrument().getSecurityId().toUpperCase();
        String name = exec.getInstrument().getSymbol().toUpperCase();
        String execId = exec.getExecId();
        boolean bTxt = code.contains(text) || execId.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        boolean bStrategy = txtStrategy.isEmpty();
        if (!bStrategy && exec.getExecMode() != null) {
            String sourceId = String.valueOf(exec.getExecMode().getEmId());
            String source = exec.getExecMode().getEmName();
            if (sourceId.contains(txtStrategy) || source.contains(txtStrategy)) {
                bStrategy = true;
            }
        }
        if (!(bTrader = (txtTrader = this.searchTextTrader.getText().trim().toUpperCase()).isEmpty()) && exec.getSelfparty() != null && (traderId = exec.getSelfparty().getTraderId().toUpperCase()).contains(txtTrader)) {
            bTrader = true;
        }
        return bTxt && bStrategy && bTrader;
    }

    protected boolean predicateSum(ObExecution t) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        return code.contains(text) || t.getInstrument().getSymbol().contains(text);
    }

    protected List<Execution> getList() {
        return this.model.getList();
    }

    protected XswapBondForwardDealModel getModel() {
        return this.model;
    }

    private List<ObExecution> createCountList(List<Execution> newList) {
        HashMap<String, Execution> map = new HashMap<String, Execution>();
        LinkedList<Execution> list = new LinkedList<Execution>();
        LinkedList<ObExecution> obList = new LinkedList<ObExecution>();
        for (Execution deal : newList) {
            String key = this.getKey(deal);
            Execution newDeal = new Execution();
            if (map.get(key) == null) {
                newDeal.update((Object)deal);
                newDeal.setOrderId("");
                newDeal.setLastAmountSum(Double.valueOf(newDeal.getLastPx() * newDeal.getLastQty()));
                newDeal.setDealCount(1);
                list.add(newDeal);
                map.put(key, newDeal);
                continue;
            }
            Execution oldDeal = (Execution)map.get(key);
            double qty = deal.getLastQty();
            double amount = deal.getLastPx() * deal.getLastQty();
            double oldQty = oldDeal.getLastQty();
            double oldAmount = oldDeal.getLastAmountSum();
            oldDeal.setLastQty(oldQty + qty);
            oldDeal.setLastAmountSum(Double.valueOf(oldAmount + amount));
            oldDeal.setLastPx(oldDeal.getLastAmountSum() / oldDeal.getLastQty());
            oldDeal.setDealCount(oldDeal.getDealCount() + 1);
        }
        for (Execution deal : list) {
            ObExecution obDeal = new ObExecution();
            obDeal.update((Object)deal);
            obList.add(obDeal);
        }
        return obList;
    }

    private String getKey(Execution deal) {
        return String.valueOf(deal.getInstrument().getSecurityId()) + deal.getSide();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableView);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableView, (String)"\u6210\u4ea4\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copySum() {
        TableUtils.copyContentWithHead(this.tableDealCount);
    }

    @FXML
    public void exportExcelSum() {
        try {
            ExcelUtils.writeExcel(this.tableDealCount, (String)"\u6210\u4ea4\u6c47\u603b\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public void defaultSort() {
    }

    public class CountCell<T>
    extends TableCell<T, Number> {
        private Label label = new Label();

        public void updateItem(Number value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                int i = (int)value.longValue();
                this.label.setText(StringUtils.toStr((double)i, (int)0));
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected class ObPriceCell
    extends DoubleTableCell<ObExecution> {
        protected ObPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)3));
            }
        }
    }
}

