/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.StdBondForwarDeliverModel;
import cms.tmx.bond.models.XSwapStrategyModel;
import cms.tmx.bond.models.YieldCell;
import cms.tmx.bond.views.AddXSwapStrategyDialog;
import cms.tmx.bond.views.IXSwapStrategy;
import cms.tmx.bond.views.XSwapStrategyLibraryDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.http.RefDataMng;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForwardDeliver;
import cms.tmx.entity.trade.XSwapStrategy;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.Logger;

public class XSwapStrategyPart
extends MxPart
implements IXSwapStrategy {
    @FXML
    private Label lbCode;
    @FXML
    private Label lbDeliver1;
    @FXML
    private Label lbDeliver2;
    @FXML
    private Label lbDeliverMkt1;
    @FXML
    private Label lbDeliverMkt2;
    @FXML
    private TableView<HandicapInfo> tableMktSell;
    @FXML
    private TableColumn<String, String> colSellIndex;
    @FXML
    private TableColumn<HandicapInfo, String> colSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellYtm1;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellYtm2;
    @FXML
    private TableView<HandicapInfo> tableMktBuy;
    @FXML
    private TableColumn<String, String> colBuyIndex;
    @FXML
    private TableColumn<HandicapInfo, String> colBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyYtm1;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyYtm2;
    @FXML
    private Label lbForwardYtm1;
    @FXML
    private Label lbForwardYtm2;
    @FXML
    private Label lbBasePrice;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnStart;
    @FXML
    private Button btnStop;
    @FXML
    private TableView<XSwapStrategy> tableStrategy;
    @FXML
    private TableColumn<XSwapStrategy, Boolean> selected;
    @FXML
    private TableColumn<XSwapStrategy, String> errorMsg;
    @FXML
    private TableColumn<XSwapStrategy, Object> operate;
    @FXML
    private TableColumn<XSwapStrategy, String> statusName;
    @FXML
    private TableColumn<XSwapStrategy, Number> maxDeal;
    @FXML
    private TableColumn<XSwapStrategy, String> contextId;
    @FXML
    private TableColumn<XSwapStrategy, String> securityId;
    @FXML
    private TableColumn<XSwapStrategy, String> securityName;
    @FXML
    private TableColumn<XSwapStrategy, MxNode> type;
    @FXML
    private TableColumn<XSwapStrategy, String> name;
    @FXML
    private TableColumn<XSwapStrategy, Number> filledQty;
    @FXML
    private TableColumn<XSwapStrategy, String> priceBuy;
    @FXML
    private TableColumn<XSwapStrategy, String> priceSell;
    @FXML
    private TableColumn<XSwapStrategy, Number> qtyBuy;
    @FXML
    private TableColumn<XSwapStrategy, Number> qtySell;
    @FXML
    private CheckBox cboxAll;
    @FXML
    private TextField txtSearch;
    @Inject
    private XSwapStrategyModel model;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private MarketDataModel mktModel;
    @Inject
    private StdBondForwarDeliverModel deliverModel;
    private MxList<XSwapStrategy> mlist = new MxList();
    private MarketItem mktItem;
    private Predicate<XSwapStrategy> pd = t -> {
        if (t.isTemplate()) {
            return false;
        }
        String code = t.getSecurityId().toUpperCase();
        String name = t.getName().toUpperCase();
        String txt = this.txtSearch.getText().toUpperCase();
        return code.contains(txt) || name.contains(txt);
    };
    private InvalidationListener selectedLis = ob -> this.checkBtnStatus();
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        this.mlist.update(this.model.getList(), this.pd);
        this.checkBtnStatus();
        for (XSwapStrategy strategy : this.mlist.getList()) {
            strategy.selectedProperty().removeListener(this.selectedLis);
            strategy.selectedProperty().addListener(this.selectedLis);
        }
        this.tableStrategy.refresh();
        this.logger.debug("std\u7b56\u7565\u4ea4\u6613\u5237\u65b0\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listenerStatus = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        this.checkBtnStatus();
        this.logger.debug("checkBtnStatus\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener lstnSearch = ob -> {
        long start = System.currentTimeMillis();
        this.mlist.filter(this.model.getList(), this.pd);
        this.mlist.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
        this.checkBtnStatus();
        this.tableStrategy.layout();
        System.err.println("time:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    };
    private InvalidationListener listener = ob -> this.refresh();

    @FXML
    protected void initialize() {
        this.mktItem = this.mktModel.createItem(5);
        this.createMktTable();
        this.createTable();
        this.cboxAll.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        this.lbBasePrice.textProperty().bind((ObservableValue)this.mktItem.basePriceProperty());
        this.lbForwardYtm1.textProperty().bind((ObservableValue)this.mktItem.forwardYtm1Property());
        this.lbForwardYtm2.textProperty().bind((ObservableValue)this.mktItem.forwardYtm2Property());
        TableUtils.doubleClicked(this.tableStrategy, strategy -> {
            List<StdBondForwardDeliver> list = this.deliverModel.getDeliver((XSwapStrategy)strategy);
            if (list == null || list.size() != 2) {
                String info = "\u6807\u503a\u8fdc\u671f\u7684\u53ef\u4ea4\u5272\u5238\u4e0d\u5168\uff0c" + (list == null ? null : Integer.valueOf(list.size()));
                this.logger.error(info);
                this.alert.alert(Alert.AlertType.ERROR, info);
                return false;
            }
            for (StdBondForwardDeliver deliver : list) {
                if (deliver.getActive() == 1) {
                    this.mktItem.setDeliver1(deliver);
                    this.lbDeliver1.setText("\u3010" + deliver.getSecurityId() + "\u3011");
                    this.lbDeliverMkt1.setText("  " + deliver.getSecurityId());
                    continue;
                }
                this.mktItem.setDeliver2(deliver);
                this.lbDeliver2.setText("\u3010" + deliver.getSecurityId() + "\u3011");
                this.lbDeliverMkt2.setText(" " + deliver.getSecurityId());
            }
            String type = RefDataMng.NEW_SECURITY ? "FORWARD" : "SBFWD";
            RefItem refItem = this.refMng.getItem(type, strategy.getMarket(), strategy.getSecurityId());
            if (refItem == null) {
                String info = "\u6807\u503a\u8fdc\u671f\u7684\u4ee3\u7801\u4e0d\u5b58\u5728";
                this.logger.error(info);
                this.alert.alert(Alert.AlertType.ERROR, info);
                return true;
            }
            this.mktItem.setRefItem(refItem);
            this.mktModel.dyeDepth(this.mktItem, strategy);
            this.lbCode.setText(refItem.getCode());
            return true;
        });
        this.model.changedProperty().addListener(this.lstnModel);
        this.model.statusChangedProperty().addListener(this.listenerStatus);
        this.txtSearch.textProperty().addListener(this.lstnSearch);
        this.refMng.changedProperty().addListener(this.listener);
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.model.statusChangedProperty().removeListener(this.listenerStatus);
        this.txtSearch.textProperty().removeListener(this.lstnSearch);
        this.refMng.changedProperty().removeListener(this.listener);
    }

    private void createMktTable() {
        this.colSellIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMktSell.getItems().size() - this.tableMktSell.getItems().indexOf(p.getValue())))))));
        this.colBuyIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMktBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.colBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem, Boolean.valueOf(false)));
        this.colSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem, Boolean.valueOf(true)));
        this.colSellYtm1.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).yield1Property());
        this.colSellYtm1.setCellFactory(data -> new YieldCell(this.mktItem));
        this.colSellYtm2.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).yield2Property());
        this.colSellYtm2.setCellFactory(data -> new YieldCell(this.mktItem));
        this.colBuyYtm1.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).yield1Property());
        this.colBuyYtm1.setCellFactory(data -> new YieldCell(this.mktItem));
        this.colBuyYtm2.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).yield2Property());
        this.colBuyYtm2.setCellFactory(data -> new YieldCell(this.mktItem));
        this.tableMktSell.setPlaceholder((Node)new Label());
        this.tableMktBuy.setPlaceholder((Node)new Label());
        this.tableMktBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMktSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
    }

    private void createTable() {
        this.selected.setSortable(false);
        TableUtils.isCheckBox(this.selected);
        this.contextId.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).contextIdProperty());
        this.securityId.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).securityIdProperty());
        this.type.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).typeProperty());
        this.name.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).nameProperty());
        this.statusName.setCellValueFactory(data -> ((XSwapStrategy)data.getValue()).statusNameProperty());
        this.errorMsg.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).errorMsgProperty());
        this.maxDeal.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).maxDealProperty());
        this.filledQty.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).filledQtyProperty());
        this.priceBuy.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).bidRefPriceFormulaProperty());
        this.priceSell.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).offerRefPriceFormulaProperty());
        this.qtyBuy.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).bidQtyProperty());
        this.qtyBuy.setCellFactory(data -> new QtyCell(true));
        this.qtySell.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).offerQtyProperty());
        this.qtySell.setCellFactory(data -> new QtyCell(false));
        this.selected.setCellValueFactory(data -> ((XSwapStrategy)data.getValue()).selectedProperty());
        this.operate.setCellValueFactory(data -> this.setOperate((XSwapStrategy)data.getValue()));
        this.tableStrategy.setPlaceholder((Node)new Label());
        this.mlist.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
        this.tableStrategy.setItems(this.mlist.getList());
    }

    @FXML
    private void copyNew() {
        XSwapStrategy strategy = (XSwapStrategy)this.tableStrategy.getSelectionModel().getSelectedItem();
        this.copyNew(strategy);
    }

    @FXML
    private void add() {
        AddXSwapStrategyDialog obj = (AddXSwapStrategyDialog)((Object)this.of.create(AddXSwapStrategyDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7b56\u7565");
        dialog.launch();
    }

    @FXML
    private void remove() {
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u5148\u505c\u6b62\u6267\u884c\u4e2d\u6216\u6682\u505c\u7684\u7b56\u7565");
            return;
        }
        boolean bDel = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u79fb\u9664\u52fe\u9009\u7684\u7b56\u7565\uff1f");
        if (!bDel) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            try {
                XSwapStrategy s = new XSwapStrategy();
                s.update((Object)strategy);
                s.setTemplate(true);
                this.model.updateStrategy(s);
            }
            catch (MException e) {
                builder.append(String.valueOf(strategy.getContextId()) + e.getMessage() + "\n");
            }
        }
        if (!builder.toString().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, builder.toString());
        }
    }

    @FXML
    private void execute() {
        ArrayList<String> listId = new ArrayList<String>();
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || strategy.getStatus().getRaw().equals("1")) continue;
            listId.add(strategy.getContextId());
        }
        this.exe.execute(() -> {
            try {
                Map<String, String> failed = this.model.startStrategy(listId);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u6267\u884c\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, str.toString());
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    @FXML
    public void stop() {
        ArrayList<String> listId = new ArrayList<String>();
        String market = "";
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            market = strategy.getMarket();
            listId.add(strategy.getContextId());
        }
        if (listId.isEmpty()) {
            this.alert.check(false, Alert.AlertType.INFORMATION, "\u65e0\u53ef\u505c\u6b62\u7684\u7b56\u7565\uff01");
            return;
        }
        try {
            Map<String, String> failed = this.model.stopStrategy(market, listId);
            if (failed.keySet().size() > 0) {
                StringBuilder str = new StringBuilder();
                str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                for (String s : failed.keySet()) {
                    str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                }
                this.alert.alert(Alert.AlertType.ERROR, str.toString());
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void stopAll() {
        ArrayList<String> listId = new ArrayList<String>();
        String market = "";
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            market = strategy.getMarket();
            listId.add(strategy.getContextId());
        }
        if (!market.isEmpty() && listId.size() > 0) {
            try {
                Map<String, String> failed = this.model.stopStrategy(market, listId);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    this.alert.alert(Alert.AlertType.ERROR, str.toString());
                }
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
        try {
            this.model.stopAll();
        }
        catch (MException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    private void strategyLib() {
        XSwapStrategyLibraryDialog lib = (XSwapStrategyLibraryDialog)this.of.create(XSwapStrategyLibraryDialog.class);
        MxDialog dialog = this.df.create((DialogObj)lib, "\u7b56\u7565\u5e93");
        lib.button = dialog.getButton(lib.buttonType);
        dialog.launch().getText().equals("\u6dfb\u52a0\u5230\u6267\u884c\u9762\u677f");
    }

    private void checkBtnStatus() {
        this.btnRemove.setDisable(true);
        this.btnStart.setDisable(true);
        this.btnStop.setDisable(true);
        int selectedNum = 0;
        int runningNum = 0;
        int pausingNum = 0;
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            ++selectedNum;
            switch (strategy.getStatus().getRaw()) {
                case "1": {
                    ++runningNum;
                    break;
                }
                case "3": {
                    ++pausingNum;
                    break;
                }
            }
        }
        if (selectedNum > 0) {
            this.btnRemove.setDisable(false);
        }
        if (selectedNum - runningNum > 0) {
            this.btnStart.setDisable(false);
        }
        if (runningNum > 0 || pausingNum > 0) {
            this.btnStop.setDisable(false);
        }
    }

    @Override
    public MObjFactory getObjFactory() {
        return this.of;
    }

    @Override
    public DialogFactory getDialogFactory() {
        return this.df;
    }

    @Override
    public MxAlert getAlert() {
        return this.alert;
    }

    @Override
    public XSwapStrategyModel getModel() {
        return this.model;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isLibPane() {
        return false;
    }

    @Override
    public TableView<XSwapStrategy> getTable() {
        return this.tableStrategy;
    }

    @Override
    @FXML
    public void refresh() {
        this.getModel().query(this.isLibPane());
    }

    public class QtyCell<S>
    extends TableCell<S, Number> {
        boolean side;

        public QtyCell(boolean side) {
            this.side = side;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                XSwapStrategy strategy = (XSwapStrategy)this.getTableRow().getItem();
                if (strategy != null && strategy.getType() != null) {
                    boolean isBuy = "200".equals(strategy.getType().getRaw());
                    boolean isMkt = "202".equals(strategy.getType().getRaw());
                    if (item != null && (isMkt || isBuy == this.side)) {
                        this.setText(StringUtils.toThousands((String)String.valueOf(item)));
                    } else {
                        this.setText(null);
                    }
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }
}

