/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XSwapStrategyModel;
import cms.tmx.bond.views.AddXSwapStrategyDialog;
import cms.tmx.bond.views.IXSwapStrategy;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.XSwapStrategy;
import cms.tmx.entity.trade.XSwapStrategySerialize;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XSwapStrategyLibraryDialog
extends DialogObj
implements IXSwapStrategy {
    private static final Logger logger = LogManager.getLogger(XSwapStrategyLibraryDialog.class);
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnDel;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableView<XSwapStrategy> tableStrategy;
    @FXML
    private TableColumn<XSwapStrategy, Boolean> selected;
    @FXML
    private TableColumn<XSwapStrategy, Object> operate;
    @FXML
    private TableColumn<XSwapStrategy, Number> maxDeal;
    @FXML
    private TableColumn<XSwapStrategy, String> contextId;
    @FXML
    private TableColumn<XSwapStrategy, String> securityId;
    @FXML
    private TableColumn<XSwapStrategy, String> securityName;
    @FXML
    private TableColumn<XSwapStrategy, MxNode> type;
    @FXML
    private TableColumn<XSwapStrategy, String> name;
    @FXML
    private CheckBox cboxAll;
    @Inject
    protected XSwapStrategyModel model;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng ref;
    private MxList<XSwapStrategy> mlist = new MxList();
    private Predicate<XSwapStrategy> pd = data -> {
        String text = this.txtSearch.getText().trim().toUpperCase();
        return data.getSecurityId().toUpperCase().contains(text) || data.getName().toUpperCase().contains(text);
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        if (this.mlist.getList().size() == this.model.getList().size() - 1) {
            this.mlist.update(this.model.getList(), this.pd);
            XSwapStrategy copy = this.model.getCopyStrategy();
            int last = this.mlist.getList().size() - 1;
            if (copy != null) {
                XSwapStrategy strategyNew = (XSwapStrategy)this.mlist.getList().get(last);
                int insertIndex = this.tableStrategy.getItems().indexOf((Object)copy) + 1;
                this.tableStrategy.getItems().remove(last);
                this.tableStrategy.getItems().add(insertIndex, (Object)strategyNew);
                this.tableStrategy.getSelectionModel().select((Object)strategyNew);
            } else {
                this.tableStrategy.getSelectionModel().select(last);
            }
        } else {
            this.mlist.update(this.model.getList(), this.pd);
        }
        this.checkBtnStatus();
        this.tableStrategy.refresh();
    });
    private InvalidationListener listenerSearch = ob -> Platform.runLater(() -> this.mlist.filter(this.model.getList(), this.pd));
    private InvalidationListener listener = ob -> this.refresh();
    @Inject
    protected MEventService es;
    public ButtonType buttonType = new ButtonType("\u6dfb\u52a0\u5230\u6267\u884c\u9762\u677f", ButtonBar.ButtonData.OK_DONE);
    public Button button;
    Gson gson = new Gson();

    @FXML
    public void initialize() {
        this.createTable();
        this.cboxAll.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        this.model.changedProperty().addListener(this.lstnModel);
        this.txtSearch.textProperty().addListener(this.listenerSearch);
        this.ref.changedProperty().addListener(this.listener);
        this.refresh();
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{this.buttonType, ButtonType.CANCEL};
    }

    public void onFinished(ButtonType bt) {
        if (bt == this.buttonType) {
            StringBuilder builder = new StringBuilder();
            for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
                if (!strategy.isSelected() || !strategy.isTemplate()) continue;
                try {
                    XSwapStrategy s = new XSwapStrategy();
                    s.update((Object)strategy);
                    s.setTemplate(false);
                    this.model.updateStrategy(s);
                }
                catch (MException e) {
                    builder.append(String.valueOf(strategy.getContextId()) + e.getMessage() + "\n");
                }
            }
            if (!builder.toString().isEmpty()) {
                logger.error("swap library \u6dfb\u52a0\u5931\u8d25", (Object)builder.toString());
                this.alert.alert(Alert.AlertType.ERROR, builder.toString());
            }
        }
    }

    @FXML
    public void add() {
        AddXSwapStrategyDialog obj = (AddXSwapStrategyDialog)((Object)this.of.create(AddXSwapStrategyDialog.class));
        obj.template = true;
        this.model.setCopyStrategy(null);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7b56\u7565");
        if (dialog.launch() == ButtonType.OK) {
            this.refresh();
        }
    }

    @FXML
    public void copyNew() {
        XSwapStrategy strategy = (XSwapStrategy)this.tableStrategy.getSelectionModel().getSelectedItem();
        this.model.setCopyStrategy(strategy);
        this.copyNew(strategy);
    }

    @FXML
    public void exportStrategy() {
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("rd files (*.txt)", new String[]{".txt"});
        chooser.getExtensionFilters().add((Object)filter);
        chooser.setInitialFileName("\u6807\u503a\u8fdc\u671f\u7b56\u7565");
        File file = chooser.showSaveDialog(null);
        try {
            if (file != null) {
                LinkedList<XSwapStrategySerialize> list = new LinkedList<XSwapStrategySerialize>();
                for (XSwapStrategy strategy : this.model.getList()) {
                    XSwapStrategySerialize strategy2 = new XSwapStrategySerialize();
                    strategy2.update((Object)strategy);
                    list.add(strategy2);
                }
                FileOutputStream fileStream = new FileOutputStream(file);
                String json = this.gson.toJson(list);
                byte[] array = json.getBytes();
                fileStream.write(array);
                fileStream.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    @FXML
    public void importStrategy() {
        FileChooser chooser = new FileChooser();
        File file = chooser.showOpenDialog(null);
        try {
            if (file != null) {
                LinkedList strategyList = new LinkedList();
                FileInputStream fileStream = new FileInputStream(file);
                byte[] array = new byte[fileStream.available()];
                fileStream.read(array);
                String json = new String(array);
                strategyList = (LinkedList)this.gson.fromJson(json, new TypeToken<LinkedList<XSwapStrategySerialize>>(){}.getType());
                for (XSwapStrategySerialize strategy : strategyList) {
                    try {
                        this.model.addStrategy(strategy);
                    }
                    catch (MException e) {
                        logger.error(e.getMessage());
                    }
                }
                fileStream.close();
            }
        }
        catch (IOException e1) {
            logger.error(e1.getMessage());
        }
        this.refresh();
    }

    @FXML
    public void delete() {
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            if (strategy.isSelected()) continue;
        }
        boolean bDel = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664\u52fe\u9009\u7684\u7b56\u7565\uff1f");
        if (!bDel) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            try {
                this.model.delStrategy(strategy.getMarket(), strategy.getContextId());
            }
            catch (MException e) {
                builder.append(String.valueOf(strategy.getContextId()) + e.getMessage() + "\n");
            }
        }
        if (!builder.toString().isEmpty()) {
            logger.error("swap library \u5220\u9664\u5931\u8d25", (Object)builder.toString());
            this.alert.alert(Alert.AlertType.ERROR, builder.toString());
        }
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.ref.changedProperty().removeListener(this.listener);
        this.txtSearch.textProperty().removeListener(this.listenerSearch);
    }

    private void createTable() {
        this.selected.setSortable(false);
        TableUtils.isCheckBox(this.selected);
        this.contextId.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).contextIdProperty());
        this.securityId.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).securityIdProperty());
        this.type.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).typeProperty());
        this.name.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).nameProperty());
        this.maxDeal.setCellValueFactory(cell -> ((XSwapStrategy)cell.getValue()).maxDealProperty());
        this.selected.setCellValueFactory(data -> {
            BooleanProperty bp = ((XSwapStrategy)data.getValue()).selectedProperty();
            bp.addListener((ob, old, now) -> this.checkBtnStatus());
            return bp;
        });
        this.operate.setCellValueFactory(data -> this.setOperate((XSwapStrategy)data.getValue()));
        this.tableStrategy.setPlaceholder((Node)new Label());
        this.mlist.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
        this.tableStrategy.setItems(this.mlist.getList());
    }

    private void checkBtnStatus() {
        this.button.setDisable(true);
        int selectedNum = 0;
        for (XSwapStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.isTemplate()) continue;
            ++selectedNum;
        }
        if (selectedNum > 0) {
            this.button.setDisable(false);
        }
    }

    @Override
    public MObjFactory getObjFactory() {
        return this.of;
    }

    @Override
    public DialogFactory getDialogFactory() {
        return this.df;
    }

    @Override
    public MxAlert getAlert() {
        return this.alert;
    }

    @Override
    public XSwapStrategyModel getModel() {
        return this.model;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public boolean isLibPane() {
        return true;
    }

    @Override
    public TableView<XSwapStrategy> getTable() {
        return this.tableStrategy;
    }

    @Override
    @FXML
    public void refresh() {
        this.getModel().query(this.isLibPane());
    }
}

