/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.SecFormatter;
import cms.tmx.bond.models.FormulaModel;
import cms.tmx.bond.models.StdBondForwarDeliverModel;
import cms.tmx.bond.models.XSwapStrategyModel;
import cms.tmx.bond.views.HedgeBenchmarkDialog;
import cms.tmx.bond.views.InitiativeBenchmarkDialog;
import cms.tmx.bond.views.StdSecSuggest;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.LocalFilter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.MatchConverter;
import cms.tmx.control.search.Search;
import cms.tmx.control.search.localSuggest;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.entity.data.StdBondForwardDeliver;
import cms.tmx.entity.trade.XSwapStrategy;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.ActiveBenchmarkPricingSettings;
import cms.tmx.http.api.strategy.dto.HedgeBenchmarkPricingSettings;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XSwapStrategyDialog
extends DialogObj {
    protected Logger logger = LogManager.getLogger(XSwapStrategyDialog.class);
    protected static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    @FXML
    protected VBox vboxAll;
    @FXML
    private ComboBox<CfetsFundAccount> cmbAccnt;
    @FXML
    private Label lbAccntErr;
    @FXML
    protected TextField txtCode;
    @FXML
    private Label lbCodeErr;
    @FXML
    protected Label lbName;
    @FXML
    protected ComboBox<MxNode> cmbType;
    @FXML
    protected TextField txtName;
    @FXML
    private Label lbNameErr;
    @FXML
    private RadioButton radioBuy;
    @FXML
    private RadioButton radioSell;
    @FXML
    private RadioButton radioMkt;
    @FXML
    protected ComboBox<MxNode> cmbCancelType;
    @FXML
    private ComboBox<MxNode> cmbOcFlag;
    @FXML
    private TextField txtBenchMarkFormula;
    @FXML
    private Label lbBenchMarkFormulaErr;
    @FXML
    private Button btnBenchMarkFormula;
    @FXML
    private RadioButton rdoAttackBuy;
    @FXML
    private RadioButton rdoDefendBuy;
    @FXML
    private RadioButton rdoAttackSell;
    @FXML
    private RadioButton rdoDefendSell;
    @FXML
    private TextField txtFormulaBuy;
    @FXML
    private Label lbFormulaBuyErr;
    @FXML
    private TextField txtFormulaSell;
    @FXML
    private Label lbFormulaSellErr;
    @FXML
    private Spinner<Double> spnDiffBuy;
    @FXML
    private Label lbDiffBuyErr;
    @FXML
    private Spinner<Double> spnDiffSell;
    @FXML
    private Label lbDiffSellErr;
    @FXML
    private TextField txtBidUpLimit;
    @FXML
    private Label lbBidUpLimitErr;
    @FXML
    private TextField txtBidFloorLimit;
    @FXML
    private Label lbBidFloorLimitErr;
    @FXML
    private TextField txtOfrUpLimit;
    @FXML
    private Label lbOfrUpLimitErr;
    @FXML
    private TextField txtOfrFloorLimit;
    @FXML
    private Label lbOfrFloorLimitErr;
    @FXML
    private Spinner<Double> spnMinShift;
    @FXML
    private Label lbMinShiftErr;
    @FXML
    private Spinner<Double> spnMaxDeal;
    @FXML
    private Label lbMaxDealErr;
    @FXML
    private Spinner<Double> spnQtyBuy;
    @FXML
    private Label lbQtyBuyErr;
    @FXML
    private Spinner<Double> spnQtySell;
    @FXML
    private Label lbQtySellErr;
    @FXML
    private TextField txtHedgeBenchMark;
    @FXML
    private Label lbHedgeBenchMarkErr;
    @FXML
    private Button btnHedgeBenchMark;
    @FXML
    private Label lbDeliver1;
    @FXML
    private Label lbDeliver2;
    @FXML
    private TextField txtFormulaBuyCtd1;
    @FXML
    private Label lbFormulaBuyCtd1Err;
    @FXML
    private TextField txtFormulaSellCtd1;
    @FXML
    private Label lbFormulaSellCtd1Err;
    @FXML
    private TextField txtFormulaBuyCtd2;
    @FXML
    private Label lbFormulaBuyCtd2Err;
    @FXML
    private TextField txtFormulaSellCtd2;
    @FXML
    private Label lbFormulaSellCtd2Err;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    protected XSwapStrategyModel model;
    @Inject
    protected PortfolioAccountModel portfModel;
    @Inject
    private CcsAccountMap accntMng;
    @Inject
    protected IRefDataMng ref;
    @Inject
    protected MxAlert alert;
    @Inject
    private StdBondForwarDeliverModel deliverModel;
    private ToggleGroup groupBs = new ToggleGroup();
    private ToggleGroup groupInvadeBuy = new ToggleGroup();
    private ToggleGroup groupInvadeSell = new ToggleGroup();
    private StdSecSuggest suggest = new StdSecSuggest();
    private MatchConverter matchCt = new MatchConverter();
    private localSuggest spFormulaXswap = new localSuggest("].");
    private localSuggest spFormulaXbond = new localSuggest("].");
    private DoubleSpinnerCtrl ctrlDiffBuy = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffSell = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlMinShift = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlMaxDeal = new DoubleSpinnerCtrl(true, 3, 1);
    private DoubleSpinnerCtrl ctrlCountBuy = new DoubleSpinnerCtrl(true, 3, 1);
    private DoubleSpinnerCtrl ctrlCountSell = new DoubleSpinnerCtrl(true, 3, 1);
    private ObservableList<CfetsFundAccount> listAcc = FxUtils.newList();
    protected XSwapStrategy stg;
    private ActiveBenchmarkPricingSettings activeBenchmark = new ActiveBenchmarkPricingSettings();
    private HedgeBenchmarkPricingSettings hedgeBenchmark = new HedgeBenchmarkPricingSettings();
    protected StdBondForward refItem;
    protected StdBondForwardDeliver deliver1;
    protected StdBondForwardDeliver deliver2;
    private Collection<RefItem> listRef = new ArrayList<RefItem>();
    @Inject
    private ISecAccountService secAccService;

    public XSwapStrategyDialog() {
        super("XSwapStrategyDialog.fxml");
    }

    @FXML
    public void initialize() {
        this.initControls();
        String typeRaw = "200201202";
        if (this.stg != null) {
            typeRaw = this.stg.getType().getRaw();
            typeRaw = "200201202".contains(typeRaw) ? "200201202" : typeRaw;
        }
        MxNode node = MxNodeFactory.create((String)"xswap_strategy_type", (String)typeRaw);
        ObservableList list = FxUtils.newList();
        list.addAll((Collection)node.getNodes());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String raw = ((MxNode)iterator.next()).getRaw();
            if ("200201202".equals(raw) || !"200201202".contains(raw)) continue;
            iterator.remove();
        }
        this.cmbType.setItems(list);
        this.cmbType.setValue((Object)node);
        this.registerCheck();
    }

    protected void initControls() {
        Map cfetsAccountMap = this.accntMng.getCfetsAccountMap();
        this.listAcc.setAll(cfetsAccountMap.values());
        this.cmbAccnt.setItems(this.listAcc);
        if (this.listAcc.size() > 0) {
            this.cmbAccnt.getSelectionModel().select(0);
        } else {
            this.accntMng.changedProperty().addListener((ob, old, now) -> {
                this.listAcc.setAll(this.accntMng.getCfetsAccountMap().values());
                this.cmbAccnt.setItems(this.listAcc);
                if (this.listAcc.size() > 0) {
                    this.cmbAccnt.getSelectionModel().select(0);
                }
            });
        }
        this.ref.changedProperty().addListener(ob -> this.suggest.setAllSuggestions(this.getRefItems()));
        this.suggest.addPossibleSuggestions(this.getRefItems());
        AutoCompletion auto = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.suggest, (StringConverter)((StringConverter)this.of.create(SecConverter.class)));
        auto.changedProperty().addListener((ob, old, now) -> this.onSecurityChange(this.txtCode, (String)now));
        this.txtCode.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
        this.lbName.setTooltip(new Tooltip());
        this.lbName.textProperty().bindBidirectional((Property)this.lbName.getTooltip().textProperty());
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5\\.]*", 32));
        this.radioBuy.setToggleGroup(this.groupBs);
        this.radioSell.setToggleGroup(this.groupBs);
        this.radioMkt.setToggleGroup(this.groupBs);
        this.groupBs.selectedToggleProperty().addListener(ob -> {
            this.rdoAttackBuy.setDisable(false);
            this.rdoDefendBuy.setDisable(false);
            this.rdoAttackSell.setDisable(false);
            this.rdoDefendSell.setDisable(false);
            this.txtFormulaBuy.setDisable(false);
            this.txtFormulaSell.setDisable(false);
            this.spnQtyBuy.setDisable(false);
            this.spnQtySell.setDisable(false);
            this.txtFormulaBuyCtd1.setDisable(false);
            this.txtFormulaBuyCtd2.setDisable(false);
            this.txtFormulaSellCtd1.setDisable(false);
            this.txtFormulaSellCtd2.setDisable(false);
            this.spnDiffBuy.setDisable(false);
            this.spnDiffSell.setDisable(false);
            this.txtBidUpLimit.setDisable(false);
            this.txtBidFloorLimit.setDisable(false);
            this.txtOfrUpLimit.setDisable(false);
            this.txtOfrFloorLimit.setDisable(false);
            this.lbFormulaBuyErr.setOpacity(0.0);
            this.lbFormulaSellErr.setOpacity(0.0);
            this.lbDiffBuyErr.setOpacity(0.0);
            this.lbDiffSellErr.setOpacity(0.0);
            this.lbQtyBuyErr.setOpacity(0.0);
            this.lbQtySellErr.setOpacity(0.0);
            this.lbFormulaBuyCtd1Err.setOpacity(0.0);
            this.lbFormulaBuyCtd2Err.setOpacity(0.0);
            this.lbFormulaSellCtd1Err.setOpacity(0.0);
            this.lbFormulaSellCtd2Err.setOpacity(0.0);
            if (this.radioBuy.isSelected()) {
                this.rdoAttackSell.setDisable(true);
                this.rdoDefendSell.setDisable(true);
                this.txtFormulaSell.setDisable(true);
                this.txtFormulaSell.clear();
                this.spnQtySell.setDisable(true);
                this.spnQtySell.getEditor().clear();
                this.txtFormulaBuyCtd1.setDisable(true);
                this.txtFormulaBuyCtd1.clear();
                this.txtFormulaBuyCtd2.setDisable(true);
                this.txtFormulaBuyCtd2.clear();
                this.spnDiffSell.setDisable(true);
                this.spnDiffSell.getEditor().clear();
                this.txtOfrUpLimit.setDisable(true);
                this.txtOfrUpLimit.clear();
                this.txtOfrFloorLimit.setDisable(true);
                this.txtOfrFloorLimit.clear();
            } else if (this.radioSell.isSelected()) {
                this.rdoAttackBuy.setDisable(true);
                this.rdoDefendBuy.setDisable(true);
                this.txtFormulaBuy.setDisable(true);
                this.txtFormulaBuy.clear();
                this.spnQtyBuy.setDisable(true);
                this.spnQtyBuy.getEditor().clear();
                this.txtFormulaSellCtd1.setDisable(true);
                this.txtFormulaSellCtd1.clear();
                this.txtFormulaSellCtd2.setDisable(true);
                this.txtFormulaSellCtd2.clear();
                this.spnDiffBuy.setDisable(true);
                this.spnDiffBuy.getEditor().clear();
                this.txtBidUpLimit.setDisable(true);
                this.txtBidUpLimit.clear();
                this.txtBidFloorLimit.setDisable(true);
                this.txtBidFloorLimit.clear();
            }
        });
        MxNode node = MxNodeFactory.create((String)"strategy_cancel_type", (String)"false");
        this.cmbCancelType.setItems(node.getNodes());
        this.cmbCancelType.setValue((Object)node);
        node = MxNodeFactory.createNew((String)"xswap_position_effect", (String)"79");
        this.cmbOcFlag.setItems(node.getNodes());
        this.cmbOcFlag.setValue((Object)node);
        this.txtBenchMarkFormula.setTooltip(new Tooltip());
        this.txtBenchMarkFormula.textProperty().bindBidirectional((Property)this.txtBenchMarkFormula.getTooltip().textProperty());
        this.spFormulaXswap.addPossibleSuggestions(new FormulaModel().values("xswap"));
        this.rdoAttackBuy.setToggleGroup(this.groupInvadeBuy);
        this.rdoDefendBuy.setToggleGroup(this.groupInvadeBuy);
        this.rdoAttackSell.setToggleGroup(this.groupInvadeSell);
        this.rdoDefendSell.setToggleGroup(this.groupInvadeSell);
        this.rdoAttackSell.setDisable(true);
        this.rdoDefendSell.setDisable(true);
        Search.bindAutoCompletion((TextField)this.txtFormulaBuy, (Callback)this.spFormulaXswap, (StringConverter)this.matchCt, (String)this.spFormulaXswap.getLocalSymbol());
        Search.bindAutoCompletion((TextField)this.txtFormulaSell, (Callback)this.spFormulaXswap, (StringConverter)this.matchCt, (String)this.spFormulaXswap.getLocalSymbol());
        this.txtFormulaBuy.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtFormulaSell.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtFormulaSell.setDisable(true);
        Search.bindAutoCompletion((TextField)this.txtBidUpLimit, (Callback)this.spFormulaXswap, (StringConverter)this.matchCt, (String)this.spFormulaXswap.getLocalSymbol());
        Search.bindAutoCompletion((TextField)this.txtBidFloorLimit, (Callback)this.spFormulaXswap, (StringConverter)this.matchCt, (String)this.spFormulaXswap.getLocalSymbol());
        Search.bindAutoCompletion((TextField)this.txtOfrUpLimit, (Callback)this.spFormulaXswap, (StringConverter)this.matchCt, (String)this.spFormulaXswap.getLocalSymbol());
        Search.bindAutoCompletion((TextField)this.txtOfrFloorLimit, (Callback)this.spFormulaXswap, (StringConverter)this.matchCt, (String)this.spFormulaXswap.getLocalSymbol());
        this.txtBidUpLimit.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtBidFloorLimit.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtOfrUpLimit.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtOfrFloorLimit.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtOfrUpLimit.setDisable(true);
        this.txtOfrFloorLimit.setDisable(true);
        this.txtHedgeBenchMark.setTooltip(new Tooltip());
        this.txtHedgeBenchMark.textProperty().bindBidirectional((Property)this.txtHedgeBenchMark.getTooltip().textProperty());
        this.spFormulaXbond.addPossibleSuggestions(new FormulaModel().values("xswap_xbond"));
        Search.bindAutoCompletion((TextField)this.txtFormulaBuyCtd1, (Callback)this.spFormulaXbond, (StringConverter)this.matchCt, (String)this.spFormulaXbond.getLocalSymbol()).setVisibleRowCount(6);
        Search.bindAutoCompletion((TextField)this.txtFormulaBuyCtd2, (Callback)this.spFormulaXbond, (StringConverter)this.matchCt, (String)this.spFormulaXbond.getLocalSymbol()).setVisibleRowCount(6);
        Search.bindAutoCompletion((TextField)this.txtFormulaSellCtd1, (Callback)this.spFormulaXbond, (StringConverter)this.matchCt, (String)this.spFormulaXbond.getLocalSymbol()).setVisibleRowCount(5);
        Search.bindAutoCompletion((TextField)this.txtFormulaSellCtd2, (Callback)this.spFormulaXbond, (StringConverter)this.matchCt, (String)this.spFormulaXbond.getLocalSymbol()).setVisibleRowCount(5);
        this.txtFormulaBuyCtd1.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtFormulaBuyCtd2.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtFormulaSellCtd1.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtFormulaSellCtd2.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtFormulaBuyCtd1.setDisable(true);
        this.txtFormulaBuyCtd2.setDisable(true);
        this.ctrlDiffBuy.ctrl(this.spnDiffBuy);
        this.ctrlDiffBuy.setUnit(0.005);
        this.spnDiffBuy.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnDiffBuy.getEditor()));
        this.ctrlDiffSell.ctrl(this.spnDiffSell);
        this.ctrlDiffSell.setUnit(0.005);
        this.spnDiffSell.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnDiffSell.getEditor()));
        this.spnDiffSell.setDisable(true);
        this.ctrlMinShift.ctrl(this.spnMinShift);
        this.ctrlMinShift.setUnit(0.005);
        this.spnMinShift.getEditor().setText("0.005");
        this.ctrlMaxDeal.ctrl(this.spnMaxDeal);
        this.ctrlMaxDeal.setUnit(1.0);
        this.ctrlCountBuy.ctrl(this.spnQtyBuy);
        this.ctrlCountBuy.setUnit(1.0);
        this.spnQtyBuy.getEditor().setOnMouseClicked(event -> this.spnQtyBuy.getEditor().selectAll());
        this.ctrlCountSell.ctrl(this.spnQtySell);
        this.ctrlCountSell.setUnit(1.0);
        this.spnQtySell.getEditor().setOnMouseClicked(event -> this.spnQtySell.getEditor().selectAll());
        this.spnQtySell.setDisable(true);
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.refItem = (StdBondForward)txtCode.getUserData();
        this.activeBenchmark = new ActiveBenchmarkPricingSettings();
        this.hedgeBenchmark = new HedgeBenchmarkPricingSettings();
        this.clearFormula();
        if (this.refItem != null) {
            this.lbName.setText(this.refItem.getName());
            List<StdBondForwardDeliver> list = this.deliverModel.getDeliver((RefItem)this.refItem);
            if (list == null || list.size() < 2) {
                return;
            }
            for (StdBondForwardDeliver deliver : list) {
                if (deliver.getActive() == 1) {
                    this.activeBenchmark.setBond1(this.deliverToBond(deliver));
                    this.hedgeBenchmark.setBond1(this.deliverToBond(deliver));
                    this.lbDeliver1.setText("\u3010" + deliver.getSecurityId() + "\u3011");
                    continue;
                }
                this.activeBenchmark.setBond2(this.deliverToBond(deliver));
                this.hedgeBenchmark.setBond2(this.deliverToBond(deliver));
                this.lbDeliver2.setText("\u3010" + deliver.getSecurityId() + "\u3011");
            }
        } else {
            this.lbName.setText("");
            this.lbDeliver1.setText("\u3010\u53ef\u4ea4\u5272\u52381\u3011");
            this.lbDeliver2.setText("\u3010\u53ef\u4ea4\u5272\u52382\u3011");
        }
    }

    private void clearFormula() {
        this.txtFormulaBuy.clear();
        this.lbFormulaBuyErr.setOpacity(0.0);
        this.txtFormulaSell.clear();
        this.lbFormulaSellErr.setOpacity(0.0);
        this.txtHedgeBenchMark.clear();
        this.lbHedgeBenchMarkErr.setOpacity(0.0);
        this.txtBenchMarkFormula.clear();
        this.lbBenchMarkFormulaErr.setOpacity(0.0);
        this.txtFormulaBuyCtd1.clear();
        this.lbFormulaBuyCtd1Err.setOpacity(0.0);
        this.txtFormulaBuyCtd2.clear();
        this.lbFormulaBuyCtd2Err.setOpacity(0.0);
        this.txtFormulaSellCtd1.clear();
        this.lbFormulaSellCtd1Err.setOpacity(0.0);
        this.txtFormulaSellCtd2.clear();
        this.lbFormulaSellCtd2Err.setOpacity(0.0);
    }

    private Instrument deliverToBond(StdBondForwardDeliver deliver) {
        Instrument inst = new Instrument();
        inst.setSecurityId(deliver.getSecurityId());
        inst.setSymbol(deliver.getName());
        inst.setSecurityType(deliver.getType());
        inst.setSecuritySubType("XcfeXBond");
        inst.setMarket(deliver.getMarket());
        return inst;
    }

    private Collection<RefItem> getRefItems() {
        Collection items = this.ref.getItems(new String[]{"SBFWD"});
        for (RefItem ref : items) {
            StdBondForward std;
            if (!(ref instanceof StdBondForward) || !(std = (StdBondForward)ref).getStatus().equals("B")) continue;
            this.listRef.add(ref);
        }
        return this.listRef;
    }

    protected void registerCheck() {
        this.mapValid.clear();
        this.registerCheck((Node)this.lbAccntErr, (ObservableBooleanValue)this.cmbAccnt.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtCode.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u4ee3\u7801");
                return false;
            }
            if (this.lbName.getText().isEmpty()) {
                this.lbCodeErr.setText("\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.textProperty(), this.lbName.textProperty()}));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtName.getText().isEmpty()) {
                this.lbNameErr.setText("\u8bf7\u8f93\u5165\u7b56\u7565\u540d\u79f0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtName.textProperty()}));
        this.registerCheck((Node)this.lbBenchMarkFormulaErr, (ObservableBooleanValue)this.txtBenchMarkFormula.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbHedgeBenchMarkErr, (ObservableBooleanValue)this.txtHedgeBenchMark.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbFormulaBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtFormulaBuy.isFocused()) {
                return true;
            }
            if (this.radioSell.isSelected()) {
                return true;
            }
            if (this.txtFormulaBuy.getText().isEmpty()) {
                this.lbFormulaBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u4ef7\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtFormulaBuy.focusedProperty(), this.txtFormulaBuy.textProperty(), this.radioSell.selectedProperty()}));
        this.registerCheck((Node)this.lbFormulaSellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtFormulaSell.isFocused()) {
                return true;
            }
            if (this.radioBuy.isSelected()) {
                return true;
            }
            if (this.txtFormulaSell.getText().isEmpty()) {
                this.lbFormulaSellErr.setText("\u8bf7\u8f93\u5165\u5356\u4ef7\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtFormulaSell.focusedProperty(), this.txtFormulaSell.textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbDiffBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("200201202")) {
                return true;
            }
            if (this.radioSell.isSelected()) {
                return true;
            }
            if (this.spnDiffBuy.getEditor().getText().isEmpty()) {
                this.lbDiffBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u4ef7\u70b9\u5dee");
                return false;
            }
            double number = StringUtils.parseDouble((String)this.spnDiffBuy.getEditor().getText()) * 1000.0;
            int integer = new BigDecimal(number).setScale(0, 4).intValue();
            if (integer % 5 != 0) {
                this.lbDiffBuyErr.setText("\u4e70\u4ef7\u70b9\u5dee\u9700\u4e3a0.005\u7684\u6574\u6570\u500d");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnDiffBuy.getEditor().textProperty(), this.radioSell.selectedProperty()}));
        this.registerCheck((Node)this.lbDiffSellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("200201202")) {
                return true;
            }
            if (this.radioBuy.isSelected()) {
                return true;
            }
            if (this.spnDiffSell.getEditor().getText().isEmpty()) {
                this.lbDiffSellErr.setText("\u8bf7\u8f93\u5165\u5356\u4ef7\u70b9\u5dee");
                return false;
            }
            double number = StringUtils.parseDouble((String)this.spnDiffSell.getEditor().getText()) * 1000.0;
            int integer = new BigDecimal(number).setScale(0, 4).intValue();
            if (integer % 5 != 0) {
                this.lbDiffSellErr.setText("\u5356\u4ef7\u70b9\u5dee\u9700\u4e3a0.005\u7684\u6574\u6570\u500d");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnDiffSell.getEditor().textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbBidUpLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtBidUpLimit.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("200201202")) {
                return true;
            }
            if (this.radioSell.isSelected()) {
                return true;
            }
            if (this.txtBidUpLimit.getText().isEmpty()) {
                this.lbBidUpLimitErr.setText("\u8bf7\u8f93\u5165BID\u4e0a\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtBidUpLimit.focusedProperty(), this.txtBidUpLimit.textProperty(), this.cmbType.valueProperty(), this.radioSell.selectedProperty()}));
        this.registerCheck((Node)this.lbBidFloorLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtBidFloorLimit.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("200201202")) {
                return true;
            }
            if (this.radioSell.isSelected()) {
                return true;
            }
            if (this.txtBidFloorLimit.getText().isEmpty()) {
                this.lbBidFloorLimitErr.setText("\u8bf7\u8f93\u5165BID\u4e0b\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtBidFloorLimit.focusedProperty(), this.txtBidFloorLimit.textProperty(), this.cmbType.valueProperty(), this.radioSell.selectedProperty()}));
        this.registerCheck((Node)this.lbOfrUpLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtOfrUpLimit.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("200201202")) {
                return true;
            }
            if (this.radioBuy.isSelected()) {
                return true;
            }
            if (this.txtOfrUpLimit.getText().isEmpty()) {
                this.lbOfrUpLimitErr.setText("\u8bf7\u8f93\u5165OFR\u4e0a\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtOfrUpLimit.focusedProperty(), this.txtOfrUpLimit.textProperty(), this.cmbType.valueProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbOfrFloorLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtOfrFloorLimit.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("200201202")) {
                return true;
            }
            if (this.radioBuy.isSelected()) {
                return true;
            }
            if (this.txtOfrFloorLimit.getText().isEmpty()) {
                this.lbOfrFloorLimitErr.setText("\u8bf7\u8f93\u5165OFR\u4e0b\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtOfrFloorLimit.focusedProperty(), this.txtOfrFloorLimit.textProperty(), this.cmbType.valueProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbMinShiftErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnMinShift.getEditor().getText().isEmpty()) {
                this.lbMinShiftErr.setText("\u8bf7\u8f93\u5165\u6700\u5c0f\u79fb\u52a8");
                return false;
            }
            if (this.getDouble(this.spnMinShift.getEditor()) == 0.0) {
                this.lbMinShiftErr.setText("\u6700\u5c0f\u79fb\u52a8\u5e94\u5927\u4e8e0");
                return false;
            }
            double number = StringUtils.parseDouble((String)this.spnMinShift.getEditor().getText()) * 1000.0;
            int integer = new BigDecimal(number).setScale(0, 4).intValue();
            if (integer % 5 != 0) {
                this.lbMinShiftErr.setText("\u6700\u5c0f\u79fb\u52a8\u9700\u4e3a0.005\u7684\u6574\u6570\u500d");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMinShift.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbMaxDealErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnMaxDeal.getEditor().getText().isEmpty()) {
                this.lbMaxDealErr.setText("\u8bf7\u8f93\u5165\u6700\u5927\u6210\u4ea4");
                return false;
            }
            if (this.getDouble(this.spnMaxDeal.getEditor()) == 0.0) {
                this.lbMaxDealErr.setText("\u6700\u5927\u6210\u4ea4\u5e94\u5927\u4e8e0");
                return false;
            }
            if (this.getDouble(this.spnMaxDeal.getEditor()) > 100.0) {
                this.lbMaxDealErr.setText("\u6700\u5927\u6210\u4ea4\u4e0a\u9650\u4e3a100");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMaxDeal.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbQtyBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.radioSell.isSelected()) {
                return true;
            }
            if (this.spnQtyBuy.getEditor().getText().isEmpty()) {
                this.lbQtyBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u5165\u6570\u91cf");
                return false;
            }
            if (this.getDouble(this.spnQtyBuy.getEditor()) == 0.0) {
                this.lbQtyBuyErr.setText("\u4e70\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            if (this.getDouble(this.spnQtyBuy.getEditor()) > 100.0) {
                this.lbQtyBuyErr.setText("\u4e70\u5165\u6570\u91cf\u4e0a\u9650\u4e3a100");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtyBuy.getEditor().textProperty(), this.radioSell.selectedProperty()}));
        this.registerCheck((Node)this.lbQtySellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.radioBuy.isSelected()) {
                return true;
            }
            if (this.spnQtySell.getEditor().getText().isEmpty()) {
                this.lbQtySellErr.setText("\u8bf7\u8f93\u5165\u5356\u51fa\u6570\u91cf");
                return false;
            }
            if (this.getDouble(this.spnQtySell.getEditor()) == 0.0) {
                this.lbQtySellErr.setText("\u5356\u51fa\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            if (this.getDouble(this.spnQtySell.getEditor()) > 100.0) {
                this.lbQtySellErr.setText("\u5356\u51fa\u6570\u91cf\u4e0a\u9650\u4e3a100");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtySell.getEditor().textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbFormulaBuyCtd1Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtFormulaBuyCtd1.isFocused()) {
                return true;
            }
            if (this.radioBuy.isSelected()) {
                return true;
            }
            if (this.txtFormulaBuyCtd1.getText().isEmpty()) {
                this.lbFormulaBuyCtd1Err.setText("\u8bf7\u8f93\u5165\u4e70\u4ef7\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtFormulaBuyCtd1.focusedProperty(), this.txtFormulaBuyCtd1.textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbFormulaSellCtd1Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtFormulaSellCtd1.isFocused()) {
                return true;
            }
            if (this.radioSell.isSelected()) {
                return true;
            }
            if (this.txtFormulaSellCtd1.getText().isEmpty()) {
                this.lbFormulaSellCtd1Err.setText("\u8bf7\u8f93\u5165\u5356\u4ef7\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtFormulaSellCtd1.focusedProperty(), this.txtFormulaSellCtd1.textProperty(), this.radioSell.selectedProperty()}));
        this.registerCheck((Node)this.lbFormulaBuyCtd2Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtFormulaBuyCtd2.isFocused()) {
                return true;
            }
            if (this.radioBuy.isSelected()) {
                return true;
            }
            if (this.txtFormulaBuyCtd2.getText().isEmpty()) {
                this.lbFormulaBuyCtd1Err.setText("\u8bf7\u8f93\u5165\u4e70\u4ef7\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtFormulaBuyCtd2.focusedProperty(), this.txtFormulaBuyCtd2.textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbFormulaSellCtd2Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtFormulaSellCtd2.isFocused()) {
                return true;
            }
            if (this.radioSell.isSelected()) {
                return true;
            }
            if (this.txtFormulaSellCtd2.getText().isEmpty()) {
                this.lbFormulaSellCtd2Err.setText("\u8bf7\u8f93\u5165\u5356\u4ef7\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtFormulaSellCtd2.focusedProperty(), this.txtFormulaSellCtd2.textProperty(), this.radioSell.selectedProperty()}));
    }

    @FXML
    protected void benchMarkFormulaSet() {
        boolean isNull;
        if (!this.alert.check(this.refItem != null, Alert.AlertType.WARNING, "\u8bf7\u5148\u8f93\u5165\u5408\u7ea6\u4ee3\u7801!")) {
            return;
        }
        boolean bl = isNull = this.activeBenchmark.getBond1() != null || this.activeBenchmark.getBond2() != null;
        if (!this.alert.check(isNull, Alert.AlertType.WARNING, "\u8be5\u5408\u7ea6\u5bf9\u5e94\u7684\u53ef\u4ea4\u5272\u5238\u4e0d\u5b58\u5728\uff01")) {
            return;
        }
        InitiativeBenchmarkDialog obj = (InitiativeBenchmarkDialog)((Object)this.of.create(InitiativeBenchmarkDialog.class));
        obj.setRefItem(this.refItem, this.activeBenchmark);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u8bbe\u7f6e\u4e3b\u52a8\u57fa\u51c6");
        if (dialog.launch() == ButtonType.OK) {
            this.refreshBenchMarkFormula();
        }
    }

    private void refreshBenchMarkFormula() {
        String format = "Cal_Bas_P(%s, %s, %s)";
        String formula1 = this.activeBenchmark.getBond1YtmFormula();
        String formula2 = this.activeBenchmark.getBond2YtmFormula();
        String benchMarkFormula = String.format(format, formula1, formula2, this.activeBenchmark.getCapitalCost());
        this.txtBenchMarkFormula.setText(benchMarkFormula);
    }

    @FXML
    protected void hedgeBenchMarkSet() {
        boolean isNull;
        if (!this.alert.check(this.refItem != null, Alert.AlertType.WARNING, "\u8bf7\u5148\u8f93\u5165\u5408\u7ea6\u4ee3\u7801!")) {
            return;
        }
        boolean bl = isNull = this.hedgeBenchmark.getBond1() != null || this.hedgeBenchmark.getBond2() != null;
        if (!this.alert.check(isNull, Alert.AlertType.WARNING, "\u8be5\u5408\u7ea6\u5bf9\u5e94\u7684\u53ef\u4ea4\u5272\u5238\u4e0d\u5b58\u5728\uff01")) {
            return;
        }
        HedgeBenchmarkDialog obj = (HedgeBenchmarkDialog)((Object)this.of.create(HedgeBenchmarkDialog.class));
        obj.setRefItem(this.refItem, this.hedgeBenchmark);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u8bbe\u7f6e\u5bf9\u51b2\u57fa\u51c6");
        if (dialog.launch() == ButtonType.OK) {
            this.refreshHedgeBenchmark();
        }
    }

    private void refreshHedgeBenchmark() {
        String format = "Cal_Hedge_P(%s, %s, %s)";
        String formula = this.hedgeBenchmark.getFormula();
        String spread = this.hedgeBenchmark.getSpread() == null ? "0" : this.hedgeBenchmark.getSpread();
        String benchMarkFormula = String.format(format, formula, spread, this.hedgeBenchmark.getCapitalCost());
        this.txtHedgeBenchMark.setText(benchMarkFormula);
    }

    protected XSwapStrategy getStrategy() throws Exception, MException {
        XSwapStrategy strategy = new XSwapStrategy();
        if (this.stg != null) {
            strategy.setContextId(this.stg.getContextId());
            strategy.setTemplate(this.stg.isTemplate());
        }
        CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
        String extFundAccntId = account.getNewCashAccntId();
        String parentExtAccntId = account.getParentId();
        String extSecAccntId = null;
        try {
            Map mapAccount = this.secAccService.getAllSecAccountMap();
            List list = (List)mapAccount.get(account);
            if (list != null && list.size() > 0) {
                extSecAccntId = ((SecAccount)list.get(0)).getExtSecAccntId();
            }
        }
        catch (MException mException) {}
        strategy.setParentExtAccntId(parentExtAccntId);
        strategy.setExtFundAccntId(extFundAccntId);
        strategy.setExtSecAccntId(extSecAccntId);
        strategy.setMarket(this.refItem.getMarket());
        strategy.setSecurityType(this.refItem.getType());
        strategy.setSecurityId(this.txtCode.getText());
        strategy.setSecurityName(this.refItem.getName());
        MxNode type = (MxNode)this.cmbType.getSelectionModel().getSelectedItem();
        strategy.setType(type);
        strategy.setName(this.txtName.getText());
        String customBs = "202";
        if (this.radioBuy.isSelected()) {
            customBs = "200";
        } else if (this.radioSell.isSelected()) {
            customBs = "201";
        }
        strategy.setCancelType((MxNode)this.cmbCancelType.getValue());
        strategy.setCustomBs(customBs);
        strategy.setPositionEffect((MxNode)this.cmbOcFlag.getValue());
        strategy.setAttackBuy(this.rdoAttackBuy.isSelected());
        strategy.setAttackSell(this.rdoAttackSell.isSelected());
        strategy.setBidRefPriceFormula(this.txtFormulaBuy.getText());
        strategy.setOfferRefPriceFormula(this.txtFormulaSell.getText());
        if (!this.spnDiffBuy.getEditor().getText().isEmpty()) {
            strategy.setBidSpread(this.getDouble(this.spnDiffBuy.getEditor()));
        }
        if (!this.spnDiffSell.getEditor().getText().isEmpty()) {
            strategy.setAskSpread(this.getDouble(this.spnDiffSell.getEditor()));
        }
        if (!this.spnQtyBuy.getEditor().getText().isEmpty()) {
            strategy.setBidQty(this.getDouble(this.spnQtyBuy.getEditor()));
        }
        if (!this.spnQtySell.getEditor().getText().isEmpty()) {
            strategy.setOfferQty(this.getDouble(this.spnQtySell.getEditor()));
        }
        if (!this.spnMinShift.getEditor().getText().isEmpty()) {
            strategy.setBidPriceSlip(this.getDouble(this.spnMinShift.getEditor()));
        }
        if (!this.spnMaxDeal.getEditor().getText().isEmpty()) {
            strategy.setMaxDeal(this.getDouble(this.spnMaxDeal.getEditor()));
        }
        strategy.setBidUpLimit(this.txtBidUpLimit.getText());
        strategy.setBidFloorLimit(this.txtBidFloorLimit.getText());
        strategy.setOfferUpLimit(this.txtOfrUpLimit.getText());
        strategy.setOfferFloorLimit(this.txtOfrFloorLimit.getText());
        strategy.setBid1HedgePriceFormula(this.txtFormulaBuyCtd1.getText());
        strategy.setBid2HedgePriceFormula(this.txtFormulaBuyCtd2.getText());
        strategy.setOffer1HedgePriceFormula(this.txtFormulaSellCtd1.getText());
        strategy.setOffer2HedgePriceFormula(this.txtFormulaSellCtd2.getText());
        strategy.setActiveBenchmark(this.activeBenchmark);
        strategy.setHedgeBenchmark(this.hedgeBenchmark);
        return strategy;
    }

    private double getDouble(TextField txt) {
        return StringUtils.parseDouble((String)txt.getText());
    }

    public void fillDialog() {
        for (CfetsFundAccount account : this.accntMng.getCfetsAccountMap().values()) {
            if (!this.stg.getExtFundAccntId().equals(account.getNewCashAccntId())) continue;
            this.cmbAccnt.getSelectionModel().select((Object)account);
        }
        this.cmbAccnt.setDisable(true);
        this.txtCode.setText(this.stg.getSecurityId());
        StdBondForward refItem = (StdBondForward)this.refMng.getItem("SBFWD", this.stg.getMarket(), this.stg.getSecurityId());
        this.txtCode.setUserData((Object)refItem);
        if (refItem != null) {
            this.lbName.setText(refItem.getName());
            this.onSecurityChange(this.txtCode, "");
        } else {
            this.lbName.setText("");
        }
        this.txtName.setText(this.stg.getName());
        switch (this.stg.getType().getRaw()) {
            case "200": {
                this.groupBs.selectToggle((Toggle)this.radioBuy);
                break;
            }
            case "201": {
                this.groupBs.selectToggle((Toggle)this.radioSell);
                break;
            }
            case "202": {
                this.groupBs.selectToggle((Toggle)this.radioMkt);
                break;
            }
            default: {
                return;
            }
        }
        this.cmbCancelType.setValue((Object)this.stg.getCancelType());
        this.cmbOcFlag.setValue((Object)this.stg.getPositionEffect());
        this.activeBenchmark = this.stg.getActiveBenchmark();
        this.refreshBenchMarkFormula();
        this.groupInvadeBuy.selectToggle((Toggle)(this.stg.isAttackBuy() ? this.rdoAttackBuy : this.rdoDefendBuy));
        this.groupInvadeSell.selectToggle((Toggle)(this.stg.isAttackSell() ? this.rdoAttackSell : this.rdoDefendSell));
        this.txtFormulaBuy.setText(this.stg.getBidRefPriceFormula());
        this.txtFormulaSell.setText(this.stg.getOfferRefPriceFormula());
        this.spnDiffBuy.getEditor().setText(StringUtils.toThousands((Number)this.stg.getBidSpread(), (int)3));
        this.spnDiffSell.getEditor().setText(StringUtils.toThousands((Number)this.stg.getAskSpread(), (int)3));
        this.txtBidUpLimit.setText(this.stg.getBidUpLimit());
        this.txtBidFloorLimit.setText(this.stg.getBidFloorLimit());
        this.txtOfrUpLimit.setText(this.stg.getOfferUpLimit());
        this.txtOfrFloorLimit.setText(this.stg.getOfferFloorLimit());
        this.spnMinShift.getEditor().setText(StringUtils.toThousands((Number)this.stg.getBidPriceSlip(), (int)3));
        this.spnMaxDeal.getEditor().setText(StringUtils.toThousands((Number)this.stg.getMaxDeal(), (int)1));
        this.spnQtyBuy.getEditor().setText(String.valueOf(this.stg.getBidQty()));
        this.spnQtySell.getEditor().setText(String.valueOf(this.stg.getOfferQty()));
        this.hedgeBenchmark = this.stg.getHedgeBenchmark();
        this.refreshHedgeBenchmark();
        this.txtFormulaBuyCtd1.setText(this.stg.getBid1HedgePriceFormula());
        this.txtFormulaBuyCtd2.setText(this.stg.getBid2HedgePriceFormula());
        this.txtFormulaSellCtd1.setText(this.stg.getOffer1HedgePriceFormula());
        this.txtFormulaSellCtd2.setText(this.stg.getOffer2HedgePriceFormula());
    }
}

