/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XRepoUnfinishedOrderModel;
import cms.tmx.bond.views.XBondUnfinishedOrderPart;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.utils.RespResult;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XRepoUnfinishedOrderPart
extends MxPart {
    private final Logger logger = LogManager.getLogger(XBondUnfinishedOrderPart.class);
    @FXML
    private TableView<Order> tableXBondUnfinished;
    @FXML
    private TableColumn<Order, String> ordCategory;
    @FXML
    private TableColumn<Order, MxNode> settlType;
    @FXML
    private TableColumn<Order, MxNode> side;
    @FXML
    private TableColumn<Order, Number> orderQty;
    @FXML
    private TableColumn<Order, Number> cumQty;
    @FXML
    private TableColumn<Order, Number> leavesQty;
    @FXML
    private TableColumn<Order, String> errInfo;
    @FXML
    private CheckBox cbxAll;
    @FXML
    private TextField searchText;
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @FXML
    private Button btnAllOrderCancel;
    @Inject
    private XRepoUnfinishedOrderModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    protected CcsCancelFactory ccf;
    @Inject
    private UserPreOrderTips setTips;
    protected MxList<Order> mxList = new MxList();
    private Predicate<Order> pd = t -> {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        String name = t.getInstrument().getSymbol().toUpperCase();
        String orderId = t.getOrderId();
        if (!SingleOrder.CAN_CANCEL_STATUS.contains(t.getOrdStatus().getValue())) {
            return false;
        }
        boolean bTxt = code.contains(text) || orderId.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        String sourceId = "";
        if (t.getExecMode() != null) {
            sourceId = String.valueOf(t.getExecMode().getEmId()).toUpperCase();
        }
        String source = t.getSource().trim().toUpperCase();
        boolean bStrategy = sourceId.contains(txtStrategy) || source.contains(txtStrategy);
        String txtTrader = this.searchTextTrader.getText().trim().toUpperCase();
        String traderId = t.getTraderId().toUpperCase();
        boolean bTrader = traderId.contains(txtTrader);
        return bTxt && bStrategy && bTrader;
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        ObservableList<Order> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
        this.tableXBondUnfinished.refresh();
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList<Order> newList = new ArrayList<Order>();
        ObservableList<Order> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<Order>)this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableXBondUnfinished.refresh();
        });
    }

    @FXML
    private void initialize() {
        long start = System.currentTimeMillis();
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.searchTextStrategy.textProperty().addListener(this.lstnSearch);
        this.searchTextTrader.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
        this.createTableView();
        this.refresh();
        this.cbxAll.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getList();
            synchronized (observableList) {
                this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
        System.err.println("order part init" + (System.currentTimeMillis() - start));
    }

    @PreDestroy
    protected void preDestroy() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.searchTextStrategy.textProperty().removeListener(this.lstnSearch);
        this.searchTextTrader.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    @FXML
    private void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55")) {
            return;
        }
        if (this.createDialog((List<Order>)list, "\u64a4\u5355\u786e\u8ba4")) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        RespResult result = this.model.orderCancel((List<Order>)list);
        Alert.AlertType aType = result.hasFailed() ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION;
        this.alert.check(!this.setTips.getOrderTips(), aType, result.getDesc("\u64a4\u5355\u63d0\u4ea4"));
    }

    @FXML
    private void allOrderCancel() {
        ObservableList list = this.mxList.getList();
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55")) {
            return;
        }
        if (this.createDialog((List<Order>)list, "\u64a4\u5355\u786e\u8ba4")) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        RespResult result = this.model.orderCancel((List<Order>)list);
        Alert.AlertType aType = result.hasFailed() ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION;
        this.alert.check(!this.setTips.getOrderTips(), aType, result.getDesc("\u64a4\u5355\u63d0\u4ea4"));
    }

    private boolean createDialog(List<Order> list, String dialogName) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)this.of.create(CcsCancelConfirmDialog.class);
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (Order or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle("", "");
            en.setSec(or.getInstrument().getSecurityId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInvestorSecId());
            en.setSecType(or.getInstrument().getSecurityType());
            en.setMarket(or.getInstrument().getMarket());
            en.setOrderType(Integer.valueOf(or.getOrdType().getValue()).intValue());
            en.setSide(new MxNode().load("side", or.getSide().getValue()));
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            en.setQuantity((long)(or.getOrderQty() - or.getCumQty()));
            en.setPrice(or.getPrice());
            en.setAmt((double)en.getQuantity() * en.getPrice());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, dialogName);
        return dialog.launch() != ButtonType.OK;
    }

    private void createTableView() {
        TableUtils.initValueFactory(this.tableXBondUnfinished);
        this.settlType.setCellValueFactory(cell -> {
            String raw = "2";
            if (((Order)cell.getValue()).getSettlType() != null) {
                raw = String.valueOf(((Order)cell.getValue()).getSettlType().ordinal());
            }
            return new SimpleObjectProperty((Object)new MxNode().load("settl_type", raw));
        });
        this.side.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("side", ((Order)cell.getValue()).getSide().getValue())));
        this.orderQty.setCellFactory(data -> new DoubleTableCell(1));
        this.cumQty.setCellFactory(data -> new DoubleTableCell(1));
        this.leavesQty.setCellFactory(data -> new DoubleTableCell(1));
        this.errInfo.setCellFactory(data -> new TooltipTableCell<Order, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((Order)this.getValue()).getErrInfo();
            }
        });
        this.tableXBondUnfinished.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableXBondUnfinished.setItems(this.mxList.getList());
    }

    @FXML
    private void refresh() {
        this.model.query();
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableXBondUnfinished, (String)"\u672a\u5b8c\u6210\u8ba2\u5355\u7ba1\u7406", (int)1, (int)(this.tableXBondUnfinished.getColumns().size() - 1));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableXBondUnfinished, (int)1, (int)0);
    }
}

