/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.algorithm.models.AlgoConfControls;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.bond.SecFormatter;
import cms.tmx.bond.models.XRepoStrategyModel;
import cms.tmx.bond.models.XRepoTradeModel;
import cms.tmx.bond.models.XRepoUnfinishedOrderModel;
import cms.tmx.bond.views.ICallBack;
import cms.tmx.bond.views.XRepoConfirmDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.Formatter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.http.RefDataMng;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfoXRepo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.XRepConfirmEntrust;
import cms.tmx.entity.trade.XRepoStrategy;
import cms.tmx.http.api.strategy.dto.CalcAccruedInterestResp;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.utils.RespResult;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;

public class XRepoTradePart
extends MxPart
implements ICallBack {
    @FXML
    private TreeTableView<HandicapInfoXRepo> treeTableMkt;
    @FXML
    private TreeTableColumn<HandicapInfoXRepo, Number> rows;
    @FXML
    private TreeTableColumn<HandicapInfoXRepo, String> code;
    @FXML
    private TreeTableColumn<HandicapInfoXRepo, Number> bidQty;
    @FXML
    private TreeTableColumn<HandicapInfoXRepo, Number> bidPrice;
    @FXML
    private TreeTableColumn<HandicapInfoXRepo, Number> offerQty;
    @FXML
    private TreeTableColumn<HandicapInfoXRepo, Number> offerPrice;
    @FXML
    private TabPane tabParam;
    @FXML
    private Tab tabNormal;
    @FXML
    private Tab tabStrategy;
    @FXML
    private VBox vbxParam;
    @FXML
    private GridPane paneHidden;
    @FXML
    private ComboBox<CfetsFundAccount> cmbAccnt;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private RadioButton rdoOffer;
    @FXML
    private RadioButton rdoBid;
    @FXML
    private ComboBox<MxNode> cmbOrdType;
    @FXML
    private Label lbPrice;
    @FXML
    private Spinner<Double> spnPrice;
    @FXML
    private Spinner<Integer> spnQty;
    @FXML
    private Label lbUnit;
    @FXML
    private ComboBox<MxNode> cmbSettlType;
    @FXML
    private ComboBox<String> cmbRepoWay;
    @FXML
    private Label lbArrow;
    @FXML
    private TextField txtStartHour;
    @FXML
    private TextField txtStartMinute;
    @FXML
    private TextField txtStartSecond;
    @FXML
    private TextField txtEndHour;
    @FXML
    private TextField txtEndMinute;
    @FXML
    private TextField txtEndSecond;
    @FXML
    private Label lbFirstDate;
    @FXML
    private Label lbDuedate;
    @FXML
    private Label lbDays;
    @FXML
    private Label lbRepoInterest;
    @FXML
    private Label lbDueAmount;
    @Inject
    private MxAlert alert;
    @Inject
    private CcsAccountMap accntMng;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private XRepoTradeModel model;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private ISecAccountService secAccService;
    @Inject
    private MarketDataModel mktModel;
    @Inject
    private AlgoConfControls algoConf;
    @Inject
    private XRepoStrategyModel strategyModel;
    @Inject
    private XRepoUnfinishedOrderModel unfinishedModel;
    @Inject
    private IBaseApi base;
    @Inject
    private RefDataMng refDataMng;
    private SecSuggest suggest = new SecSuggest(true);
    private ToggleGroup group = new ToggleGroup();
    private DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 2);
    private IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 1);
    private ObservableList<CfetsFundAccount> obList = FxUtils.newList();
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private Map<String, TreeItem<HandicapInfoXRepo>> mapParent = new HashMap<String, TreeItem<HandicapInfoXRepo>>();
    private Map<String, MarketItem> mapMkt = new HashMap<String, MarketItem>();
    private InvalidationListener lstnUnfinish = ob -> this.resetAll();
    private static int amB = 32400;
    private static int amE = 43200;
    private static int pmB = 48600;
    private static int pmE = 59700;
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private Callback<TreeTableColumn<HandicapInfoXRepo, Number>, TreeTableCell<HandicapInfoXRepo, Number>> checkBoxFactory = p -> new TreeTableCell<HandicapInfoXRepo, Number>(){

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
            } else {
                if (this.getTreeTableRow().getItem() != null) {
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    if (((HandicapInfoXRepo)treeItem.getValue()).getCode().isEmpty()) {
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    if (!treeItem.isExpanded() && item != null && item.doubleValue() > 1.0) {
                        this.setText("         " + item.toString());
                        return;
                    }
                }
                this.setText(null);
            }
        }
    };

    @FXML
    public void initialize() {
        this.createTable();
        this.initControls();
        this.subMktItem();
        this.unfinishedModel.changedProperty().addListener(this.lstnUnfinish);
        if (this.unfinishedModel.getList().isEmpty()) {
            this.unfinishedModel.query();
        } else {
            this.lstnUnfinish.invalidated(null);
        }
    }

    private void createTable() {
        TreeItem root = new TreeItem();
        this.treeTableMkt.setRoot(root);
        this.treeTableMkt.setShowRoot(false);
        this.rows.setCellValueFactory(cell -> ((HandicapInfoXRepo)cell.getValue().getValue()).rowsProperty());
        this.rows.setCellFactory(this.checkBoxFactory);
        this.code.setCellValueFactory(cell -> ((HandicapInfoXRepo)cell.getValue().getValue()).codeProperty());
        this.bidQty.setCellValueFactory(cell -> ((HandicapInfoXRepo)cell.getValue().getValue()).bidQtyProperty());
        this.bidPrice.setCellValueFactory(cell -> ((HandicapInfoXRepo)cell.getValue().getValue()).bidPriceProperty());
        this.offerQty.setCellValueFactory(cell -> ((HandicapInfoXRepo)cell.getValue().getValue()).offerQtyProperty());
        this.offerPrice.setCellValueFactory(cell -> ((HandicapInfoXRepo)cell.getValue().getValue()).offerPriceProperty());
        this.bidQty.setCellFactory(cell -> new NumberTreeCell(false, true));
        this.bidPrice.setCellFactory(cell -> new NumberTreeCell(false, false));
        this.offerQty.setCellFactory(cell -> new NumberTreeCell(true, true));
        this.offerPrice.setCellFactory(cell -> new NumberTreeCell(true, false));
        TableUtils.initScroll(this.treeTableMkt, (StringConverter)new StringConverter<HandicapInfoXRepo>(){

            public String toString(HandicapInfoXRepo object) {
                return object.getCode();
            }

            public HandicapInfoXRepo fromString(String string) {
                return null;
            }
        });
    }

    private void initControls() {
        this.vbxParam.getChildren().remove((Object)this.txtStartHour.getParent().getParent());
        this.vbxParam.getChildren().remove((Object)this.txtEndHour.getParent().getParent());
        this.tabParam.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            old.setContent(null);
            now.setContent((Node)this.vbxParam);
            if (now.equals(this.tabNormal)) {
                this.vbxParam.getChildren().add(3, (Object)this.cmbOrdType.getParent());
                this.vbxParam.getChildren().remove((Object)this.txtStartHour.getParent().getParent());
                this.vbxParam.getChildren().remove((Object)this.txtEndHour.getParent().getParent());
                this.lbPrice.setText("\u4ea4\u6613\u4ef7\u683c");
            } else {
                this.vbxParam.getChildren().remove((Object)this.cmbOrdType.getParent());
                this.vbxParam.getChildren().add(5, (Object)this.txtStartHour.getParent().getParent());
                this.vbxParam.getChildren().add(6, (Object)this.txtEndHour.getParent().getParent());
                this.lbPrice.setText("\u4ef7\u683c\u4e0a\u9650");
            }
        });
        this.initFunds();
        this.txtCode.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
        this.refMng.changedProperty().addListener((ob, old, now) -> this.suggest.setAllSuggestions(this.getRefItems()));
        this.suggest.addPossibleSuggestions(this.getRefItems());
        AutoCompletion auto = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.suggest, (StringConverter)((StringConverter)this.of.create(SecConverter.class)));
        auto.changedProperty().addListener((ob, old, now) -> this.onSecurityChange(this.txtCode, (String)now));
        TooltipUtil.bind((Label)this.lbName);
        this.rdoOffer.setToggleGroup(this.group);
        this.rdoBid.setToggleGroup(this.group);
        this.group.selectToggle((Toggle)this.rdoOffer);
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            this.lbPrice.setText(this.rdoOffer.equals(now) ? "\u4ef7\u683c\u4e0a\u9650" : "\u4ef7\u683c\u4e0b\u9650");
            this.model.setOffer(this.rdoOffer.equals(now));
        });
        MxNode node = MxNodeFactory.create((String)"xrepo_ord_type", (String)"0");
        this.cmbOrdType.valueProperty().bindBidirectional(this.model.ordTypeProperty());
        this.cmbOrdType.setItems(node.getNodes());
        this.cmbOrdType.setValue((Object)node);
        MxBindings.bindSD((Property)this.spnPrice.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.spnPrice.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.ctrlPrice.ctrl(this.spnPrice);
        this.spnPrice.getEditor().textProperty().addListener((ob, old, now) -> {
            if (StringUtils.parseDouble((String)old) != StringUtils.parseDouble((String)now)) {
                this.model.calcAccruedInterest(this);
            }
        });
        MxBindings.bindSD((Property)this.spnQty.getEditor().textProperty(), (Property)this.model.countProperty());
        this.spnQty.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$", 10));
        this.ctrlCount.ctrl(this.spnQty);
        this.spnQty.getEditor().textProperty().addListener((ob, old, now) -> {
            if (StringUtils.parseDouble((String)old) != StringUtils.parseDouble((String)now)) {
                this.model.calcAccruedInterest(this);
            }
        });
        node = new MxNode().load("settl_type", "1");
        this.cmbSettlType.valueProperty().bindBidirectional(this.model.settlTypeProperty());
        this.cmbSettlType.setItems(node.getNodes());
        this.cmbSettlType.setValue((Object)node);
        this.cmbSettlType.setDisable(true);
        this.cmbRepoWay.setValue((Object)"\u53cc\u8fb9\u56de\u8d2d");
        this.cmbRepoWay.setDisable(true);
        FxUtils.makePC((Node)this.lbArrow, (String)"left", (boolean)true);
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtEndHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtEndMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartSecond.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtEndSecond.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtEndHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.txtEndMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndMinute.selectAll());
        this.txtStartSecond.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartSecond.selectAll());
        this.txtEndSecond.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndSecond.selectAll());
    }

    private void doOrderFill(TreeTableRow<HandicapInfoXRepo> row, TreeTableColumn<HandicapInfoXRepo, Number> column) {
        double qty;
        RefItem refItem;
        TreeItem treeItem = row.getTreeItem();
        HandicapInfoXRepo info = (HandicapInfoXRepo)treeItem.getValue();
        String code = info.getCode();
        if (code.isEmpty()) {
            code = ((HandicapInfoXRepo)treeItem.getParent().getValue()).getCode();
        }
        boolean isBid = this.bidQty.equals(column) || this.bidPrice.equals(column);
        RadioButton rdo = isBid ? this.rdoBid : this.rdoOffer;
        rdo.setSelected(true);
        this.model.refItem = refItem = this.refDataMng.getItem("REPOXCFE", "XCFE", code);
        this.txtCode.setUserData((Object)refItem);
        this.txtCode.setText(refItem.getCode());
        this.lbName.setText(refItem.getName());
        this.lbUnit.setText(refItem.getCode().contains("mini") ? "(\u5343\u4e07)" : "(\u4ebf)");
        this.cmbOrdType.setValue((Object)MxNodeFactory.create((String)"xrepo_ord_type", (String)"1"));
        double price = isBid ? info.getBidPrice() : info.getOfferPrice();
        double d = qty = isBid ? info.getBidQty() : info.getOfferQty();
        if (refItem.getCode().contains("mini")) {
            qty *= 10.0;
        }
        this.spnPrice.getEditor().setText(String.valueOf(price));
        this.spnQty.getEditor().setText(String.valueOf((int)qty));
    }

    private void subMktItem() {
        Collection<RefItem> items = this.getRefItems();
        for (RefItem item : items) {
            MarketItem mktItem = this.mktModel.createItem(10);
            mktItem.setRefItem(item);
            this.mapMkt.put(item.getCode(), mktItem);
            TreeItem<HandicapInfoXRepo> treeParent = this.createItem(mktItem);
            this.treeTableMkt.getRoot().getChildren().add(treeParent);
            mktItem.changedProperty().addListener(ob -> {
                List<HandicapInfoXRepo> list = this.resetOwn(item);
                this.resetTreeItem(item, treeParent, list);
            });
        }
        this.mktModel.subMarketItems(new LinkedList<RefItem>(items));
    }

    private void resetTreeItem(RefItem item, TreeItem<HandicapInfoXRepo> treeParent, List<HandicapInfoXRepo> list) {
        treeParent.getChildren().clear();
        int i = 0;
        while (i < list.size()) {
            if (i == 0) {
                ((HandicapInfoXRepo)treeParent.getValue()).update((Object)list.get(i));
                ((HandicapInfoXRepo)treeParent.getValue()).setCode(item.getCode());
                ((HandicapInfoXRepo)treeParent.getValue()).setName(item.getName());
            } else {
                TreeItem treeItem = new TreeItem();
                treeItem.setValue((Object)list.get(i));
                treeParent.getChildren().add((Object)treeItem);
            }
            ++i;
        }
        Platform.runLater(() -> this.treeTableMkt.layout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAll() {
        HashMap<String, LinkedList<Order>> mapOrder = new HashMap<String, LinkedList<Order>>();
        ObservableList<Order> observableList = this.unfinishedModel.getList();
        synchronized (observableList) {
            LinkedList<HandicapInfoXRepo> list;
            for (Order ord : this.unfinishedModel.getList()) {
                list = (LinkedList<Order>)mapOrder.get(ord.getSecurityId());
                if (list == null) {
                    list = new LinkedList<Order>();
                    mapOrder.put(ord.getSecurityId(), list);
                }
                list.add((HandicapInfoXRepo)ord);
            }
            for (Map.Entry<String, TreeItem<HandicapInfoXRepo>> entry : this.mapParent.entrySet()) {
                list = this.resetMkt(entry.getKey(), (List)mapOrder.get(entry.getKey()));
                RefItem item = this.refDataMng.getItem("REPOXCFE", "XCFE", entry.getKey());
                this.resetTreeItem(item, entry.getValue(), list);
            }
        }
    }

    private List<HandicapInfoXRepo> resetMkt(String code, List<Order> listOrder) {
        double optimalPx;
        HandicapInfoXRepo optimalInfo;
        LinkedList<HandicapInfoXRepo> listMkt = new LinkedList<HandicapInfoXRepo>();
        MarketItem mktItem = this.mapMkt.get(code);
        if (listOrder == null || listOrder.isEmpty()) {
            return mktItem.getListRepoHandicap().filtered(p -> p.getBidPrice() > 0.0 || p.getOfferPrice() > 0.0);
        }
        ArrayList<Object> listMktBid = new ArrayList<Object>();
        ArrayList<Object> listMktOffer = new ArrayList<Object>();
        for (HandicapInfoXRepo repo : mktItem.getListRepoHandicap()) {
            double offerPrice;
            double bidPrice = repo.getBidPrice();
            if (bidPrice > 0.0) {
                HandicapInfoXRepo info = new HandicapInfoXRepo();
                info.setClear(false);
                info.setBidPrice(bidPrice);
                info.setBidQty(repo.getBidQty());
                info.setBidDealQty(repo.getBidDealQty());
                listMktBid.add(info);
            }
            if (!((offerPrice = repo.getOfferPrice()) > 0.0)) continue;
            HandicapInfoXRepo info = new HandicapInfoXRepo();
            info.setClear(false);
            info.setOfferPrice(offerPrice);
            info.setOfferQty(repo.getOfferQty());
            info.setOfferDealQty(repo.getOfferDealQty());
            listMktOffer.add(info);
        }
        HashMap<Double, HandicapInfoXRepo> mapBid = new HashMap<Double, HandicapInfoXRepo>();
        HashMap mapOffer = new HashMap();
        for (Order order : listOrder) {
            HashMap<Double, Object> map = order.getSide() == Side.SIDE_BID ? mapBid : mapOffer;
            HandicapInfoXRepo info = (HandicapInfoXRepo)map.get(order.getPrice());
            if (info == null) {
                info = new HandicapInfoXRepo();
                info.setClear(false);
                map.put(order.getPrice(), info);
            }
            if (order.getSide() == Side.SIDE_BID) {
                info.addBidUserId(order.getUserId());
                info.setBidPrice(order.getPrice());
                info.setBidQty((double)((int)(info.getBidQty() + order.getLeavesQty())));
                continue;
            }
            info.addOfferUserId(order.getUserId());
            info.setOfferPrice(order.getPrice());
            info.setOfferQty((double)((int)(info.getOfferQty() + order.getLeavesQty())));
        }
        if (!listMktBid.isEmpty() && (optimalInfo = (HandicapInfoXRepo)mapBid.get(optimalPx = ((HandicapInfoXRepo)listMktBid.get(0)).getBidPrice())) != null) {
            ((HandicapInfoXRepo)listMktBid.get(0)).setBidUserId(optimalInfo.getBidUserId());
            mapBid.remove(optimalPx);
        }
        if (!listMktOffer.isEmpty() && (optimalInfo = (HandicapInfoXRepo)mapOffer.get(optimalPx = ((HandicapInfoXRepo)listMktOffer.get(0)).getOfferPrice())) != null) {
            ((HandicapInfoXRepo)listMktOffer.get(0)).setOfferUserId(optimalInfo.getOfferUserId());
            mapBid.remove(optimalPx);
        }
        ArrayList orderOffer = new ArrayList(mapOffer.values());
        ArrayList orderBid = new ArrayList(mapBid.values());
        orderOffer.sort((o1, o2) -> (int)((o2.getOfferPrice() - o1.getOfferPrice()) * 10000.0));
        orderBid.sort((o1, o2) -> (int)((o1.getBidPrice() - o2.getBidPrice()) * 10000.0));
        int subIndexBuy = orderBid.size() > 10 - listMktBid.size() ? 10 - listMktBid.size() : orderBid.size();
        listMktBid.addAll(orderBid.subList(0, subIndexBuy));
        int subIndexSell = orderOffer.size() > 10 - listMktOffer.size() ? 10 - listMktOffer.size() : orderOffer.size();
        listMktOffer.addAll(orderOffer.subList(0, subIndexSell));
        listMktOffer.sort((o1, o2) -> (int)((o2.getOfferPrice() - o1.getOfferPrice()) * 10000.0));
        listMktBid.sort((o1, o2) -> (int)((o1.getBidPrice() - o2.getBidPrice()) * 10000.0));
        int maxSize = listMktBid.size() > listMktOffer.size() ? listMktBid.size() : listMktOffer.size();
        int i = 0;
        while (i < maxSize) {
            HandicapInfoXRepo info = new HandicapInfoXRepo();
            if (listMktBid.size() > i) {
                info.setBidPrice(((HandicapInfoXRepo)listMktBid.get(i)).getBidPrice());
                info.setBidQty(((HandicapInfoXRepo)listMktBid.get(i)).getBidQty());
                info.setBidDealQty(((HandicapInfoXRepo)listMktBid.get(i)).getBidDealQty());
                if (!((HandicapInfoXRepo)listMktBid.get(i)).getBidUserId().isEmpty()) {
                    info.setBidUserId(((HandicapInfoXRepo)listMktBid.get(i)).getBidUserId());
                }
            }
            if (listMktOffer.size() > i) {
                info.setOfferPrice(((HandicapInfoXRepo)listMktOffer.get(i)).getOfferPrice());
                info.setOfferQty(((HandicapInfoXRepo)listMktOffer.get(i)).getOfferQty());
                info.setOfferDealQty(((HandicapInfoXRepo)listMktOffer.get(i)).getOfferDealQty());
                if (!((HandicapInfoXRepo)listMktOffer.get(i)).getOfferUserId().isEmpty()) {
                    info.setOfferUserId(((HandicapInfoXRepo)listMktOffer.get(i)).getOfferUserId());
                }
            }
            listMkt.add(info);
            ++i;
        }
        return listMkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HandicapInfoXRepo> resetOwn(RefItem item) {
        LinkedList<Order> listOrder = new LinkedList<Order>();
        ObservableList<Order> observableList = this.unfinishedModel.getList();
        synchronized (observableList) {
            for (Order ord : this.unfinishedModel.getList()) {
                if (!item.getCode().equals(ord.getSecurityId())) continue;
                listOrder.add(ord);
            }
        }
        return this.resetMkt(item.getCode(), listOrder);
    }

    private TreeItem<HandicapInfoXRepo> createItem(MarketItem mktItem) {
        TreeItem treeParent = new TreeItem();
        treeParent.setExpanded(true);
        HandicapInfoXRepo info = new HandicapInfoXRepo();
        treeParent.setValue((Object)info);
        info.setCode(mktItem.getRefItem().getCode());
        info.rowsProperty().bind((ObservableValue)Bindings.createIntegerBinding(() -> treeParent.getChildren().size() + 1, (Observable[])new Observable[]{treeParent.getChildren()}));
        this.mapParent.put(mktItem.getRefItem().getCode(), (TreeItem<HandicapInfoXRepo>)treeParent);
        return treeParent;
    }

    private Collection<RefItem> getRefItems() {
        return this.refDataMng.getItems(new String[]{"REPOXCFE"});
    }

    private void initFunds() {
        Map cfetsAccountMap = this.accntMng.getCfetsAccountMap();
        this.obList.setAll(cfetsAccountMap.values());
        this.cmbAccnt.setItems(this.obList);
        if (this.obList.size() > 0) {
            this.cmbAccnt.setValue((Object)((CfetsFundAccount)this.obList.get(0)));
        } else {
            this.accntMng.changedProperty().addListener((ob, old, now) -> {
                this.obList.clear();
                this.obList.setAll(this.accntMng.getCfetsAccountMap().values());
                this.cmbAccnt.setItems(this.obList);
                if (this.obList.size() > 0) {
                    this.cmbAccnt.setValue((Object)((CfetsFundAccount)this.obList.get(0)));
                }
            });
        }
        StringBinding extFundAccntIdBinding = Bindings.createStringBinding(() -> {
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String extFundAccntId = account.getNewCashAccntId();
            return extFundAccntId;
        }, (Observable[])new Observable[]{this.cmbAccnt.getSelectionModel().selectedItemProperty()});
        this.model.extFundAccntIdProperty().bind((ObservableValue)extFundAccntIdBinding);
        StringBinding investorIdBinding = Bindings.createStringBinding(() -> {
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String investorId = account.getInvestId();
            return investorId;
        }, (Observable[])new Observable[]{this.cmbAccnt.getSelectionModel().selectedItemProperty()});
        this.model.investorIdProperty().bind((ObservableValue)investorIdBinding);
        StringBinding extSecAccntIdBinding = Bindings.createStringBinding(() -> {
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String extSecAccntId = null;
            try {
                Map mapAccount = this.secAccService.getAllSecAccountMap();
                List list = (List)mapAccount.get(account);
                this.logger.error("\u8bc1\u5238\u8d26\u6237\u6570\u91cf\uff1a" + list.size());
                if (list.size() > 0) {
                    extSecAccntId = ((SecAccount)list.get(0)).getExtSecAccntId();
                    this.logger.error("\u8bc1\u5238\u8d26\u6237\u7b2c\u4e00\u4e2a\uff1a" + extSecAccntId);
                }
            }
            catch (MException e) {
                e.printStackTrace();
            }
            return extSecAccntId;
        }, (Observable[])new Observable[]{this.cmbAccnt.getSelectionModel().selectedItemProperty()});
        this.model.extSecAccntIdProperty().bind((ObservableValue)extSecAccntIdBinding);
        StringBinding investorsecIdBinding = Bindings.createStringBinding(() -> {
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String investorsecId = null;
            try {
                Map mapAccount = this.secAccService.getAllSecAccountMap();
                List list = (List)mapAccount.get(account);
                this.logger.error("\u8bc1\u5238\u8d26\u6237\u6570\u91cf\uff1a" + list.size());
                if (list.size() > 0) {
                    investorsecId = ((SecAccount)list.get(0)).getInverstorSecId();
                    this.logger.error("\u8bc1\u5238\u8d26\u6237\u7b2c\u4e00\u4e2a\uff1a" + investorsecId);
                }
            }
            catch (MException e) {
                this.logger.error("\u8bc1\u5238\u8d26\u53f7\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            }
            return investorsecId;
        }, (Observable[])new Observable[]{this.cmbAccnt.getSelectionModel().selectedItemProperty()});
        this.model.investorsecIdProperty().bind((ObservableValue)investorsecIdBinding);
    }

    private void onSecurityChange(TextField txtCode, String newText) {
        txtCode.setText(newText);
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.model.refItem = refItem;
        this.spnQty.getEditor().clear();
        this.spnPrice.getEditor().clear();
        if (refItem != null) {
            txtCode.setText(refItem.getCode());
            this.lbUnit.setText(refItem.getCode().contains("mini") ? "(\u5343\u4e07)" : "(\u4ebf)");
        } else {
            this.lbName.setText("");
            this.lbName.setTooltip(null);
        }
        txtCode.selectEnd();
        txtCode.deselect();
        if (newText.length() >= 4) {
            this.check();
        }
        this.model.calcAccruedInterest(this);
        this.layout();
    }

    private void check() {
        this.checkSecLabel();
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                XRepoTradePart.this.checkSecLabel();
            }
        };
        timer.schedule(task, 500L);
    }

    private void checkSecLabel() {
        if (this.txtCode.getText().length() < 4) {
            return;
        }
        RefItem ref = this.model.refItem;
        Platform.runLater(() -> {
            if (this.model.refItem == null || this.model.refItem.getType().isEmpty()) {
                this.lbName.setText(INVALID_CODE);
                this.lbName.setStyle("-fx-font-size: 12;");
            } else {
                this.lbName.setText(ref.getName());
                this.lbName.setStyle("-fx-font-size: 12;");
            }
        });
    }

    private boolean valid() {
        String tip;
        if (this.cmbAccnt.getSelectionModel().getSelectedItem() == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8d44\u91d1\u8d26\u53f7");
            return false;
        }
        if (this.model.refItem == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
            return false;
        }
        if (this.model.getPrice() == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u4e70\u5165\u4ef7\u683c");
            return false;
        }
        if (this.model.getCount() == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u4ea4\u6613\u91d1\u989d");
            return false;
        }
        String string = tip = this.tabNormal.isSelected() ? "" : this.checkTime();
        return this.alert.check(tip.isEmpty(), Alert.AlertType.ERROR, tip);
    }

    protected int getTime(TextField txt) {
        if (txt.getText().isEmpty()) {
            txt.setText("00");
        } else if (StringUtils.patternCheck((String)"[0-9]?", (String)txt.getText())) {
            txt.insertText(0, "0");
        }
        return StringUtils.parseInt((String)txt.getText());
    }

    private String checkTime() {
        int end;
        String check = "";
        int start = this.getTime(this.txtStartHour) * 60 * 60 + this.getTime(this.txtStartMinute) * 60 + this.getTime(this.txtStartSecond);
        if (start >= (end = this.getTime(this.txtEndHour) * 60 * 60 + this.getTime(this.txtEndMinute) * 60 + this.getTime(this.txtEndSecond))) {
            check = "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01";
        }
        boolean startV = XRepoTradePart.timeIsValid(start);
        boolean endV = XRepoTradePart.timeIsValid(end);
        if (this.algoConf.limitTime() && !startV && !endV) {
            check = "\u89e6\u53d1\u65f6\u95f4\u8303\u56f4  09:00-12:00 13:30-16:35";
        }
        return check;
    }

    public static boolean timeIsValid(int time) {
        if (time >= amB && time <= amE) {
            return true;
        }
        return time >= pmB && time <= pmE;
    }

    @FXML
    public void order() {
        if (!this.valid()) {
            return;
        }
        if (this.tabNormal.isSelected()) {
            XRepoConfirmDialog obj = (XRepoConfirmDialog)((Object)this.of.create(XRepoConfirmDialog.class));
            XRepConfirmEntrust entrust = new XRepConfirmEntrust();
            entrust.setInvestorId(this.model.getInvestorId());
            entrust.setCount(this.model.getCount());
            entrust.setMarket(this.model.refItem.getMarket());
            entrust.setCode(this.model.refItem.getCode());
            entrust.setName(this.model.refItem.getName());
            entrust.setSide(this.model.isOffer() ? 81 : 80);
            entrust.setPrice(this.model.getPrice());
            entrust.setOrdType(this.model.getOrdType());
            entrust.setSettlType(this.model.getSettlType());
            entrust.setFirstDate(this.lbFirstDate.getText());
            entrust.setDuedate(this.lbDuedate.getText());
            entrust.setDays(this.lbDays.getText());
            entrust.setRepoInterest(this.lbRepoInterest.getText());
            entrust.setDueAmount(this.lbDueAmount.getText());
            obj.setRefItem(this.model.refItem);
            obj.setEntrust(entrust);
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
            if (dialog.launch() != ButtonType.OK) {
                return;
            }
            try {
                this.model.submit();
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            XRepoStrategy strategy = new XRepoStrategy();
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String extFundAccntId = account.getNewCashAccntId();
            String parentExtAccntId = account.getParentId();
            String extSecAccntId = null;
            try {
                Map mapAccount = this.secAccService.getAllSecAccountMap();
                List list = (List)mapAccount.get(account);
                if (list != null && list.size() > 0) {
                    extSecAccntId = ((SecAccount)list.get(0)).getExtSecAccntId();
                }
            }
            catch (MException e) {
                this.logger.error((Object)e);
            }
            strategy.setParentExtAccntId(parentExtAccntId);
            strategy.setExtFundAccntId(extFundAccntId);
            strategy.setExtSecAccntId(extSecAccntId);
            strategy.setStartTime(this.getTime(this.txtStartHour, this.txtStartHour, this.txtStartHour));
            strategy.setEndTime(this.getTime(this.txtEndHour, this.txtEndHour, this.txtEndHour));
            try {
                if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u4e0b\u5355\uff1f")) {
                    this.model.addStrategy(strategy);
                    this.alert.alert(Alert.AlertType.INFORMATION, "\u4e0b\u5355\u6210\u529f\uff01");
                }
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getTime(TextField txtHour, TextField txtMinute, TextField txtSecond) {
        StringBuffer buffer = new StringBuffer(txtHour.getText());
        buffer.append(":").append(txtMinute.getText());
        buffer.append(":").append(txtSecond.getText());
        return buffer.toString();
    }

    @FXML
    public void sw() {
        FxUtils.makePC((Node)this.lbArrow, (String)"left", (boolean)this.paneHidden.isVisible());
        this.paneHidden.setVisible(!this.paneHidden.isVisible());
    }

    @FXML
    public void stopAll() {
        ArrayList<String> listId = new ArrayList<String>();
        String market = "";
        for (XRepoStrategy strategy : this.strategyModel.getList()) {
            market = strategy.getMarket();
            listId.add(strategy.getContextId());
        }
        if (!market.isEmpty() && listId.size() > 0) {
            try {
                RespResult result = this.strategyModel.stopStrategy(market, listId);
                if (result.hasFailed()) {
                    this.alert.alert(Alert.AlertType.ERROR, result.getFailedDesc("\u505c\u6b62"));
                }
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
        try {
            this.model.stopAll();
        }
        catch (MException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void openTree() {
        this.treeTableMkt.getRoot().getChildren().forEach(item -> item.setExpanded(true));
    }

    @FXML
    public void closeTree() {
        this.treeTableMkt.getRoot().getChildren().forEach(item -> item.setExpanded(false));
    }

    @Override
    public void resetExtraInfo() {
        CalcAccruedInterestResp resp = this.model.getResp();
        if (resp == null) {
            this.lbFirstDate.setText("");
            this.lbDuedate.setText("");
            this.lbDays.setText("");
            this.lbRepoInterest.setText("");
            this.lbDueAmount.setText("");
            return;
        }
        this.lbFirstDate.setText(this.model.getReq().getSettlDate());
        this.lbDuedate.setText(resp.getMaturityDate());
        this.lbDays.setText(String.valueOf(resp.getActualDays()));
        this.lbRepoInterest.setText(StringUtils.toThousands((Number)resp.getAccruedInterest(), (int)4));
        double dueAmount = resp.getAccruedInterest() + this.model.getReq().getQty();
        this.lbDueAmount.setText(StringUtils.toThousands((Number)dueAmount, (int)4));
    }

    @Override
    public String getSettlDate() {
        return null;
    }

    public class NumberTreeCell
    extends TreeTableCell<HandicapInfoXRepo, Number> {
        private boolean offer;
        private boolean qty;

        public NumberTreeCell(boolean offer, boolean qty) {
            CssUtils.priceTag((Control)this);
            this.offer = offer;
            this.qty = qty;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    if (event.getClickCount() == 2) {
                        XRepoTradePart.this.doOrderFill((TreeTableRow<HandicapInfoXRepo>)this.getTreeTableRow(), (TreeTableColumn<HandicapInfoXRepo, Number>)this.getTableColumn());
                        this.getTreeTableRow().getTreeItem().setExpanded(true);
                    }
                });
                HandicapInfoXRepo info = (HandicapInfoXRepo)this.getTreeTableRow().getItem();
                if (item != null && item.doubleValue() >= 0.0 && info != null) {
                    double dealQty;
                    Set userIdSet;
                    Set set = userIdSet = this.offer ? info.getOfferUserId() : info.getBidUserId();
                    if (userIdSet.contains(XRepoTradePart.this.base.getUserId())) {
                        CssUtils.makeYellow((Control)this);
                    } else if (!userIdSet.isEmpty()) {
                        CssUtils.makePink((Control)this);
                    } else {
                        CssUtils.makeEven((Control)this);
                    }
                    int scale = DecimalUtils.getScale((double)item.doubleValue());
                    String txt = StringUtils.toThousands((String)String.valueOf(item), (int)scale);
                    double d = dealQty = this.offer ? info.getOfferDealQty() : info.getBidDealQty();
                    if (this.qty && dealQty > 0.0) {
                        int scaleDeal = DecimalUtils.getScale((double)dealQty);
                        String dealQtyStr = StringUtils.toThousands((String)String.valueOf(dealQty), (int)scaleDeal);
                        txt = String.valueOf(txt) + "(" + dealQtyStr + ")";
                    }
                    FxUtils.makePC((Node)this, (String)"highlight", (dealQty > 0.0 ? 1 : 0) != 0);
                    this.setText(txt);
                    return;
                }
            }
            this.setText("0");
        }
    }
}

