/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XRepoStrategyModel;
import cms.tmx.bond.views.XRepoStrategyDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.XRepoStrategy;
import cms.tmx.http.utils.RespResult;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class XRepoStrategyPart
extends MxPart {
    private MxList<XRepoStrategy> mlist = new MxList();
    @FXML
    private Button btnStop;
    @FXML
    private CheckBox cbxAll;
    @FXML
    private TableView<XRepoStrategy> tableStrategy;
    @FXML
    private TableColumn<XRepoStrategy, Boolean> selected;
    @FXML
    private TableColumn<XRepoStrategy, String> errorMsg;
    @FXML
    private TableColumn<XRepoStrategy, Object> operate;
    @FXML
    private TableColumn<XRepoStrategy, MxNode> status;
    @FXML
    private TableColumn<XRepoStrategy, String> contextId;
    @FXML
    private TableColumn<XRepoStrategy, String> securityId;
    @FXML
    private TableColumn<XRepoStrategy, String> name;
    @FXML
    private TextField searchText;
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng ref;
    @FXML
    private Label lbCount;
    @Inject
    private XRepoStrategyModel model;
    private Predicate<XRepoStrategy> pd = t -> {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getSecurityId().toUpperCase();
        String name = t.getSecurityName().toUpperCase();
        boolean bTxt = code.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        String contextId = t.getContextId().toUpperCase();
        boolean bStrategy = contextId.contains(txtStrategy);
        String txtTrader = this.searchTextTrader.getText().trim().toUpperCase();
        String traderId = t.getTraderId().toUpperCase();
        boolean bTrader = traderId.contains(txtTrader);
        return bTxt && bStrategy && bTrader;
    };
    private ChangeListener<? super Boolean> selectedLis = (o, old, now) -> this.checkBtnStatus();
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        ArrayList<XRepoStrategy> newList = new ArrayList<XRepoStrategy>();
        ObservableList<XRepoStrategy> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<XRepoStrategy>)this.model.getList());
        }
        this.mlist.update(newList, this.pd);
        this.checkBtnStatus();
        this.tableStrategy.sort();
        this.tableStrategy.refresh();
        for (XRepoStrategy strategy : this.mlist.getList()) {
            strategy.selectedProperty().removeListener(this.selectedLis);
            strategy.selectedProperty().addListener(this.selectedLis);
        }
        this.logger.debug("XRepo\u7b56\u7565\u4ea4\u6613\u5237\u65b0\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listenerStatus = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        this.checkBtnStatus();
        this.logger.debug("checkBtnStatus\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener lstnSearch = ob -> {
        long start = System.currentTimeMillis();
        ArrayList<XRepoStrategy> newList = new ArrayList<XRepoStrategy>();
        ObservableList<XRepoStrategy> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<XRepoStrategy>)this.model.getList());
        }
        this.mlist.filter(newList, this.pd);
        this.mlist.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
        this.checkBtnStatus();
        this.tableStrategy.sort();
        this.tableStrategy.refresh();
        System.err.println("time:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    };
    private InvalidationListener listener = ob -> this.refresh();

    private void checkBtnStatus() {
    }

    @FXML
    public void initialize() {
        this.createTable();
        this.model.changedProperty().addListener(this.lstnModel);
        this.model.statusChangedProperty().addListener(this.listenerStatus);
        this.ref.changedProperty().addListener(this.listener);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.searchTextStrategy.textProperty().addListener(this.lstnSearch);
        this.searchTextTrader.textProperty().addListener(this.lstnSearch);
        this.refresh();
        this.cbxAll.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
    }

    @FXML
    public void stop() {
        ArrayList<String> listId = new ArrayList<String>();
        String market = "";
        for (XRepoStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            market = strategy.getMarket();
            listId.add(strategy.getContextId());
        }
        if (listId.isEmpty()) {
            this.alert.check(false, Alert.AlertType.INFORMATION, "\u65e0\u53ef\u505c\u6b62\u7684\u7b56\u7565\uff01");
            return;
        }
        try {
            RespResult result = this.model.stopStrategy(market, listId);
            if (result.hasFailed()) {
                this.alert.alert(Alert.AlertType.ERROR, result.getFailedDesc("\u505c\u6b62"));
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.model.statusChangedProperty().removeListener(this.listenerStatus);
        this.ref.changedProperty().removeListener(this.listener);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.searchTextStrategy.textProperty().removeListener(this.lstnSearch);
        this.searchTextTrader.textProperty().removeListener(this.lstnSearch);
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tableStrategy);
        this.operate.setCellValueFactory(data -> this.setOperate((XRepoStrategy)data.getValue()));
        this.tableStrategy.setPlaceholder((Node)new Label());
        this.tableStrategy.setItems(this.mlist.getList());
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.contextId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableStrategy.getSortOrder().add(this.contextId);
        this.tableStrategy.sort();
    }

    public ReadOnlyObjectWrapper<Object> setOperate(XRepoStrategy ap) {
        HBox hBox = new HBox();
        Button btnShow = new Button("\u67e5\u770b");
        btnShow.getStyleClass().add((Object)"btnOperation");
        btnShow.setOnAction(event -> this.show(ap));
        hBox.getChildren().add((Object)btnShow);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    public void show(XRepoStrategy strategy) {
        XRepoStrategyDialog obj = (XRepoStrategyDialog)((Object)this.of.create(XRepoStrategyDialog.class));
        obj.setStrategy(strategy);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u67e5\u770b");
        dialog.launch();
    }

    public void refresh() {
        this.model.query();
    }
}

