/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.trade.XRepoStrategy;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.utils.StringUtils;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javax.inject.Inject;

public class XRepoStrategyDialog
extends DialogObj {
    @FXML
    private ComboBox<CfetsFundAccount> cmbAccnt;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private RadioButton rdoBuy;
    @FXML
    private RadioButton rdoSell;
    @FXML
    private ComboBox<MxNode> cmbOrdType;
    @FXML
    private Label lbPrice;
    @FXML
    private Spinner<Double> spnPrice;
    @FXML
    private Spinner<Integer> spnQty;
    @FXML
    private Label lbUnit;
    @FXML
    private ComboBox<MxNode> cmbSettlType;
    @FXML
    private ComboBox<String> cmbRepoWay;
    @FXML
    private Label lbArrow;
    @FXML
    private TextField txtStartHour;
    @FXML
    private TextField txtStartMinute;
    @FXML
    private TextField txtStartSecond;
    @FXML
    private TextField txtEndHour;
    @FXML
    private TextField txtEndMinute;
    @FXML
    private TextField txtEndSecond;
    @Inject
    private CcsAccountMap accntMng;
    private XRepoStrategy strategy;

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.OK};
    }

    @FXML
    public void initialize() {
        for (CfetsFundAccount account : this.accntMng.getCfetsAccountMap().values()) {
            if (!this.strategy.getExtFundAccntId().equals(account.getNewCashAccntId())) continue;
            this.cmbAccnt.getSelectionModel().select((Object)account);
        }
        this.txtCode.setText(this.strategy.getSecurityId());
        this.lbName.setText(this.strategy.getSecurityName());
        this.rdoBuy.setSelected(Side.SIDE_OFFER.equals((Object)this.strategy.getSide()));
        this.rdoSell.setSelected(Side.SIDE_BID.equals((Object)this.strategy.getSide()));
        String priceName = this.rdoBuy.isSelected() ? "\u4ef7\u683c\u4e0a\u9650" : "\u4ef7\u683c\u4e0b\u9650";
        this.lbPrice.setText(priceName);
        double price = this.rdoBuy.isSelected() ? this.strategy.getUpLimit() : this.strategy.getFloorLimit();
        this.spnPrice.getEditor().setText(StringUtils.toThousands((Number)price, (int)2));
        this.spnQty.getEditor().setText(StringUtils.toThousands((Number)this.strategy.getTotalQty()));
        MxNode node = new MxNode().load("settl_type", "1");
        this.cmbSettlType.setItems(node.getNodes());
        this.cmbSettlType.setValue((Object)node);
        this.cmbRepoWay.setValue((Object)"\u53cc\u8fb9\u56de\u8d2d");
        String[] startTime = this.strategy.getStartTime().split(":");
        String[] endTime = this.strategy.getEndTime().split(":");
        this.txtStartHour.setText(startTime[0]);
        this.txtEndHour.setText(endTime[0]);
        this.txtStartMinute.setText(startTime[1]);
        this.txtEndMinute.setText(endTime[1]);
        this.txtStartSecond.setText(startTime[2]);
        this.txtEndSecond.setText(endTime[2]);
    }

    public void setStrategy(XRepoStrategy strategy) {
        this.strategy = strategy;
    }
}

