/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XRepoOrderModel;
import cms.tmx.bond.views.XBondTypeCell;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.ObSingleOrderXRepo;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.utils.RespResult;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class XRepoOrderPart
extends MxPagePart<Order, ObSingleOrderXRepo> {
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @FXML
    private TableColumn<ObSingleOrderXRepo, String> ordCategory;
    @FXML
    private TableColumn<ObSingleOrderXRepo, MxNode> side;
    @FXML
    private TableColumn<ObSingleOrderXRepo, Number> orderQty;
    @FXML
    private TableColumn<ObSingleOrderXRepo, Number> cumQty;
    @FXML
    private TableColumn<ObSingleOrderXRepo, Number> leavesQty;
    @FXML
    private TableColumn<ObSingleOrderXRepo, String> errInfo;
    @FXML
    private MenuItem miCancel;
    @Inject
    private XRepoOrderModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private UserPreOrderTips setTips;
    public static List<String> ORDER_STATUS = Arrays.asList("48", "49", "54");
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";

    protected boolean predicate(Order data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String orderId = data.getOrderId();
        boolean bTxt = code.contains(text) || orderId.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        String sourceId = "";
        if (data.getExecMode() != null) {
            sourceId = String.valueOf(data.getExecMode().getEmId()).toUpperCase();
        }
        String source = data.getSource().trim().toUpperCase();
        boolean bStrategy = sourceId.contains(txtStrategy) || source.contains(txtStrategy);
        String txtTrader = this.searchTextTrader.getText().trim().toUpperCase();
        String traderId = data.getTraderId().toUpperCase();
        boolean bTrader = traderId.contains(txtTrader);
        return bTxt && bStrategy && bTrader;
    }

    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.searchTextStrategy.textProperty().removeListener(this.listenerSearch);
        this.searchTextTrader.textProperty().removeListener(this.listenerSearch);
    }

    @FXML
    protected void initialize() {
        super.initialize();
        this.searchTextStrategy.textProperty().addListener(this.listenerSearch);
        this.searchTextTrader.textProperty().addListener(this.listenerSearch);
    }

    @FXML
    protected void refresh() {
        this.mxList.setBeginIndex(0);
        this.model.query();
    }

    protected List<Order> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.ordCategory.setCellFactory(cell -> new XBondTypeCell());
        this.side.setCellFactory(cell -> new SideCell());
        this.orderQty.setCellFactory(data -> new DoubleTableCell(1));
        this.cumQty.setCellFactory(data -> new DoubleTableCell(1));
        this.leavesQty.setCellFactory(data -> new DoubleTableCell(1));
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderXRepo, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((ObSingleOrderXRepo)this.getValue()).getErrInfo();
            }
        });
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
        TableUtils.beforeClick((TableView)this.tableView, item -> {
            boolean cancel = ORDER_STATUS.contains(item.getOrdStatus().getRaw());
            this.miCancel.setDisable(item == null || !cancel);
            return true;
        });
    }

    @FXML
    private void rightCancel() {
        ObSingleOrderXRepo selectedItem = (ObSingleOrderXRepo)this.tableView.getSelectionModel().getSelectedItem();
        for (Order order : this.mxList.getList()) {
            if (!order.getOrderId().equals(selectedItem.getOrderId())) continue;
            RespResult result = this.model.orderCancel(Arrays.asList(order));
            Alert.AlertType aType = result.hasFailed() ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION;
            this.alert.check(!this.setTips.getOrderTips(), aType, result.getDesc("\u64a4\u5355\u63d0\u4ea4"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u8ba2\u5355\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
    }
}

