/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XRepoDealModel;
import cms.tmx.bond.views.XBondTypeCell;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.ObExecutionXRepo;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.utils.SideCell;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class XRepoDealPart
extends MxPagePart<Execution, ObExecutionXRepo> {
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @FXML
    private TableColumn<ObExecutionXRepo, String> ordCategory;
    @FXML
    private TableColumn<ObExecutionXRepo, MxNode> side;
    @FXML
    private TableColumn<ObExecutionXRepo, String> chName;
    @FXML
    private TableColumn<ObExecutionXRepo, String> counterTraderId;
    @Inject
    private XRepoDealModel model;
    @Inject
    private MxAlert alert;

    protected MxModel getModel() {
        return this.model;
    }

    @FXML
    public void initialize() {
        this.searchTextStrategy.textProperty().addListener(this.listenerSearch);
        this.searchTextTrader.textProperty().addListener(this.listenerSearch);
        super.initialize();
    }

    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.searchTextStrategy.textProperty().removeListener(this.listenerSearch);
        this.searchTextTrader.textProperty().removeListener(this.listenerSearch);
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.ordCategory.setCellFactory(cell -> new XBondTypeCell());
        this.side.setCellFactory(cell -> new SideCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getExecId().compareTo(o1.getExecId()));
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.getColumns().remove(this.chName);
        this.tableView.getColumns().remove(this.counterTraderId);
    }

    @FXML
    protected void refresh() {
        this.mxList.setBeginIndex(0);
        this.model.query();
    }

    protected boolean predicate(Execution exec) {
        String traderId;
        String txtTrader;
        boolean bTrader;
        String text = this.searchText.getText().trim().toUpperCase();
        String code = exec.getInstrument().getSecurityId().toUpperCase();
        String name = exec.getInstrument().getSymbol().toUpperCase();
        String execId = exec.getExecId();
        boolean bTxt = code.contains(text) || execId.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        boolean bStrategy = txtStrategy.isEmpty();
        if (!bStrategy && exec.getExecMode() != null) {
            String sourceId = String.valueOf(exec.getExecMode().getEmId());
            String source = exec.getSource().trim().toUpperCase();
            if (sourceId.contains(txtStrategy) || source.contains(txtStrategy)) {
                bStrategy = true;
            }
        }
        if (!(bTrader = (txtTrader = this.searchTextTrader.getText().trim().toUpperCase()).isEmpty()) && exec.getSelfParty() != null && (traderId = exec.getSelfParty().getTraderId().toUpperCase()).contains(txtTrader)) {
            bTrader = true;
        }
        return bTxt && bStrategy && bTrader;
    }

    protected List<Execution> getList() {
        return this.model.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listExec, (String)"\u6210\u4ea4\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
    }
}

