/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.XRepConfirmEntrust;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class XRepoConfirmDialog
extends DialogObj {
    @FXML
    private TableView<XRepConfirmEntrust> tableItems;
    @FXML
    private TableColumn<XRepConfirmEntrust, String> index;
    @FXML
    private TableColumn<XRepConfirmEntrust, String> market;
    @FXML
    private TableColumn<XRepConfirmEntrust, Number> side;
    @FXML
    private TableColumn<XRepConfirmEntrust, Number> count;
    @FXML
    private TableColumn<XRepConfirmEntrust, String> colUnit;
    @FXML
    private TableColumn<XRepConfirmEntrust, Number> price;
    @FXML
    private TableColumn<XRepConfirmEntrust, String> colAcc;
    @FXML
    private TableColumn<XRepConfirmEntrust, String> colSecAcc;
    @FXML
    private TableColumn<XRepConfirmEntrust, String> colMatchType;
    @FXML
    private TableColumn<XRepConfirmEntrust, String> colSettlType;
    @FXML
    private TableColumn<XRepConfirmEntrust, String> colYield;
    private ObservableList<XRepConfirmEntrust> list = FxUtils.newList();
    public long totalCount = 0L;
    public boolean triggered = false;
    private RefItem refItem;
    private String type = "";
    private boolean showWarning = true;

    @FXML
    public void initialize() {
        this.createTable();
    }

    protected void createTable() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        TableUtils.initValueFactory(this.tableItems);
        this.market.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((XRepConfirmEntrust)m.getValue()).getMarket()).getValue()));
        this.side.setCellFactory(cell -> new SideCell());
        this.price.setCellFactory(cell -> new ItemPriceCell());
        String priceName = "\u4ea4\u6613\u91d1\u989d";
        priceName = String.valueOf(priceName) + (this.refItem.getCode().contains("mini") ? "(\u5343\u4e07)" : "(\u4ebf)");
        this.count.setText(priceName);
        this.count.setCellFactory(cell -> new NumberTableCell());
        this.tableItems.getColumns().remove(this.colUnit);
        this.tableItems.setItems(this.list);
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    public void setList(List<XRepConfirmEntrust> list) {
        this.list.setAll(list);
    }

    public void setEntrust(XRepConfirmEntrust entrust) {
        this.list.setAll(Arrays.asList(entrust));
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean priceIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean AmtIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public boolean isPlegde() {
        return this.type.equals("PLEDGE");
    }

    public boolean isAlgo() {
        return this.type.equals("ALGO");
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<XRepConfirmEntrust, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            XRepConfirmEntrust item = (XRepConfirmEntrust)XRepConfirmEntrust.class.cast(this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            this.pseudoClassStateChanged(this.MARKET_PRICE, false);
            String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)2);
            this.setText(text);
        }
    }

    private class SideCell
    extends TableCell<XRepConfirmEntrust, Number> {
        private Label label = new Label();
        private MxNode sideNode;

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            this.sideNode = MxNodeFactory.create((String)"xrepo_side", (String)"");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = value.intValue();
            this.label.setText(this.sideNode.getNode(String.valueOf(side)).getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

