/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondUnfinishedOrderModel;
import cms.tmx.bond.views.XBondOrderReplaceDialog;
import cms.tmx.bond.views.XBondTypeCell;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.utils.SideCell;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondUnfinishedOrderPart
extends MxPart {
    private final Logger logger = LogManager.getLogger(XBondUnfinishedOrderPart.class);
    @FXML
    private TableView<SingleOrder> tableXBondUnfinished;
    @FXML
    private TableColumn<SingleOrder, Boolean> selected;
    @FXML
    private TableColumn<SingleOrder, String> source;
    @FXML
    private TableColumn<SingleOrder, String> sourceId;
    @FXML
    private TableColumn<SingleOrder, String> securityId;
    @FXML
    private TableColumn<SingleOrder, String> securityName;
    @FXML
    private TableColumn<SingleOrder, String> termToMaturity;
    @FXML
    private TableColumn<SingleOrder, MxNode> side;
    @FXML
    private TableColumn<SingleOrder, MxNode> matchType;
    @FXML
    private TableColumn<SingleOrder, MxNode> status;
    @FXML
    private TableColumn<SingleOrder, MxNode> settlType;
    @FXML
    private TableColumn<SingleOrder, String> ordCategory;
    @FXML
    private TableColumn<SingleOrder, Number> leavesQty;
    @FXML
    private TableColumn<SingleOrder, Number> price;
    @FXML
    private TableColumn<SingleOrder, Number> yield;
    @FXML
    private TableColumn<SingleOrder, Number> avgPx;
    @FXML
    private TableColumn<SingleOrder, Number> avgYield;
    @FXML
    private TableColumn<SingleOrder, Number> orderQty;
    @FXML
    private TableColumn<SingleOrder, MxNode> type;
    @FXML
    private TableColumn<SingleOrder, String> ordTime;
    @FXML
    private TableColumn<SingleOrder, String> userName;
    @FXML
    private TableColumn<SingleOrder, String> traderId;
    @FXML
    private TableColumn<SingleOrder, String> orderId;
    @FXML
    private TextField searchText;
    @FXML
    protected TextField searchTextStrategy;
    @FXML
    protected TextField searchTextTrader;
    @FXML
    private Button btnAllOrderCancel;
    @Inject
    private XBondUnfinishedOrderModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private IUserService userService;
    @Inject
    protected CcsCancelFactory ccf;
    protected MxList<SingleOrder> mxList = new MxList();
    private Predicate<SingleOrder> pd = t -> {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = t.getInstrument().getSecurityId().toUpperCase();
        String name = t.getInstrument().getSymbol().toUpperCase();
        String orderId = t.getOrderId();
        if (!SingleOrder.CAN_CANCEL_STATUS.contains(t.getOrdStatus().getValue())) {
            return false;
        }
        boolean bTxt = code.contains(text) || orderId.contains(text) || name.contains(text);
        String txtStrategy = this.searchTextStrategy.getText().trim().toUpperCase();
        String sourceId = t.getSourceId().toUpperCase();
        String source = t.getSource().trim().toUpperCase();
        boolean bStrategy = sourceId.contains(txtStrategy) || source.contains(txtStrategy);
        String txtTrader = this.searchTextTrader.getText().trim().toUpperCase();
        String traderId = t.getTraderId().toUpperCase();
        boolean bTrader = traderId.contains(txtTrader);
        return bTxt && bStrategy && bTrader;
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        List<SingleOrder> list = this.model.getList();
        synchronized (list) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
        this.tableXBondUnfinished.refresh();
    };
    protected CheckBox checkBox = new CheckBox();
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private MEventService es;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList<SingleOrder> newList = new ArrayList<SingleOrder>();
        List<SingleOrder> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableXBondUnfinished.refresh();
        });
    }

    @FXML
    private void initialize() {
        long start = System.currentTimeMillis();
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.searchTextStrategy.textProperty().addListener(this.lstnSearch);
        this.searchTextTrader.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
        this.createTableView();
        this.refresh();
        this.checkBox.selectedProperty().addListener((obv, old, now) -> {
            ObservableList observableList = this.mxList.getList();
            synchronized (observableList) {
                this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
            }
        });
        System.err.println("order part init" + (System.currentTimeMillis() - start));
        this.tableXBondUnfinished.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            SingleOrder order;
            if (event.getClickCount() == 2 && (order = (SingleOrder)this.tableXBondUnfinished.getSelectionModel().getSelectedItem()) != null) {
                XBondOrderReplaceDialog obj = (XBondOrderReplaceDialog)((Object)((Object)this.of.create(XBondOrderReplaceDialog.class)));
                obj.setOrder(order);
                MxDialog dialog = this.df.create((DialogObj)obj, "\u6539\u5355");
                if (dialog.launch() == ButtonType.OK) {
                    this.refresh();
                }
            }
        });
    }

    @PreDestroy
    protected void preDestroy() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.searchTextStrategy.textProperty().removeListener(this.lstnSearch);
        this.searchTextTrader.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    @FXML
    private void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55")) {
            return;
        }
        if (this.createDialog((List<SingleOrder>)list, "\u64a4\u5355\u786e\u8ba4")) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = new MEvent();
        event.setObj((Object)list);
        this.es.sendEvent("xbond.cancel.order", event);
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        if (event.getInt("fail.count") > 0) {
            type = Alert.AlertType.ERROR;
        }
        this.alert.check(!this.setTips.getCancelOrderTips(), type, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14\n" + event.get((Object)"fail.message"));
    }

    @FXML
    private void allOrderCancel() {
        ObservableList list = this.mxList.getList();
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.WARNING, "\u65e0\u53ef\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55\uff01")) {
            return;
        }
        if (this.createDialog((List<SingleOrder>)list, "\u64a4\u5355\u786e\u8ba4")) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        MEvent event = new MEvent();
        event.setObj((Object)list);
        this.es.sendEvent("xbond.cancel.order", event);
        Alert.AlertType type = Alert.AlertType.INFORMATION;
        if (event.getInt("fail.count") > 0) {
            type = Alert.AlertType.ERROR;
        }
        this.alert.check(!this.setTips.getCancelOrderTips(), type, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14\n" + event.get((Object)"fail.message"));
    }

    private boolean createDialog(List<SingleOrder> list, String dialogName) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)this.of.create(CcsCancelConfirmDialog.class);
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (SingleOrder or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle("", "");
            en.setSec(or.getInstrument().getSecurityId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInvestorSecId());
            en.setSecType(or.getInstrument().getSecurityType());
            en.setMarket(or.getInstrument().getMarket());
            en.setOrderType(Integer.valueOf(or.getOrdType().getValue()).intValue());
            en.setSide(new MxNode().load("xbond_side", or.getSide().getValue()));
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            en.setQuantity((long)(or.getOrderQty() - or.getCumQty()));
            en.setPrice(or.getPrice());
            en.setAmt((double)en.getQuantity() * en.getPrice());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, dialogName);
        return dialog.launch() != ButtonType.OK;
    }

    private void createTableView() {
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((SingleOrder)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.source.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getSource()));
        this.sourceId.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getSourceId()));
        this.ordCategory.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getOrdCategory()));
        this.ordCategory.setCellFactory(cell -> new XBondTypeCell());
        this.securityId.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getInstrument().getSecurityId()));
        this.securityName.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getInstrument().getSymbol()));
        this.side.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("xbond_side", ((SingleOrder)cell.getValue()).getSide().getValue())));
        this.side.setCellFactory(cell -> new SideCell());
        this.status.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("ord_status", ((SingleOrder)cell.getValue()).getOrdStatus().getValue())));
        this.matchType.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("match_type", ((SingleOrder)cell.getValue()).getMatchType().getValue())));
        this.settlType.setCellValueFactory(cell -> new SimpleObjectProperty((Object)new MxNode().load("settl_type", String.valueOf(((SingleOrder)cell.getValue()).getSettlType().ordinal()))));
        DecimalFormat df = new DecimalFormat("#.####");
        this.price.setCellValueFactory(cell -> {
            String price = df.format(((SingleOrder)cell.getValue()).getPrice());
            return new SimpleDoubleProperty(Double.valueOf(price).doubleValue());
        });
        this.yield.setCellValueFactory(cell -> {
            String yield = df.format(((SingleOrder)cell.getValue()).getYield());
            return new SimpleDoubleProperty(Double.valueOf(yield).doubleValue());
        });
        this.avgPx.setCellValueFactory(cell -> {
            String price = df.format(((SingleOrder)cell.getValue()).getAvgPx());
            return new SimpleDoubleProperty(Double.valueOf(price).doubleValue());
        });
        this.avgYield.setCellValueFactory(cell -> {
            String yield = df.format(((SingleOrder)cell.getValue()).getAvgYield());
            return new SimpleDoubleProperty(Double.valueOf(yield).doubleValue());
        });
        this.leavesQty.setCellValueFactory(cell -> new SimpleDoubleProperty(((SingleOrder)cell.getValue()).getLeavesQty()));
        this.orderQty.setCellValueFactory(cell -> new SimpleDoubleProperty(((SingleOrder)cell.getValue()).getOrderQty()));
        this.orderId.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getOrderId()));
        this.ordTime.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getOrdTime()));
        this.termToMaturity.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getTermToMaturity()));
        this.traderId.setCellValueFactory(cell -> new SimpleStringProperty(((SingleOrder)cell.getValue()).getTraderId()));
        this.userName.setCellValueFactory(data -> new SimpleStringProperty(this.userService.getUserName(((SingleOrder)data.getValue()).getUserId()).getValue()));
        this.tableXBondUnfinished.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableXBondUnfinished.setItems(this.mxList.getList());
    }

    @FXML
    private void refresh() {
        this.model.query();
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableXBondUnfinished, (String)"\u672a\u5b8c\u6210\u8ba2\u5355\u7ba1\u7406", (int)1, (int)(this.tableXBondUnfinished.getColumns().size() - 1));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableXBondUnfinished, (int)1, (int)0);
    }
}

