/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.javafx.utils.CssUtils;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondTypeCell<T>
extends TableCell<T, String> {
    private static final Logger logger = LogManager.getLogger(XBondTypeCell.class);
    private Label label = new Label();

    public XBondTypeCell() {
        this.label.getStyleClass().add((Object)"priceTag");
    }

    public void updateItem(String value, boolean empty) {
        try {
            if (value == null || empty) {
                this.setGraphic(null);
                return;
            }
            if (value == null || value.trim().isEmpty()) {
                return;
            }
            this.label.setText(value);
            switch (value) {
                case "\u4e3b\u52a8\u5355": {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                case "\u5bf9\u51b2\u5355": {
                    CssUtils.makeFall((Control)this.label);
                    break;
                }
                case "\u53cc\u8fb9\u5355": {
                    CssUtils.makeYellow((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeEven((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
    }
}

