/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.SecFormatter;
import cms.tmx.bond.models.XBondTradeModel;
import cms.tmx.bond.models.XBondUnfinishedOrderModel;
import cms.tmx.bond.views.ICallBack;
import cms.tmx.bond.views.XBondConfirmDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.Formatter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.XBond;
import cms.tmx.http.api.strategy.dto.CalcYieldResp;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.calendar.api.CalendarServiceApi;
import cms.tmx.http.calendar.dto.GetBusinessDateReq;
import cms.tmx.http.calendar.dto.GetBusinessDateResp;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.manage.models.TraderModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.trade.message.XBondAlertMng;
import cms.tmx.trade.models.UserPreCtrl;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondTradePart
extends MxPart
implements ICallBack {
    private static final Logger logger = LogManager.getLogger(XBondTradePart.class);
    @FXML
    private VBox vboxMarket;
    @FXML
    private Line marketLine;
    @FXML
    private CheckBox checkShow;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> indexBuy;
    @FXML
    private TableColumn<HandicapInfo, String> indexSell;
    @FXML
    private TableColumn<HandicapInfo, String> colSellSettlType;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> mktSellYield;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> mktBuyYield;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, String> colBuySettlType;
    @FXML
    private ComboBox<CfetsFundAccount> cmbAccnt;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private Label lbTermToMaturity;
    @FXML
    private Label lbNetVal;
    @FXML
    private Label lbIssrRat;
    @FXML
    private Label lbArrow;
    @FXML
    private GridPane gridPaneExtraInfo;
    @FXML
    private Label lbAccruedInterest;
    @FXML
    private Label lbDirtyPx;
    @FXML
    private Label lbAmt;
    @FXML
    private Label lbAccruedInterestAmt;
    @FXML
    private Label lbSettlementAmt;
    @FXML
    private VBox tradeBoxBuy;
    @FXML
    private VBox tradeBoxSell;
    @FXML
    private RadioButton radioBS;
    @FXML
    private RadioButton radioBuy;
    @FXML
    private RadioButton radioSell;
    @FXML
    private ComboBox<MxNode> cmbMatchTypeBuy;
    @FXML
    private ComboBox<MxNode> cmbMatchTypeSell;
    @FXML
    private ComboBox<MxNode> cmbSettlTypeBuy;
    @FXML
    private ComboBox<MxNode> cmbSettlTypeSell;
    @FXML
    private TextField txtSettlDayBuy;
    @FXML
    private TextField txtSettlDaySell;
    @FXML
    private Spinner<Double> spnPriceBuy;
    @FXML
    private Spinner<Double> spnPriceSell;
    @FXML
    private Spinner<Double> spnYieldBuy;
    @FXML
    private Spinner<Double> spnYieldSell;
    @FXML
    private Spinner<Integer> spnQtyBuy;
    @FXML
    private Spinner<Integer> spnQtySell;
    @FXML
    private Button btnOrder;
    @Inject
    private XBondTradeModel model;
    @Inject
    protected MxAlert alert;
    @Inject
    protected IRefDataMng ref;
    @Inject
    protected MEventService es;
    @Inject
    protected MObjFactory of;
    @Inject
    private MarketDataModel mktModel;
    private MarketItem mktItem;
    @Inject
    private MarketDataModel marketDataModel;
    @Inject
    private CalendarServiceApi calendarApi;
    @Inject
    private CcsAccountMap accntMng;
    @Inject
    private XBondAlertMng xbondAlertMng;
    private SecSuggest suggest = new SecSuggest();
    private ToggleGroup group = new ToggleGroup();
    private ObservableList<HandicapInfo> listHdicapInfoBuy = FxUtils.newList();
    private ObservableList<HandicapInfo> listHdicapInfoSell = FxUtils.newList();
    private DoubleSpinnerCtrl ctrlPriceBuy = new DoubleSpinnerCtrl(true, 6, 4);
    private DoubleSpinnerCtrl ctrlPriceSell = new DoubleSpinnerCtrl(true, 6, 4);
    private DoubleSpinnerCtrl ctrlYieldBuy = new DoubleSpinnerCtrl(false, 6, 4);
    private DoubleSpinnerCtrl ctrlYieldSell = new DoubleSpinnerCtrl(false, 6, 4);
    private IntSpinnerCtrl ctrlCountBuy = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlCountSell = new IntSpinnerCtrl(true, 9, 1);
    private String latestBusinessDate = null;
    private String latestNextBusinessDate = null;
    private ObservableList<CfetsFundAccount> obList = FxUtils.newList();
    @Inject
    private XBondUnfinishedOrderModel unfinishedOrderModel;
    private InvalidationListener lstnUnfinish = ob -> this.resetOwn();
    private boolean extraInfoAlwaysShow = false;
    private Collection<RefItem> refs = null;
    @Inject
    protected UserPreCtrl preModel;
    @Inject
    protected DialogFactory df;
    @Inject
    private ISecAccountService secAccService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetOwn() {
        boolean ownShow = this.checkShow.isSelected();
        if (this.mktItem == null || this.mktItem.getListSellHandicap() == null || this.model.refItem == null) {
            this.listHdicapInfoBuy.clear();
            this.listHdicapInfoSell.clear();
            return;
        }
        ArrayList<HandicapInfo> listMktBuy = new ArrayList<HandicapInfo>();
        ArrayList<HandicapInfo> listMktSell = new ArrayList<HandicapInfo>();
        listMktBuy.addAll((Collection<HandicapInfo>)this.mktItem.getListBuyHandicap().filtered(item -> item.getPrice() > 0.0));
        listMktSell.addAll((Collection<HandicapInfo>)this.mktItem.getListSellHandicap().filtered(item -> item.getPrice() > 0.0));
        ComboBox<MxNode> cmdSettType = this.model.isBuy() ? this.cmbSettlTypeBuy : this.cmbSettlTypeSell;
        SettlType type = SettlType.getSettlType((String)((MxNode)cmdSettType.getSelectionModel().getSelectedItem()).getRaw());
        if (ownShow) {
            HashMap<Double, HandicapInfo> mapBuy = new HashMap<Double, HandicapInfo>();
            HashMap mapSell = new HashMap();
            List<SingleOrder> list = this.unfinishedOrderModel.getList();
            synchronized (list) {
                for (SingleOrder order : this.unfinishedOrderModel.getList()) {
                    if (!order.getSecurityId().equals(this.txtCode.getText()) || !order.getSettlType().toString().equals(type.toString())) continue;
                    HashMap<Double, Object> map = order.getSide() == Side.SIDE_BID ? mapBuy : mapSell;
                    HandicapInfo info = (HandicapInfo)map.get(order.getPrice());
                    if (info == null) {
                        info = new HandicapInfo();
                        info.setClear(false);
                        info.setPrice(order.getPrice());
                        info.setPriceStr(StringUtils.toStr((double)order.getPrice(), (int)4));
                        info.setYield((double)Math.round(order.getYield() * 10000.0) / 10000.0);
                        info.setOrderStr(order.getTraderId());
                        map.put(order.getPrice(), info);
                    }
                    info.setCount((int)((double)info.getCount() + order.getLeavesQty()));
                }
            }
            ArrayList tempSell = new ArrayList(mapSell.values());
            ArrayList tempBuy = new ArrayList(mapBuy.values());
            tempSell.sort((o1, o2) -> (int)((o1.getPrice() - o2.getPrice()) * 10000.0));
            tempBuy.sort((o1, o2) -> (int)((o2.getPrice() - o1.getPrice()) * 10000.0));
            int subIndexBuy = tempBuy.size() > 10 - listMktBuy.size() ? 10 - listMktBuy.size() : tempBuy.size();
            listMktBuy.addAll(tempBuy.subList(0, subIndexBuy));
            int subIndexSell = tempSell.size() > 10 - listMktSell.size() ? 10 - listMktSell.size() : tempSell.size();
            listMktSell.addAll(tempSell.subList(0, subIndexSell));
        }
        this.checkSize10(listMktBuy, true);
        listMktBuy.sort((o1, o2) -> (int)((o2.getPrice() - o1.getPrice()) * 10000.0));
        listMktSell.sort((o1, o2) -> (int)((o2.getPrice() - o1.getPrice()) * 10000.0));
        this.checkSize10(listMktSell, false);
        Platform.runLater(() -> {
            this.listHdicapInfoBuy.setAll((Collection)listMktBuy);
            this.listHdicapInfoSell.setAll((Collection)listMktSell);
        });
    }

    private void checkSize10(List<HandicapInfo> list, boolean buy) {
        if (list.size() == 10) {
            return;
        }
        int i = list.size();
        while (i < 10) {
            if (buy) {
                list.add(new HandicapInfo());
            } else {
                list.add(0, new HandicapInfo());
            }
            ++i;
        }
    }

    @PreDestroy
    protected void close() {
        this.xbondAlertMng.removePart((MxPart)this);
    }

    @FXML
    private void initialize() {
        this.xbondAlertMng.addPart((MxPart)this);
        this.mktItem = this.mktModel.createItem(10);
        Map cfetsAccountMap = this.accntMng.getCfetsAccountMap();
        this.obList.setAll(cfetsAccountMap.values());
        this.cmbAccnt.setItems(this.obList);
        if (this.obList.size() > 0) {
            this.cmbAccnt.setValue((Object)((CfetsFundAccount)this.obList.get(0)));
        } else {
            this.accntMng.changedProperty().addListener((ob, old, now) -> {
                this.obList.clear();
                this.obList.setAll(this.accntMng.getCfetsAccountMap().values());
                this.cmbAccnt.setItems(this.obList);
                if (this.obList.size() > 0) {
                    this.cmbAccnt.setValue((Object)((CfetsFundAccount)this.obList.get(0)));
                }
            });
        }
        this.initControls();
        this.createTableview();
        this.keyEvent();
        this.mktItem.changedProperty().addListener(ob -> this.lstnUnfinish.invalidated(null));
        this.es.subscribe("xbond.refitem.change", event -> {
            if (event.getObj() instanceof MarketItem) {
                MarketItem item = (MarketItem)event.getObj();
                Platform.runLater(() -> {
                    if (this.model.isBuy()) {
                        MxNode node = (MxNode)this.cmbMatchTypeBuy.getSelectionModel().getSelectedItem();
                        this.cmbMatchTypeBuy.getSelectionModel().select((Object)node.getNode(item.getMdBookType() == 2 ? "9" : "10"));
                        node = (MxNode)this.cmbSettlTypeBuy.getSelectionModel().getSelectedItem();
                        this.cmbSettlTypeBuy.getSelectionModel().select((Object)node.getNode(String.valueOf(item.getSettlType().ordinal())));
                    } else {
                        MxNode node = (MxNode)this.cmbMatchTypeSell.getSelectionModel().getSelectedItem();
                        this.cmbMatchTypeSell.getSelectionModel().select((Object)node.getNode(item.getMdBookType() == 2 ? "9" : "10"));
                        node = (MxNode)this.cmbSettlTypeSell.getSelectionModel().getSelectedItem();
                        this.cmbSettlTypeSell.getSelectionModel().select((Object)node.getNode(String.valueOf(item.getSettlType().ordinal())));
                    }
                    this.txtCode.requestFocus();
                    this.txtCode.setText(item.getRefItem().getCode());
                });
            }
        });
        this.refreshBusinessDate();
        this.es.subscribe("auto_reload_refdata", event -> this.refreshBusinessDate());
        StringBinding extFundAccntIdBinding = Bindings.createStringBinding(() -> {
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String extFundAccntId = account.getNewCashAccntId();
            return extFundAccntId;
        }, (Observable[])new Observable[]{this.cmbAccnt.getSelectionModel().selectedItemProperty()});
        this.model.extFundAccntIdProperty().bind((ObservableValue)extFundAccntIdBinding);
        StringBinding investorIdBinding = Bindings.createStringBinding(() -> {
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String investorId = account.getInvestId();
            return investorId;
        }, (Observable[])new Observable[]{this.cmbAccnt.getSelectionModel().selectedItemProperty()});
        this.model.investorIdProperty().bind((ObservableValue)investorIdBinding);
        StringBinding extSecAccntIdBinding = Bindings.createStringBinding(() -> {
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String extSecAccntId = null;
            try {
                Map mapAccount = this.secAccService.getAllSecAccountMap();
                List list = (List)mapAccount.get(account);
                logger.error("\u8bc1\u5238\u8d26\u6237\u6570\u91cf\uff1a" + list.size());
                if (list.size() > 0) {
                    extSecAccntId = ((SecAccount)list.get(0)).getExtSecAccntId();
                    logger.error("\u8bc1\u5238\u8d26\u6237\u7b2c\u4e00\u4e2a\uff1a" + extSecAccntId);
                }
            }
            catch (MException e) {
                e.printStackTrace();
            }
            return extSecAccntId;
        }, (Observable[])new Observable[]{this.cmbAccnt.getSelectionModel().selectedItemProperty()});
        this.model.extSecAccntIdProperty().bind((ObservableValue)extSecAccntIdBinding);
        StringBinding investorsecIdBinding = Bindings.createStringBinding(() -> {
            CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
            String investorsecId = null;
            try {
                Map mapAccount = this.secAccService.getAllSecAccountMap();
                List list = (List)mapAccount.get(account);
                logger.error("\u8bc1\u5238\u8d26\u6237\u6570\u91cf\uff1a" + list.size());
                if (list.size() > 0) {
                    investorsecId = ((SecAccount)list.get(0)).getInverstorSecId();
                    logger.error("\u8bc1\u5238\u8d26\u6237\u7b2c\u4e00\u4e2a\uff1a" + investorsecId);
                }
            }
            catch (MException e) {
                logger.error("\u8bc1\u5238\u8d26\u53f7\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            }
            return investorsecId;
        }, (Observable[])new Observable[]{this.cmbAccnt.getSelectionModel().selectedItemProperty()});
        this.model.investorsecIdProperty().bind((ObservableValue)investorsecIdBinding);
        this.unfinishedOrderModel.changedProperty().addListener(this.lstnUnfinish);
        if (this.unfinishedOrderModel.getList().isEmpty()) {
            this.unfinishedOrderModel.query();
        }
        this.gridPaneExtraInfo.setVisible(false);
        FxUtils.makePC((Node)this.lbArrow, (String)"left", (boolean)true);
        this.lbArrow.setOnMouseClicked(event -> {
            FxUtils.makePC((Node)this.lbArrow, (String)"left", (boolean)this.extraInfoAlwaysShow);
            this.extraInfoAlwaysShow = !this.extraInfoAlwaysShow;
            this.gridPaneExtraInfo.setVisible(this.extraInfoAlwaysShow);
            if (this.extraInfoAlwaysShow) {
                this.resetExtraInfo();
            }
        });
        this.lbArrow.setOnMouseEntered(event -> {
            if (this.extraInfoAlwaysShow) {
                return;
            }
            this.gridPaneExtraInfo.setVisible(true);
            this.resetExtraInfo();
        });
        this.lbArrow.setOnMouseExited(event -> {
            if (this.extraInfoAlwaysShow) {
                return;
            }
            this.gridPaneExtraInfo.setVisible(false);
        });
        this.model.countBuyProperty().addListener(ob -> this.resetExtraInfo());
        this.model.countSellProperty().addListener(ob -> this.resetExtraInfo());
    }

    private void refreshBusinessDate() {
        GetBusinessDateReq bizDateReq = new GetBusinessDateReq();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        bizDateReq.setDate(today);
        bizDateReq.setMarket("XCFE");
        bizDateReq.setMarketGrp("IB");
        try {
            GetBusinessDateResp resp = this.calendarApi.GetBusinessDate(bizDateReq);
            this.latestBusinessDate = resp.getLatestBusinessDate();
            this.latestNextBusinessDate = resp.getLatestNextBusinessDate();
            MxNode node = (MxNode)this.cmbSettlTypeBuy.getSelectionModel().getSelectedItem();
            SettlType type = SettlType.getSettlType((String)node.getRaw());
            if (type == SettlType.CASH_OR_TOD_OR_T_PLUS_0_SETTLTYPE) {
                this.txtSettlDayBuy.setText(this.latestBusinessDate);
            } else {
                this.txtSettlDayBuy.setText(this.latestNextBusinessDate);
            }
            node = (MxNode)this.cmbSettlTypeSell.getSelectionModel().getSelectedItem();
            type = SettlType.getSettlType((String)node.getRaw());
            if (type == SettlType.CASH_OR_TOD_OR_T_PLUS_0_SETTLTYPE) {
                this.txtSettlDaySell.setText(this.latestBusinessDate);
            } else {
                this.txtSettlDaySell.setText(this.latestNextBusinessDate);
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u83b7\u53d6\u4ea4\u6613\u65e5\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private void createTableview() {
        this.indexSell.setCellValueFactory(p -> {
            int index = ((HandicapInfo)p.getValue()).getIndex();
            StringBuilder builder = new StringBuilder("\u5356");
            if (index != 0) {
                builder.append(StringUtils.numToChinese((int)index)).toString();
            }
            return new ReadOnlyStringWrapper(builder.toString());
        });
        this.indexBuy.setCellValueFactory(p -> {
            int index = ((HandicapInfo)p.getValue()).getIndex();
            StringBuilder builder = new StringBuilder("\u4e70");
            if (index != 0) {
                builder.append(StringUtils.numToChinese((int)index)).toString();
            }
            return new ReadOnlyStringWrapper(builder.toString());
        });
        this.mktSellYield.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).yieldProperty());
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.mktBuyYield.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).yieldProperty());
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellSettlType.setCellValueFactory(data -> this.mktItem.settlTypeNameProperty());
        this.colBuySettlType.setCellValueFactory(data -> this.mktItem.settlTypeNameProperty());
        this.colSellSettlType.setCellFactory(cell -> new SettlTypeCell());
        this.colBuySettlType.setCellFactory(cell -> new SettlTypeCell());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell());
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(true));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(false));
        this.mktSellYield.setCellFactory(cell -> new YieldCell());
        this.mktBuyYield.setCellFactory(cell -> new YieldCell());
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.tableMarketBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected(true, (HandicapInfo)now));
        this.tableMarketSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected(false, (HandicapInfo)now));
        this.tableMarketBuy.setItems(this.listHdicapInfoBuy);
        this.tableMarketSell.setItems(this.listHdicapInfoSell);
    }

    private void onItemSelected(boolean buy, HandicapInfo now) {
        if (now != null) {
            if (buy) {
                this.radioSell.setSelected(true);
                this.model.setPriceSell(now.getPrice());
            } else {
                this.radioBuy.setSelected(true);
                this.model.setPriceBuy(now.getPrice());
            }
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void clearSelection() {
        this.tableMarketBuy.getSelectionModel().clearSelection();
        this.tableMarketSell.getSelectionModel().clearSelection();
    }

    @Override
    public void resetExtraInfo() {
        CalcYieldResp resp = this.model.getResp();
        if (!this.gridPaneExtraInfo.isVisible()) {
            return;
        }
        if (resp == null) {
            this.lbAccruedInterest.setText("");
            this.lbDirtyPx.setText("");
            this.lbAmt.setText("");
            this.lbAccruedInterestAmt.setText("");
            this.lbSettlementAmt.setText("");
            return;
        }
        double clean = this.model.isBuy() ? this.model.getPriceBuy() : this.model.getPriceSell();
        double qty = this.model.isBuy() ? this.model.getCountBuy() : this.model.getCountSell();
        double dirty = resp.getDirtyPx();
        double interest = resp.getAccruedAmount();
        double amt = clean * qty * 1.0E7 / 100.0;
        double interestAmt = interest * qty * 1.0E7 / 100.0;
        double settlementAmt = dirty * qty * 1.0E7 / 100.0;
        this.lbAccruedInterest.setText(String.valueOf(StringUtils.toThousands((Number)interest, (int)4)) + " \u5143");
        this.lbDirtyPx.setText(String.valueOf(StringUtils.toThousands((Number)dirty, (int)4)) + " \u5143");
        this.lbAmt.setText(String.valueOf(StringUtils.toThousands((Number)amt, (int)2)) + " \u5143");
        this.lbAccruedInterestAmt.setText(String.valueOf(StringUtils.toThousands((Number)interestAmt, (int)2)) + " \u5143");
        this.lbSettlementAmt.setText(String.valueOf(StringUtils.toThousands((Number)settlementAmt, (int)2)) + " \u5143");
    }

    private void initControls() {
        this.initSecurity();
        this.txtCode.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
        this.checkShow.selectedProperty().addListener(ob -> this.resetOwn());
        this.radioBS.setToggleGroup(this.group);
        this.radioBuy.setToggleGroup(this.group);
        this.radioSell.setToggleGroup(this.group);
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            if (this.radioBS.isSelected()) {
                this.model.setBuy(true);
                this.model.setSell(true);
                this.tradeBoxBuy.setDisable(false);
                this.tradeBoxSell.setDisable(false);
            }
            if (this.radioBuy.isSelected()) {
                this.model.setBuy(true);
                this.model.setSell(false);
                this.tradeBoxBuy.setDisable(false);
                this.tradeBoxSell.setDisable(true);
                this.onSettlTypeChange((MxNode)this.cmbSettlTypeBuy.getSelectionModel().getSelectedItem());
                this.model.calcYieldResp("PRICE", this);
            }
            if (this.radioSell.isSelected()) {
                this.model.setBuy(false);
                this.model.setSell(true);
                this.tradeBoxBuy.setDisable(true);
                this.tradeBoxSell.setDisable(false);
                this.onSettlTypeChange((MxNode)this.cmbSettlTypeSell.getSelectionModel().getSelectedItem());
                this.model.calcYieldResp("PRICE", this);
            }
        });
        MxNode node = new MxNode().load("match_type", "9");
        this.cmbMatchTypeBuy.valueProperty().bindBidirectional(this.model.matchTypeBuyProperty());
        this.cmbMatchTypeBuy.setItems(node.getNodes());
        this.cmbMatchTypeBuy.setValue((Object)node);
        this.cmbMatchTypeBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onMatchTypeChange((MxNode)now));
        node = new MxNode().load("match_type", "9");
        this.cmbMatchTypeSell.valueProperty().bindBidirectional(this.model.matchTypeSellProperty());
        this.cmbMatchTypeSell.setItems(node.getNodes());
        this.cmbMatchTypeSell.setValue((Object)node);
        this.cmbMatchTypeSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onMatchTypeChange((MxNode)now));
        node = new MxNode().load("settl_type", "2");
        this.cmbSettlTypeBuy.valueProperty().bindBidirectional(this.model.settlTypeBuyProperty());
        this.cmbSettlTypeBuy.setItems(node.getNodes());
        this.cmbSettlTypeBuy.setValue((Object)node);
        this.cmbSettlTypeBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.onSettlTypeChange((MxNode)now);
            this.spnPriceBuy.getEditor().clear();
        });
        new MxNode().load("settl_type", "2");
        this.cmbSettlTypeSell.valueProperty().bindBidirectional(this.model.settlTypeSellProperty());
        this.cmbSettlTypeSell.setItems(node.getNodes());
        this.cmbSettlTypeSell.setValue((Object)node);
        this.cmbSettlTypeSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.onSettlTypeChange((MxNode)now);
            this.spnPriceSell.getEditor().clear();
        });
        this.radioBuy.setSelected(true);
        MxBindings.bindSD((Property)this.spnPriceBuy.getEditor().textProperty(), (Property)this.model.priceBuyProperty());
        MxBindings.bindSD((Property)this.spnPriceSell.getEditor().textProperty(), (Property)this.model.priceSellProperty());
        MxBindings.bindSD((Property)this.spnQtyBuy.getEditor().textProperty(), (Property)this.model.countBuyProperty());
        MxBindings.bindSD((Property)this.spnQtySell.getEditor().textProperty(), (Property)this.model.countSellProperty());
        MxBindings.bindSD((Property)this.spnYieldBuy.getEditor().textProperty(), (Property)this.model.yieldBuyProperty());
        MxBindings.bindSD((Property)this.spnYieldSell.getEditor().textProperty(), (Property)this.model.yieldSellProperty());
        this.spnPriceBuy.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.spnPriceBuy.getEditor().setText("");
        this.spnPriceSell.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.spnPriceSell.getEditor().setText("");
        this.spnQtyBuy.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$", 10));
        this.spnQtyBuy.getEditor().setText("");
        this.spnQtySell.getEditor().setTextFormatter((TextFormatter)new Formatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$", 10));
        this.spnQtySell.getEditor().setText("");
        this.ctrlPriceBuy.ctrl(this.spnPriceBuy);
        this.ctrlPriceSell.ctrl(this.spnPriceSell);
        this.ctrlYieldBuy.ctrl(this.spnYieldBuy);
        this.ctrlYieldSell.ctrl(this.spnYieldSell);
        this.ctrlCountBuy.ctrl(this.spnQtyBuy);
        this.ctrlCountSell.ctrl(this.spnQtySell);
        this.spnPriceBuy.getEditor().textProperty().addListener((ob, old, now) -> {
            if (StringUtils.parseDouble((String)old) != StringUtils.parseDouble((String)now)) {
                this.model.calcYieldResp("PRICE", this);
            }
        });
        this.spnYieldBuy.getEditor().textProperty().addListener((ob, old, now) -> {
            if (StringUtils.parseDouble((String)old) != StringUtils.parseDouble((String)now)) {
                this.model.calcYieldResp("YIELD", this);
            }
        });
        this.spnPriceSell.getEditor().textProperty().addListener((ob, old, now) -> {
            if (StringUtils.parseDouble((String)old) != StringUtils.parseDouble((String)now)) {
                this.model.calcYieldResp("PRICE", this);
            }
        });
        this.spnYieldSell.getEditor().textProperty().addListener((ob, old, now) -> {
            if (StringUtils.parseDouble((String)old) != StringUtils.parseDouble((String)now)) {
                this.model.calcYieldResp("YIELD", this);
            }
        });
    }

    private void onMatchTypeChange(MxNode now) {
        int mdBookType = now.getRaw().equals("9") ? 2 : 107;
        this.mktItem.setMdBookType(mdBookType);
        XBond ref = this.model.refItem;
        if (ref == null) {
            return;
        }
        SettlType type = this.model.isBuy() ? SettlType.getSettlType((String)((MxNode)this.cmbSettlTypeBuy.getSelectionModel().getSelectedItem()).getRaw()) : SettlType.getSettlType((String)((MxNode)this.cmbSettlTypeSell.getSelectionModel().getSelectedItem()).getRaw());
        String key = String.valueOf(ref.getMarket()) + ref.getCode() + type.name() + mdBookType;
        MarketItem item = (MarketItem)((Map)this.marketDataModel.getMapInfo().get(ref)).get(key);
        this.mktItem.update((Object)item);
    }

    private void onSettlTypeChange(MxNode now) {
        XBond ref;
        SettlType type = SettlType.getSettlType((String)now.getRaw());
        this.mktItem.setSettlType(type);
        if (this.model.isBuy()) {
            if (type == SettlType.CASH_OR_TOD_OR_T_PLUS_0_SETTLTYPE && this.latestBusinessDate != null) {
                this.txtSettlDayBuy.setText(this.latestBusinessDate);
            }
            if (type == SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1 && this.latestNextBusinessDate != null) {
                this.txtSettlDayBuy.setText(this.latestNextBusinessDate);
            }
        } else {
            if (type == SettlType.CASH_OR_TOD_OR_T_PLUS_0_SETTLTYPE && this.latestBusinessDate != null) {
                this.txtSettlDaySell.setText(this.latestBusinessDate);
            }
            if (type == SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1 && this.latestNextBusinessDate != null) {
                this.txtSettlDaySell.setText(this.latestNextBusinessDate);
            }
        }
        if ((ref = this.model.refItem) == null) {
            return;
        }
        int mdBookType = this.model.isBuy() ? (((MxNode)this.cmbMatchTypeBuy.getSelectionModel().getSelectedItem()).getRaw().equals("9") ? 2 : 107) : (((MxNode)this.cmbMatchTypeSell.getSelectionModel().getSelectedItem()).getRaw().equals("9") ? 2 : 107);
        String key = String.valueOf(ref.getMarket()) + ref.getCode() + type.name() + mdBookType;
        MarketItem item = (MarketItem)((Map)this.marketDataModel.getMapInfo().get(ref)).get(key);
        this.mktItem.update((Object)item);
    }

    private void keyEvent() {
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.spnQtyBuy.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.qtyKeyPress((KeyEvent)event));
        this.spnPriceBuy.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event, this.spnQtyBuy));
        this.spnQtySell.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.qtyKeyPress((KeyEvent)event));
        this.spnPriceSell.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event, this.spnQtySell));
    }

    private void codeKeyPress(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key, Spinner<?> spnQty) {
        if (KeyCode.ENTER == key.getCode()) {
            spnQty.getEditor().requestFocus();
            key.consume();
        }
    }

    private void qtyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order();
            key.consume();
        }
    }

    private void initSecurity() {
        this.refs = this.ref.getItems(new String[]{"BONDXcfeXBond"});
        this.ref.changedProperty().addListener((ob, old, now) -> {
            this.refs = this.ref.getItems(new String[]{"BONDXcfeXBond"});
            this.suggest.setAllSuggestions(this.refs);
        });
        this.suggest.addPossibleSuggestions(this.refs);
        AutoCompletion auto = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.suggest, (StringConverter)((StringConverter)this.of.create(SecConverter.class)));
        auto.changedProperty().addListener((ob, old, now) -> {
            this.model.refItem = (XBond)this.txtCode.getUserData();
            if (this.model.refItem != null) {
                this.lbName.setText(this.model.refItem.getName());
                this.lbTermToMaturity.setText(this.model.refItem.getTermToMaturityString());
                String netVal = String.format("%.4f", this.model.refItem.getNetVal());
                String yldRat = String.format("%.4f", this.model.refItem.getYldRat());
                this.lbNetVal.setText(String.valueOf(netVal) + " / " + yldRat);
                this.lbIssrRat.setText(String.valueOf(this.model.refItem.getIssrRat()) + " / " + this.model.refItem.getRatLvl());
            } else {
                this.lbName.setText("");
                this.lbTermToMaturity.setText("-");
                this.lbNetVal.setText("-");
                this.lbIssrRat.setText("-");
                this.spnPriceBuy.getEditor().clear();
                this.spnYieldBuy.getEditor().clear();
                this.spnQtyBuy.getEditor().clear();
                this.spnPriceSell.getEditor().clear();
                this.spnYieldSell.getEditor().clear();
                this.spnQtySell.getEditor().clear();
            }
            this.onRefItemChange();
        });
        this.txtCode.setTextFormatter((TextFormatter)new SecFormatter("[A-Za-z0-9_]*", 12));
    }

    private void onRefItemChange() {
        if (this.model.refItem != null) {
            int mdBookType;
            SettlType type;
            XBond ref = this.model.refItem;
            if (this.model.isBuy()) {
                type = SettlType.getSettlType((String)((MxNode)this.cmbSettlTypeBuy.getSelectionModel().getSelectedItem()).getRaw());
                mdBookType = ((MxNode)this.cmbMatchTypeBuy.getSelectionModel().getSelectedItem()).getRaw().equals("9") ? 2 : 107;
            } else {
                type = SettlType.getSettlType((String)((MxNode)this.cmbSettlTypeSell.getSelectionModel().getSelectedItem()).getRaw());
                mdBookType = ((MxNode)this.cmbMatchTypeSell.getSelectionModel().getSelectedItem()).getRaw().equals("9") ? 2 : 107;
            }
            String key = String.valueOf(ref.getMarket()) + ref.getCode() + type.name() + mdBookType;
            Map map = (Map)this.marketDataModel.getMapInfo().get(ref);
            if (map == null) {
                this.marketDataModel.subMarketItem((RefItem)this.model.refItem);
            }
            MarketItem item = (MarketItem)((Map)this.marketDataModel.getMapInfo().get(ref)).get(key);
            this.mktItem.setRefItem((RefItem)this.model.refItem);
            this.mktItem.setSettlType(type);
            this.mktItem.setMdBookType(mdBookType);
            this.mktItem.update((Object)item);
            this.listHdicapInfoBuy.clear();
            this.listHdicapInfoSell.clear();
            this.lstnUnfinish.invalidated(null);
        } else {
            this.mktItem.clear();
        }
        this.model.calcYieldResp("PRICE", this);
    }

    private boolean valid() {
        if (this.cmbAccnt.getSelectionModel().getSelectedItem() == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8d44\u91d1\u8d26\u53f7");
            return false;
        }
        if (this.model.refItem == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
            return false;
        }
        if (this.model.isBuy() && this.model.getPriceBuy() == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u51c0\u4ef7");
            return false;
        }
        if (this.model.isSell() && this.model.getPriceSell() == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u51c0\u4ef7");
            return false;
        }
        if (this.model.isBuy() && this.model.getCountBuy() == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u4e70\u5165\u5238\u9762\u603b\u989d");
            return false;
        }
        if (this.model.isSell() && this.model.getCountSell() == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u5356\u51fa\u5238\u9762\u603b\u989d");
            return false;
        }
        if (this.model.isBuy() && Double.valueOf(this.spnQtyBuy.getEditor().getText().replace(",", "")) > 100.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e70\u5165\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100(\u5343\u4e07)");
            return false;
        }
        if (this.model.isSell() && Double.valueOf(this.spnQtySell.getEditor().getText().replace(",", "")) > 100.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u5356\u51fa\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100(\u5343\u4e07)");
            return false;
        }
        return true;
    }

    @FXML
    public void order() {
        if (!this.valid()) {
            return;
        }
        if (this.preModel.isPopBeforeOrder()) {
            XBondConfirmDialog obj = (XBondConfirmDialog)((Object)this.of.create(XBondConfirmDialog.class));
            obj.setRefItem((RefItem)this.model.refItem);
            obj.setUnit("\u5f20");
            obj.setList(this.model.getEntrustList());
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
            if (dialog.launch() != ButtonType.OK) {
                return;
            }
        }
        try {
            this.model.submit();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getSettlDate() {
        return this.radioBuy.isSelected() ? this.txtSettlDayBuy.getText() : this.txtSettlDaySell.getText();
    }

    class HandicapCountCell
    extends TableCell<HandicapInfo, Number> {
        private static final int INVALID_COUNT = -1;

        HandicapCountCell() {
        }

        public void updateItem(Number item, boolean empty) {
            HandicapInfo handiInfo;
            if (!empty && item.longValue() != -1L && (handiInfo = (HandicapInfo)this.getTableRow().getItem()) != null && !handiInfo.isClear()) {
                this.setText(String.valueOf(item));
                return;
            }
            this.setText(null);
        }
    }

    public class PriceCell
    extends TableCell<HandicapInfo, String> {
        private boolean buy = false;

        PriceCell(boolean buy) {
            CssUtils.priceTag((Control)this);
            this.buy = buy;
        }

        public void updateItem(String item, boolean empty) {
            HandicapInfo handiInfo;
            if (!(empty || item.isEmpty() || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear())) {
                double price = Double.parseDouble(item);
                String traderId = handiInfo.getOrderStr();
                if (handiInfo.getIndex() == 0 && !StringUtils.isEmpty((String)traderId)) {
                    if (TraderModel.traderId.equals(traderId)) {
                        CssUtils.makePink((Control)this);
                    } else {
                        CssUtils.makeYellow((Control)this);
                    }
                } else if (this.buy) {
                    CssUtils.makeFall((Control)this);
                } else {
                    CssUtils.makeRise((Control)this);
                }
                if (price > 0.0) {
                    String txt = String.format("%.4f", price);
                    this.setText(txt);
                    return;
                }
            }
            this.setText(null);
        }
    }

    public class SettlTypeCell
    extends TableCell<HandicapInfo, String> {
        public void updateItem(String item, boolean empty) {
            HandicapInfo handiInfo;
            if (!(empty || item.isEmpty() || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear() || !(handiInfo.getPrice() > 0.0) && handiInfo.getCount() <= 0)) {
                this.setText(item);
                return;
            }
            this.setText(null);
        }
    }

    public class YieldCell
    extends TableCell<HandicapInfo, Number> {
        public void updateItem(Number item, boolean empty) {
            HandicapInfo handiInfo;
            if (!empty && item.doubleValue() > 0.0 && (handiInfo = (HandicapInfo)this.getTableRow().getItem()) != null && !handiInfo.isClear()) {
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)4));
                return;
            }
            this.setText(null);
        }
    }
}

