/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondStrategyModel;
import cms.tmx.bond.models.XBondUnfinishedOrderModel;
import cms.tmx.bond.views.AddXBondStrategyDialog;
import cms.tmx.bond.views.IXBondStrategy;
import cms.tmx.bond.views.XBondStrategyLibraryDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.XBondStrategy;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.trade.message.XBondAlertMng;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondStrategyPart
extends MxPart
implements IXBondStrategy {
    private MxList<XBondStrategy> mlist = new MxList();
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnStart;
    @FXML
    private Button btnStop;
    @FXML
    private TableView<XBondStrategy> tableStrategy;
    @FXML
    private TableColumn<XBondStrategy, Boolean> selected;
    @FXML
    private TableColumn<XBondStrategy, String> errorMsg;
    @FXML
    private TableColumn<XBondStrategy, Object> operate;
    @FXML
    private TableColumn<XBondStrategy, MxNode> status;
    @FXML
    private TableColumn<XBondStrategy, Number> dealLimit;
    @FXML
    private TableColumn<XBondStrategy, String> contextId;
    @FXML
    private TableColumn<XBondStrategy, String> securityId;
    @FXML
    private TableColumn<XBondStrategy, String> securityName;
    @FXML
    private TableColumn<XBondStrategy, MxNode> type;
    @FXML
    private TableColumn<XBondStrategy, String> name;
    @FXML
    private TableColumn<XBondStrategy, Number> filledQty;
    @FXML
    private TableColumn<XBondStrategy, MxNode> cancelType;
    @FXML
    private TableColumn<XBondStrategy, String> yieldBid;
    @FXML
    private TableColumn<XBondStrategy, String> yieldOffer;
    @FXML
    private TableColumn<XBondStrategy, String> priceBid;
    @FXML
    private TableColumn<XBondStrategy, String> priceOffer;
    @FXML
    private TextField searchText;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng ref;
    @FXML
    private Label lbCount;
    @Inject
    private XBondStrategyModel model;
    @Inject
    private XBondAlertMng xbondAlertMng;
    private Predicate<XBondStrategy> pd = t -> {
        if (t.isTemplate()) {
            return false;
        }
        String code = t.getSecurityId().toUpperCase();
        String name = t.getName().toUpperCase();
        String txt = this.searchText.getText().toUpperCase();
        return code.contains(txt) || name.contains(txt);
    };
    private ChangeListener<? super Boolean> selectedLis = (o, old, now) -> this.checkBtnStatus();
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        ArrayList<XBondStrategy> newList = new ArrayList<XBondStrategy>();
        ObservableList<XBondStrategy> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<XBondStrategy>)this.model.getList());
        }
        this.mlist.update(newList, this.pd);
        this.checkBtnStatus();
        this.tableStrategy.refresh();
        for (XBondStrategy strategy : this.mlist.getList()) {
            strategy.selectedProperty().removeListener(this.selectedLis);
            strategy.selectedProperty().addListener(this.selectedLis);
        }
        logger.debug("XBond\u7b56\u7565\u4ea4\u6613\u5237\u65b0\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listenerStatus = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        this.checkBtnStatus();
        logger.debug("checkBtnStatus\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener lstnSearch = ob -> {
        long start = System.currentTimeMillis();
        ArrayList<XBondStrategy> newList = new ArrayList<XBondStrategy>();
        ObservableList<XBondStrategy> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<XBondStrategy>)this.model.getList());
        }
        this.mlist.filter(newList, this.pd);
        this.mlist.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
        this.checkBtnStatus();
        this.tableStrategy.refresh();
        logger.debug("XBond\u7b56\u7565\u6a21\u7cca\u641c\u7d22\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    };
    private InvalidationListener listener = ob -> this.refresh();
    private InvalidationListener lstnLayout = ob -> Platform.runLater(() -> this.tableStrategy.layout());
    @Inject
    private XBondUnfinishedOrderModel unfinishModel;
    @Inject
    private ExecutorService exe;
    private static final Logger logger = LogManager.getLogger(IXBondStrategy.class);

    @FXML
    public void initialize() {
        this.xbondAlertMng.addPart((MxPart)this);
        this.createTable();
        this.model.changedProperty().addListener(this.lstnModel);
        this.model.changedYieldProperty().addListener(this.lstnLayout);
        this.model.statusChangedProperty().addListener(this.listenerStatus);
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.ref.changedProperty().addListener(this.listener);
        this.refresh();
        this.lbCount.textProperty().bind((ObservableValue)XBondStrategyModel.refreshTime);
        TableUtils.doubleClicked(this.tableStrategy, strategy -> {
            this.model.subYields(Arrays.asList(strategy));
            return true;
        });
    }

    @FXML
    public void add() {
        AddXBondStrategyDialog obj = (AddXBondStrategyDialog)((Object)this.of.create(AddXBondStrategyDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7b56\u7565");
        obj.setDialog(dialog);
        dialog.launch();
    }

    @FXML
    public void copyNew() {
        XBondStrategy strategy = (XBondStrategy)this.tableStrategy.getSelectionModel().getSelectedItem();
        this.copyNew(strategy);
    }

    @FXML
    public void remove() {
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u5148\u505c\u6b62\u6267\u884c\u4e2d\u6216\u6682\u505c\u7684\u7b56\u7565");
            return;
        }
        boolean bDel = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u79fb\u9664\u52fe\u9009\u7684\u7b56\u7565\uff1f");
        if (!bDel) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            try {
                XBondStrategy s = new XBondStrategy();
                s.update((Object)strategy);
                s.setTemplate(true);
                this.model.updateStrategy(s);
            }
            catch (MException e) {
                builder.append(String.valueOf(strategy.getContextId()) + e.getMessage() + "\n");
            }
        }
        if (!builder.toString().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, builder.toString());
        }
    }

    @FXML
    public void execute() {
        ArrayList<String> listId = new ArrayList<String>();
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || strategy.getStatus().getRaw().equals("1")) continue;
            listId.add(strategy.getContextId());
        }
        try {
            this.unfinishModel.fullQuery();
        }
        catch (MException | IOException e1) {
            logger.error("xbond\u7b56\u7565\u6267\u884c\uff0c\u66f4\u65b0\u672a\u5b8c\u6210\u59d4\u6258\u5931\u8d25", e1);
        }
        for (String contextId : listId) {
            String tip;
            if (!this.unfinishModel.getMapUnfinish().containsKey(contextId) || this.alert.alert(Alert.AlertType.CONFIRMATION, tip = "\u8be5\u7b56\u7565\u4e0a\u6b21\u505c\u6b62\u540e\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8ba2\u5355\uff0c\u5efa\u8bae\u5148\u68c0\u67e5\u4e00\u4e0b\u672a\u5b8c\u6210\u7684\u8ba2\u5355\uff0c\u5e76\u624b\u5de5\u64a4\u56de\u3002\u662f\u5426\u7ee7\u7eed\u672c\u6b21\u6267\u884c\uff1f")) continue;
            return;
        }
        this.exe.execute(() -> {
            try {
                Map<String, String> failed = this.model.startStrategy(listId);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u6267\u884c\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, str.toString());
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    @FXML
    public void stop() {
        ArrayList<String> listId = new ArrayList<String>();
        String market = "";
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            market = strategy.getMarket();
            listId.add(strategy.getContextId());
        }
        if (listId.isEmpty()) {
            this.alert.check(false, Alert.AlertType.INFORMATION, "\u65e0\u53ef\u505c\u6b62\u7684\u7b56\u7565\uff01");
            return;
        }
        try {
            Map<String, String> failed = this.model.stopStrategy(market, listId);
            if (failed.keySet().size() > 0) {
                StringBuilder str = new StringBuilder();
                str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                for (String s : failed.keySet()) {
                    str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                }
                this.alert.alert(Alert.AlertType.ERROR, str.toString());
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void stopAll() {
        ArrayList<String> listId = new ArrayList<String>();
        String market = "";
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            market = strategy.getMarket();
            listId.add(strategy.getContextId());
        }
        if (!market.isEmpty() && listId.size() > 0) {
            try {
                Map<String, String> failed = this.model.stopStrategy(market, listId);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    this.alert.alert(Alert.AlertType.ERROR, str.toString());
                }
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
        try {
            this.model.stopAll();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void strategyLib() {
        XBondStrategyLibraryDialog lib = (XBondStrategyLibraryDialog)this.of.create(XBondStrategyLibraryDialog.class);
        MxDialog dialog = this.df.create((DialogObj)lib, "\u7b56\u7565\u5e93");
        lib.button = dialog.getButton(lib.buttonType);
        dialog.launch().getText().equals("\u6dfb\u52a0\u5230\u6267\u884c\u9762\u677f");
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.model.statusChangedProperty().removeListener(this.listenerStatus);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.ref.changedProperty().removeListener(this.listener);
        this.xbondAlertMng.removePart((MxPart)this);
    }

    private void createTable() {
        this.tableStrategy.setPlaceholder((Node)new Label());
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        this.selected.setSortable(false);
        TableUtils.isCheckBox(this.selected);
        this.contextId.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).contextIdProperty());
        this.securityId.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).securityIdProperty());
        this.securityName.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).securityNameProperty());
        this.type.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).typeProperty());
        this.name.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).nameProperty());
        this.status.setCellValueFactory(data -> ((XBondStrategy)data.getValue()).statusProperty());
        this.errorMsg.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).errorMsgProperty());
        this.dealLimit.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).dealLimitProperty());
        this.filledQty.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).filledQtyProperty());
        this.contextId.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).contextIdProperty());
        this.selected.setCellValueFactory(data -> ((XBondStrategy)data.getValue()).selectedProperty());
        this.operate.setCellValueFactory(data -> this.setOperate((XBondStrategy)data.getValue()));
        this.cancelType.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).cancelTypeProperty());
        this.yieldBid.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).yieldBidProperty());
        this.yieldOffer.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).yieldOfferProperty());
        this.priceBid.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).priceBidProperty());
        this.priceOffer.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).priceOfferProperty());
        this.mlist.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
        this.tableStrategy.setItems(this.mlist.getList());
    }

    private void checkBtnStatus() {
        this.btnRemove.setDisable(true);
        this.btnStart.setDisable(true);
        this.btnStop.setDisable(true);
        int selectedNum = 0;
        int runningNum = 0;
        int pausingNum = 0;
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            ++selectedNum;
            switch (strategy.getStatus().getRaw()) {
                case "1": {
                    ++runningNum;
                    break;
                }
                case "3": {
                    ++pausingNum;
                    break;
                }
            }
        }
        if (selectedNum > 0) {
            this.btnRemove.setDisable(false);
        }
        if (selectedNum - runningNum > 0) {
            this.btnStart.setDisable(false);
        }
        if (runningNum > 0 || pausingNum > 0) {
            this.btnStop.setDisable(false);
        }
    }

    @Override
    public MObjFactory getObjFactory() {
        return this.of;
    }

    @Override
    public DialogFactory getDialogFactory() {
        return this.df;
    }

    @Override
    public MxAlert getAlert() {
        return this.alert;
    }

    @Override
    public XBondStrategyModel getModel() {
        return this.model;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public boolean isLibPane() {
        return false;
    }

    @Override
    public TableView<XBondStrategy> getTable() {
        return this.tableStrategy;
    }

    @Override
    @FXML
    public void refresh() {
        this.getModel().query(this.isLibPane());
    }
}

