/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondStrategyModel;
import cms.tmx.bond.views.AddXBondStrategyDialog;
import cms.tmx.bond.views.IXBondStrategy;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.XBondStrategy;
import cms.tmx.entity.trade.XBondStrategySerialize;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondStrategyLibraryDialog
extends DialogObj
implements IXBondStrategy {
    private static final Logger logger = LogManager.getLogger(XBondStrategyLibraryDialog.class);
    @Inject
    protected XBondStrategyModel model;
    private MxList<XBondStrategy> mlist = new MxList();
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnDel;
    @FXML
    private TableView<XBondStrategy> tableStrategy;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<XBondStrategy, Boolean> selected;
    @FXML
    private TableColumn<XBondStrategy, Object> operate;
    @FXML
    private TableColumn<XBondStrategy, Number> dealLimit;
    @FXML
    private TableColumn<XBondStrategy, String> contextId;
    @FXML
    private TableColumn<XBondStrategy, String> securityId;
    @FXML
    private TableColumn<XBondStrategy, String> securityName;
    @FXML
    private TableColumn<XBondStrategy, MxNode> tacticsType;
    @FXML
    private TableColumn<XBondStrategy, String> name;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng ref;
    private Predicate<XBondStrategy> pd = data -> {
        String text = this.txtSearch.getText().trim().toUpperCase();
        return data.getSecurityId().toUpperCase().contains(text) || data.getName().toUpperCase().contains(text);
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        if (this.mlist.getList().size() == this.model.getList().size() - 1) {
            this.mlist.update(this.model.getList(), this.pd);
            XBondStrategy copy = this.model.getCopyStrategy();
            int last = this.mlist.getList().size() - 1;
            if (copy != null) {
                XBondStrategy strategyNew = (XBondStrategy)this.mlist.getList().get(last);
                int insertIndex = this.tableStrategy.getItems().indexOf((Object)copy) + 1;
                this.tableStrategy.getItems().remove(last);
                this.tableStrategy.getItems().add(insertIndex, (Object)strategyNew);
                this.tableStrategy.getSelectionModel().select((Object)strategyNew);
            } else {
                this.tableStrategy.getSelectionModel().select(last);
            }
        } else {
            this.mlist.update(this.model.getList(), this.pd);
        }
        this.checkBtnStatus();
        this.tableStrategy.refresh();
    });
    private InvalidationListener listenerSearch = ob -> Platform.runLater(() -> this.mlist.filter(this.model.getList(), this.pd));
    private InvalidationListener listener = ob -> this.refresh();
    @Inject
    protected MEventService es;
    public ButtonType buttonType = new ButtonType("\u6dfb\u52a0\u5230\u6267\u884c\u9762\u677f", ButtonBar.ButtonData.OK_DONE);
    public Button button;
    Gson gson = new Gson();

    @FXML
    public void initialize() {
        this.createTable();
        this.model.changedProperty().addListener(this.lstnModel);
        this.txtSearch.textProperty().addListener(this.listenerSearch);
        this.ref.changedProperty().addListener(this.listener);
        this.refresh();
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{this.buttonType, ButtonType.CANCEL};
    }

    public void onFinished(ButtonType bt) {
        if (bt == this.buttonType) {
            StringBuilder builder = new StringBuilder();
            for (XBondStrategy strategy : this.tableStrategy.getItems()) {
                if (!strategy.isSelected() || !strategy.isTemplate()) continue;
                try {
                    XBondStrategy s = new XBondStrategy();
                    s.update((Object)strategy);
                    s.setTemplate(false);
                    this.model.updateStrategy(s);
                }
                catch (MException e) {
                    builder.append(String.valueOf(strategy.getContextId()) + e.getMessage() + "\n");
                }
            }
            if (!builder.toString().isEmpty()) {
                logger.error("xbond library \u6dfb\u52a0\u5931\u8d25", (Object)builder.toString());
                this.alert.alert(Alert.AlertType.ERROR, builder.toString());
            }
        }
    }

    @FXML
    public void add() {
        AddXBondStrategyDialog obj = (AddXBondStrategyDialog)((Object)this.of.create(AddXBondStrategyDialog.class));
        obj.template = true;
        this.model.setCopyStrategy(null);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7b56\u7565");
        obj.setDialog(dialog);
        if (dialog.launch() == ButtonType.OK) {
            this.refresh();
        }
    }

    @FXML
    public void copyNew() {
        XBondStrategy strategy = (XBondStrategy)this.tableStrategy.getSelectionModel().getSelectedItem();
        this.model.setCopyStrategy(strategy);
        this.copyNew(strategy);
    }

    @FXML
    public void exportStrategy() {
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("rd files (*.txt)", new String[]{".txt"});
        chooser.getExtensionFilters().add((Object)filter);
        chooser.setInitialFileName("XBondStrategy");
        File file = chooser.showSaveDialog(null);
        try {
            if (file != null) {
                LinkedList<XBondStrategySerialize> list = new LinkedList<XBondStrategySerialize>();
                for (XBondStrategy strategy : this.model.getList()) {
                    XBondStrategySerialize strategy2 = new XBondStrategySerialize();
                    strategy2.update((Object)strategy);
                    list.add(strategy2);
                }
                FileOutputStream fileStream = new FileOutputStream(file);
                String json = this.gson.toJson(list);
                byte[] array = json.getBytes();
                fileStream.write(array);
                fileStream.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    @FXML
    public void importStrategy() {
        FileChooser chooser = new FileChooser();
        File file = chooser.showOpenDialog(null);
        try {
            if (file != null) {
                LinkedList strategyList = new LinkedList();
                FileInputStream fileStream = new FileInputStream(file);
                byte[] array = new byte[fileStream.available()];
                fileStream.read(array);
                String json = new String(array);
                strategyList = (LinkedList)this.gson.fromJson(json, new TypeToken<LinkedList<XBondStrategySerialize>>(){}.getType());
                for (XBondStrategySerialize strategy : strategyList) {
                    try {
                        this.model.addStrategy(strategy);
                    }
                    catch (MException e) {
                        logger.error(e.getMessage());
                    }
                }
                fileStream.close();
            }
        }
        catch (IOException e1) {
            logger.error(e1.getMessage());
        }
        this.refresh();
    }

    @FXML
    public void delete() {
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            if (strategy.isSelected()) continue;
        }
        boolean bDel = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664\u52fe\u9009\u7684\u7b56\u7565\uff1f");
        if (!bDel) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            try {
                this.model.delStrategy(strategy.getMarket(), strategy.getContextId());
            }
            catch (MException e) {
                builder.append(String.valueOf(strategy.getContextId()) + e.getMessage() + "\n");
                logger.error((Object)e);
            }
        }
        if (!builder.toString().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, builder.toString());
        }
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.ref.changedProperty().removeListener(this.listener);
        this.txtSearch.textProperty().removeListener(this.listenerSearch);
    }

    private void createTable() {
        this.tableStrategy.setPlaceholder((Node)new Label());
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        this.selected.setSortable(false);
        TableUtils.isCheckBox(this.selected);
        this.contextId.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).contextIdProperty());
        this.securityId.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).securityIdProperty());
        this.securityName.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).securityNameProperty());
        this.tacticsType.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).typeProperty());
        this.name.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).nameProperty());
        this.dealLimit.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).dealLimitProperty());
        this.contextId.setCellValueFactory(cell -> ((XBondStrategy)cell.getValue()).contextIdProperty());
        this.selected.setCellValueFactory(data -> {
            BooleanProperty bp = ((XBondStrategy)data.getValue()).selectedProperty();
            bp.addListener((ob, old, now) -> this.checkBtnStatus());
            return bp;
        });
        this.operate.setCellValueFactory(data -> this.setOperate((XBondStrategy)data.getValue()));
        this.tableStrategy.setItems(this.mlist.getList());
    }

    private void checkBtnStatus() {
        this.button.setDisable(true);
        int selectedNum = 0;
        for (XBondStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.isTemplate()) continue;
            ++selectedNum;
        }
        if (selectedNum > 0) {
            this.button.setDisable(false);
        }
    }

    @Override
    public MObjFactory getObjFactory() {
        return this.of;
    }

    @Override
    public DialogFactory getDialogFactory() {
        return this.df;
    }

    @Override
    public MxAlert getAlert() {
        return this.alert;
    }

    @Override
    public XBondStrategyModel getModel() {
        return this.model;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public boolean isLibPane() {
        return true;
    }

    @Override
    public TableView<XBondStrategy> getTable() {
        return this.tableStrategy;
    }

    @Override
    @FXML
    public void refresh() {
        this.getModel().query(this.isLibPane());
    }
}

