/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.FormulaModel;
import cms.tmx.bond.models.XBondStrategyModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.LocalFilter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.MatchConverter;
import cms.tmx.control.search.Search;
import cms.tmx.control.search.localSuggest;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.XBond;
import cms.tmx.entity.trade.XBondStrategy;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondStrategyDialog
extends DialogObj {
    protected Logger logger = LogManager.getLogger(XBondStrategyDialog.class);
    protected static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    @FXML
    protected VBox vboxAll;
    @FXML
    protected VBox vboxParam;
    @FXML
    protected VBox vboxParamOld;
    @FXML
    protected VBox vboxParamCustom;
    @FXML
    protected GridPane gridPrice;
    @FXML
    protected GridPane gridHedgeUp;
    @FXML
    protected GridPane gridHedgeDown;
    @FXML
    private RadioButton radioBuy;
    @FXML
    private RadioButton radioSell;
    @FXML
    private ComboBox<CfetsFundAccount> cmbAccnt;
    @FXML
    protected TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    private Label lbTermToMaturity;
    @FXML
    private Label lbNetVal;
    @FXML
    private Label lbIssrRat;
    @FXML
    protected ComboBox<MxNode> cmbType;
    @FXML
    protected TextField txtName;
    @FXML
    private Spinner<Double> spnAsk1MinusBid1;
    @FXML
    private Spinner<Double> spnAsk2MinusBid2;
    @FXML
    private Spinner<Integer> spnQtyAsk1;
    @FXML
    private Spinner<Integer> spnQtyBid1;
    @FXML
    private Spinner<Integer> spnAsk1PlusAsk2;
    @FXML
    private Spinner<Integer> spnBid1PlusBid2;
    @FXML
    protected Spinner<Double> spnSpread;
    @FXML
    private Spinner<Integer> spnQty;
    @FXML
    private Spinner<Integer> spnDealLimit;
    @FXML
    protected Spinner<Double> spnHedgeSpread;
    @FXML
    protected ComboBox<MxNode> cmbPriceBase;
    @FXML
    protected ComboBox<MxNode> cmbHedgePrice;
    @FXML
    private Label lbAccntErr;
    @FXML
    private Label lbCodeErr;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbAsk1MinusBid1Err;
    @FXML
    private Label lbAsk2MinusBid2Err;
    @FXML
    private Label lbQtyBid1Err;
    @FXML
    private Label lbQtyAsk1Err;
    @FXML
    private Label lbAsk1PlusAsk2Err;
    @FXML
    private Label lbSpreadErr;
    @FXML
    private Label lbQtyErr;
    @FXML
    private Label lbDealLimitErr;
    @FXML
    private Label lbHedgeSpreadErr;
    @FXML
    private Label lbHedgePrice;
    @FXML
    private Label lbAsk1MinusBid1;
    @FXML
    private Label lbAsk2MinusBid2;
    @FXML
    private Label lbBracketLeft;
    @FXML
    private Label lbBracketRight;
    @FXML
    private Label lbOr;
    @FXML
    private RadioButton radioB;
    @FXML
    private RadioButton radioS;
    @FXML
    private RadioButton radioMkt;
    @FXML
    protected ComboBox<MxNode> cmbCancelType;
    @FXML
    private RadioButton rdoAttackBuy;
    @FXML
    private RadioButton rdoDefendBuy;
    @FXML
    private RadioButton rdoAttackSell;
    @FXML
    private RadioButton rdoDefendSell;
    @FXML
    private TextField txtPriceCustomBuy;
    @FXML
    private Label lbPriceCustomBuyErr;
    @FXML
    private TextField txtPriceCustomSell;
    @FXML
    private Label lbPriceCustomSellErr;
    @FXML
    private Spinner<Double> spnDiffBuy;
    @FXML
    private Label lbDiffBuyErr;
    @FXML
    private Spinner<Double> spnDiffSell;
    @FXML
    private Label lbDiffSellErr;
    @FXML
    private Spinner<Double> spnMinShift;
    @FXML
    private Label lbMinShiftErr;
    @FXML
    private Spinner<Double> spnMaxDeal;
    @FXML
    private Label lbMaxDealErr;
    @FXML
    private Spinner<Double> spnQtyBuy;
    @FXML
    private Label lbQtyBuyErr;
    @FXML
    private Spinner<Double> spnQtySell;
    @FXML
    private Label lbQtySellErr;
    @FXML
    private TextField txtBidUpLimit;
    @FXML
    private Label lbBidUpLimitErr;
    @FXML
    private TextField txtBidFloorLimit;
    @FXML
    private Label lbBidFloorLimitErr;
    @FXML
    private TextField txtOfrUpLimit;
    @FXML
    private Label lbOfrUpLimitErr;
    @FXML
    private TextField txtOfrFloorLimit;
    @FXML
    private Label lbOfrFloorLimitErr;
    @FXML
    protected TextField txtHedgeContract;
    @FXML
    private Label lbHedgeContract;
    @FXML
    private Label lbHedgeContractErr;
    @FXML
    private RadioButton radioHedge;
    @FXML
    private RadioButton radioAutoHedge;
    @FXML
    protected GridPane gridCustomHedge;
    @FXML
    protected TextField txtHedgePriceCustomBuy;
    @FXML
    private Label lbHedgePriceCustomBuyErr;
    @FXML
    protected TextField txtHedgePriceCustomSell;
    @FXML
    private Label lbHedgePriceCustomSellErr;
    @FXML
    protected TextField txtMarketMaking;
    @FXML
    private Label lbMarketMakingErr;
    @FXML
    protected TextField txtHedge;
    @FXML
    private Label lbHedgeErr;
    @FXML
    protected TextField txtTimeoutFill;
    @FXML
    protected Spinner<Double> spnStoplossFill;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private MObjFactory of;
    @Inject
    protected XBondStrategyModel model;
    @Inject
    private CcsAccountMap accntMng;
    @Inject
    protected MxAlert alert;
    private DoubleSpinnerCtrl ctrlAsk1MinusBid1 = new DoubleSpinnerCtrl(true, 6, 4);
    private DoubleSpinnerCtrl ctrlAsk2MinusBid2 = new DoubleSpinnerCtrl(true, 6, 4);
    private IntSpinnerCtrl ctrlQtyAsk1 = new IntSpinnerCtrl(true, 5, 1);
    private IntSpinnerCtrl ctrlQtyBid1 = new IntSpinnerCtrl(true, 5, 1);
    private IntSpinnerCtrl ctrlAsk1PlusAsk2 = new IntSpinnerCtrl(true, 5, 1);
    private DoubleSpinnerCtrl ctrlSpread = new DoubleSpinnerCtrl(true, 6, 4);
    private DoubleSpinnerCtrl ctrlHedgeSpread = new DoubleSpinnerCtrl(true, 6, 4);
    private IntSpinnerCtrl ctrlDealLimit = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlQty = new IntSpinnerCtrl(true, 9, 1);
    private ToggleGroup group = new ToggleGroup();
    private ToggleGroup groupCst = new ToggleGroup();
    private ToggleGroup groupHedge = new ToggleGroup();
    private ToggleGroup groupInvadeBuy = new ToggleGroup();
    private ToggleGroup groupInvadeSell = new ToggleGroup();
    private DoubleSpinnerCtrl ctrlDiffBuy = new DoubleSpinnerCtrl(true, 6, 2);
    private DoubleSpinnerCtrl ctrlDiffSell = new DoubleSpinnerCtrl(true, 6, 2);
    private DoubleSpinnerCtrl ctrlMinShift = new DoubleSpinnerCtrl(true, 6, 2);
    private DoubleSpinnerCtrl ctrlMaxDeal = new DoubleSpinnerCtrl(true, 8, 1);
    private DoubleSpinnerCtrl ctrlCountBuy = new DoubleSpinnerCtrl(true, 3, 1);
    private DoubleSpinnerCtrl ctrlCountSell = new DoubleSpinnerCtrl(true, 3, 1);
    private DoubleSpinnerCtrl ctrlStoploss = new DoubleSpinnerCtrl(true, 6, 2);
    protected XBond refItem;
    public double maxDiff = Double.MAX_VALUE;
    private SecSuggest spCode = new SecSuggest();
    private MatchConverter matchCt = new MatchConverter();
    private localSuggest spFormula = new localSuggest("].");
    public List<String> nameList = new ArrayList<String>();
    protected XBondStrategy stg;
    @Inject
    protected IRefDataMng ref;
    private Collection<RefItem> refs = null;
    private ChangeListener<? super Boolean> refListener = (ob, old, now) -> {
        this.refs = this.ref.getItems(new String[]{"BONDXcfeXBond"});
        this.spCode.setAllSuggestions(this.refs);
    };
    private ObservableList<CfetsFundAccount> obList = FxUtils.newList();
    @Inject
    private ISecAccountService secAccService;
    MxDialog mxDialog;

    public XBondStrategyDialog() {
        super("XBondStrategyDialog.fxml");
    }

    public void fillDialog() {
        for (CfetsFundAccount account : this.accntMng.getCfetsAccountMap().values()) {
            if (!this.stg.getExtFundAccntId().equals(account.getNewCashAccntId())) continue;
            this.cmbAccnt.getSelectionModel().select((Object)account);
        }
        this.cmbAccnt.setDisable(true);
        this.txtCode.setText(this.stg.getSecurityId());
        this.refItem = (XBond)this.refMng.getItem(this.stg.getMarket(), this.stg.getSecurityId());
        if (this.refItem != null) {
            this.lbName.setText(this.refItem.getName());
            this.lbTermToMaturity.setText(this.refItem.getTermToMaturityString());
            String netVal = String.format("%.4f", this.refItem.getNetVal());
            String yldRat = String.format("%.4f", this.refItem.getYldRat());
            this.lbNetVal.setText(String.valueOf(netVal) + " / " + yldRat);
            this.lbIssrRat.setText(String.valueOf(this.refItem.getIssrRat()) + " / " + this.refItem.getRatLvl());
        } else {
            this.lbName.setText("");
            this.lbTermToMaturity.setText("-");
            this.lbNetVal.setText("-");
            this.lbIssrRat.setText("-");
        }
        this.txtName.setText(this.stg.getName());
        this.cmbPriceBase.getSelectionModel().select((Object)this.stg.getBasePrice());
        this.spnAsk1MinusBid1.getEditor().setText(String.format("%.4f", (double)Math.round(this.stg.getAsk1MinusBid1() * 10000.0) / 10000.0));
        this.spnAsk2MinusBid2.getEditor().setText(String.format("%.4f", (double)Math.round(this.stg.getAsk2MinusBid2() * 10000.0) / 10000.0));
        this.spnQtyAsk1.getEditor().setText(String.valueOf((int)this.stg.getAskQty1()));
        this.spnQtyBid1.getEditor().setText(String.valueOf((int)this.stg.getBidQty1()));
        this.spnQty.getEditor().setText(String.valueOf(this.stg.getQty()));
        this.spnSpread.getEditor().setText(String.format("%.4f", (double)Math.round(this.stg.getSpread() * 10000.0) / 10000.0));
        this.spnDealLimit.getEditor().setText(String.valueOf((int)this.stg.getDealLimit()));
        if (((MxNode)this.cmbType.getValue()).getRaw().equals("12")) {
            this.spnAsk1PlusAsk2.getEditor().setText(String.valueOf((int)this.stg.getAskQty1PlusAskQty2()));
        } else {
            this.cmbHedgePrice.getSelectionModel().select((Object)this.stg.getBasePriceHedge());
            this.spnHedgeSpread.getEditor().setText(String.format("%.4f", (double)Math.round(this.stg.getSpreadHedge() * 10000.0) / 10000.0));
        }
        if (((MxNode)this.cmbType.getValue()).getRaw().equals("13")) {
            if (this.stg.getBidQty1() > 0.0) {
                this.radioBuy.setSelected(true);
            } else {
                this.radioSell.setSelected(true);
            }
        }
        switch (this.stg.getType().getRaw()) {
            case "16": {
                this.groupCst.selectToggle((Toggle)this.radioB);
                break;
            }
            case "17": {
                this.groupCst.selectToggle((Toggle)this.radioS);
                break;
            }
            case "18": {
                this.groupCst.selectToggle((Toggle)this.radioMkt);
                break;
            }
            default: {
                return;
            }
        }
        this.cmbCancelType.setValue((Object)this.stg.getCancelType());
        this.groupInvadeBuy.selectToggle((Toggle)(this.stg.isAttackBuy() ? this.rdoAttackBuy : this.rdoDefendBuy));
        this.txtPriceCustomBuy.setText(this.stg.getBidRefPriceFormula());
        this.groupInvadeSell.selectToggle((Toggle)(this.stg.isAttackSell() ? this.rdoAttackSell : this.rdoDefendSell));
        this.txtPriceCustomSell.setText(this.stg.getOfferRefPriceFormula());
        this.spnDiffBuy.getEditor().setText(StringUtils.toThousands((Number)this.stg.getBidSpread(), (int)2));
        this.spnDiffSell.getEditor().setText(StringUtils.toThousands((Number)this.stg.getAskSpread(), (int)2));
        this.spnMinShift.getEditor().setText(StringUtils.toThousands((Number)this.stg.getBidPriceSlip(), (int)2));
        this.spnMaxDeal.getEditor().setText(StringUtils.toThousands((Number)this.stg.getMaxDeal(), (int)1));
        this.spnQtyBuy.getEditor().setText(String.valueOf(this.stg.getBidQty()));
        this.spnQtySell.getEditor().setText(String.valueOf(this.stg.getAskQty()));
        this.txtBidUpLimit.setText(this.stg.getBidUpLimit());
        this.txtBidFloorLimit.setText(this.stg.getBidFloorLimit());
        this.txtOfrUpLimit.setText(this.stg.getOfferUpLimit());
        this.txtOfrFloorLimit.setText(this.stg.getOfferFloorLimit());
        if (this.stg.getBidHedgePriceFormula().isEmpty() && this.stg.getOfferHedgePriceFormula().isEmpty()) {
            this.groupHedge.selectToggle((Toggle)this.radioHedge);
        } else {
            this.groupHedge.selectToggle((Toggle)this.radioAutoHedge);
        }
        this.txtHedgeContract.setUserData((Object)this.stg.getHedgeContract());
        this.txtHedgeContract.setText(this.stg.getHedgeContract().getCode());
        this.lbHedgeContract.setText(this.stg.getHedgeContract().getName());
        this.gridCustomHedge.setDisable(this.radioHedge.isSelected());
        this.txtHedgePriceCustomBuy.setText(this.stg.getBidHedgePriceFormula());
        this.txtHedgePriceCustomSell.setText(this.stg.getOfferHedgePriceFormula());
        this.txtMarketMaking.setText(String.valueOf(this.stg.getMarketMakingCount()));
        this.txtHedge.setText(String.valueOf(this.stg.getHedgeCount()));
        this.txtTimeoutFill.setText(String.valueOf(this.stg.getTimeoutFill()));
        this.spnStoplossFill.getEditor().setText(StringUtils.toThousands((Number)this.stg.getStoplossFill(), (int)2));
    }

    public void onFinished(ButtonType bt) {
        this.refMng.changedProperty().removeListener(this.refListener);
    }

    @FXML
    public void initialize() {
        Map cfetsAccountMap = this.accntMng.getCfetsAccountMap();
        this.obList.setAll(cfetsAccountMap.values());
        this.cmbAccnt.setItems(this.obList);
        if (this.obList.size() > 0) {
            this.cmbAccnt.setValue((Object)((CfetsFundAccount)this.obList.get(0)));
        } else {
            this.accntMng.changedProperty().addListener((ob, old, now) -> {
                this.obList.clear();
                this.obList.setAll(this.accntMng.getCfetsAccountMap().values());
                this.cmbAccnt.setItems(this.obList);
                if (this.obList.size() > 0) {
                    this.cmbAccnt.setValue((Object)((CfetsFundAccount)this.obList.get(0)));
                }
            });
        }
        this.initControls();
        MxNode node = new MxNode().load("xbond_price", this.stg == null ? "ASK_2" : this.stg.getBasePrice().getRaw());
        node.getNodes().sort((o1, o2) -> o1.getRaw().compareTo(o2.getRaw()));
        this.cmbPriceBase.setItems(node.getNodes());
        this.cmbPriceBase.setValue((Object)node);
        node = new MxNode().load("xbond_price", this.stg == null ? "ASK_2" : this.stg.getBasePriceHedge().getRaw());
        node.getNodes().sort((o1, o2) -> o1.getRaw().compareTo(o2.getRaw()));
        this.cmbHedgePrice.setItems(node.getNodes());
        this.cmbHedgePrice.setValue((Object)node);
        this.cmbType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.typeChanged((MxNode)old, (MxNode)now));
        String typeRaw = "161718";
        if (this.stg != null) {
            typeRaw = this.stg.getType().getRaw();
            typeRaw = "161718".contains(typeRaw) ? "161718" : typeRaw;
        }
        node = MxNodeFactory.create((String)"xbond_strategy_type", (String)typeRaw);
        ObservableList list = FxUtils.newList();
        list.addAll((Collection)node.getNodes());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String raw = ((MxNode)iterator.next()).getRaw();
            if ("161718".equals(raw) || !"161718".contains(raw)) continue;
            iterator.remove();
        }
        this.cmbType.setItems(list);
        this.cmbType.setValue((Object)node);
        boolean isCustomStg = "161718".equals(node.getRaw());
        this.vboxParam.getChildren().setAll((Object[])new Node[]{isCustomStg ? this.vboxParamCustom : this.vboxParamOld});
        this.registerCheck();
    }

    protected void typeChanged(MxNode old, MxNode now) {
        this.registerCheck();
        if (now.getRaw().equals("12")) {
            this.lbAsk1MinusBid1.setVisible(true);
            this.lbAsk2MinusBid2.setVisible(true);
            this.spnAsk1MinusBid1.setVisible(true);
            this.spnAsk2MinusBid2.setVisible(true);
            this.radioBuy.setVisible(false);
            this.radioSell.setVisible(false);
            this.gridHedgeUp.setVisible(true);
            this.gridHedgeDown.setVisible(false);
            this.cmbPriceBase.setDisable(false);
            MxNode n = (MxNode)this.cmbPriceBase.getSelectionModel().getSelectedItem();
            this.cmbPriceBase.getSelectionModel().select((Object)n.getNode("ASK_2"));
            this.lbBracketLeft.setVisible(false);
            this.lbBracketRight.setVisible(false);
            this.lbOr.setVisible(false);
        } else if (now.getRaw().equals("11")) {
            this.lbAsk1MinusBid1.setVisible(true);
            this.lbAsk2MinusBid2.setVisible(true);
            this.spnAsk1MinusBid1.setVisible(true);
            this.spnAsk2MinusBid2.setVisible(true);
            this.radioBuy.setVisible(false);
            this.radioSell.setVisible(false);
            this.gridHedgeUp.setVisible(false);
            this.gridHedgeDown.setVisible(true);
            this.lbHedgePrice.setVisible(true);
            this.cmbHedgePrice.setVisible(true);
            this.cmbPriceBase.setDisable(true);
            MxNode n = (MxNode)this.cmbPriceBase.getSelectionModel().getSelectedItem();
            this.cmbPriceBase.getSelectionModel().select((Object)n.getNode("BID_1"));
            n = (MxNode)this.cmbHedgePrice.getSelectionModel().getSelectedItem();
            this.cmbHedgePrice.getSelectionModel().select((Object)n.getNode("ASK_2"));
            this.lbBracketLeft.setVisible(true);
            this.lbBracketRight.setVisible(true);
            this.lbOr.setVisible(true);
        } else if (now.getRaw().equals("13")) {
            this.lbAsk1MinusBid1.setVisible(false);
            this.lbAsk2MinusBid2.setVisible(false);
            this.spnAsk1MinusBid1.setVisible(false);
            this.spnAsk2MinusBid2.setVisible(false);
            this.radioBuy.setVisible(true);
            this.radioSell.setVisible(true);
            this.gridHedgeUp.setVisible(false);
            this.gridHedgeDown.setVisible(true);
            this.lbHedgePrice.setVisible(false);
            this.cmbHedgePrice.setVisible(false);
            this.cmbPriceBase.setDisable(false);
            MxNode n = (MxNode)this.cmbPriceBase.getSelectionModel().getSelectedItem();
            this.cmbPriceBase.getSelectionModel().select((Object)n.getNode("BID_1"));
            n = (MxNode)this.cmbHedgePrice.getSelectionModel().getSelectedItem();
            this.cmbHedgePrice.getSelectionModel().select((Object)n.getNode("ASK_2"));
            this.lbBracketLeft.setVisible(false);
            this.lbBracketRight.setVisible(false);
            this.lbOr.setVisible(false);
        }
        if (now.getRaw().equals("161718")) {
            this.vboxParam.getChildren().setAll((Object[])new Node[]{this.vboxParamCustom});
        } else {
            this.vboxParam.getChildren().setAll((Object[])new Node[]{this.vboxParamOld});
        }
        this.dialogHeightChanged(old, now);
    }

    protected void registerCheck() {
        this.mapValid.clear();
        this.registerCheck((Node)this.lbAccntErr, (ObservableBooleanValue)this.cmbAccnt.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtCode.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u4ee3\u7801");
                return false;
            }
            if (this.lbName.getText().isEmpty()) {
                this.lbCodeErr.setText("\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.textProperty(), this.lbName.textProperty()}));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtName.getText().isEmpty()) {
                this.lbNameErr.setText("\u8bf7\u8f93\u5165\u7b56\u7565\u540d\u79f0");
                return false;
            }
            if (this.nameList.contains(this.txtName.getText())) {
                this.lbNameErr.setText("\u6b64\u540d\u79f0\u5df2\u5b58\u5728");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtName.textProperty()}));
        MxNode node = (MxNode)this.cmbType.getSelectionModel().getSelectedItem();
        if (node.getRaw().equals("161718")) {
            this.CustomRegisterCheck();
        } else {
            this.xbondRegisterCheck();
        }
    }

    private void CustomRegisterCheck() {
        this.registerCheck((Node)this.lbPriceCustomBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtPriceCustomBuy.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioS.isSelected()) {
                return true;
            }
            if (this.txtPriceCustomBuy.getText().isEmpty()) {
                this.lbPriceCustomBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u5165\u57fa\u51c6\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtPriceCustomBuy.focusedProperty(), this.txtPriceCustomBuy.textProperty(), this.cmbType.valueProperty(), this.radioS.selectedProperty()}));
        this.registerCheck((Node)this.lbPriceCustomSellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtPriceCustomSell.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioB.isSelected()) {
                return true;
            }
            if (this.txtPriceCustomSell.getText().isEmpty()) {
                this.lbPriceCustomSellErr.setText("\u8bf7\u8f93\u5165\u5356\u51fa\u57fa\u51c6\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtPriceCustomSell.focusedProperty(), this.txtPriceCustomSell.textProperty(), this.cmbType.valueProperty(), this.radioB.selectedProperty()}));
        this.registerCheck((Node)this.lbDiffBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioS.isSelected()) {
                return true;
            }
            if (this.spnDiffBuy.getEditor().getText().isEmpty()) {
                this.lbDiffBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u4ef7\u70b9\u5dee");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnDiffBuy.getEditor().textProperty(), this.radioS.selectedProperty()}));
        this.registerCheck((Node)this.lbDiffSellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioB.isSelected()) {
                return true;
            }
            if (this.spnDiffSell.getEditor().getText().isEmpty()) {
                this.lbDiffSellErr.setText("\u8bf7\u8f93\u5165\u5356\u4ef7\u70b9\u5dee");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnDiffSell.getEditor().textProperty(), this.radioB.selectedProperty()}));
        this.registerCheck((Node)this.lbMinShiftErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.spnMinShift.getEditor().getText().isEmpty()) {
                this.lbMinShiftErr.setText("\u8bf7\u8f93\u5165\u6700\u5c0f\u79fb\u52a8");
                return false;
            }
            if (this.getDouble(this.spnMinShift.getEditor()) == 0.0) {
                this.lbMinShiftErr.setText("\u6700\u5c0f\u79fb\u52a8\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMinShift.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbMaxDealErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.spnMaxDeal.getEditor().getText().isEmpty()) {
                this.lbMaxDealErr.setText("\u8bf7\u8f93\u5165\u6700\u5927\u6210\u4ea4");
                return false;
            }
            if (this.getDouble(this.spnMaxDeal.getEditor()) == 0.0) {
                this.lbMaxDealErr.setText("\u6700\u5927\u6210\u4ea4\u5e94\u5927\u4e8e0");
                return false;
            }
            if (this.getDouble(this.spnMaxDeal.getEditor()) > 100.0) {
                this.lbMaxDealErr.setText("\u6700\u5927\u6210\u4ea4\u4e0a\u9650\u4e3a100");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMaxDeal.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbQtyBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioS.isSelected()) {
                return true;
            }
            if (this.spnQtyBuy.getEditor().getText().isEmpty()) {
                this.lbQtyBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u5165\u6570\u91cf");
                return false;
            }
            if (this.getDouble(this.spnQtyBuy.getEditor()) == 0.0) {
                this.lbQtyBuyErr.setText("\u4e70\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            if (this.getDouble(this.spnQtyBuy.getEditor()) > 100.0) {
                this.lbQtyBuyErr.setText("\u4e70\u5165\u6570\u91cf\u4e0a\u9650\u4e3a100");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtyBuy.getEditor().textProperty(), this.radioS.selectedProperty()}));
        this.registerCheck((Node)this.lbQtySellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioB.isSelected()) {
                return true;
            }
            if (this.spnQtySell.getEditor().getText().isEmpty()) {
                this.lbQtySellErr.setText("\u8bf7\u8f93\u5165\u5356\u51fa\u6570\u91cf");
                return false;
            }
            if (this.getDouble(this.spnQtySell.getEditor()) == 0.0) {
                this.lbQtySellErr.setText("\u5356\u51fa\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            if (this.getDouble(this.spnQtySell.getEditor()) > 100.0) {
                this.lbQtySellErr.setText("\u5356\u51fa\u6570\u91cf\u4e0a\u9650\u4e3a100");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtySell.getEditor().textProperty(), this.radioB.selectedProperty()}));
        this.registerCheck((Node)this.lbBidUpLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtBidUpLimit.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioS.isSelected()) {
                return true;
            }
            if (this.txtBidUpLimit.getText().isEmpty()) {
                this.lbBidUpLimitErr.setText("\u8bf7\u8f93\u5165BID\u4e0a\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtBidUpLimit.focusedProperty(), this.txtBidUpLimit.textProperty(), this.cmbType.valueProperty(), this.radioS.selectedProperty()}));
        this.registerCheck((Node)this.lbBidFloorLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtBidFloorLimit.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioS.isSelected()) {
                return true;
            }
            if (this.txtBidFloorLimit.getText().isEmpty()) {
                this.lbBidFloorLimitErr.setText("\u8bf7\u8f93\u5165BID\u4e0b\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtBidFloorLimit.focusedProperty(), this.txtBidFloorLimit.textProperty(), this.cmbType.valueProperty(), this.radioS.selectedProperty()}));
        this.registerCheck((Node)this.lbOfrUpLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtOfrUpLimit.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioB.isSelected()) {
                return true;
            }
            if (this.txtOfrUpLimit.getText().isEmpty()) {
                this.lbOfrUpLimitErr.setText("\u8bf7\u8f93\u5165OFR\u4e0a\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtOfrUpLimit.focusedProperty(), this.txtOfrUpLimit.textProperty(), this.cmbType.valueProperty(), this.radioB.selectedProperty()}));
        this.registerCheck((Node)this.lbOfrFloorLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtOfrFloorLimit.isFocused() || !((MxNode)this.cmbType.getValue()).getRaw().equals("161718")) {
                return true;
            }
            if (this.radioB.isSelected()) {
                return true;
            }
            if (this.txtOfrFloorLimit.getText().isEmpty()) {
                this.lbOfrFloorLimitErr.setText("\u8bf7\u8f93\u5165OFR\u4e0b\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtOfrFloorLimit.focusedProperty(), this.txtOfrFloorLimit.textProperty(), this.cmbType.valueProperty(), this.radioB.selectedProperty()}));
        this.registerCheck((Node)this.lbHedgeContractErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtHedgeContract.getText().isEmpty()) {
                this.lbHedgeContractErr.setText("\u8bf7\u8f93\u5165\u4ee3\u7801");
                return false;
            }
            if (this.lbHedgeContract.getText().isEmpty()) {
                this.lbHedgeContractErr.setText("\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtHedgeContract.textProperty(), this.lbHedgeContract.textProperty()}));
        this.registerCheck((Node)this.lbHedgePriceCustomSellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtHedgePriceCustomSell.isFocused()) {
                return true;
            }
            if (this.radioS.isSelected()) {
                return true;
            }
            if (this.radioHedge.isSelected()) {
                return true;
            }
            if (this.txtHedgePriceCustomSell.getText().isEmpty()) {
                this.lbHedgePriceCustomSellErr.setText("\u8bf7\u8f93\u5165\u4ef7\u683c\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtHedgePriceCustomSell.focusedProperty(), this.txtHedgePriceCustomSell.textProperty(), this.cmbType.valueProperty(), this.radioS.selectedProperty()}));
        this.registerCheck((Node)this.lbHedgePriceCustomBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtHedgePriceCustomBuy.isFocused()) {
                return true;
            }
            if (this.radioB.isSelected()) {
                return true;
            }
            if (this.radioHedge.isSelected()) {
                return true;
            }
            if (this.txtHedgePriceCustomBuy.getText().isEmpty()) {
                this.lbHedgePriceCustomBuyErr.setText("\u8bf7\u8f93\u5165\u4ef7\u683c\u516c\u5f0f");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtHedgePriceCustomBuy.focusedProperty(), this.txtHedgePriceCustomBuy.textProperty(), this.cmbType.valueProperty(), this.radioB.selectedProperty()}));
        this.registerCheck((Node)this.lbMarketMakingErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.radioHedge.isSelected()) {
                return true;
            }
            if (this.txtMarketMaking.getText().isEmpty()) {
                this.lbMarketMakingErr.setText("\u8bf7\u8f93\u5165\u6bd4\u4f8b");
                return false;
            }
            if (Integer.valueOf(this.txtMarketMaking.getText().replaceAll(",", "")) <= 0) {
                this.lbMarketMakingErr.setText("\u8f93\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtMarketMaking.textProperty(), this.radioHedge.selectedProperty()}));
        this.registerCheck((Node)this.lbHedgeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.radioHedge.isSelected()) {
                return true;
            }
            if (this.txtHedge.getText().isEmpty()) {
                this.lbHedgeErr.setText("\u8bf7\u8f93\u5165\u6bd4\u4f8b");
                return false;
            }
            if (Integer.valueOf(this.txtHedge.getText().replaceAll(",", "")) <= 0) {
                this.lbHedgeErr.setText("\u8f93\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtHedge.textProperty(), this.radioHedge.selectedProperty()}));
    }

    private void xbondRegisterCheck() {
        this.registerCheck((Node)this.lbAsk1MinusBid1Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("13")) {
                return true;
            }
            if (this.spnAsk1MinusBid1.getEditor().getText().isEmpty() || Double.valueOf(this.spnAsk1MinusBid1.getEditor().getText().replaceAll(",", "")) == 0.0) {
                this.lbAsk1MinusBid1Err.setText("\u5fc5\u586b\u9879 (\u5927\u4e8e0)");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnAsk1MinusBid1.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbAsk2MinusBid2Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("13")) {
                return true;
            }
            if (this.spnAsk2MinusBid2.getEditor().getText().isEmpty() || Double.valueOf(this.spnAsk2MinusBid2.getEditor().getText().replaceAll(",", "")) == 0.0) {
                this.lbAsk2MinusBid2Err.setText("\u5fc5\u586b\u9879 (\u5927\u4e8e0)");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnAsk2MinusBid2.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbQtyBid1Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnQtyBid1.isDisable()) {
                return true;
            }
            if (this.spnQtyBid1.getEditor().getText().isEmpty() || Double.valueOf(this.spnQtyBid1.getEditor().getText().replaceAll(",", "")) == 0.0) {
                this.lbQtyBid1Err.setText("\u5fc5\u586b\u9879 (\u5927\u4e8e0)");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtyBid1.getEditor().textProperty(), this.spnQtyBid1.disableProperty()}));
        this.registerCheck((Node)this.lbQtyAsk1Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnQtyAsk1.isDisable()) {
                return true;
            }
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("13")) {
                this.spnQtyBid1.getEditor().setText(this.spnQtyAsk1.getEditor().getText());
            }
            if (this.spnQtyAsk1.getEditor().getText().isEmpty() || Double.valueOf(this.spnQtyAsk1.getEditor().getText().replaceAll(",", "")) == 0.0) {
                this.lbQtyAsk1Err.setText("\u5fc5\u586b\u9879 (\u5927\u4e8e0)");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtyAsk1.getEditor().textProperty(), this.spnQtyAsk1.disableProperty()}));
        this.registerCheck((Node)this.lbAsk1PlusAsk2Err, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbType.getValue()).getRaw().equals("12")) {
                return true;
            }
            if (this.spnAsk1PlusAsk2.getEditor().getText().isEmpty() || Double.valueOf(this.spnAsk1PlusAsk2.getEditor().getText().replaceAll(",", "")) == 0.0) {
                this.lbAsk1PlusAsk2Err.setText("\u5fc5\u586b\u9879 (\u5927\u4e8e0)");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnAsk1PlusAsk2.getEditor().textProperty(), this.cmbType.valueProperty()}));
        this.registerCheck((Node)this.lbQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnQty.getEditor().getText().isEmpty()) {
                this.lbQtyErr.setText("\u8bf7\u8f93\u5165\u62a5\u5355\u6570\u91cf");
                return false;
            }
            if (Integer.valueOf(this.spnQty.getEditor().getText().replaceAll(",", "")) == 0) {
                this.lbQtyErr.setText("\u62a5\u5355\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQty.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbDealLimitErr, (ObservableBooleanValue)this.spnDealLimit.getEditor().textProperty().isNotEmpty());
    }

    private double getDouble(TextField txt) {
        return StringUtils.parseDouble((String)txt.getText());
    }

    protected XBondStrategy getStrategy() throws Exception, MException {
        XBondStrategy strategy = new XBondStrategy();
        if (this.stg != null) {
            strategy.setContextId(this.stg.getContextId());
            strategy.setTemplate(this.stg.isTemplate());
        }
        CfetsFundAccount account = (CfetsFundAccount)this.cmbAccnt.getSelectionModel().getSelectedItem();
        String extFundAccntId = account.getNewCashAccntId();
        String parentExtAccntId = account.getParentId();
        String extSecAccntId = null;
        try {
            Map mapAccount = this.secAccService.getAllSecAccountMap();
            List list = (List)mapAccount.get(account);
            if (list != null && list.size() > 0) {
                extSecAccntId = ((SecAccount)list.get(0)).getExtSecAccntId();
            }
        }
        catch (MException e) {
            e.printStackTrace();
        }
        strategy.setParentExtAccntId(parentExtAccntId);
        strategy.setExtFundAccntId(extFundAccntId);
        strategy.setExtSecAccntId(extSecAccntId);
        strategy.setMarket(this.refItem.getMarket());
        strategy.setSecurityType(this.refItem.getType());
        strategy.setSecurityId(this.txtCode.getText());
        strategy.setSecurityName(this.refItem.getName());
        MxNode type = (MxNode)this.cmbType.getSelectionModel().getSelectedItem();
        strategy.setType(type);
        strategy.setName(this.txtName.getText());
        strategy.setBasePrice((MxNode)this.cmbPriceBase.getSelectionModel().getSelectedItem());
        if (!this.spnSpread.getEditor().getText().isEmpty()) {
            strategy.setSpread(Double.valueOf(this.spnSpread.getEditor().getText()).doubleValue());
        }
        if (type.getRaw().equals("161718")) {
            this.customParam(strategy);
        } else {
            this.xbondParam(strategy);
        }
        return strategy;
    }

    private void customParam(XBondStrategy strategy) {
        String customBs = "18";
        if (this.radioB.isSelected()) {
            customBs = "16";
        } else if (this.radioS.isSelected()) {
            customBs = "17";
        }
        strategy.setCancelType((MxNode)this.cmbCancelType.getValue());
        strategy.setCustomBs(customBs);
        strategy.setAttackBuy(this.rdoAttackBuy.isSelected());
        strategy.setAttackSell(this.rdoAttackSell.isSelected());
        strategy.setBidRefPriceFormula(this.txtPriceCustomBuy.getText());
        strategy.setOfferRefPriceFormula(this.txtPriceCustomSell.getText());
        if (!this.spnDiffBuy.getEditor().getText().isEmpty()) {
            strategy.setBidSpread(this.getDouble(this.spnDiffBuy.getEditor()));
        }
        if (!this.spnDiffSell.getEditor().getText().isEmpty()) {
            strategy.setAskSpread(this.getDouble(this.spnDiffSell.getEditor()));
        }
        if (!this.spnMinShift.getEditor().getText().isEmpty()) {
            strategy.setBidPriceSlip(this.getDouble(this.spnMinShift.getEditor()));
        }
        if (!this.spnMaxDeal.getEditor().getText().isEmpty()) {
            strategy.setMaxDeal(this.getDouble(this.spnMaxDeal.getEditor()));
        }
        if (!this.spnQtyBuy.getEditor().getText().isEmpty()) {
            strategy.setBidQty(this.getDouble(this.spnQtyBuy.getEditor()));
        }
        if (!this.spnQtySell.getEditor().getText().isEmpty()) {
            strategy.setAskQty(this.getDouble(this.spnQtySell.getEditor()));
        }
        strategy.setBidUpLimit(this.txtBidUpLimit.getText());
        strategy.setBidFloorLimit(this.txtBidFloorLimit.getText());
        strategy.setOfferUpLimit(this.txtOfrUpLimit.getText());
        strategy.setOfferFloorLimit(this.txtOfrFloorLimit.getText());
        strategy.setHedgeContract((XBond)this.txtHedgeContract.getUserData());
        if (!this.txtHedgePriceCustomBuy.getText().isEmpty() && !this.txtHedgePriceCustomBuy.isDisable()) {
            strategy.setBidHedgePriceFormula(this.txtHedgePriceCustomBuy.getText());
        }
        if (!this.txtHedgePriceCustomSell.getText().isEmpty() && !this.txtHedgePriceCustomSell.isDisable()) {
            strategy.setOfferHedgePriceFormula(this.txtHedgePriceCustomSell.getText());
        }
        if (!this.txtMarketMaking.getText().isEmpty()) {
            strategy.setMarketMakingCount(Integer.valueOf(this.txtMarketMaking.getText()).intValue());
        }
        if (!this.txtHedge.getText().isEmpty()) {
            strategy.setHedgeCount(Integer.valueOf(this.txtHedge.getText()).intValue());
        }
        if (!this.txtTimeoutFill.getText().isEmpty()) {
            strategy.setTimeoutFill(Integer.valueOf(this.txtTimeoutFill.getText()).intValue());
        }
        if (!this.spnStoplossFill.getEditor().getText().isEmpty()) {
            strategy.setStoplossFill(Double.valueOf(this.spnStoplossFill.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
    }

    private void xbondParam(XBondStrategy strategy) {
        String type = ((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw();
        if (type.equals("12")) {
            strategy.setAskQty1PlusAskQty2(Double.valueOf(this.spnAsk1PlusAsk2.getEditor().getText().replaceAll(",", "")).doubleValue());
        } else {
            if (type.equals("13")) {
                strategy.setBasePriceHedge((MxNode)this.cmbPriceBase.getSelectionModel().getSelectedItem());
            } else {
                strategy.setBasePriceHedge((MxNode)this.cmbHedgePrice.getSelectionModel().getSelectedItem());
            }
            if (!this.spnHedgeSpread.getEditor().getText().isEmpty()) {
                strategy.setSpreadHedge(Double.valueOf(this.spnHedgeSpread.getEditor().getText()).doubleValue());
            }
        }
        if (!this.spnAsk1MinusBid1.getEditor().getText().isEmpty()) {
            strategy.setAsk1MinusBid1(StringUtils.parseDouble((String)this.spnAsk1MinusBid1.getEditor().getText()));
        }
        if (!this.spnAsk2MinusBid2.getEditor().getText().isEmpty()) {
            strategy.setAsk2MinusBid2(StringUtils.parseDouble((String)this.spnAsk2MinusBid2.getEditor().getText()));
        }
        if (!this.spnQtyBid1.getEditor().getText().isEmpty()) {
            strategy.setBidQty1(Double.valueOf(this.spnQtyBid1.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
        if (!this.spnQtyAsk1.getEditor().getText().isEmpty()) {
            strategy.setAskQty1(Double.valueOf(this.spnQtyAsk1.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
        if (!this.spnAsk1PlusAsk2.getEditor().getText().isEmpty()) {
            strategy.setAskQty1PlusAskQty2(Double.valueOf(this.spnAsk1PlusAsk2.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
        if (!this.spnQty.getEditor().getText().isEmpty()) {
            strategy.setQty(Integer.valueOf(this.spnQty.getEditor().getText().replaceAll(",", "")).intValue());
        }
        strategy.setDealLimit((double)Integer.valueOf(this.spnDealLimit.getEditor().getText().replaceAll(",", "")).intValue());
    }

    protected void initControls() {
        this.refs = this.ref.getItems(new String[]{"BONDXcfeXBond"});
        this.spCode.addPossibleSuggestions(this.refs);
        this.refMng.changedProperty().addListener(this.refListener);
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        SecConverter secCvt = (SecConverter)this.of.create(SecConverter.class);
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)secCvt).changedProperty().addListener((ob, oldV, newV) -> {
            System.err.println("=== search: " + Thread.currentThread().getName());
            this.refItem = (XBond)this.txtCode.getUserData();
            if (this.refItem == null || this.refItem.getName().equals("")) {
                this.lbName.setText("");
                this.lbTermToMaturity.setText("-");
                this.lbNetVal.setText("-");
                this.lbIssrRat.setText("-");
                this.txtHedgeContract.setText("");
            } else {
                this.lbName.setText(this.refItem.getName());
                this.lbTermToMaturity.setText(this.refItem.getTermToMaturityString());
                String netVal = String.format("%.4f", this.refItem.getNetVal());
                String yldRat = String.format("%.4f", this.refItem.getYldRat());
                this.lbNetVal.setText(String.valueOf(netVal) + " / " + yldRat);
                this.lbIssrRat.setText(String.valueOf(this.refItem.getIssrRat()) + " / " + this.refItem.getRatLvl());
                this.txtHedgeContract.setUserData((Object)this.refItem);
                this.txtHedgeContract.setText(this.refItem.getCode());
                this.lbHedgeContract.setText(this.refItem.getName());
            }
            if (this.txtCode.getText().isEmpty()) {
                this.lbName.setText("");
            }
        });
        this.txtHedgeContract.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        AutoCompletion auto = Search.bindAutoCompletion((TextField)this.txtHedgeContract, (Callback)this.spCode, (StringConverter)secCvt);
        auto.changedProperty().addListener((ob, oldV, newV) -> {
            XBond refItem = (XBond)this.txtHedgeContract.getUserData();
            System.err.println("=== search: " + Thread.currentThread().getName());
            refItem = (XBond)this.txtHedgeContract.getUserData();
            if (refItem == null || refItem.getName().equals("")) {
                this.lbHedgeContract.setText("");
            } else {
                this.lbHedgeContract.setText(refItem.getName());
                this.txtHedgeContract.setText(refItem.getCode());
                this.txtHedgeContract.setUserData((Object)refItem);
            }
        });
        auto.setVisibleRowCount(6);
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5\\.]*", 32));
        this.radioBuy.setToggleGroup(this.group);
        this.radioSell.setToggleGroup(this.group);
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            if (this.radioBuy.isSelected()) {
                this.spnQtyBid1.setDisable(false);
                this.spnQtyAsk1.setDisable(true);
                this.spnQtyAsk1.getEditor().clear();
            }
            if (this.radioSell.isSelected()) {
                this.spnQtyBid1.setDisable(true);
                this.spnQtyBid1.getEditor().clear();
                this.spnQtyAsk1.setDisable(false);
            }
        });
        this.ctrlAsk1MinusBid1.ctrl(this.spnAsk1MinusBid1);
        this.spnAsk1MinusBid1.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnAsk1MinusBid1.getEditor()));
        this.ctrlAsk2MinusBid2.ctrl(this.spnAsk2MinusBid2);
        this.spnAsk2MinusBid2.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnAsk2MinusBid2.getEditor()));
        this.ctrlQtyAsk1.ctrl(this.spnQtyAsk1);
        this.ctrlQtyBid1.ctrl(this.spnQtyBid1);
        this.spnBid1PlusBid2.getEditor().textProperty().bind((ObservableValue)this.spnAsk1PlusAsk2.getEditor().textProperty());
        this.ctrlAsk1PlusAsk2.ctrl(this.spnAsk1PlusAsk2);
        this.ctrlSpread.ctrl(this.spnSpread);
        this.spnSpread.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnSpread.getEditor()));
        this.ctrlHedgeSpread.ctrl(this.spnHedgeSpread);
        this.spnHedgeSpread.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnHedgeSpread.getEditor()));
        this.ctrlQty.ctrl(this.spnQty);
        this.ctrlDealLimit.ctrl(this.spnDealLimit);
        this.spnDealLimit.getEditor().setOnMouseClicked(event -> this.spnDealLimit.getEditor().selectAll());
        this.radioB.setToggleGroup(this.groupCst);
        this.radioS.setToggleGroup(this.groupCst);
        this.radioMkt.setToggleGroup(this.groupCst);
        this.groupCst.selectedToggleProperty().addListener(ob -> {
            this.spnDiffBuy.setDisable(false);
            this.spnQtyBuy.setDisable(false);
            this.spnDiffSell.setDisable(false);
            this.spnQtySell.setDisable(false);
            this.rdoAttackBuy.setDisable(false);
            this.rdoDefendBuy.setDisable(false);
            this.rdoAttackSell.setDisable(false);
            this.rdoDefendSell.setDisable(false);
            this.txtPriceCustomBuy.setDisable(false);
            this.txtPriceCustomSell.setDisable(false);
            this.txtOfrUpLimit.setDisable(false);
            this.txtOfrFloorLimit.setDisable(false);
            this.lbPriceCustomBuyErr.setOpacity(0.0);
            this.lbPriceCustomSellErr.setOpacity(0.0);
            this.lbDiffBuyErr.setOpacity(0.0);
            this.lbDiffSellErr.setOpacity(0.0);
            this.lbQtyBuyErr.setOpacity(0.0);
            this.lbQtySellErr.setOpacity(0.0);
            this.txtBidUpLimit.setDisable(false);
            this.txtBidFloorLimit.setDisable(false);
            if (this.radioB.isSelected()) {
                this.txtPriceCustomSell.setDisable(true);
                this.txtPriceCustomSell.clear();
                this.rdoAttackSell.setDisable(true);
                this.rdoDefendSell.setDisable(true);
                this.spnDiffSell.setDisable(true);
                this.spnQtySell.setDisable(true);
                this.spnDiffSell.getEditor().clear();
                this.spnQtySell.getEditor().clear();
                this.txtOfrUpLimit.setDisable(true);
                this.txtOfrUpLimit.clear();
                this.txtOfrFloorLimit.setDisable(true);
                this.txtOfrFloorLimit.clear();
            } else if (this.radioS.isSelected()) {
                this.txtPriceCustomBuy.setDisable(true);
                this.txtPriceCustomBuy.clear();
                this.rdoAttackBuy.setDisable(true);
                this.rdoDefendBuy.setDisable(true);
                this.spnDiffBuy.setDisable(true);
                this.spnQtyBuy.setDisable(true);
                this.spnDiffBuy.getEditor().clear();
                this.spnQtyBuy.getEditor().clear();
                this.txtBidUpLimit.setDisable(true);
                this.txtBidUpLimit.clear();
                this.txtBidFloorLimit.setDisable(true);
                this.txtBidFloorLimit.clear();
            }
            if (this.radioAutoHedge.isSelected()) {
                this.txtHedgePriceCustomBuy.setDisable(this.radioB.isSelected());
                this.txtHedgePriceCustomSell.setDisable(this.radioS.isSelected());
            }
        });
        MxNode node = MxNodeFactory.create((String)"strategy_cancel_type", (String)"false");
        this.cmbCancelType.setItems(node.getNodes());
        this.cmbCancelType.setValue((Object)node);
        this.spnDiffSell.setDisable(true);
        this.spnQtySell.setDisable(true);
        this.rdoAttackBuy.setToggleGroup(this.groupInvadeBuy);
        this.rdoDefendBuy.setToggleGroup(this.groupInvadeBuy);
        this.rdoAttackSell.setToggleGroup(this.groupInvadeSell);
        this.rdoDefendSell.setToggleGroup(this.groupInvadeSell);
        this.rdoAttackSell.setDisable(true);
        this.rdoDefendSell.setDisable(true);
        this.spFormula.addPossibleSuggestions(new FormulaModel().values("xbond"));
        Search.bindAutoCompletion((TextField)this.txtPriceCustomBuy, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol()).setPrefWidth(300.0);
        Search.bindAutoCompletion((TextField)this.txtPriceCustomSell, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol()).setPrefWidth(300.0);
        this.txtPriceCustomBuy.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtPriceCustomSell.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtPriceCustomSell.setDisable(true);
        this.ctrlDiffBuy.ctrl(this.spnDiffBuy);
        this.spnDiffBuy.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnDiffBuy.getEditor()));
        this.ctrlDiffSell.ctrl(this.spnDiffSell);
        this.spnDiffSell.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnDiffSell.getEditor()));
        this.ctrlMinShift.ctrl(this.spnMinShift);
        this.spnMinShift.getEditor().setText("0.01");
        this.ctrlMaxDeal.ctrl(this.spnMaxDeal);
        this.ctrlMaxDeal.setUnit(1.0);
        this.ctrlCountBuy.ctrl(this.spnQtyBuy);
        this.ctrlCountBuy.setUnit(1.0);
        this.spnQtyBuy.getEditor().setOnMouseClicked(event -> this.spnQtyBuy.getEditor().selectAll());
        this.ctrlCountSell.ctrl(this.spnQtySell);
        this.ctrlCountSell.setUnit(1.0);
        this.spnQtySell.getEditor().setOnMouseClicked(event -> this.spnQtySell.getEditor().selectAll());
        auto = Search.bindAutoCompletion((TextField)this.txtBidUpLimit, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol());
        auto = Search.bindAutoCompletion((TextField)this.txtBidFloorLimit, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol());
        auto = Search.bindAutoCompletion((TextField)this.txtOfrUpLimit, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol());
        auto = Search.bindAutoCompletion((TextField)this.txtOfrFloorLimit, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol());
        this.txtBidUpLimit.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtBidFloorLimit.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtOfrUpLimit.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtOfrFloorLimit.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtOfrUpLimit.setDisable(true);
        this.txtOfrFloorLimit.setDisable(true);
        this.radioHedge.setToggleGroup(this.groupHedge);
        this.radioAutoHedge.setToggleGroup(this.groupHedge);
        this.groupHedge.selectedToggleProperty().addListener(ob -> {
            this.gridCustomHedge.setDisable(this.radioHedge.isSelected());
            if (this.radioHedge.isSelected()) {
                this.txtHedgePriceCustomBuy.clear();
                this.txtHedgePriceCustomSell.clear();
                this.txtMarketMaking.clear();
                this.txtHedge.clear();
                this.txtTimeoutFill.clear();
                this.spnStoplossFill.getEditor().clear();
            }
            this.txtHedgePriceCustomBuy.setDisable(this.radioB.isSelected());
            this.txtHedgePriceCustomSell.setDisable(this.radioS.isSelected());
        });
        this.gridCustomHedge.setDisable(this.radioHedge.isSelected());
        Search.bindAutoCompletion((TextField)this.txtHedgePriceCustomBuy, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol()).setVisibleRowCount(5);
        Search.bindAutoCompletion((TextField)this.txtHedgePriceCustomSell, (Callback)this.spFormula, (StringConverter)this.matchCt, (String)this.spFormula.getLocalSymbol()).setVisibleRowCount(5);
        this.txtHedgePriceCustomBuy.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtHedgePriceCustomSell.setTextFormatter(new TextFormatter((UnaryOperator)new LocalFilter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300)));
        this.txtMarketMaking.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 6));
        this.txtHedge.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 6));
        this.txtTimeoutFill.setTextFormatter((TextFormatter)new MxFormatter("^([1-9]{1}\\d*)$", 9));
        this.ctrlStoploss.ctrl(this.spnStoplossFill);
    }

    public void setDialog(MxDialog mxDialog) {
        this.mxDialog = mxDialog;
        this.dialogHeightChanged(null, (MxNode)this.cmbType.getSelectionModel().getSelectedItem());
    }

    private void dialogHeightChanged(MxNode old, MxNode now) {
        if (this.mxDialog == null) {
            return;
        }
        if (now.getRaw().equals("161718")) {
            this.mxDialog.setHeight(860.0);
            this.mxDialog.setY(this.mxDialog.getY() - 130.0);
        } else if (old != null && old.getRaw().equals("161718")) {
            this.mxDialog.setHeight(600.0);
            this.mxDialog.setY(this.mxDialog.getY() + 130.0);
        }
    }
}

