/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondQuoteMktModel;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.web.resp.BaseListResult;
import cms.tmx.entity.web.resp.BondClassify;
import cms.tmx.entity.web.resp.ResponseData;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.web.api.core.HttpClientService;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;

public class XBondQuoteMktPart
extends MxPart {
    private static final String STATIC_TYPE = "1";
    private static final String DYNAMIC_TYPE = "2";
    @FXML
    private TextField searchText;
    @FXML
    private ComboBox<MxNode> cmbSettlType;
    @FXML
    private ComboBox<BondClassify> cmbStatic;
    @FXML
    private ComboBox<BondClassify> cmbDynamic;
    @FXML
    private RadioButton radioAll;
    @FXML
    private RadioButton radioStatic;
    @FXML
    private RadioButton radioDynamic;
    private ToggleGroup group = new ToggleGroup();
    @Inject
    private HttpClientService httpClient;
    @FXML
    private TableView<MarketItem> tableContinue;
    @FXML
    private TableColumn<MarketItem, String> code;
    @FXML
    private TableColumn<MarketItem, String> name;
    @FXML
    private TableColumn<MarketItem, String> settlType;
    @FXML
    private TableColumn<MarketItem, Number> qtyBuy;
    @FXML
    private TableColumn<MarketItem, Number> priceBuy;
    @FXML
    private TableColumn<MarketItem, Number> yieldBuy;
    @FXML
    private TableColumn<MarketItem, Number> qtySell;
    @FXML
    private TableColumn<MarketItem, Number> priceSell;
    @FXML
    private TableColumn<MarketItem, Number> yieldSell;
    @FXML
    private TableView<MarketItem> tableCentral;
    @FXML
    private TableColumn<MarketItem, String> codeCentral;
    @FXML
    private TableColumn<MarketItem, String> nameCentral;
    @FXML
    private TableColumn<MarketItem, String> settlTypeCentral;
    @FXML
    private TableColumn<MarketItem, Number> unMatchBuy;
    @FXML
    private TableColumn<MarketItem, Number> unMatchSell;
    @FXML
    private TableColumn<MarketItem, Number> canDealTotal;
    @FXML
    private TableColumn<MarketItem, Number> priceOpen;
    @FXML
    private TableColumn<MarketItem, Number> openYield;
    @Inject
    protected IRefDataMng ref;
    ObservableList<BondClassify> obStatic = FxUtils.newList();
    ObservableList<BondClassify> obDynamic = FxUtils.newList();
    @Inject
    private XBondQuoteMktModel model;
    private Gson gson = new Gson();
    private MxList<MarketItem> mlistContinue = new MxList();
    private MxList<MarketItem> mlistCentral = new MxList();
    private Predicate<MarketItem> pd = t -> {
        String txt = this.searchText.getText().toUpperCase();
        String code = t.getRefItem().getCode().toUpperCase();
        String name = t.getRefItem().getName().toUpperCase();
        if (t.getSettlType().ordinal() != Integer.valueOf(((MxNode)this.cmbSettlType.getSelectionModel().getSelectedItem()).getRaw()).intValue()) {
            return false;
        }
        if (!this.radioAll.isSelected() && !this.model.getPreferList().contains(t.getRefItem().getCode())) {
            return false;
        }
        return code.contains(txt) || name.contains(txt);
    };
    private InvalidationListener lstnModel = ob -> {
        this.mlistContinue.update(this.model.getContinueList(), this.pd);
        this.mlistCentral.update(this.model.getCentralList(), this.pd);
        Platform.runLater(() -> {
            this.tableContinue.refresh();
            this.tableCentral.refresh();
        });
    };
    private InvalidationListener lstnSearch = ob -> {
        this.mlistContinue.filter(this.model.getContinueList(), this.pd);
        this.mlistContinue.getList().sort((o1, o2) -> o1.getRefItem().getCode().compareTo(o2.getRefItem().getCode()));
        this.tableContinue.refresh();
        this.mlistCentral.filter(this.model.getCentralList(), this.pd);
        this.mlistCentral.getList().sort((o1, o2) -> o1.getRefItem().getCode().compareTo(o2.getRefItem().getCode()));
        this.tableCentral.refresh();
    };
    private boolean refreshCombobox = false;

    @FXML
    private void initialize() {
        this.model.querySubscribedContract();
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.cmbSettlType.getSelectionModel().selectedItemProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        MxNode node = new MxNode().load("settl_type", DYNAMIC_TYPE);
        this.cmbSettlType.setItems(node.getNodes());
        this.cmbSettlType.setValue((Object)node);
        this.radioAll.setToggleGroup(this.group);
        this.radioStatic.setToggleGroup(this.group);
        this.radioDynamic.setToggleGroup(this.group);
        this.radioAll.setSelected(true);
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            if (this.radioAll.isSelected()) {
                this.lstnSearch.invalidated(null);
            } else if (this.radioStatic.isSelected()) {
                this.model.resetPreferList((BondClassify)this.cmbStatic.getSelectionModel().getSelectedItem());
            } else {
                this.model.resetPreferList((BondClassify)this.cmbDynamic.getSelectionModel().getSelectedItem());
            }
        });
        this.cmbStatic.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (this.refreshCombobox) {
                return;
            }
            if (this.radioStatic.isSelected()) {
                this.model.resetPreferList((BondClassify)now);
            } else {
                this.radioStatic.setSelected(true);
            }
        });
        this.cmbDynamic.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (this.refreshCombobox) {
                return;
            }
            if (this.radioDynamic.isSelected()) {
                this.model.resetPreferList((BondClassify)now);
            } else {
                this.radioDynamic.setSelected(true);
            }
        });
        this.cmbStatic.setItems(this.obStatic);
        this.cmbDynamic.setItems(this.obDynamic);
        this.initPrefer(STATIC_TYPE);
        this.initPrefer(DYNAMIC_TYPE);
        this.tableContinue.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            MarketItem position = (MarketItem)this.tableContinue.getSelectionModel().getSelectedItem();
            MEvent e = new MEvent();
            e.setObj((Object)position);
            this.es.postEvent("xbond.refitem.change", e);
        });
        this.tableCentral.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            MarketItem position = (MarketItem)this.tableCentral.getSelectionModel().getSelectedItem();
            MEvent e = new MEvent();
            e.setObj((Object)position);
            this.es.postEvent("xbond.refitem.change", e);
        });
        this.createTableview();
        this.es.subscribe("xbond.prefer.change", event -> Platform.runLater(() -> this.preferChange(event)));
    }

    private void preferChange(MEvent event) {
        String json = (String)event.getObj();
        JsonObject jo = (JsonObject)this.gson.fromJson(json, JsonObject.class);
        jo.get("id").getAsString();
        jo.get("action").getAsString();
        BondClassify staticCurrent = (BondClassify)this.cmbStatic.getSelectionModel().getSelectedItem();
        BondClassify dynamicCurrent = (BondClassify)this.cmbDynamic.getSelectionModel().getSelectedItem();
        this.refreshCombobox = true;
        this.initPrefer(STATIC_TYPE);
        this.initPrefer(DYNAMIC_TYPE);
        for (BondClassify bond : this.cmbStatic.getItems()) {
            if (!bond.getId().equals(staticCurrent.getId())) continue;
            this.cmbStatic.getSelectionModel().select((Object)bond);
        }
        for (BondClassify bond : this.obDynamic) {
            if (!bond.getId().equals(dynamicCurrent.getId())) continue;
            this.cmbDynamic.getSelectionModel().select((Object)bond);
        }
        this.refreshCombobox = false;
    }

    private void createTableview() {
        this.code.setCellValueFactory(data -> ((MarketItem)data.getValue()).getRefItem().codeProperty());
        this.name.setCellValueFactory(data -> ((MarketItem)data.getValue()).getRefItem().nameProperty());
        this.settlType.setCellValueFactory(data -> new SimpleStringProperty(((MarketItem)data.getValue()).getSettlType().toString()));
        this.qtyBuy.setCellValueFactory(data -> ((MarketItem)data.getValue()).getBuyHandicap().countProperty());
        this.priceBuy.setCellValueFactory(data -> ((MarketItem)data.getValue()).getBuyHandicap().priceProperty());
        this.yieldBuy.setCellValueFactory(data -> ((MarketItem)data.getValue()).getBuyHandicap().yieldProperty());
        this.qtySell.setCellValueFactory(data -> ((MarketItem)data.getValue()).getSellHandicap().countProperty());
        this.priceSell.setCellValueFactory(data -> ((MarketItem)data.getValue()).getSellHandicap().priceProperty());
        this.yieldSell.setCellValueFactory(data -> ((MarketItem)data.getValue()).getSellHandicap().yieldProperty());
        this.tableContinue.setPlaceholder((Node)new Label());
        this.tableContinue.setItems(this.mlistContinue.getList());
        this.codeCentral.setCellValueFactory(data -> ((MarketItem)data.getValue()).getRefItem().codeProperty());
        this.nameCentral.setCellValueFactory(data -> ((MarketItem)data.getValue()).getRefItem().nameProperty());
        this.settlTypeCentral.setCellValueFactory(data -> new SimpleStringProperty(((MarketItem)data.getValue()).getSettlType().toString()));
        this.unMatchBuy.setCellValueFactory(data -> ((MarketItem)data.getValue()).getBuyHandicap().unMatchQtyProperty());
        this.unMatchSell.setCellValueFactory(data -> ((MarketItem)data.getValue()).getSellHandicap().unMatchQtyProperty());
        this.canDealTotal.setCellValueFactory(data -> ((MarketItem)data.getValue()).canDealTotalProperty());
        this.priceOpen.setCellValueFactory(data -> ((MarketItem)data.getValue()).openPriceProperty());
        this.openYield.setCellValueFactory(data -> ((MarketItem)data.getValue()).openYieldProperty());
        this.tableCentral.setItems(this.mlistCentral.getList());
        this.tableCentral.setPlaceholder((Node)new Label());
    }

    private void initPrefer(String type) {
        if (type.equals(STATIC_TYPE)) {
            this.obStatic.clear();
        } else {
            this.obDynamic.clear();
        }
        ObservableList list = FxUtils.newList();
        HashMap<String, String> paramStatic = new HashMap<String, String>();
        paramStatic.put("type", type);
        try {
            String json = this.httpClient.doGet("/bond-classify/queryList", paramStatic, true);
            ResponseData resp = (ResponseData)this.gson.fromJson(json, new TypeToken<ResponseData<BaseListResult<BondClassify>>>(){}.getType());
            for (BondClassify classify : ((BaseListResult)resp.getRes()).getList()) {
                if (type.equals(STATIC_TYPE)) {
                    this.obStatic.add((Object)classify);
                } else {
                    this.obDynamic.add((Object)classify);
                }
                list.add((Object)classify);
            }
        }
        catch (MException e) {
            e.printStackTrace();
            this.logger.error((Object)e, (Throwable)e);
        }
    }
}

