/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondPositionModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.ImportExcel;
import cms.tmx.core.MException;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.PosAccnt;
import cms.tmx.http.api.strategy.dto.PosDelta;
import cms.tmx.http.api.strategy.dto.PosType;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.ResetPosReq;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondPositionPart
extends MxPart {
    private final Logger logger = LogManager.getLogger(XBondPositionPart.class);
    private MxList<Position> mlist = new MxList();
    @FXML
    private TableView<Position> tablePosition;
    @FXML
    private TableColumn<Position, String> code;
    @FXML
    private TableColumn<Position, String> name;
    @FXML
    private TableColumn<Position, MxNode> market;
    @FXML
    private TableColumn<Position, Number> position;
    @FXML
    private TableColumn<Position, Number> available;
    @FXML
    private TableColumn<Position, Number> receivable;
    @FXML
    private TableColumn<Position, Number> payable;
    @FXML
    private TableColumn<Position, Number> frozen;
    @FXML
    private TableColumn<Position, String> date;
    @FXML
    private TableColumn<Position, String> secAccntId;
    @FXML
    private TextField searchText;
    @Inject
    private XBondPositionModel model;
    @Inject
    private MxAlert alert;
    private Predicate<Position> pd = t -> {
        String text = this.searchText.getText().trim().toUpperCase();
        if (t.getInstrument() == null || t.getInstrument().getSecurityId() == null) {
            return true;
        }
        String code = t.getInstrument().getSecurityId().toUpperCase();
        String name = t.getInstrument().getSymbol();
        return code.contains(text) || name != null && name.contains(text);
    };
    private InvalidationListener lstnModel = ob -> {
        this.mlist.update(this.model.getList(), this.pd);
        this.mlist.getList().sort((o1, o2) -> o1.getInstrument().getSecurityId().compareTo(o2.getInstrument().getSecurityId()));
        this.tablePosition.refresh();
    };
    private InvalidationListener lstnSearch = ob -> this.mlist.filter(this.model.getList(), this.pd);
    @Inject
    protected CcsAccountMap accntMap;
    private final String XLSX = ".xlsx";
    private final String XLS = ".xls";

    @FXML
    private void initialize() {
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.createTable();
        this.refresh();
    }

    private void createTable() {
        this.code.setCellValueFactory(data -> new SimpleStringProperty(((Position)data.getValue()).getInstrument().getSecurityId()));
        this.name.setCellValueFactory(data -> new SimpleStringProperty(((Position)data.getValue()).getInstrument().getSymbol()));
        this.market.setCellValueFactory(data -> new SimpleObjectProperty((Object)new MxNode().load("market_code", ((Position)data.getValue()).getInstrument().getMarket())));
        this.position.setCellValueFactory(data -> new SimpleDoubleProperty((((Position)data.getValue()).getSodQty() + ((Position)data.getValue()).getIntraDayQty()) / 10000.0));
        this.receivable.setCellValueFactory(data -> new SimpleDoubleProperty(((Position)data.getValue()).getReceivable() / 10000.0));
        this.payable.setCellValueFactory(data -> new SimpleDoubleProperty(((Position)data.getValue()).getPayable() / 10000.0));
        this.available.setCellValueFactory(data -> new SimpleDoubleProperty((((Position)data.getValue()).getSodQty() + ((Position)data.getValue()).getIntraDayQty() - ((Position)data.getValue()).getFrozenQty()) / 10000.0));
        this.frozen.setCellValueFactory(data -> new SimpleDoubleProperty(((Position)data.getValue()).getFrozenQty() / 10000.0));
        this.date.setCellValueFactory(data -> new SimpleStringProperty(((Position)data.getValue()).getTrdDate()));
        this.secAccntId.setCellValueFactory(data -> {
            String secAccntId = this.accntMap.getCfetsInverstorSecId(((Position)data.getValue()).getPosAccnt().getSecAccntId());
            return new SimpleStringProperty(secAccntId);
        });
        this.tablePosition.setPlaceholder((Node)new Label());
        this.mlist.getList().sort((o1, o2) -> o1.getInstrument().getSecurityId().compareTo(o2.getInstrument().getSecurityId()));
        this.tablePosition.setItems(this.mlist.getList());
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void importExcel() {
        try {
            FileChooser chooser = new FileChooser();
            File file = chooser.showOpenDialog(null);
            if (file == null) {
                return;
            }
            this.checkAndImport(file);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5bfc\u5165\u6210\u529f");
        }
        catch (MException | Exception e) {
            this.logger.error(e.getMessage(), e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void checkAndImport(File file) throws Exception, MException {
        if (!file.getPath().endsWith(".xlsx") && !file.getPath().endsWith(".xls")) {
            throw new Exception("\u6301\u4ed3\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List positionItemList = ImportExcel.read((String)file.getPath());
        if (positionItemList == null) {
            throw new Exception("\u6301\u4ed3\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u9519\u8bef");
        }
        if (!positionItemList.isEmpty()) {
            positionItemList.remove(0);
        }
        if (positionItemList.size() == 0) {
            throw new Exception("\u6301\u4ed3\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        HashSet<String> stkCodeSet = new HashSet<String>();
        ResetPosReq resetReq = new ResetPosReq();
        int nullRows = 0;
        int j = 0;
        while (j < positionItemList.size()) {
            int nullRow = 0;
            for (String str : (List)positionItemList.get(j)) {
                if (str != null && !"".equals(str.trim())) continue;
                ++nullRow;
            }
            if (nullRow == ((List)positionItemList.get(j)).size()) {
                ++nullRows;
            } else {
                PosDelta item = new PosDelta();
                Instrument instrument = new Instrument();
                item.setInstrument(instrument);
                instrument.setMarket("XCFE");
                instrument.setSecurityType("BOND");
                item.setPosType(PosType.kPosTypeSod);
                PosAccnt accnt = new PosAccnt();
                item.setPosAccnt(accnt);
                accnt.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
                accnt.setAccntType(AccntType.ACCNT_TYPE_SEC);
                int i = 0;
                while (i < ((List)positionItemList.get(j)).size()) {
                    String value = (String)((List)positionItemList.get(j)).get(i);
                    switch (i) {
                        case 0: {
                            if ("".equals(value.trim())) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u8bc1\u5238\u4ee3\u7801\u4e3a\u7a7a");
                            }
                            if (!StringUtils.isNumeric((String)value)) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u8bc1\u5238\u4ee3\u7801 " + value + "\u9519\u8bef");
                            }
                            instrument.setSecurityId(value);
                            break;
                        }
                        case 1: {
                            boolean flag = "".equals(value);
                            if (flag) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u8bc1\u5238\u540d\u79f0\u4e3a\u7a7a");
                            }
                            instrument.setSymbol(value);
                            break;
                        }
                        case 2: {
                            BigDecimal b1;
                            if ("".equals(value)) {
                                value = "0";
                            }
                            try {
                                b1 = new BigDecimal(value);
                            }
                            catch (Exception e) {
                                this.logger.error("import failed", (Throwable)e);
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + instrument.getSecurityId() + " \u6301\u4ed3\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570\uff0c\u4e14\u4e0d\u5927\u4e8e9\u4f4d\uff01");
                            }
                            item.setQty((double)(b1.longValue() * 10000L));
                            break;
                        }
                        case 3: {
                            boolean flag = "".equals(value);
                            if (flag) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u8bc1\u5238\u8d26\u53f7\u4e3a\u7a7a");
                            }
                            accnt.setSecAccntId(value);
                            stkCodeSet.add(String.valueOf(instrument.getSecurityId()) + value);
                            break;
                        }
                    }
                    ++i;
                }
                resetReq.getDelta().add(item);
            }
            ++j;
        }
        if (stkCodeSet.size() < positionItemList.size() - nullRows) {
            throw new Exception("\u6301\u4ed3\u5bfc\u5165\u5931\u8d25 \u6210\u4efd\u80a1\u91cd\u590d");
        }
        this.model.resetPosition(resetReq);
    }
}

