/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.bond.views;

import cms.tmx.bond.models.XBondOrderModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.core.MException;
import cms.tmx.http.api.strategy.api.CalculateServiceApi;
import cms.tmx.http.api.strategy.dto.CalcYieldReq;
import cms.tmx.http.api.strategy.dto.CalcYieldResp;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.calendar.api.CalendarServiceApi;
import cms.tmx.http.calendar.dto.GetBusinessDateReq;
import cms.tmx.http.calendar.dto.GetBusinessDateResp;
import cms.tmx.javafx.MxNode;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XBondOrderReplaceDialog
extends DialogObj {
    protected Logger logger = LogManager.getLogger(XBondOrderReplaceDialog.class);
    @Inject
    private XBondOrderModel model;
    private SingleOrder order;
    private DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 4);
    @FXML
    private TextField txtCode;
    @FXML
    private TextField txtName;
    @FXML
    private RadioButton radioBuy;
    @FXML
    private RadioButton radioSell;
    @FXML
    private ComboBox<MxNode> cmbMatchType;
    @FXML
    private ComboBox<MxNode> cmbSettlType;
    @FXML
    private TextField txtSettlDay;
    @FXML
    private Spinner<Double> spnPrice;
    @FXML
    private Spinner<Double> spnYield;
    @FXML
    private Spinner<Integer> spnQty;
    @Inject
    private CalendarServiceApi calendarApi;
    @Inject
    private CalculateServiceApi calcApi;
    @Inject
    protected MxAlert alert;

    public ButtonType[] getTypes() {
        return new ButtonType[]{new ButtonType("\u6539\u5355", ButtonBar.ButtonData.OK_DONE), ButtonType.CANCEL};
    }

    @FXML
    private void initialize() {
        this.initControls();
        this.ctrlPrice.ctrl(this.spnPrice);
        this.spnPrice.getEditor().setText(String.valueOf(this.order.getPrice()));
    }

    private void initControls() {
        this.txtCode.setText(this.order.getInstrument().getSecurityId());
        this.txtName.setText(this.order.getInstrument().getSymbol());
        if (this.order.getSide().equals((Object)Side.SIDE_BID)) {
            this.radioBuy.setSelected(true);
        } else {
            this.radioSell.setSelected(true);
        }
        MxNode node = new MxNode().load("match_type", this.order.getMatchType().getValue());
        this.cmbMatchType.setItems(node.getNodes());
        this.cmbMatchType.setValue((Object)node);
        node = new MxNode().load("settl_type", String.valueOf(this.order.getSettlType().ordinal()));
        this.cmbSettlType.setItems(node.getNodes());
        this.cmbSettlType.setValue((Object)node);
        this.spnQty.getEditor().setText(String.valueOf((int)((this.order.getOrderQty() - this.order.getCumQty()) / 1000.0)));
        GetBusinessDateReq bizDateReq = new GetBusinessDateReq();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        bizDateReq.setDate(today);
        bizDateReq.setMarket("XCFE");
        bizDateReq.setMarketGrp("IB");
        try {
            GetBusinessDateResp resp = this.calendarApi.GetBusinessDate(bizDateReq);
            String latestBusinessDate = resp.getLatestBusinessDate();
            String latestNextBusinessDate = resp.getLatestNextBusinessDate();
            SettlType type = this.order.getSettlType();
            if (type == SettlType.CASH_OR_TOD_OR_T_PLUS_0_SETTLTYPE && latestBusinessDate != null) {
                this.txtSettlDay.setText(latestBusinessDate);
            }
            if (type == SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1 && latestNextBusinessDate != null) {
                this.txtSettlDay.setText(latestNextBusinessDate);
            }
        }
        catch (MException e) {
            e.printStackTrace();
            this.logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u83b7\u53d6\u4ea4\u6613\u65e5\u5931\u8d25\uff1a" + e.getMessage()));
        }
        this.spnPrice.getEditor().textProperty().addListener((ob, old, now) -> {
            CalcYieldReq req = new CalcYieldReq();
            req.setInstrument(this.order.getInstrument());
            req.setCleanPx(Double.valueOf(this.spnPrice.getEditor().getText()).doubleValue());
            req.setSettlDate(this.txtSettlDay.getText());
            try {
                CalcYieldResp resp = this.calcApi.getYield(req);
                double yield = (double)(100L * Math.round(resp.getYield() * 10000.0)) / 10000.0;
                this.spnYield.getEditor().setText(String.valueOf(yield));
            }
            catch (MException | IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static void main(String[] args) {
        double yield = Double.valueOf("");
        System.out.println(yield);
    }

    public boolean isOK(ButtonType bt) {
        if (this.spnPrice.getEditor().getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u4ef7\u683c");
            return false;
        }
        double price = Double.valueOf(this.spnPrice.getEditor().getText());
        if (price == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0");
            return false;
        }
        if (price == this.order.getPrice()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4ef7\u683c\u672a\u53d8\u5316");
            return false;
        }
        double yield = Double.valueOf(this.spnYield.getEditor().getText());
        try {
            this.model.orderCancelReplace(this.order, price, yield);
        }
        catch (MException | NumberFormatException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public SingleOrder getOrder() {
        return this.order;
    }

    public void setOrder(SingleOrder order) {
        this.order = order;
    }
}

